/*  -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * 
 * This file is part of the GNOME Debugging Framework.
 * 
 * Copyright (C) 1999-2000 Martin Baulig <martin@home-of-linux.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#include <config.h>
#include "gdf-event-channel-client.h"

#include <liboaf/liboaf.h>

/* FIXME: This file needs exception handling done right */
static void event_channel_client_class_init (GdfEventChannelClientClass *class);
static void event_channel_client_init (GdfEventChannelClient *prog);
static void event_channel_client_destroy (GdfEventChannelClient *prog);

static GtkObjectClass *parent_class;

enum {
    EVENT_PUSHED,
    LAST_SIGNAL
};

static gint event_channel_client_signals[LAST_SIGNAL] = {0};

struct _GdfEventChannelClientPrivate {
    CORBA_Environment ev;
    PortableServer_POA root_poa;
    CosEventChannelAdmin_SupplierAdmin supplier_admin;
    CosEventChannelAdmin_ProxyPushConsumer proxy_push_consumer;
    CosEventChannelAdmin_ConsumerAdmin consumer_admin;
    CosEventChannelAdmin_ProxyPushSupplier proxy_push_supplier;
    CosEventComm_PushConsumer push_consumer;
    gboolean listening;
};

GdfEventChannelClient *
gdf_event_channel_client_new_from_corba (CosEventChannelAdmin_EventChannel channel)
{
    GdfEventChannelClient *client;

    g_return_val_if_fail (channel != CORBA_OBJECT_NIL, NULL);

    client = gtk_type_new (gdf_event_channel_client_get_type ());

    return gdf_event_channel_client_construct (client, channel);
}

GdfEventChannelClient *
gdf_event_channel_client_new (void) 
{
    CosEventChannelAdmin_EventChannel channel;
    GdfEventChannelClient *client;
    CORBA_Environment ev;

#if 0
    channel = goad_server_activate_with_id (NULL, "gdf_event_channel", 
                                            0, NULL);
#endif
    CORBA_exception_init (&ev);

    channel = oaf_activate_from_id ("OAFIID:gdf_event_channel:1124b7ed-752c-4091-9b6c-c426fdd50517", 0, NULL, &ev);
    
    CORBA_exception_free (&ev);

    if (channel == CORBA_OBJECT_NIL)
        return NULL;

    client = gdf_event_channel_client_new_from_corba (channel);

    return client;
}

GdfEventChannelClient *
gdf_event_channel_client_construct (GdfEventChannelClient *client,
                                    CosEventChannelAdmin_EventChannel channel)
{
    g_return_val_if_fail (client != NULL, NULL);
    g_return_val_if_fail (channel != CORBA_OBJECT_NIL, NULL);
    g_return_val_if_fail (GDF_IS_EVENT_CHANNEL_CLIENT (client), NULL);
    
    client->priv = g_new0 (GdfEventChannelClientPrivate, 1);
    
    CORBA_exception_init (&client->priv->ev);

    client->priv->supplier_admin =
        CosEventChannelAdmin_EventChannel_for_suppliers
        (channel, &client->priv->ev);
	
    /*gdf_handle_exception (&client->priv->ev);*/

    client->priv->proxy_push_consumer =
        CosEventChannelAdmin_SupplierAdmin_obtain_push_consumer
        (client->priv->supplier_admin, &client->priv->ev);

    /*gdf_handle_exception (&client->priv->ev);*/

    client->priv->root_poa = (PortableServer_POA)
        CORBA_ORB_resolve_initial_references (oaf_orb_get (),
                                              "RootPOA",
                                              &client->priv->ev);

    /*gdf_handle_exception (&client->priv->ev);*/

    bonobo_object_client_construct (BONOBO_OBJECT_CLIENT (client), channel);

    return client;
}

GtkType 
gdf_event_channel_client_get_type (void)
{
    static GtkType type = 0;
    
    if (!type) {
        GtkTypeInfo info = {
            "Handle to a Debugger::EventChannel object",
            sizeof (GdfEventChannelClient),
            sizeof (GdfEventChannelClientClass),
            (GtkClassInitFunc) event_channel_client_class_init,
            (GtkObjectInitFunc) event_channel_client_init,
            NULL,
            NULL,
            (GtkClassInitFunc) NULL
        };
	
        type = gtk_type_unique (bonobo_object_client_get_type (), &info);
    }

    return type;
}

/* private routines */
static void
event_channel_client_class_init (GdfEventChannelClientClass *klass) 
{
    GtkObjectClass *object_class = (GtkObjectClass*) klass;
    
    g_return_if_fail (klass != NULL);
    g_return_if_fail (GDF_IS_EVENT_CHANNEL_CLIENT_CLASS (klass));
    
    parent_class = gtk_type_class (bonobo_object_client_get_type ());

    event_channel_client_signals [EVENT_PUSHED] =
        gtk_signal_new ("event_pushed",
                        GTK_RUN_LAST,
                        object_class->type,
                        GTK_SIGNAL_OFFSET (GdfEventChannelClientClass,
                                           event_pushed),
                        gtk_marshal_NONE__POINTER,
                        GTK_TYPE_NONE, 1,
                        GTK_TYPE_POINTER);

    gtk_object_class_add_signals (object_class,
                                  event_channel_client_signals,
                                  LAST_SIGNAL);
    object_class->destroy = (GtkSignalFunc) event_channel_client_destroy;
}

static void
event_channel_client_init (GdfEventChannelClient *client)
{
    client->priv = NULL;
}

static void
event_channel_client_destroy (GdfEventChannelClient *client)
{
    if (parent_class->destroy)
        parent_class->destroy (GTK_OBJECT (client));
}

void
gdf_event_channel_client_push (GdfEventChannelClient *client, CORBA_any *any)
{
    g_return_if_fail (client != NULL);
    g_return_if_fail (GDF_IS_EVENT_CHANNEL_CLIENT (client));
    g_return_if_fail (any != NULL);

    CosEventComm_PushConsumer_push (client->priv->proxy_push_consumer,
                                    any, &client->priv->ev);

    /*gdf_handle_exception (&client->priv->ev);*/
}

void
gdf_event_channel_client_destroy_channel (GdfEventChannelClient *client)
{
    g_return_if_fail (client != NULL);
    g_return_if_fail (GDF_IS_EVENT_CHANNEL_CLIENT (client));

    CosEventChannelAdmin_EventChannel_destroy (bonobo_object_corba_objref (BONOBO_OBJECT (client)), 
                                               &client->priv->ev);    
}

/*** App-specific servant structures ***/

typedef struct {
    POA_CosEventComm_PushConsumer servant;
    PortableServer_POA poa;

    GdfEventChannelClient *client;
} impl_POA_CosEventComm_PushConsumer;

/*** Implementation stub prototypes ***/

static void 
impl_CosEventComm_PushConsumer__destroy (impl_POA_CosEventComm_PushConsumer *,
                                         CORBA_Environment *);

void
impl_CosEventComm_PushConsumer_push (impl_POA_CosEventComm_PushConsumer *,
                                     CORBA_any *, CORBA_Environment *);

static void
impl_CosEventComm_PushConsumer_disconnect_push_consumer (impl_POA_CosEventComm_PushConsumer *,
                                                         CORBA_Environment *);

/*** epv structures ***/

static PortableServer_ServantBase__epv impl_CosEventComm_PushConsumer_base_epv =
{
    NULL,			/* _private data */
    (gpointer) & impl_CosEventComm_PushConsumer__destroy,	/* finalize */
    NULL,			/* default_POA routine */
};

static POA_CosEventComm_PushConsumer__epv impl_CosEventComm_PushConsumer_epv =
{
    NULL,			/* _private */
    (gpointer) & impl_CosEventComm_PushConsumer_push,
    (gpointer) & impl_CosEventComm_PushConsumer_disconnect_push_consumer,
};

/*** vepv structures ***/

static POA_CosEventComm_PushConsumer__vepv impl_CosEventComm_PushConsumer_vepv =
{
    &impl_CosEventComm_PushConsumer_base_epv,
    &impl_CosEventComm_PushConsumer_epv,
};

/*** Stub implementations ***/

static CosEventComm_PushConsumer
impl_CosEventComm_PushConsumer__create (PortableServer_POA poa,
                                        GdfEventChannelClient *client,
                                        CORBA_Environment * ev)
{
    CosEventComm_PushConsumer retval;
    impl_POA_CosEventComm_PushConsumer *newservant;
    PortableServer_ObjectId *objid;

    bonobo_object_ref (BONOBO_OBJECT (client));
	
    newservant = g_new0(impl_POA_CosEventComm_PushConsumer, 1);
    newservant->servant.vepv = &impl_CosEventComm_PushConsumer_vepv;
    newservant->client = client;
    newservant->poa = poa;
    POA_CosEventComm_PushConsumer__init((PortableServer_Servant) newservant, ev);
    objid = PortableServer_POA_activate_object(poa, newservant, ev);
    CORBA_free(objid);
    retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);
	
    return retval;
}

static void
impl_CosEventComm_PushConsumer__destroy (impl_POA_CosEventComm_PushConsumer *servant, CORBA_Environment * ev)
{
    PortableServer_ObjectId *objid;
	
    objid = PortableServer_POA_servant_to_id(servant->poa, servant, ev);
    PortableServer_POA_deactivate_object(servant->poa, objid, ev);
    CORBA_free(objid);

    POA_CosEventComm_PushConsumer__fini((PortableServer_Servant) servant, ev);
    g_free(servant);
}

void
impl_CosEventComm_PushConsumer_push (impl_POA_CosEventComm_PushConsumer *servant,
                                     CORBA_any *data, CORBA_Environment *ev)
{
    g_return_if_fail (servant->client != NULL);
    g_return_if_fail (GDF_IS_EVENT_CHANNEL_CLIENT (servant->client));

    gtk_signal_emit (GTK_OBJECT (servant->client),
                     event_channel_client_signals [EVENT_PUSHED],
                     data);
}

void
impl_CosEventComm_PushConsumer_disconnect_push_consumer (impl_POA_CosEventComm_PushConsumer * servant, CORBA_Environment * ev)
{
}

void
gdf_event_channel_client_listen (GdfEventChannelClient *client)
{
    g_return_if_fail (client != NULL);
    g_return_if_fail (GDF_IS_EVENT_CHANNEL_CLIENT (client));
    g_return_if_fail (!client->priv->listening);

    client->priv->push_consumer =
        impl_CosEventComm_PushConsumer__create (client->priv->root_poa,
                                                client, &client->priv->ev);

    /*gdf_handle_exception (&client->priv->ev);*/
    
    client->priv->consumer_admin = 
        CosEventChannelAdmin_EventChannel_for_consumers
        (bonobo_object_corba_objref (BONOBO_OBJECT (client)),
         &client->priv->ev);
    
    /*gdf_handle_exception (&client->priv->ev);*/

    client->priv->proxy_push_supplier =
        CosEventChannelAdmin_ConsumerAdmin_obtain_push_supplier
        (client->priv->consumer_admin, &client->priv->ev);

    /*gdf_handle_exception (&client->priv->ev);*/

    CosEventChannelAdmin_ProxyPushSupplier_connect_push_consumer
        (client->priv->proxy_push_supplier, client->priv->push_consumer,
         &client->priv->ev);

    /*gdf_handle_exception (&client->priv->ev);*/

    client->priv->listening = TRUE;
}



