/*  -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * 
 * This file is part of the GNOME Debugging Framework.
 * 
 * Copyright (C) 2000 Dave Camp <campd@oit.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#ifndef __GDF_SYMBOL_SET_CLIENT_H__
#define __GDF_SYMBOL_SET_CLIENT_H__

#include <bonobo.h>
#include "gnome-debug.h"

BEGIN_GNOME_DECLS

#include "gdf-event-channel-client.h"

#define GDF_SYMBOL_SET_CLIENT_TYPE		(gdf_symbol_set_client_get_type ())
#define GDF_SYMBOL_SET_CLIENT(o)		(GTK_CHECK_CAST ((o), GDF_SYMBOL_SET_CLIENT_TYPE, GdfSymbolSetClient))
#define GDF_SYMBOL_SET_CLIENT_CLASS(k)	(GTK_CHECK_CLASS_CAST((k), GDF_SYMBOL_SET_CLIENT_TYPE, GdfSymbolSetClientClass))
#define GDF_IS_SYMBOL_SET_CLIENT(o)		(GTK_CHECK_TYPE ((o), GDF_SYMBOL_SET_CLIENT_TYPE))
#define GDF_IS_SYMBOL_SET_CLIENT_CLASS(k)	(GTK_CHECK_CLASS_TYPE ((k), GDF_SYMBOL_SET_CLIENT_TYPE))

typedef struct _GdfSymbolSetClient        GdfSymbolSetClient;
typedef struct _GdfSymbolSetClientPrivate GdfSymbolSetClientPrivate;
typedef struct _GdfSymbolSetClientClass   GdfSymbolSetClientClass;


struct _GdfSymbolSetClient {
    GtkObject parent;
    
    CORBA_Object objref;
    GdfSymbolSetClientPrivate *priv;
};

struct _GdfSymbolSetClientClass {
    GtkObjectClass parent_class;
    
    void (*symbol_set_changed) (GdfSymbolSetClient *);
    void (*symbol_changed) (GdfSymbolSetClient *, gint handle);
};

GdfSymbolSetClient *gdf_symbol_set_client_new_from_corba (GDF_SymbolSet symbol_set);
GtkType gdf_symbol_set_client_get_type (void);

GDF_SymbolSequence *gdf_symbol_set_client_get_symbols (GdfSymbolSetClient *ss);
void gdf_symbol_set_client_add_expression (GdfSymbolSetClient *ss,
                                           const char *expr);
GDF_Symbol *gdf_symbol_set_client_get_symbol (GdfSymbolSetClient *ss,
                                              int handle);
GDF_SymbolSequence *gdf_symbol_set_client_get_symbol_children (GdfSymbolSetClient *ss,
                                                              int handle);

END_GNOME_DECLS

#endif
