/*  -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * 
 * This file is part of the GNOME Debugging Framework.
 * 
 * Copyright (C) 1999-2000 Dave Camp <campd@oit.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#ifndef __GDF_SOURCE_VIEWER_MANAGER_H__
#define __GDF_SOURCE_VIEWER_MANAGER_H__

#include <gnome.h>
#include <gdf.h>
#include "gdf-source-viewer.h"

BEGIN_GNOME_DECLS

typedef struct _GdfSourceViewerManager      GdfSourceViewerManager;
typedef struct _GdfSourceViewerManagerClass GdfSourceViewerManagerClass;
typedef struct _GdfSourceViewerManagerPriv  GdfSourceViewerManagerPriv;

#define GDF_SOURCE_VIEWER_MANAGER_TYPE        (gdf_source_viewer_manager_get_type ())
#define GDF_SOURCE_VIEWER_MANAGER(o)          (GTK_CHECK_CAST ((o), GDF_SOURCE_VIEWER_MANAGER_TYPE, GdfSourceViewerManager))
#define GDF_SOURCE_VIEWER_MANAGER_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), GDF_SOURCE_VIEWER_MANAGER_TYPE, GdfSourceViewerManagerClass))
#define GDF_IS_SOURCE_VIEWER_MANAGER(o)       (GTK_CHECK_TYPE ((o), GDF_SOURCE_VIEWER_MANAGER_TYPE))
#define GDF_IS_SOURCE_VIEWER_MANAGER_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), GDF_SOURCE_VIEWER_MANAGER_TYPE))

struct _GdfSourceViewerManager {
	GtkVBox parent;

	GdfSourceViewerManagerPriv *priv;
};

struct _GdfSourceViewerManagerClass {
	GtkVBoxClass parent_class;
};

GtkType gdf_source_viewer_manager_get_type (void);
GdfSourceViewerManager *gdf_source_viewer_manager_new (void);

GtkWidget *gdf_source_viewer_manager_view_source (GdfSourceViewerManager *svm,
                                                  const gchar *file_name);

void gdf_source_viewer_manager_set_debugger (GdfSourceViewerManager *svm, 
                                             GdfDebuggerClient *dbg);


END_GNOME_DECLS

#endif
