/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 4 -*- */

#include <config.h>
#include "gdf-libdryad-debugger.h"
#include <gnome.h>
#include <bonobo.h>
#include <liboaf/liboaf.h>

static void
start_debugger (CORBA_Environment *ev)
{
    GdfLibdryadDebugger *dbg;
    OAF_RegistrationResult result;
    
#if 0  /* goad stuff */
    CORBA_Object name_service;
#endif    

    dbg = gdf_libdryad_debugger_new ();
	
    gtk_signal_connect (GTK_OBJECT (dbg), "destroy",
			GTK_SIGNAL_FUNC (gtk_main_quit), NULL);

#if 0 /* goad stuff */
    name_service = gnome_name_service_get ();
    goad_server_register (name_service,
			  bonobo_object_corba_objref (BONOBO_OBJECT (dbg)),
			  "gdf_libdryad_debugger",
			  "object",
			  ev);
#endif

    result = oaf_active_server_register ("OAFIID:gdf:libdryad-debugger:bacdada7-c2c5-43c1-9d1e-64982c205fa4",
					 bonobo_object_corba_objref (BONOBO_OBJECT (dbg)));

    switch (result) {
    case OAF_REG_SUCCESS :
	oaf_active_server_unregister ("OAFIID:gdf:libdryad-debugger:bacdada7-c2c5-43c1-9d1e-64982c205fa4", 
				      bonobo_object_corba_objref (BONOBO_OBJECT (dbg)));
	return;
    case OAF_REG_NOT_LISTED:
	g_error ("Cannot register the debugger because it is not listed.");
	return;
    case OAF_REG_ALREADY_ACTIVE:
	g_error ("Cannot register the debugger because it is already active.");
	return;
    case OAF_REG_ERROR :
    default :
	g_error ("Cannot register the debugger because of an unknown error.");
	return;
    }
    
}

int
main (int argc, char *argv[])
{
    CORBA_Environment ev;

    CORBA_exception_init (&ev);

#if 0   /* goad stuff */
    orb = gnome_CORBA_init ("gdf-libdryad-server", VERSION, &argc, argv, 
			    GNORBA_INIT_SERVER_FUNC, &ev);
#endif

    gnome_init_with_popt_table ("gdf-libdryad-server", VERSION, argc, argv,
				oaf_popt_options, 0, NULL);
    oaf_init (argc, argv);    

    if (!bonobo_init (oaf_orb_get (), NULL, NULL)) 
	g_error (_("Can't initialize bonobo!"));

    start_debugger (&ev);
	
    bonobo_main ();

    return 0;
}

