// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_SIMPLEASYNCRESULT_H
#define _GIOMM_SIMPLEASYNCRESULT_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <giomm/asyncresult.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GSimpleAsyncResult GSimpleAsyncResult;
typedef struct _GSimpleAsyncResultClass GSimpleAsyncResultClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class SimpleAsyncResult_Class; } // namespace Gio
namespace Gio
{

//TODO: Is this used in the rest of the API at all? If not, it seems like semi-private API that we should not wrap for now. Murray.

/** Implements AsyncResult for simple cases. Most of the time, this will be all an application needs, and will be used transparently. Because of this, 
 * SimpleAsyncResult is used throughout GIO for handling asynchronous functions.
 *
 * Most of the time, an application will not need to know of the details of this API; it is handled transparently, and any necessary operations are handled 
 * by AsyncResult's interface. However, if implementing a new GIO module, for writing language bindings, or for complex applications that need better 
 * control of how asynchronous operations are completed, it is important to understand this functionality.
 * 
 * SimpleAsyncResult handles SlotAsyncReady, error reporting, operation cancellation and the final state of an operation, completely transparent to 
 * the application. Results can be returned as a pointer e.g. for functions that return data that is collected asynchronously, a boolean value for checking 
 * the success or failure of an operation, or a gssize for operations which return the number of bytes modified by the operation; all of the simple return 
 * cases are covered.
 * 
 * SimpleAsyncResults are tagged with the calling function to ensure that asynchronous functions and their finishing functions are used together correctly.
 * 
 * To create a new SimpleAsyncResult, call create(). If the result needs to be created for a GError, use 
 * create_from_error(). If a GError is not available (e.g. the asynchronous operation's doesn't take a GError argument), but the result 
 * still needs to be created for an error condition, use g_simple_async_result_new_error() (or g_simple_async_result_set_error_va() if your application or 
 * binding requires passing a variable argument list directly), and the error can then be propegated through the use of 
 * g_simple_async_result_propagate_error().
 * 
 * An asynchronous operation can be made to ignore a cancellation event by calling set_handle_cancellation() with false.
 * 
 * SimpleAsyncResult can integrate into GLib's event loop, GMainLoop, or it can use GThreads if available. complete() will finish an 
 * I/O task directly within the main event loop. complete_in_idle() will integrate the I/O task into the main event loop as an idle 
 * function and run_in_thread() will run the job in a separate thread.
 * 
 * To set the results of an asynchronous function, set_op_res() methods are provided, setting the operation's result to a gpointer, bool, or gssize,.
 * 
 * Likewise, to get the result of an asynchronous function, get_op_res_gpointer(), get_op_res_bool(), and 
 * get_op_res_gssize() are provided, getting the operation's result as a gpointer, bool, and gssize, respectively.
 *
 * @newin2p16
 */

class SimpleAsyncResult : public Glib::Object, public AsyncResult
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SimpleAsyncResult CppObjectType;
  typedef SimpleAsyncResult_Class CppClassType;
  typedef GSimpleAsyncResult BaseObjectType;
  typedef GSimpleAsyncResultClass BaseClassType;

private:  friend class SimpleAsyncResult_Class;
  static CppClassType simpleasyncresult_class_;

private:
  // noncopyable
  SimpleAsyncResult(const SimpleAsyncResult&);
  SimpleAsyncResult& operator=(const SimpleAsyncResult&);

protected:
  explicit SimpleAsyncResult(const Glib::ConstructParams& construct_params);
  explicit SimpleAsyncResult(GSimpleAsyncResult* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SimpleAsyncResult();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GSimpleAsyncResult*       gobj()       { return reinterpret_cast<GSimpleAsyncResult*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GSimpleAsyncResult* gobj() const { return reinterpret_cast<GSimpleAsyncResult*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GSimpleAsyncResult* gobj_copy();

private:

  
public:
  //


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::SimpleAsyncResult
   */
  Glib::RefPtr<Gio::SimpleAsyncResult> wrap(GSimpleAsyncResult* object, bool take_copy = false);
}


#endif /* _GIOMM_SIMPLEASYNCRESULT_H */

