/***************************************************************************
 *            camel-kolab-imapx-metadata-db.h
 *
 *  Mon Oct 11 12:37:05 2010
 *  Copyright  2010  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
/*----------------------------------------------------------------------------*/

#ifndef _CAMEL_KOLAB_IMAPX_METADATA_DB_H_
#define _CAMEL_KOLAB_IMAPX_METADATA_DB_H_

/*----------------------------------------------------------------------------*/

#include <glib.h>
#include <sqlite3.h>

#include <camel/camel.h>
#include <camel/providers/imapx/camel-imapx-metadata.h>

/*----------------------------------------------------------------------------*/

struct _CamelKolabFolderMetaData;

/*----------------------------------------------------------------------------*/

typedef struct _CamelKolabIMAPXMetaDataDB {
	sqlite3  *db;	/* sqlite3 DB handle */
	gchar    *path; /* path to the sqlite3 metadata db file */
	gint	 ctr;	/* aux counter, usable with callback functions */
} CamelKolabIMAPXMetaDataDB;

/*----------------------------------------------------------------------------*/

CamelKolabIMAPXMetaDataDB *kolab_imapx_meta_data_db_new (void);
gboolean kolab_imapx_meta_data_db_free (CamelKolabIMAPXMetaDataDB*, GError**);
gboolean kolab_imapx_meta_data_db_open (CamelKolabIMAPXMetaDataDB*, CamelService*, CamelSession*, GError**);
gboolean kolab_imapx_meta_data_db_init (CamelKolabIMAPXMetaDataDB*, GError**);
gboolean kolab_imapx_meta_data_db_close (CamelKolabIMAPXMetaDataDB*, GError**);

gboolean kolab_imapx_meta_data_db_folder_update (CamelKolabIMAPXMetaDataDB*, const gchar*, const struct _CamelKolabFolderMetaData*, GError**);
gboolean kolab_imapx_meta_data_db_update (CamelKolabIMAPXMetaDataDB*, GHashTable*, GError**);
struct _CamelKolabFolderMetaData *kolab_imapx_meta_data_db_lookup (CamelKolabIMAPXMetaDataDB*, const gchar*, GError**);
gboolean kolab_imapx_meta_data_db_remove_folder (CamelKolabIMAPXMetaDataDB*, const gchar*, GError**);

/*----------------------------------------------------------------------------*/

#endif /* _CAMEL_KOLAB_IMAPX_METADATA_DB_H_ */

/*----------------------------------------------------------------------------*/
