/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * evolution-kolab
 * Copyright (C) Silvan Marco Fin 2011 <silvan@kernelconcepts.de>
 * 
 * evolution-kolab is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * evolution-kolab is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _KOLAB_UTIL_CONTACT_H_
#define _KOLAB_UTIL_CONTACT_H_

#include <libekolab/kolab-mail-access.h>

#include <glib-object.h>
#include <libebook/e-contact.h>
#include <libedata-book/e-data-book-types.h>
#include <libedata-book/e-book-backend-sync.h>

G_BEGIN_DECLS

gboolean kolab_util_contact_has_id (EContact *contact);
void kolab_util_contact_gen_uid_if_none (EContact **contact);
KolabMailAccessOpmodeID kolab_util_contact_deploy_mode_by_koma (KolabMailAccess *koma, KolabMailAccessOpmodeID koma_mode);
gboolean kolab_util_contact_deploy_mode_by_backend (KolabMailAccess *koma, GNOME_Evolution_Addressbook_BookMode backend_mode);
void kolab_util_contact_store (EContact *econtact, KolabMailAccess *koma, const gchar *uri, GError **error);
EBookBackendSyncStatus kolab_util_contact_map_error (GError *error);

G_END_DECLS

#endif /* _KOLAB_UTIL_CONTACT_H_ */
