/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * This file is part of capuchin-glib. 
 *
 * Copyright (C) Sebastian Pölsterl 2008 <marduk@k-d-w.org>
 * 
 * capuchin-glib is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option)
 * any later version.
 * 
 * capuchin-glib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with capuchin-glib.
 * If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _CAPUCHIN_G_APP_OBJECT_H_
#define _CAPUCHIN_G_APP_OBJECT_H_

#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include <capuchin-glib/capuchin-g-plugin-info.h>
#include <capuchin-glib/capuchin-g-plugin-author.h>

G_BEGIN_DECLS

#define CAPUCHIN_TYPE_G_APP_OBJECT             (capuchin_g_app_object_get_type ())
#define CAPUCHIN_G_APP_OBJECT(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAPUCHIN_TYPE_G_APP_OBJECT, CapuchinGAppObject))
#define CAPUCHIN_G_APP_OBJECT_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), CAPUCHIN_TYPE_G_APP_OBJECT, CapuchinGAppObjectClass))
#define CAPUCHIN_IS_G_APP_OBJECT(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAPUCHIN_TYPE_G_APP_OBJECT))
#define CAPUCHIN_IS_G_APP_OBJECT_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), CAPUCHIN_TYPE_G_APP_OBJECT))
#define CAPUCHIN_G_APP_OBJECT_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), CAPUCHIN_TYPE_G_APP_OBJECT, CapuchinGAppObjectClass))

/*< private >*/
typedef struct _CapuchinGAppObjectPrivate CapuchinGAppObjectPrivate;

typedef struct _CapuchinGAppObjectClass CapuchinGAppObjectClass;
typedef struct _CapuchinGAppObject CapuchinGAppObject;

typedef enum /*< underscore_name=capuchin_g_app_object_action >*/
{
	CAPUCHIN_G_APP_OBJECT_ACTION_UPDATING_REPO,
	CAPUCHIN_G_APP_OBJECT_ACTION_DOWNLOADING_PLUGIN,
	CAPUCHIN_G_APP_OBJECT_ACTION_EXTRACTING_PLUGIN
} CapuchinGAppObjectActionType;

struct _CapuchinGAppObjectClass
{
	GObjectClass parent_class;
	
	/* Signals */
	void (*update_finished)(CapuchinGAppObject *appobject);
	void (*install_finished)(CapuchinGAppObject *appobject,
							 const gchar *plugin_id);
	void (*status)(CapuchinGAppObject *appobject,
				   CapuchinGAppObjectActionType type,
				   const gchar *plugin_id,
				   gdouble progress,
				   gint speed);
};

struct _CapuchinGAppObject
{
	GObject parent_instance;
	CapuchinGAppObjectPrivate *priv;
};

GType capuchin_g_app_object_get_type (void) G_GNUC_CONST;
CapuchinGAppObject* capuchin_g_app_object_new (DBusGProxy *proxy);
void capuchin_g_app_object_update (CapuchinGAppObject *appobject, gboolean force_update, GError **error);
void capuchin_g_app_object_update_async (CapuchinGAppObject *appobject, gboolean force_update);
void capuchin_g_app_object_install (CapuchinGAppObject *appobject, const gchar *plugin_id, GError **error);
gchar* capuchin_g_app_object_get_application_name (CapuchinGAppObject *appobject, GError **error);
gchar** capuchin_g_app_object_get_available_plugins (CapuchinGAppObject *appobject, GError **error);
gchar** capuchin_g_app_object_get_available_updates (CapuchinGAppObject *appobject, CapuchinGPluginInfo **plugins, GError **error);
gchar** capuchin_g_app_object_get_plugins_with_tag (CapuchinGAppObject *appobject, const gchar *tag, GError **error);
gchar* capuchin_g_app_object_get_plugin_name (CapuchinGAppObject *appobject, const gchar *plugin_id, GError **error);
gchar* capuchin_g_app_object_get_plugin_description (CapuchinGAppObject *appobject, const gchar *plugin_id, GError **error);
gchar* capuchin_g_app_object_get_plugin_changes (CapuchinGAppObject *appobject, const gchar *plugin_id, const gchar *version, GError **error);
gchar** capuchin_g_app_object_get_plugin_tags (CapuchinGAppObject *appobject, const gchar *plugin_id, GError **error);
CapuchinGPluginAuthor* capuchin_g_app_object_get_plugin_author (CapuchinGAppObject *appobject, const gchar *plugin_id, GError **error);
gchar* capuchin_g_app_object_get_plugin_version (CapuchinGAppObject *appobject, const gchar *plugin_id, GError **error);
gchar** capuchin_g_app_object_get_tags (CapuchinGAppObject *appobject, GError **error);
void capuchin_g_app_object_close (CapuchinGAppObject *appobject, GError **error);

G_END_DECLS

#endif /* _CAPUCHIN_G_APP_OBJECT_H_ */
