#include <stdio.h>
#include <orb/orbit.h>

int main(int argc, char *argv[])
{
	CORBA_Environment ev;
	CORBA_ORB orb;
	CORBA_Repository ir;
	CORBA_ConstantDef constant;
	CORBA_IDLType type;
	CORBA_any any;
	CORBA_long fooval=1;

	CORBA_exception_init(&ev);
	orb = CORBA_ORB_init(&argc, argv, "orbit-local-orb", &ev);

	ir=CORBA_ORB_resolve_initial_references(orb, "InterfaceRepository", &ev);
	if(CORBA_Object_is_nil(ir, &ev)) {
		g_print("No Interface Repo found.\n");
		exit(0);
	}

	any._type = TC_CORBA_long;
	any._value = &fooval;

	constant=CORBA_Repository_create_constant(ir, "IDL:wibble:1.0", "wibble", "1.0", ir, &any, &ev);
	g_print("%s\n", CORBA_ConstantDef__get_id(constant, &ev));

	CORBA_Object_release((CORBA_Object) ir, &ev);
	CORBA_Object_release((CORBA_Object) constant, &ev);
	CORBA_Object_release((CORBA_Object) orb, &ev);

	return 0;
}
