/*******************************************************************************
* output.cpp: output streams
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: output.cpp,v 1.3 2001/11/22 01:51:12 bozo Exp $
*
* Authors: Benoit Steiner <benny@via.ecp.fr>
*          Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


//------------------------------------------------------------------------------
// Preamble
//------------------------------------------------------------------------------
#include "../core/defs.h"

#include "config.h"
#include "../core/core.h"
#include "../mpeg/mpeg.h"
#include "../mpeg/ts.h"
#include "buffer.h"
#include "output.h"



//******************************************************************************
// E_Output class
//******************************************************************************
//
//******************************************************************************
E_Output::E_Output(const C_String& strMsg, const E_Exception& e) :
                                                 E_Exception(GEN_ERR, strMsg, e)
{
}


//******************************************************************************
// C_Output class
//******************************************************************************
//
//******************************************************************************


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_Output::C_Output(unsigned int iBuffSize) : m_cTsBuff(iBuffSize)
{
  // Byte loss couter initialisation
  m_iByteLost = 0;

  ZERO(m_pTsProvider);
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_Output::~C_Output()
{
  ZERO(m_pTsProvider);

  ASSERT(m_cTsBuff.Size() == 0);
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void C_Output::Init(C_NetList* pTsProvider)
{
  ASSERT(pTsProvider);
  m_pTsProvider = pTsProvider;

  ASSERT(m_cTsBuff.Size() == 0);
  OnInit();
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void C_Output::Close()
{
  Flush();
  OnClose();
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// Bla Bla sur buffer
//------------------------------------------------------------------------------
void C_Output::Send(C_TsPacket* pPacket)
{
  ASSERT(pPacket);

  // Append the packet to the buffer for later write to the output
  int iRc = m_cTsBuff.Push(pPacket);
  ASSERT(!iRc);

  if(m_cTsBuff.Size() == m_cTsBuff.Capacity())
  {
    // Send the buffered packets to the device and give them back to the
    // netlist
    WriteToPort();
  }
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void C_Output::Flush()
{
  WriteToPort();
}


