/*****************************************************************************
 * vlm-jni.cc: JNI native VLM functions for VLC Java Bindings
 *****************************************************************************
 * Copyright (C) 1998-2006 the VideoLAN team
 *
 * Authors: Philippe Morin <phmorin@free.fr>
 *
 *
 * $Id $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <jni.h>

#include <vlc/libvlc.h>

/* JVLC internal imports, generated by gcjh */
#include "../includes/VLM.h"
#include "utils.h"

JNIEXPORT void JNICALL Java_org_videolan_jvlc_VLM__1addBroadcast (JNIEnv *env, jobject _this, jstring name, jstring inputmrl, jstring outputmrl, jobjectArray options, jboolean enable, jboolean loop) 
{
    INIT_FUNCTION;
    const char* psz_name = env->GetStringUTFChars( name, 0 );	
    const char* psz_inputmrl = env->GetStringUTFChars( inputmrl, 0 );    
    const char* psz_outputmrl = env->GetStringUTFChars( outputmrl, 0 );        
    int i_options = 0;
    const char** ppsz_options = NULL;
    
    if ( options != NULL ) {
        i_options = ( int ) env->GetArrayLength( ( jarray ) options );
        ppsz_options = ( const char ** ) malloc( i_options * sizeof( char* ) );
        
        for ( int i = 0; i < i_options - 1; i++ ) {
            ppsz_options[ i ] = 
                env->GetStringUTFChars( ( jstring ) env->GetObjectArrayElement( options, i ), 0 );
        }
    }

    libvlc_vlm_add_broadcast( (libvlc_instance_t *) instance, (char*)psz_name, (char*)psz_inputmrl, (char*)psz_outputmrl ,
                              i_options, (char**)ppsz_options, enable, loop, exception );

    CHECK_EXCEPTION_FREE ;

    
    if (psz_name != NULL) {
        env->ReleaseStringUTFChars( name, psz_name );
    }    
    if (psz_inputmrl != NULL) {
        env->ReleaseStringUTFChars( inputmrl, psz_inputmrl );
    }    
    if (psz_outputmrl != NULL) {
        env->ReleaseStringUTFChars( outputmrl, psz_outputmrl );
    }
}

JNIEXPORT void JNICALL Java_org_videolan_jvlc_VLM__1deleteMedia (JNIEnv *env, jobject _this, jstring name) 
{
    INIT_FUNCTION ;
    const char* psz_name = env->GetStringUTFChars( name, 0 );

    libvlc_vlm_del_media( (libvlc_instance_t *) instance, (char*)psz_name, exception);    
    CHECK_EXCEPTION_FREE ;

    if (psz_name != NULL) {
        env->ReleaseStringUTFChars( name, psz_name );
    }    
}

JNIEXPORT void JNICALL Java_org_videolan_jvlc_VLM__1setEnabled (JNIEnv *env, jobject _this, jstring name, jboolean newStatus) 
{
    INIT_FUNCTION ;
    const char* psz_name = env->GetStringUTFChars( name, 0 );

    libvlc_vlm_set_enabled( (libvlc_instance_t *) instance, (char*)psz_name, newStatus, exception);
    CHECK_EXCEPTION_FREE ;

    if (psz_name != NULL) {
        env->ReleaseStringUTFChars( name, psz_name );
    }        
}

JNIEXPORT void JNICALL Java_org_videolan_jvlc_VLM__1setOutput (JNIEnv *env, jobject _this, jstring name, jstring mrl) 
{
    INIT_FUNCTION;
    const char* psz_name = env->GetStringUTFChars( name, 0 );
    const char* psz_mrl = env->GetStringUTFChars( mrl, 0 );    

    libvlc_vlm_set_output((libvlc_instance_t *) instance, (char*)psz_name, (char*)psz_mrl, exception);
    CHECK_EXCEPTION_FREE ;

    if (psz_name != NULL) {
        env->ReleaseStringUTFChars( name, psz_name );
    }    

    if (psz_mrl != NULL) {
        env->ReleaseStringUTFChars( mrl, psz_mrl );
    }    
}

JNIEXPORT void JNICALL Java_org_videolan_jvlc_VLM__1setInput (JNIEnv *env, jobject _this, jstring name, jstring mrl) 
{
    INIT_FUNCTION;
    const char* psz_name = env->GetStringUTFChars( name, 0 );
    const char* psz_mrl = env->GetStringUTFChars( mrl, 0 );    

    libvlc_vlm_set_input((libvlc_instance_t *) instance, (char*)psz_name, (char*)psz_mrl, exception);
    CHECK_EXCEPTION_FREE ;

    if (psz_name != NULL) {
        env->ReleaseStringUTFChars( name, psz_name );
    }    
    if (psz_mrl != NULL) {
        env->ReleaseStringUTFChars( mrl, psz_mrl );
    }    
}

JNIEXPORT void JNICALL Java_org_videolan_jvlc_VLM__1setLoop (JNIEnv *env, jobject _this, jstring name, jboolean newStatus) 
{
    INIT_FUNCTION;
    const char* psz_name = env->GetStringUTFChars( name, 0 );

    libvlc_vlm_set_loop((libvlc_instance_t *) instance, (char*)psz_name, newStatus, exception);
    CHECK_EXCEPTION_FREE ;

    if (psz_name != NULL) {
        env->ReleaseStringUTFChars( name, psz_name );
    }    
}

JNIEXPORT void JNICALL Java_org_videolan_jvlc_VLM__1changeMedia (JNIEnv *env, jobject _this, jstring name, jstring inputmrl, jstring outputmrl, jobjectArray options, jboolean enablenewbroadcast, jboolean broadcast) 
{
    INIT_FUNCTION;
    int i_options = 0;
    const char** ppsz_options = NULL;
    const char* psz_name      = env->GetStringUTFChars( name, 0 );
    const char* psz_inputmrl  = env->GetStringUTFChars( inputmrl, 0 );    
    const char* psz_outputmrl = env->GetStringUTFChars( outputmrl, 0 );        

    if ( options != NULL ) {
        i_options = ( int ) env->GetArrayLength( ( jarray ) options );
        ppsz_options = ( const char ** ) malloc( i_options * sizeof( char* ) );
        
        for ( int i = 0; i < i_options - 1; i++ ) {
            ppsz_options[ i ] = 
                env->GetStringUTFChars( ( jstring ) env->GetObjectArrayElement( options, i ), 0 );
        }
    }

    libvlc_vlm_change_media( (libvlc_instance_t *) instance, (char*)psz_name, (char*)psz_inputmrl, (char*)psz_outputmrl ,
                              i_options, (char**)ppsz_options, enablenewbroadcast, broadcast, exception );
    CHECK_EXCEPTION_FREE ;
    
    if (psz_name != NULL) {
        env->ReleaseStringUTFChars( name, psz_name );
    }    
    
    if (psz_inputmrl != NULL) {
       env->ReleaseStringUTFChars( name, psz_inputmrl );
    }    
   
    if (psz_outputmrl != NULL) {
        env->ReleaseStringUTFChars( name, psz_outputmrl );
    }
}

JNIEXPORT void JNICALL Java_org_videolan_jvlc_VLM__1playMedia (JNIEnv *env, jobject _this, jstring name) 
{
    INIT_FUNCTION;
    const char* psz_name = env->GetStringUTFChars( name, 0 );

    libvlc_vlm_play_media( (libvlc_instance_t *) instance, (char*)psz_name, exception );
    CHECK_EXCEPTION_FREE ;

    if (psz_name != NULL) {
        env->ReleaseStringUTFChars( name, psz_name );
    }
}

JNIEXPORT void JNICALL Java_org_videolan_jvlc_VLM__1stopMedia (JNIEnv *env, jobject _this, jstring name) 
{
    INIT_FUNCTION;
    const char* psz_name = env->GetStringUTFChars( name, 0 );


    libvlc_vlm_stop_media( (libvlc_instance_t *) instance, (char*)psz_name, exception );
    CHECK_EXCEPTION_FREE ;

    if (psz_name != NULL) {
        env->ReleaseStringUTFChars( name, psz_name );
    }
}

JNIEXPORT void JNICALL Java_org_videolan_jvlc_VLM__1pauseMedia (JNIEnv *env, jobject _this, jstring name) 
{
    INIT_FUNCTION;
    const char* psz_name = env->GetStringUTFChars( name, 0 );
   
    libvlc_vlm_pause_media( (libvlc_instance_t *) instance, (char*)psz_name, exception );
    CHECK_EXCEPTION_FREE ;

    if (psz_name != NULL) {
        env->ReleaseStringUTFChars( name, psz_name );
    }    
}
