package org.videolan.vlc.databinding;
import org.videolan.vlc.R;
import org.videolan.vlc.BR;
import android.view.View;
public class VideoGridCardBinding extends android.databinding.ViewDataBinding {
    
    private static final android.databinding.ViewDataBinding.IncludedLayouts sIncludes;
    private static final android.util.SparseIntArray sViewsWithIds;
    static {
        sIncludes = null;
        sViewsWithIds = new android.util.SparseIntArray();
        sViewsWithIds.put(R.id.card_view, 7);
        sViewsWithIds.put(R.id.layout_item, 8);
    }
    // views
    public final android.support.v7.widget.CardView cardView;
    public final android.widget.ImageView itemMore;
    public final android.widget.LinearLayout layoutItem;
    private final android.widget.FrameLayout mboundView0;
    public final android.widget.ProgressBar mlItemProgress;
    public final android.widget.TextView mlItemResolution;
    public final android.widget.ImageView mlItemThumbnail;
    public final android.widget.TextView mlItemTime;
    public final android.widget.TextView mlItemTitle;
    // variables
    private android.graphics.drawable.BitmapDrawable mCover;
    private org.videolan.vlc.media.MediaWrapper mMedia;
    private android.widget.ImageView.ScaleType mScaleType;
    private org.videolan.vlc.gui.video.VideoListAdapter.ViewHolder mHolder;
    private java.lang.String mTime;
    private int mProgress;
    private java.lang.String mResolution;
    private int mMax;
    // values
    // listeners
    private OnClickListenerImpl mAndroidViewViewOnCl;
    private OnClickListenerImpl1 mAndroidViewViewOnCl1;
    
    public VideoGridCardBinding(android.databinding.DataBindingComponent bindingComponent, View root) {
        super(bindingComponent, root, 0);
        final Object[] bindings = mapBindings(bindingComponent, root, 9, sIncludes, sViewsWithIds);
        this.cardView = (android.support.v7.widget.CardView) bindings[7];
        this.itemMore = (android.widget.ImageView) bindings[3];
        this.itemMore.setTag(null);
        this.layoutItem = (android.widget.LinearLayout) bindings[8];
        this.mboundView0 = (android.widget.FrameLayout) bindings[0];
        this.mlItemProgress = (android.widget.ProgressBar) bindings[6];
        this.mlItemProgress.setTag(null);
        this.mlItemResolution = (android.widget.TextView) bindings[5];
        this.mlItemResolution.setTag(null);
        this.mlItemThumbnail = (android.widget.ImageView) bindings[1];
        this.mlItemThumbnail.setTag(null);
        this.mlItemTime = (android.widget.TextView) bindings[4];
        this.mlItemTime.setTag(null);
        this.mlItemTitle = (android.widget.TextView) bindings[2];
        this.mlItemTitle.setTag(null);
        setRootTag(root);
        invalidateAll();
    }
    
    @Override
    public void invalidateAll() {
        synchronized(this) {
            mDirtyFlags = 0b100000000L;
        }
        requestRebind();
    }
    
    @Override
    public boolean hasPendingBindings() {
        synchronized(this) {
            if (mDirtyFlags != 0) {
                return true;
            }
        }
        return false;
    }
    
    public boolean setVariable(int variableId, Object variable) {
        switch(variableId) {
            case BR.cover :
                setCover((android.graphics.drawable.BitmapDrawable) variable);
                return true;
            case BR.media :
                setMedia((org.videolan.vlc.media.MediaWrapper) variable);
                return true;
            case BR.scaleType :
                setScaleType((android.widget.ImageView.ScaleType) variable);
                return true;
            case BR.holder :
                setHolder((org.videolan.vlc.gui.video.VideoListAdapter.ViewHolder) variable);
                return true;
            case BR.time :
                setTime((java.lang.String) variable);
                return true;
            case BR.progress :
                setProgress((int) variable);
                return true;
            case BR.resolution :
                setResolution((java.lang.String) variable);
                return true;
            case BR.max :
                setMax((int) variable);
                return true;
        }
        return false;
    }
    
    public void setCover(android.graphics.drawable.BitmapDrawable cover) {
        this.mCover = cover;
        synchronized(this) {
            mDirtyFlags |= 0b1L;
        }
        super.requestRebind();
    }
    public android.graphics.drawable.BitmapDrawable getCover() {
        return mCover;
    }
    public void setMedia(org.videolan.vlc.media.MediaWrapper media) {
        this.mMedia = media;
        synchronized(this) {
            mDirtyFlags |= 0b10L;
        }
        super.requestRebind();
    }
    public org.videolan.vlc.media.MediaWrapper getMedia() {
        return mMedia;
    }
    public void setScaleType(android.widget.ImageView.ScaleType scaleType) {
        this.mScaleType = scaleType;
        synchronized(this) {
            mDirtyFlags |= 0b100L;
        }
        super.requestRebind();
    }
    public android.widget.ImageView.ScaleType getScaleType() {
        return mScaleType;
    }
    public void setHolder(org.videolan.vlc.gui.video.VideoListAdapter.ViewHolder holder) {
        this.mHolder = holder;
        synchronized(this) {
            mDirtyFlags |= 0b1000L;
        }
        super.requestRebind();
    }
    public org.videolan.vlc.gui.video.VideoListAdapter.ViewHolder getHolder() {
        return mHolder;
    }
    public void setTime(java.lang.String time) {
        this.mTime = time;
        synchronized(this) {
            mDirtyFlags |= 0b10000L;
        }
        super.requestRebind();
    }
    public java.lang.String getTime() {
        return mTime;
    }
    public void setProgress(int progress) {
        this.mProgress = progress;
        synchronized(this) {
            mDirtyFlags |= 0b100000L;
        }
        super.requestRebind();
    }
    public int getProgress() {
        return mProgress;
    }
    public void setResolution(java.lang.String resolution) {
        this.mResolution = resolution;
        synchronized(this) {
            mDirtyFlags |= 0b1000000L;
        }
        super.requestRebind();
    }
    public java.lang.String getResolution() {
        return mResolution;
    }
    public void setMax(int max) {
        this.mMax = max;
        synchronized(this) {
            mDirtyFlags |= 0b10000000L;
        }
        super.requestRebind();
    }
    public int getMax() {
        return mMax;
    }
    
    @Override
    protected boolean onFieldChange(int localFieldId, Object object, int fieldId) {
        switch (localFieldId) {
        }
        return false;
    }
    
    @Override
    protected void executeBindings() {
        long dirtyFlags = 0;
        synchronized(this) {
            dirtyFlags = mDirtyFlags;
            mDirtyFlags = 0;
        }
        android.graphics.drawable.BitmapDrawable cover = mCover;
        org.videolan.vlc.media.MediaWrapper media = mMedia;
        android.widget.ImageView.ScaleType scaleType = mScaleType;
        boolean MaxInt0 = false;
        org.videolan.vlc.gui.video.VideoListAdapter.ViewHolder holder = mHolder;
        java.lang.String time = mTime;
        android.view.View.OnClickListener androidViewViewOnCli = null;
        android.view.View.OnClickListener androidViewViewOnCli1 = null;
        int progress = mProgress;
        java.lang.String titleMedia = null;
        java.lang.String resolution = mResolution;
        int max = mMax;
        int MaxInt0INVISIBLEView = 0;
    
        if ((dirtyFlags & 0b100000001L) != 0) {
            // read cover~
            cover = cover;
        }
        if ((dirtyFlags & 0b100000010L) != 0) {
            // read media~
            media = media;
        
            if (media != null) {
                // read title~.~media~
                titleMedia = media.getTitle();
            }
        }
        if ((dirtyFlags & 0b100000100L) != 0) {
            // read scaleType~
            scaleType = scaleType;
        }
        if ((dirtyFlags & 0b100001000L) != 0) {
            // read holder~
            holder = holder;
        
            if (holder != null) {
                // read android.view.View.OnClickListener~holder~~onMoreClick
                androidViewViewOnCli = (((mAndroidViewViewOnCl == null) ? (mAndroidViewViewOnCl = new OnClickListenerImpl()) : mAndroidViewViewOnCl).setValue(holder));
                // read android.view.View.OnClickListener~holder~~onClick
                androidViewViewOnCli1 = (((mAndroidViewViewOnCl1 == null) ? (mAndroidViewViewOnCl1 = new OnClickListenerImpl1()) : mAndroidViewViewOnCl1).setValue(holder));
            }
        }
        if ((dirtyFlags & 0b100010000L) != 0) {
            // read time~
            time = time;
        }
        if ((dirtyFlags & 0b100100000L) != 0) {
            // read progress~
            progress = progress;
        }
        if ((dirtyFlags & 0b101000000L) != 0) {
            // read resolution~
            resolution = resolution;
        }
        if ((dirtyFlags & 0b110000000L) != 0) {
            // read max~
            max = max;
        
            // read ==~max~~int0
            MaxInt0 = max==0;
            if((dirtyFlags & 0b110000000L) != 0) {
                if (MaxInt0) {
                    dirtyFlags |= 0b10000000000L;
                } else {
                    dirtyFlags |= 0b1000000000L;
                }}
        
            // read ?:==~max~~int0~INVISIBLE~.~View~~VISIBLE~.~View~
            MaxInt0INVISIBLEView = MaxInt0 ? android.view.View.INVISIBLE : android.view.View.VISIBLE;
        }
        // batch finished
        if ((dirtyFlags & 0b100001000L) != 0) {
            // api target 1
            this.itemMore.setOnClickListener(androidViewViewOnCli);
            this.mboundView0.setOnClickListener(androidViewViewOnCli1);
        }
        if ((dirtyFlags & 0b110000000L) != 0) {
            // api target 1
            this.mlItemProgress.setMax(max);
            this.mlItemProgress.setVisibility(MaxInt0INVISIBLEView);
        }
        if ((dirtyFlags & 0b100100000L) != 0) {
            // api target 1
            this.mlItemProgress.setProgress(progress);
        }
        if ((dirtyFlags & 0b101000000L) != 0) {
            // api target 1
            this.mlItemResolution.setText(resolution);
        }
        if ((dirtyFlags & 0b100000100L) != 0) {
            // api target 1
            this.mlItemThumbnail.setScaleType(scaleType);
        }
        if ((dirtyFlags & 0b100000001L) != 0) {
            // api target 1
            android.databinding.adapters.ImageViewBindingAdapter.setImageDrawable(this.mlItemThumbnail, cover);
        }
        if ((dirtyFlags & 0b100010000L) != 0) {
            // api target 1
            this.mlItemTime.setText(time);
        }
        if ((dirtyFlags & 0b100000010L) != 0) {
            // api target 1
            this.mlItemTitle.setText(titleMedia);
        }
    }
    // Listener Stub Implementations
    public static class OnClickListenerImpl implements android.view.View.OnClickListener{
        private org.videolan.vlc.gui.video.VideoListAdapter.ViewHolder value;
        public OnClickListenerImpl setValue(org.videolan.vlc.gui.video.VideoListAdapter.ViewHolder value) {
            this.value = value;
            return value == null ? null : this;
        }
        @Override
        public void onClick(android.view.View arg0) {
            this.value.onMoreClick(arg0);
        }
    }
    public static class OnClickListenerImpl1 implements android.view.View.OnClickListener{
        private org.videolan.vlc.gui.video.VideoListAdapter.ViewHolder value;
        public OnClickListenerImpl1 setValue(org.videolan.vlc.gui.video.VideoListAdapter.ViewHolder value) {
            this.value = value;
            return value == null ? null : this;
        }
        @Override
        public void onClick(android.view.View arg0) {
            this.value.onClick(arg0);
        }
    }
    // dirty flag
    private  long mDirtyFlags = 0b1111111111111111111111111111111111111111111111111111111111111111L;
    
    public static VideoGridCardBinding inflate(android.view.LayoutInflater inflater, android.view.ViewGroup root, boolean attachToRoot) {
        return inflate(inflater, root, attachToRoot, android.databinding.DataBindingUtil.getDefaultComponent());
    }
    public static VideoGridCardBinding inflate(android.view.LayoutInflater inflater, android.view.ViewGroup root, boolean attachToRoot, android.databinding.DataBindingComponent bindingComponent) {
        return android.databinding.DataBindingUtil.<VideoGridCardBinding>inflate(inflater, org.videolan.vlc.R.layout.video_grid_card, root, attachToRoot, bindingComponent);
    }
    public static VideoGridCardBinding inflate(android.view.LayoutInflater inflater) {
        return inflate(inflater, android.databinding.DataBindingUtil.getDefaultComponent());
    }
    public static VideoGridCardBinding inflate(android.view.LayoutInflater inflater, android.databinding.DataBindingComponent bindingComponent) {
        return bind(inflater.inflate(org.videolan.vlc.R.layout.video_grid_card, null, false), bindingComponent);
    }
    public static VideoGridCardBinding bind(android.view.View view) {
        return bind(view, android.databinding.DataBindingUtil.getDefaultComponent());
    }
    public static VideoGridCardBinding bind(android.view.View view, android.databinding.DataBindingComponent bindingComponent) {
        if (!"layout/video_grid_card_0".equals(view.getTag())) {
            throw new RuntimeException("view tag isn't correct on view:" + view.getTag());
        }
        return new VideoGridCardBinding(bindingComponent, view);
    }
}
    /* flag mapping
        flag 0: cover~
        flag 1: media~
        flag 2: scaleType~
        flag 3: holder~
        flag 4: time~
        flag 5: progress~
        flag 6: resolution~
        flag 7: max~
        flag 8: INVALIDATE ANY
        flag 9: ?:==~max~~int0~INVISIBLE~.~View~~VISIBLE~.~View~== false
        flag 10: ?:==~max~~int0~INVISIBLE~.~View~~VISIBLE~.~View~== true
    flag mapping end*/
    //end