This is PL 1 of a port of Sun RPC 4.0 to Mint and MintNet >= 0.30.

Installation:
-------------

There is a complete installation in installdir, which looks like
an *x root directory. You should put the files from installdir
to the appropriate directories in your root dir, ie do the
equivalent of:
	cd installdir; cp -R * /

You must start /etc/portmap before running any rpc services, eg
from mint.cnf, or rc.local.

After this you might want to try out the demo programs. Cd to
demos and type make. You should get at least two executeables
in each subdir, the server (*_svc) and the client. Run the server
in the background and then start the client.

Changes:
--------

*** PL 1:
	- removed the patches to get along without net/if.h
	  introduced in PL 0. MintNet as of 0.3 has real net
	  interfaces.

*** PL 0:

doc/:
	- No changes, of course. You will need groff or another `real'
	  nroff+pic+eqn+tbl plus a working tmac.s macro package.
	  Tell we if you want me to include preformatted versions.

etc/:
	- Made portmap ignore TCP requests (otherwise it will complain
	  about not beeing able to create a TCP client and exit).
	- Changed a fork() into __fork_and_exit().
	- Changed `rpcinfo -p' (dump services) to use UDP instead of TCP.
	- Set the stacksize of portmap and rpcinfo to 16k. Without this (eg
	  _stksize = 0) they will crash when broadcasting (rpcinfo -b).
	- BTW: It is always a good idea to set the stacksize to at least 8k
	  when using rpc/xdr stuff, especially when the name resolver is
	  invoked (as with get_myaddress()), since some xdr routines are
	  recursive and therefore need lots of stack space. If your programs
	  crash try increasing the stack first.

rpc/:
	- Serveral hacks to get rid of the net interface stuff in
	  net/if.h. This can be changed back when MintNet gets real
	  net interfaces. (Use the nameserver for get_myaddress() instead
	  of looping through the net interfaces. Use INADDR_BROADCAST as
	  the broadcast address instead of looping trough the net interfaces.)
	- Use O_NDELAY nonblocking mode instead of using FIONBIO.
	- Fixed a bug in clnttcp_create() which caused a bind(-1, ...)
	  to be done.
	- Changed clnt_spcreateerror() to make it display messages for
	  the socket related errors instead of error numbers.

rpcgen/:
	- Fixed a bug in rpc_parse.c:def_program() which caused unter-
	  minated linked lists -> crash.
	- Configured to generate UDP code by default.
	- Changed so that it loads the preprocessor from $(GCCEXEC)cpp
	  or from /usr/lib/cpp if GCCEXEC is not set.
	- Added code to check for memory allocation failures (the original
	  sources did not check whether malloc() returned 0)

rpcsvc/:
	All the stuff except the files dealing with rstat/rstatd are
	unchanged. rstatd/rstat work, but rstatd produces very bogus
	output:
	- boottime is the time when rstatd was started
	- havedisk is true when there are any drives C...P
	- current time works ok :)
	- swap in/out, page in/out are correct (zero for MiNT)
	- all other infos (load avg, # net if's, xfer, # contex
	  switches, # interrupts, ...) are always zero

demo/:
	- Configured the demos to use UDP.
	- Set stacksize of dir/{dir_svc, rls} to 16k.

Compilation:
------------

I used gcc 2.4.5 to compile and loaded MintLib PL 42, Socket Lib 0.23,
and Portlib PL 01.

Note that Portlib is NOT part of this distribution.
Note also that you cannot compile librpc.olb with old SocketLibs < 0.23
without changing netdb.h.

Bugs:
-----

- If you do an `rpcinfo -b portmapper 2' (broadcast to portmapper, version 2),
  you won't get responses from the local machines portmapper.
  This is because of MiNT's blocking fork(). Have a look at portmap.c:callit()
  to understand why.

Because TCP is not implemented yet, all the rpc tcp stuff is
compiled in, but does not work. This means:
- I have configured rpcgen to generate UDP code by default.
- I have configured the example programs and rpcinfo to use UDP.


Enjoy and please report any bugs you encounter...
Ports of rpc services (rex, spray, yp, ...) are also welcome.

Kay Roemer,
roemer@hera.rbi.informatik.uni-frankfurt.de
