/*
 * u_long gethostid (void) -- get 32 bit host identification number.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <support.h>
#include "portlib.h"

u_long
gethostid (void)
{
	struct hostent *hp;
	static char hname[MAXHOSTNAMELEN];

	if (gethostname (hname, sizeof (hname) < 0))
		return INADDR_NONE;
	if (!(hp = gethostbyname (hname)))
		return INADDR_NONE;
	return *(u_long *)hp->h_addr;
}
