#include <aesbind.h>
#include <gemdefs.h>
#include <vdibind.h>
#include <osbind.h>
#include <macros.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include <dirent.h>


#include "gemmail.h"
#include "folder.h"
#include "mailrsc.h"

#define WINDOW_PARTS NAME|CLOSER|MOVER|SMALLER|INFO|SIZER|FULLER|UPARROW|DNARROW|VSLIDE/*|LFARROW|RTARROW|HSLIDE*/

TEDINFO *c_text;
int selectedfolder=0,noofselmsgs=0;
int iconified=0,totallines=0,tmpfilecount=0;
OBJECT *letterbox,*letters,*menubar,*about_d,*creatf_d;
struct stat filestat;
GRECT full,window_dim;
int i,charw,charh,boxw,boxh,wincharx,winchary;
DIR *mailfolder;
struct dirent *folders;
char foldername[100][64], maildir[256],menutitle[20];
int foldernos=1,folderno=0;
struct passwd *pwd;
int displaylineno=0;
FOLDER newmail;
extern char *optarg;
extern int errno;


typedef struct tmpmsgname{
int app_id;
char tmpfilename[256];
} TMPMSG;

main(int argc,char *argv[])
{
	char pwd_error[]="[3][The user does not exist][Quit]";
	char vdi_error[]="[3][Error Opening Virtual|Workstation][Quit]";
	char window_error[]="[3][Error Opening Windows][Quit]";
	char rsc_error[]="[3][Error Opening Resource][Quit]";
	char *showprog,*sendprog,*tmpdir;
		char *username=NULL ,title[50],infoline[60];
	char infotemp[50],tmp[128];
	
	int work_in[12],work_out[57],rez;
	int vdihandle;
	int window_handle;
	int msg[8],isfull=0;

	int mx,my,button,shift,keycode,clicked,event;

	FOLDER otherfolder,*openfolder;
	FILE *fp;

	mx=Dgetdrv();
	if(mx!=('U'-'A')) /* change to drive u pointing at the same place */
	{
		Dgetpath(&tmp[3],mx);
		tmp[0]='\\';
		tmp[1]=mx+'A';
		tmp[2]='\\';
		Dsetdrv('U'-'A');
		Dsetpath(tmp);
	}

	appl_init();
	graf_mouse(ARROW,0L);
	rez=Getrez();

	for(i=0,work_in[10]=2;i<10;work_in[i++]=1);
	vdihandle=graf_handle(&charw,&charh,&boxw,&boxh);

	work_in[0]=rez+2;
	v_opnvwk(work_in, &vdihandle, work_out);
	if(vdihandle==0){form_alert(1,vdi_error);appl_exit();exit(0);}



	while((i=getopt(argc,argv,"u:"))!=EOF) switch(i)
	{
		case 'u':
		username=optarg;
		break;
		default:
		username=NULL;
		break;
	}


	showprog=getenv("MAILREAD");
	sendprog=getenv("MAILSEND");

	tmpdir=getenv("TEMP");
	if(tmpdir==NULL) tmpdir=getenv("TMPDIR");
	if(tmpdir==NULL) strcpy(tmp,"u:\\tmp");
	else
	{	strcpy(tmp,"u:\\");
		strcat(tmp,tmpdir);
	}

	for(i=0;i!=100;i++){foldername[i][0]=5;foldername[i][1]=32;}
	strcpy(&foldername[0][2],"New Mail");

	if(username==NULL)	username=getlogin();

	if(gl_ap_version>=0x0400)
	{
		strcpy(menutitle,"  EMail - ");
		strcat(menutitle,username);
		menu_register(gl_apid,menutitle);
		shel_write(9,1,0,NULL,NULL);
	}


	pwd=getpwnam(username);

	if(pwd==NULL){form_alert(1,pwd_error);v_clsvwk(vdihandle);appl_exit();exit(0);}

	strcpy(maildir,"u:");
	strcat(maildir,pwd->pw_dir);
	strcat(maildir,"/Mail");



	mailfolder=opendir(maildir);
	if(mailfolder!=NULL)
	{
		folders=readdir(mailfolder);
		while(folders!=NULL)
		{
			if( !(((folders->d_name)[0]=='.' &&  (folders->d_name)[1]=='\0') ||  ((folders->d_name)[0]=='.' &&  (folders->d_name)[1]=='.' && (folders->d_name)[2]=='\0')))
				strcpy(&foldername[foldernos++][2],folders->d_name);
			folders=readdir(mailfolder);
		}
	closedir(mailfolder);
	}


	openfolder=&newmail;

	strcpy(newmail.mbox,"u:/usr/spool/mail/");
	strcat(newmail.mbox,username);

	strcpy(infoline,newmail.mbox+2);
	strcat(infoline," ");

	strcpy(title,"MAIL - ");
	strcat(title,username);

	open_folder(&newmail);
			
	if(newmail.nomsg==1)
	   sprintf(infotemp," 1 message");
	else
	   sprintf(infotemp," %d messages",newmail.nomsg);

	totallines=openfolder->nomsg+foldernos;

	strcat(infoline,infotemp);


/*	if(!rsrc_load("gemskel.rsc"))
*	{form_alert(1,rsc_error);v_clsvwk(vdihandle);appl_exit();exit(0);}
*	
*	rsrc_gaddr(R_TREE,ICON_NO_LETTER,&letterbox);
*	rsrc_gaddr(R_TREE,ICON_LETTERS,&letters);
*	rsrc_gaddr(R_TREE,MENU,&menubar);
*	rsrc_gaddr(R_TREE,ABOUT_D,&about_d);
*	rsrc_gaddr(R_TREE,CREATEFOLDER_D,&creatf_d);
*/
	met_rsc();
	letterbox=rs_tx[ICON_NO_LETTER];
	letters=rs_tx[ICON_LETTERS];
	menubar=rs_tx[MENU];
	about_d=rs_tx[ABOUT_D];
	creatf_d=rs_tx[CREATEFOLDER_D];

for(i=ABOUT_BACK;i!=ABOUTOK;
	about_d[i++].ob_flags |= FL3DBAK);
	about_d[ABOUTOK].ob_flags |= FL3DACT;

for(i=C_BACK;i!=C_OK; creatf_d[i++].ob_flags |= FL3DBAK);
	creatf_d[C_OK].ob_flags |= FL3DACT;
	creatf_d[C_CANCEL].ob_flags |= FL3DACT;

	c_text = (TEDINFO *)creatf_d[C_TEXT].ob_spec;
	*(c_text->te_ptext)=0;

	menu_bar(menubar,1);
	menu_ienable(menubar,DELFOLDER,0);
	menu_ienable(menubar,COPY,0);
	menu_ienable(menubar,MOVE,0);
	menu_ienable(menubar,DELETE,0);
	menu_ienable(menubar,REPLY,0);
/*	menu_ienable(menubar,SEND,0); */
	menu_ienable(menubar,FORWARD,0);

	wind_get(0,WF_WORKXYWH,&full.g_x,&full.g_y,&full.g_w,&full.g_h);

	window_handle=wind_create(WINDOW_PARTS,full.g_x,full.g_y,full.g_w,full.g_h);
	if(window_handle<0){form_alert(1,window_error);v_clsvwk(vdihandle);appl_exit();exit(0);}

	wind_calc(0,WINDOW_PARTS,10,60,75*charw,20*charh,&full.g_x,&full.g_y,&full.g_w,&full.g_h);

	wind_set(window_handle,WF_NAME,title,0,0);
	wind_set(window_handle,WF_CURRXYWH,full.g_x,full.g_y,full.g_w,full.g_h);
	wind_open(window_handle,full.g_x,full.g_y,full.g_w,full.g_h);
	wind_set(window_handle,WF_INFO,infoline,0,0);

	wind_get(0,WF_WORKXYWH,&full.g_x,&full.g_y,&full.g_w,&full.g_h);

	wind_get(window_handle,WF_WORKXYWH,&window_dim.g_x,&window_dim.g_y,&window_dim.g_w,&window_dim.g_h);

	wincharx=window_dim.g_w/charw;
	winchary=window_dim.g_h/charh;

	wind_set(window_handle,WF_VSLSIZE,min(1000,(1000*winchary)/totallines),0,0,0);

	msg[0]=WM_REDRAW;
	msg[1]=gl_apid;
	msg[2]=0;
	msg[3]=window_handle;
	msg[4]=window_dim.g_x;
	msg[5]=window_dim.g_y;
	msg[6]=window_dim.g_w;
	msg[7]=window_dim.g_h;
	appl_write(gl_apid,16,msg);

openfolder->status=0;

	for(;;)
	{
/*		evnt_mesag(msg); */
if(iconified)
		event=evnt_multi(MU_BUTTON|MU_MESAG|MU_TIMER,
			2,1,1,
			0,0,0,0,0,
			0,0,0,0,0,
			msg,
			60000,
			&mx,&my,&button,&shift,&keycode,&clicked);
else
		event=evnt_multi(MU_BUTTON|MU_MESAG,
			2,1,1,
			0,0,0,0,0,
			0,0,0,0,0,
			msg,
			0,
			&mx,&my,&button,&shift,&keycode,&clicked);
switch(event)
	{
	case MU_MESAG:			
		switch(msg[0])
		{
			case MN_SELECTED:
				switch(msg[4])
				{
					case ABOUT:
					{
						int x,y,w,h;
						form_center(about_d,&x,&y,&w,&h);
						form_dial(FMD_START,0,0,0,0,x,y,w,h);
						objc_draw(about_d,0,5,x,y,w,h);
						form_do(about_d,0);
						form_dial(FMD_FINISH,0,0,0,0,x,y,w,h);
						about_d[ABOUTOK].ob_state^=SELECTED;
					}
					break;
					case CREATE:
					{
						int x,y,w,h,obsel;
						form_center(creatf_d,&x,&y,&w,&h);
						form_dial(FMD_START,0,0,0,0,x,y,w,h);
						objc_draw(creatf_d,0,5,x,y,w,h);
						obsel=form_do(creatf_d,C_TEXT);
						form_dial(FMD_FINISH,0,0,0,0,x,y,w,h);
						creatf_d[obsel].ob_state^=SELECTED;
						if(obsel==C_OK)
						{
							creat_folder(c_text->te_ptext);
							totallines=foldernos+openfolder->nomsg;
							wind_set(window_handle,WF_VSLSIZE,min(1000,(1000*winchary)/totallines),0,0,0);
							wind_set(window_handle,WF_INFO,openfolder->mbox,0,0);
							wind_set(window_handle,WF_VSLIDE,1,0,0,0);
							redraw_window(vdihandle,window_handle,(GRECT*)&window_dim,&window_dim,openfolder);
						}
					}
					break;
					case QUIT:
						exit_program(vdihandle,window_handle);
					break;
					case DELFOLDER:
					if(selectedfolder!=0)
					{

						remove_folder(&foldername[selectedfolder][2]);
						if(selectedfolder==folderno)
						{
							close_folder(openfolder);
							openfolder=&newmail;
							open_folder(openfolder);
							folderno=0;
							displaylineno=0;

						}
						totallines=foldernos+openfolder->nomsg;
						wind_set(window_handle,WF_VSLSIZE,min(1000,(1000*winchary)/totallines),0,0,0);
						wind_set(window_handle,WF_INFO,openfolder->mbox,0,0);
						wind_set(window_handle,WF_VSLIDE,1,0,0,0);
	
						menu_ienable(menubar,COPY,0);
						menu_ienable(menubar,MOVE,0);
						
						selectedfolder=0;
						menu_ienable(menubar,DELFOLDER,0);
						redraw_window(vdihandle,window_handle,(GRECT*)&window_dim,&window_dim,openfolder);
					}
					break;

					case COPY:
					{
						char path[256];
						FILE *fp;
						strcpy(path,maildir);
						strcat(path,"/");
						strcat(path,&foldername[selectedfolder][2]);
						fp=fopen(path,"ab");
						copymsgs(fp,openfolder);
						fclose(fp);
					}
					break;
					case MOVE:
					{
						char path[256];
						FILE *fp;
						strcpy(path,maildir);
						strcat(path,"/");
						strcat(path,&foldername[selectedfolder][2]);
						fp=fopen(path,"ab");
						copymsgs(fp,openfolder);
						fclose(fp);
					}
					case DELETE:
						delmsgs(openfolder);
						noofselmsgs=0;
						close_folder(openfolder);
						open_folder(openfolder);
						menu_ienable(menubar,DELETE,0);
						totallines=foldernos+openfolder->nomsg;
						wind_set(window_handle,WF_VSLSIZE,min(1000,(1000*winchary)/totallines),0,0,0);
						wind_set(window_handle,WF_INFO,openfolder->mbox,0,0);
						wind_set(window_handle,WF_VSLIDE,1,0,0,0);
						menu_ienable(menubar,COPY,0);
						menu_ienable(menubar,MOVE,0);
						redraw_window(vdihandle,window_handle,(GRECT*)&window_dim,&window_dim,openfolder);
					break;

					case SEND:
					{ char tmpfilename[256];
						sprintf(&tmpfilename[1],"-u %s",username);
						tmpfilename[0]=(char)strlen(&tmpfilename[1]);
						shel_write(0,0,0,sendprog,tmpfilename);

					}
					break;
					case FORWARD:
					{	char tmpfilename[256],tmpbuf[64];
						int me,ms;
						int msgno=-1,i=0;
						while(msgno==-1)
						{
							if(openfolder->msgstatus[i])msgno=i;
							i++;
						}
						ms=openfolder->lines[openfolder->msgstart[msgno]];
						if(msgno==openfolder->nomsg-1) me=openfolder->filesize;
						else me=openfolder->lines[openfolder->msgstart[msgno+1]];

						sprintf(&tmpfilename[1],"-f u:/tmp/msg%d%d",username,gl_apid,tmpfilecount++);
						sprintf(tmpbuf," -u %s",username);
						fp=fopen(&tmpfilename[4],"wb");
						fwrite(&openfolder->filecont[openfolder->lines[openfolder->msgstart[msgno]]],sizeof(char),me-ms,fp);
						fclose(fp);
						strcat(&tmpfilename[1],tmpbuf);
						tmpfilename[0]=(char)strlen(&tmpfilename[1]);
						for(i=1;i<strlen(&tmpfilename[1]);i++) if(tmpfilename[i+1]=='/')tmpfilename[i+1]='\\';
						
						shel_write(0,0,0,sendprog,tmpfilename);
					}
					break;


					case REPLY:
					{	char tmpfilename[256],tmpbuf[64];

						int me,ms;
						int msgno=-1,i=0;
						while(msgno==-1)
						{
							if(openfolder->msgstatus[i])msgno=i;
							i++;
						}
						ms=openfolder->lines[openfolder->msgstart[msgno]];
						if(msgno==openfolder->nomsg-1) me=openfolder->filesize;
						else me=openfolder->lines[openfolder->msgstart[msgno+1]];

						sprintf(&tmpfilename[1],"-r u:/tmp/msg%d%d",gl_apid,tmpfilecount++);
						sprintf(tmpbuf," -u %s",username);
						fp=fopen(&tmpfilename[4],"wb");
						fwrite(&openfolder->filecont[openfolder->lines[openfolder->msgstart[msgno]]],sizeof(char),me-ms,fp);
						fclose(fp);
						strcat(&tmpfilename[1],tmpbuf);
						tmpfilename[0]=(char)strlen(&tmpfilename[1]);
						for(i=1;i<strlen(&tmpfilename[1]);i++) if(tmpfilename[i+1]=='/')tmpfilename[i+1]='\\';
						
						shel_write(0,0,0,sendprog,tmpfilename);
					}
					break;

					default:
					break;
				}
				menu_tnormal(menubar,msg[3],1);
			break;

			case WM_REDRAW:
				redraw_window(vdihandle,window_handle,(GRECT*)&msg[4],&window_dim,openfolder);
			break;

			case AP_TERM:
			case WM_CLOSED:
				exit_program(vdihandle,window_handle);
			break;

			case WM_TOPPED:
				wind_set(msg[3],WF_TOP,0,0,0,0);
			break;

			case WM_MOVED:
				wind_set(msg[3],WF_CURRXYWH,msg[4],msg[5],msg[6],msg[7]);
				wind_get(window_handle,WF_WORKXYWH,&window_dim.g_x,&window_dim.g_y,&window_dim.g_w,&window_dim.g_h);
				letterbox[0].ob_x=window_dim.g_x;
				letterbox[0].ob_y=window_dim.g_y;
				letters[0].ob_x=window_dim.g_x;
				letters[0].ob_y=window_dim.g_y;
			break;

			case WM_FULLED:
				if(isfull==0)
				{
					isfull=1;
					wind_get(window_handle,WF_FULLXYWH,&msg[4],&msg[5],&msg[6],&msg[7]);
				}
				else
				{
					isfull=0;
					wind_get(window_handle,WF_PREVXYWH,&msg[4],&msg[5],&msg[6],&msg[7]);
				}
			
			case WM_SIZED:
			{ int size,ow=window_dim.g_w,oh=window_dim.g_h,position=1;
				wind_set(msg[3],WF_CURRXYWH,msg[4],msg[5],msg[6],msg[7]);
				wind_get(window_handle,WF_WORKXYWH,&window_dim.g_x,&window_dim.g_y,&window_dim.g_w,&window_dim.g_h);

				wincharx=window_dim.g_w/charw;
				winchary=window_dim.g_h/charh;
				size=min(1000,(1000*winchary)/totallines);
				wind_set(window_handle,WF_VSLSIZE,min(1000,(1000*winchary)/totallines),0,0,0);
				if(size>=1000) displaylineno=0;
				else 
				{
					position=max(1,1000*displaylineno)/max(1,totallines-winchary);
					displaylineno=min(displaylineno,totallines-winchary);
				}
				wind_set(window_handle,WF_VSLIDE,position,0,0,0);				
				if(ow>window_dim.g_w && oh>window_dim.g_h && size<1000) 
					redraw_window(vdihandle,window_handle,&window_dim,&window_dim,openfolder);
			}
			break;

			case WM_ARROWED:
			{ int size,position;
				size=min(1000,(1000*winchary)/totallines);
				if(size!=1000)
				{
					switch(msg[4])
					{
					case 0:
						displaylineno=max(displaylineno-winchary,0);
						position=(1000*displaylineno)/max(1,totallines-winchary);
					break;
					case 1:
						displaylineno=min(displaylineno+winchary,totallines-winchary);
						position=(1000*displaylineno)/max(1,totallines-winchary);
					break;
					case 2:
						displaylineno=max(--displaylineno,0);
						position=(1000*displaylineno)/max(1,totallines-winchary);
					break;
					case 3:
						displaylineno=min(++displaylineno,totallines-winchary);
						position=(1000*displaylineno)/max(1,totallines-winchary);
					break;
					default:
						displaylineno=0;
						position=0;
					break;
					}
				wind_set(window_handle,WF_VSLIDE,position,0,0,0);
				redraw_window(vdihandle,window_handle,&window_dim,&window_dim,openfolder);
				}
			}
			break;

			case WM_BOTTOM:
				wind_set(msg[3],WF_BOTTOM,msg[4],msg[5],msg[6],msg[7]);
			break;

			case WM_VSLID:
				wind_set(window_handle,WF_VSLIDE,msg[4],0,0,0);
				displaylineno=msg[4]*max(0,totallines-winchary)/1000;
				redraw_window(vdihandle,window_handle,&window_dim,&window_dim,openfolder);
			break;


			case WM_ICONIFY:
				menu_bar(menubar,0);
				iconified=max(newmail.filesize,1);
				newmail.status=0;
				wind_set(msg[3],WF_ICONIFY,msg[4],msg[5],msg[6],msg[7]);
				wind_set(window_handle,WF_NAME,title+7,0,0);
				wind_get(window_handle,WF_WORKXYWH,&window_dim.g_x,&window_dim.g_y,&window_dim.g_w,&window_dim.g_h);
				letterbox[0].ob_x=window_dim.g_x;
				letterbox[0].ob_y=window_dim.g_y;
				letterbox[0].ob_width=window_dim.g_w;
				letterbox[0].ob_height=window_dim.g_h;
				letterbox[1].ob_x=(window_dim.g_w-letterbox[1].ob_width)/2;
				letters[0].ob_x=window_dim.g_x;
				letters[0].ob_y=window_dim.g_y;
				letters[0].ob_width=window_dim.g_w;
				letters[0].ob_height=window_dim.g_h;
				letters[1].ob_x=(window_dim.g_w-letters[1].ob_width)/2;
			break;

			case WM_UNICONIFY:
				menu_bar(menubar,1);
				iconified=0;
				if(newmail.status)
				{
					newmail.status=0;
				}
				wind_set(msg[3],WF_UNICONIFY,msg[4],msg[5],msg[6],msg[7]);
				wind_get(window_handle,WF_WORKXYWH,&window_dim.g_x,&window_dim.g_y,&window_dim.g_w,&window_dim.g_h);
				wind_set(window_handle,WF_NAME,title,0,0);
			break;

			default:
			break;
		}
	break;
	case MU_BUTTON:
		{	int c;
			c=max(0,(my - window_dim.g_y)/charh + displaylineno );

			if(clicked==2)
			{ 
				if(c>0 && c<foldernos) /* A mail folder */
				{  if(c!=selectedfolder)
				   {	if(openfolder!=&newmail) 
						close_folder(openfolder);
					strcpy(otherfolder.mbox,maildir);
					strcat(otherfolder.mbox,"/");
					strcat(otherfolder.mbox,&foldername[c][2]);
					openfolder=&otherfolder;
					open_folder(openfolder);
					totallines=foldernos+openfolder->nomsg;
					displaylineno=0;
					folderno=c;
					noofselmsgs=0;
	menu_ienable(menubar,FORWARD,0);
	menu_ienable(menubar,REPLY,0);

					menu_ienable(menubar,COPY,0);
					menu_ienable(menubar,MOVE,0);

					menu_ienable(menubar,DELETE,0);
					wind_set(window_handle,WF_VSLSIZE,min(1000,(1000*winchary)/totallines),0,0,0);
					wind_set(window_handle,WF_INFO,openfolder->mbox,0,0);
					wind_set(window_handle,WF_VSLIDE,1,0,0,0);
					redraw_window(vdihandle,window_handle,&window_dim,&window_dim,openfolder);
				   }
				}
				else
					if(c==0) /* new mail */
					{
						openfolder=&newmail;
						close_folder(openfolder);
						open_folder(openfolder);
						totallines=foldernos+openfolder->nomsg;
						displaylineno=0;
						folderno=0;
						noofselmsgs=0;
	menu_ienable(menubar,FORWARD,0);
	menu_ienable(menubar,REPLY,0);

						menu_ienable(menubar,COPY,0);
						menu_ienable(menubar,MOVE,0);


						menu_ienable(menubar,DELETE,0);
						wind_set(window_handle,WF_VSLSIZE,min(1000,(1000*winchary)/totallines),0,0,0);
						wind_set(window_handle,WF_INFO,openfolder->mbox,0,0);
						wind_set(window_handle,WF_VSLIDE,1,0,0,0);
						redraw_window(vdihandle,window_handle,&window_dim,&window_dim,openfolder);
					}
					else /* message clicked */
					{
						char tmpfilename[256];
						int i,msgnoclicked=c-foldernos;
						int ms,me;
						if(msgnoclicked<=openfolder->nomsg-1)
						{
						ms=openfolder->lines[openfolder->msgstart[msgnoclicked]];
						if(msgnoclicked==openfolder->nomsg-1) me=openfolder->filesize;
						else me=openfolder->lines[openfolder->msgstart[msgnoclicked+1]];
						sprintf(&tmpfilename[1],"u:/tmp/msg%d%d",gl_apid,tmpfilecount++);
				
						fp=fopen(&tmpfilename[1],"wb");
						fwrite(&openfolder->filecont[openfolder->lines[openfolder->msgstart[msgnoclicked]]],sizeof(char),me-ms,fp);
						fclose(fp);
						tmpfilename[0]=(char)strlen(&tmpfilename[1]);
						for(i=1;i<strlen(&tmpfilename[1]);i++) if(tmpfilename[i+1]=='/')tmpfilename[i+1]='\\';
						
						shel_write(0,0,0,showprog,tmpfilename);
						}
					}
			}
			else
			{	/* Single Click */
				if(c<foldernos) /*folder selected*/
				{  
					if(c!=folderno)
					{
						if(selectedfolder==c || (c==0 && selectedfolder!=0))
						{
							selectedfolder=0;
							menu_ienable(menubar,FORWARD,0);
							menu_ienable(menubar,REPLY,0);

							menu_ienable(menubar,DELFOLDER,0);
							menu_ienable(menubar,COPY,0);
							menu_ienable(menubar,MOVE,0);
						}
						else
						{
							selectedfolder=c;
							menu_ienable(menubar,DELFOLDER,1);
							if(noofselmsgs)
							{
								menu_ienable(menubar,FORWARD,0);
								menu_ienable(menubar,REPLY,0);
								menu_ienable(menubar,COPY,1);
								menu_ienable(menubar,MOVE,1);
								}
							if(noofselmsgs==1)
							{
								menu_ienable(menubar,FORWARD,0);
								menu_ienable(menubar,REPLY,0);
							}
							else
							{
								menu_ienable(menubar,FORWARD,0);
								menu_ienable(menubar,REPLY,0);
							}

							
						}
					}
					redraw_window(vdihandle,window_handle,&window_dim,&window_dim,openfolder);
				}
			
				else /*message selected */
				{
					int msgnoclicked=c-foldernos;
					if(msgnoclicked < openfolder->nomsg)
					{
						openfolder->msgstatus[msgnoclicked]^=1;
						menu_ienable(menubar,DELETE,0);
						if(openfolder->msgstatus[msgnoclicked]&1==1)
						{
							noofselmsgs++;
							menu_ienable(menubar,DELETE,1);
							if(noofselmsgs==1)
							{	
								menu_ienable(menubar,FORWARD,1);
								menu_ienable(menubar,REPLY,1);
							}
							else
							{
								menu_ienable(menubar,FORWARD,0);
								menu_ienable(menubar,REPLY,0);
							}

						}
						else 
						{ 
							noofselmsgs--; 
							if(noofselmsgs!=0) menu_ienable(menubar,DELETE,1);
							if(noofselmsgs==1)
							{	
								menu_ienable(menubar,FORWARD,1);
								menu_ienable(menubar,REPLY,1);
							}
							else
							{
								menu_ienable(menubar,FORWARD,0);
								menu_ienable(menubar,REPLY,0);
							}
							
							menu_ienable(menubar,COPY,0);
							menu_ienable(menubar,MOVE,0);
							if(noofselmsgs && selectedfolder)
							{
								if(noofselmsgs==1)
								{	
									menu_ienable(menubar,FORWARD,1);
									menu_ienable(menubar,REPLY,1);
								}
								else
								{
									menu_ienable(menubar,FORWARD,0);
									menu_ienable(menubar,REPLY,0);
								}

						
								menu_ienable(menubar,COPY,1);
								menu_ienable(menubar,MOVE,1);
							}
						}

					redraw_window(vdihandle,window_handle,&window_dim,&window_dim,openfolder);
					}
					else
					{ int i;
						for(i=0;i<openfolder->nomsg;openfolder->msgstatus[i++]&=0xFFFE);
						noofselmsgs=0;
						menu_ienable(menubar,FORWARD,0);
						menu_ienable(menubar,REPLY,0);
						menu_ienable(menubar,COPY,0);
						menu_ienable(menubar,MOVE,0);

						menu_ienable(menubar,DELETE,0);
						redraw_window(vdihandle,window_handle,&window_dim,&window_dim,openfolder);
					}
				}
			}
		}
	break;
	case MU_TIMER:
		stat(newmail.mbox,&filestat);
		if((filestat.st_size!=iconified) && !(iconified==1 && filestat.st_size==0))
		{	
			newmail.status=1;
			redraw_window(vdihandle,window_handle,&window_dim,&window_dim,openfolder);
		}
	break;
	default:
	break;
	}

	}
}

exit_program(int vdihandle,int window_handle)
{
	int i;
	char t[64];
	for(i=0;i!=tmpfilecount;i++)
	{
		sprintf(t,"u:/tmp/msg%d%d",gl_apid,i);
		unlink(t);
	}
	wind_close(window_handle);
	wind_delete(window_handle);
	menu_bar(menubar,0);
	v_clsvwk(vdihandle);
/*	rsrc_free();*/
	appl_exit();
	exit(0);
}

draw_window(int vdihandle,int *pxy, FOLDER *folder,GRECT *f)
{
	int line=0,i,j,p[4];
	vr_recfl(vdihandle,pxy);
	if(displaylineno<foldernos)
		j=0;
	else
		j=displaylineno-foldernos;

	for(i=displaylineno;i<foldernos;i++,line++)
	{
		if(i==folderno) vst_effects(vdihandle,1); else vst_effects(vdihandle,0);
		v_gtext(vdihandle,f->g_x+charw,f->g_y+(line+1)*charh,&foldername[i][0]);
		if(i==selectedfolder && i!=0)
		{	char d[2]={8,0};
			v_gtext(vdihandle,f->g_x+2*charw,f->g_y+((line)+1)*charh,d);
		}
	}
	vst_effects(vdihandle,0);
	for(i=j;i!=folder->nomsg;i++)
	{
		if(folder->subjectline[i]) 
		{	char c,d[2];
			d[0]=8;d[1]=0;

			if(folder->msgstatus[i]&1)
				v_gtext(vdihandle,f->g_x+2*charw,f->g_y+((line)+1)*charh,d);

			c=folder->filecont[folder->lines[folder->subjectline[i]+1]-1];
			folder->filecont[folder->lines[folder->subjectline[i]+1]-1]=0;
			v_gtext(vdihandle,f->g_x+3*charw,f->g_y+((line)+1)*charh,&folder->filecont[folder->lines[folder->subjectline[i]]+9]);
			folder->filecont[folder->lines[folder->subjectline[i]+1]-1]=c;
		}
		else
		{ char d[2]={8,0};
			if(folder->msgstatus[i]&1)
				v_gtext(vdihandle,f->g_x+2*charw,f->g_y+((line)+1)*charh,d);
			v_gtext(vdihandle,f->g_x+3*charw,f->g_y+((line)+1)*charh,"No subject");
		}
		if(folder->from[i]) 
		{	char c;
			c=folder->filecont[folder->lines[folder->from[i]+1]-1];
			folder->filecont[folder->lines[folder->from[i]+1]-1]=0;
			v_gtext(vdihandle,f->g_x+43*charw,f->g_y+((line++)+1)*charh,&folder->filecont[folder->lines[folder->from[i]]+6]);
			folder->filecont[folder->lines[folder->from[i]+1]-1]=c;
		}
		else
		{
			v_gtext(vdihandle,f->g_x+3*charw,f->g_y+((line++)+1)*charh,"?");
		}
	}
	
}



redraw_window(int vdihandle,int window_handle,GRECT *r,GRECT *f,FOLDER *folder)
{
	int pxy[4],i;
	GRECT xywh;

	vsf_interior(vdihandle,1);
	vsf_color(vdihandle,0);
        vsl_color(vdihandle,1);
	vst_color(vdihandle,1);

	wind_update(BEG_UPDATE);
	graf_mouse(M_OFF,0L);
 
	wind_get(window_handle,WF_FIRSTXYWH,&xywh.g_x,&xywh.g_y,&xywh.g_w,&xywh.g_h);
	while(xywh.g_w && xywh.g_h)
	{	pxy[0]=max(xywh.g_x,r->g_x); 
		pxy[1]=max(xywh.g_y,r->g_y);
		pxy[2]=min(xywh.g_x+xywh.g_w,r->g_x+r->g_w)-pxy[0];
		pxy[3]=min(xywh.g_y+xywh.g_h,r->g_y+r->g_h)-pxy[1];
		if( (pxy[2]>0) && (pxy[3]>0))
		switch(iconified)
		{
			case 0:
				pxy[2]=pxy[2]+pxy[0]-1;
				pxy[3]=pxy[3]+pxy[1]-1;
				vs_clip(vdihandle,1,pxy);
				draw_window(vdihandle,pxy,folder,f);
				vs_clip(vdihandle,0,pxy);
			break;
			default:
			    if(newmail.status==1)
				{objc_draw(letters,0,5,pxy[0],pxy[1],pxy[2],pxy[3]);}
			    else
				{objc_draw(letterbox,0,5,pxy[0],pxy[1],pxy[2],pxy[3]);}
			break;

		}
		wind_get(window_handle,WF_NEXTXYWH,&xywh.g_x,&xywh.g_y,&xywh.g_w,&xywh.g_h);
	}
	graf_mouse(M_ON,0L);
	wind_update(END_UPDATE);

}


delmsgs(FOLDER *folder)
{
	int i,ms,me;
	FILE *fp;
	fp=fopen(folder->mbox,"wb");
	for(i=0;i!=folder->nomsg;i++)
		if(folder->msgstatus[i]==0)
		{
			ms=folder->lines[folder->msgstart[i]];
			if(i==folder->nomsg-1) me=folder->filesize;
			else me=folder->lines[folder->msgstart[i+1]];
			fwrite(&folder->filecont[folder->lines[folder->msgstart[i]]],sizeof(char),me-ms,fp);
		}
	fclose(fp);

}

copymsgs(FILE *fp, FOLDER *folder)
{
	int i,ms,me;
	for(i=0;i!=folder->nomsg;i++)
		if(folder->msgstatus[i]&0x1)
		{
			ms=folder->lines[folder->msgstart[i]];
			if(i==folder->nomsg-1) me=folder->filesize;
			else me=folder->lines[folder->msgstart[i+1]];
			fwrite(&folder->filecont[folder->lines[folder->msgstart[i]]],sizeof(char),me-ms,fp);
		}
}
