#include <aesbind.h>
#include <gemdefs.h>
#include <vdibind.h>
#include <osbind.h>
#include <macros.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include <dirent.h>

#include "gemmail.h"
#include "folder.h"


extern char maildir[256];
extern DIR *mailfolder;
extern struct dirent *folders;
extern int foldernos,folderno;
extern char foldername[][64];


remove_folder(char *folder)
{
	char path[512];
	strcpy(path,maildir);
	strcat(path,"/");
	strcat(path,folder);
	unlink(path);
	reread_folders();
}

creat_folder(char *name)
{
	char path[512];
	strcpy(path,maildir);
	strcat(path,"/");
	strcat(path,name);
	creat(path,S_IWUSR|S_IRUSR);
	reread_folders();
}

reread_folders()
{
	foldernos=1;
	mailfolder=opendir(maildir);
	if(mailfolder!=NULL)
	{
		folders=readdir(mailfolder);
		while(folders!=NULL)
		{
			if( !(((folders->d_name)[0]=='.' &&  (folders->d_name)[1]=='\0') ||  ((folders->d_name)[0]=='.' &&  (folders->d_name)[1]=='.' && (folders->d_name)[2]=='\0')))
				strcpy(&foldername[foldernos++][2],folders->d_name);
			folders=readdir(mailfolder);
		}
	}
	closedir(mailfolder);
	
}


open_folder(FOLDER *folder)
{
	FILE *fp;
	struct stat filestat;


	stat(folder->mbox,&filestat);
	folder->filesize=filestat.st_size;
	folder->nomsg=0;
	if(filestat.st_size)    /* Are there messages in the file? */
	{


/* Read the file into a buffer */
		folder->filecont=(char *) calloc(filestat.st_size,sizeof(char));
		fp=fopen(folder->mbox,"rb");
		fread(folder->filecont,sizeof(char),filestat.st_size,fp);
		fclose(fp);
		{
			int i,j,m;
			folder->nolines=1;
			/* Determine the number of lines in the file */
			for(i=0;i!=filestat.st_size;i++)
				if(folder->filecont[i]=='\n')folder->nolines++;
			/* Allocate buffer space for an array which
			   will contain the offsets to the beginning of 
			   each line  */
			folder->lines=(int*)calloc(folder->nolines,sizeof(int));
			folder->lines[0]=0;
			/* Scan file and register the position of each line
			*/
			for(i=1,j=1;i!=filestat.st_size;i++)
				if(folder->filecont[i]=='\n')folder->lines[j++]=i+1;
			/* Determine the number of messages - 
			   Begginning with 'From '*/
			for(i=0;i!=folder->nolines;i++)
				if(folder->filecont[folder->lines[i]]=='F' &&
				   folder->filecont[folder->lines[i]+1]=='r' &&
				   folder->filecont[folder->lines[i]+2]=='o' &&
				   folder->filecont[folder->lines[i]+3]=='m' &&
				   folder->filecont[folder->lines[i]+4]==' ')
					folder->nomsg++;
			/* Allocate buffer and determine the line number
			   which starts each new message */
			folder->msgstart=(int*)calloc(folder->nomsg,sizeof(int));
			for(i=0,j=0;i!=folder->nolines;i++)
				if(folder->filecont[folder->lines[i]]=='F' &&
				   folder->filecont[folder->lines[i]+1]=='r' &&
				   folder->filecont[folder->lines[i]+2]=='o' &&
				   folder->filecont[folder->lines[i]+3]=='m' &&
				   folder->filecont[folder->lines[i]+4]==' ')
					folder->msgstart[j++]=i;
			/* Allocate buffer and determine the line numbers
			   containing the subject headers
			   0 means no subject
			*/
			folder->subjectline=(int*)calloc(folder->nomsg,sizeof(int));
			for(i=0;i!=folder->nomsg;i++) folder->subjectline[i]=0;
			for(i=0,j=0;i!=folder->nolines;i++)
			{
				if(j!=(folder->nomsg-1) && i>=folder->msgstart[j+1])j++; 
				if(folder->filecont[folder->lines[i]]=='S' &&
				   folder->filecont[folder->lines[i]+1]=='u' &&
				   folder->filecont[folder->lines[i]+2]=='b' &&
				   folder->filecont[folder->lines[i]+3]=='j' &&
				   folder->filecont[folder->lines[i]+4]=='e' &&
				   folder->filecont[folder->lines[i]+5]=='c' &&
				   folder->filecont[folder->lines[i]+6]=='t' &&
				   folder->filecont[folder->lines[i]+7]==':' &&
				   folder->subjectline[j]==0	)
				{
					folder->subjectline[j++]=i;
					if(j==folder->nomsg)
						i=folder->nolines-1;
					else
						i=folder->msgstart[j]-1;
				}
			}
			folder->from=(int*)calloc(folder->nomsg,sizeof(int));
			for(i=0;i!=folder->nomsg;i++) folder->from[i]=0;
			for(i=0,j=0;i!=folder->nolines;i++)
			{
				if(j!=(folder->nomsg-1) && i>=folder->msgstart[j+1])j++; 
				if(folder->filecont[folder->lines[i]]=='F' &&
				   folder->filecont[folder->lines[i]+1]=='r' &&
				   folder->filecont[folder->lines[i]+2]=='o' &&
				   folder->filecont[folder->lines[i]+3]=='m' &&
				   folder->filecont[folder->lines[i]+4]==':' &&
				   folder->from[j]==0	)
				{
					folder->from[j++]=i;
					if(j==folder->nomsg)
						i=folder->nolines-1;
					else
						i=folder->msgstart[j]-1;
				}
			}
			folder->msgstatus=(int*)calloc(folder->nomsg,sizeof(int));
			for(i=0;i!=folder->nomsg;folder->msgstatus[i++]=0);
				

		}
	}
	else
	{ 
		folder->nomsg=0;
	}

}


close_folder(FOLDER *folder)
{
	if(folder->filesize!=0)
	{
		free(folder->filecont);
		free(folder->lines);
		if(folder->nomsg!=0)
		{
			free(folder->msgstart);
			free(folder->subjectline);
			free(folder->from);
/*			free(folder->msgbody);*/
			free(folder->msgstatus);
		}
	}
}
