/* 
** weblib.c for assorted programs
** 
** Copyright (C) 1995-1996, Andrew 'Dancer' Vesperman. All rights reserved.
** Copyright (C) 1997, Howard Chu
** 
** This file can be redistributed under the terms of the GNU General
** Public Licence.
*/

#include <unistd.h>
#include "module.h"

#include <osbind.h>
#include <mintbind.h>
#include <aesbind.h>
#include <signal.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <netdb.h>
#include <fcntl.h>
#include <errno.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "weblib.h"

char fname[256];
char gbuf[READ_SIZE+256];
int ifd, ofd, ap_id;
extern int h_errno;
extern short _global[];

FILE *fp, *sp;
int s;

jmp_buf myjmp;

char *url, *ctype, *enc, *body, *debug, *prev_url;

extern long child;
char *gzip;

#define	LOG(x)	if (debug) printf x

#if DEBUG_PARENT
static int didreopen;
#endif
static int didreply;
long hsize;

long            ___CDECL 
_get_url(char *Url, int kind, void *ptr1, void *ptr2, void *ptr3)
{
	long *l;
	short *buf = (short *)l;
	int i, t;

#if DEBUG_PARENT
	if (debug)
	{
		if (!didreopen)
		{
			freopen("CMTWO.LOG","w",stderr);
			didreopen = 1;
		}
		fprintf(stderr,"\nclk %ld req %d, url %lx, p1 %lx, p2 %lx, p3 %lx\n",
			time(0L), kind, Url, ptr1, ptr2, ptr3);
		fflush(stderr);
		fprintf(stderr,"url: %s\n", Url);
		fflush(stderr);
		switch(kind)
		{
		case HEAD:
			fprintf(stderr,"time %ld, size %ld, type %s\n",
				*(long *)ptr1, *(long *)ptr2, ptr3);
			break;
		case GET:
			fprintf(stderr,"file %s\n", ptr1);
			break;
		case POST:
			fprintf(stderr,"file %s, enc %s, body %s\n",
				ptr1, ptr2, ptr3);
			break;
		case GETNEW:
			fprintf(stderr,"file %s, time %ld\n", ptr1, *(long *)ptr2);
			break;
		case MAIL:
			fprintf(stderr,"file %s, subject %s\n", ptr1, ptr2);
			break;
		}
		fflush(stderr);
	}
#endif

	url = Url;
	ctype = ptr1;
	strcpy(fname, ctype);
	enc = ptr2;
	body = ptr3;
	hsize = -1;

	Fputchar(ofd, kind, 0);

	for (t=0;;)
	{
	    l = (long *)browser->aes_events(30000);
	    if ((long) l == -1)
	    {
		didreply = 1;
		kill(child, SIGINT);
		return 0;
	    }
	    if (!l)
	    {
		++t;
		browser->msg_status(STATUS_WAITINGFORDATA, t);
		continue;
	    }
	    buf = (short *)l;
	    if (buf[0] != 3)
	    {
		browser->aes_messages((int *)buf);
		continue;
	    }
	    t = 0;
	    switch(buf[1])
	    {
		case R_ERROR:
		    if (l[1])
		    {
		    	if (l[1] > 0)
			    l[1] = -l[1];
			browser->msg_error(l[1]);
		    }
#if DEBUG_PARENT
		    if (debug)
			fprintf(stderr,"\nclk %ld return %ld\n",
				time(0L), l[1]);
#endif
		    if (kind == HEAD)
			*(long *)body = hsize;
		    return l[1];
		case R_STATUS:
		    browser->msg_status(l[1], l[2]);
		    break;
		case R_ALERT:
		    i = browser->alert_box(l[1], l[2]);
		    break;
		case R_CLEAR:
		    i = browser->clear_cache(l[1]);
		    break;
		case R_REDIR:
		    i = browser->new_url((char *)l[1], (char **)l[2]);
		    break;
		case R_PROMPT:
		    i = browser->ask_user(l[1], (char **)l[2]);
		    break;
		case R_ONLINE:
		    browser->online(l[1]);
		    break;
	    }
	    switch(buf[1])
	    {
		case R_ALERT:
		case R_CLEAR:
		case R_REDIR:
		case R_PROMPT:
		    Fputchar(ofd, i, 0);
	    }
	}
	return EBADREQ;
}

static int respond(int how, long l1, long l2)
{
    long l[4];
    short *buf = (short *)l;

    buf[0] = 3;
    buf[1] = how;
    l[1] = l1;
    l[2] = l2;
    appl_write(ap_id,16,buf);
    switch(how)
    {
	case R_ERROR:
	case R_STATUS:
	case R_ONLINE:
	    return 0;
	case R_ALERT:
	case R_CLEAR:
	case R_REDIR:
	case R_PROMPT:
	    return Fgetchar(ifd, 0);
    }
}

static const service urltypes[] = {
	{"ftp", 21}, {"http", 80}, {"wais", 210},
	{"gopher", 79}, {"news", 119}, {"mailto", 25}
};

static URL      ux;

URL            *___CDECL 
_parseURL(char *url)
{
    int             x, y;
    short oldport = ux.port;

    respond(R_STATUS, STATUS_RESOLVING_HOST, 0);
    ux.port = 0;
    ux.path[0] = '/';
    ux.path[1] = '\0';
    x = 0;
    y = 0;
    while (url[x] && url[x] != ':' && url[x] != '/')
	gbuf[y++] = url[x++];
    gbuf[y] = '\0';
    for (y=FTP; y<=MAIL; y++)
	if (!stricmp(gbuf, urltypes[y].name))
	{
	    ux.request = y;
	    ux.port = urltypes[y].port;
	    break;
	}
    if (y > MAIL)
	return NULL;    
    while (url[x] == ':')
	x++;
    if (url[x] == '/' && url[x+1] == '/')
	x += 2;
    /* special case URLs */
    if (ux.request == NEWS)
    {
	/* news URL's are usually formatted as news:group */
	strcpy(ux.site, browser->proxy->nntp_server);
    } else
    if (ux.request == MAIL)
    {
	/* mailto URL's are usually formatted as mailto:user@host.domain */
	strcpy(ux.site, browser->proxy->smtp_server);
    } else
    {
	y = 0;
	while (url[x] && url[x] != ':' && url[x] != '/')
	    ux.site[y++] = url[x++];
	if (y)
	    ux.site[y] = '\0';
	/* Got xxxx:///path, missing hostname. reuse previous hostname. */
	else if (ux.flags & DID_PROXY)
	{
	    char *p1, *p2;
	    for (p1 = ux.site, p2 = ux.host; *p2 && *p2 != ':';
		*p1++ = *p2++)
		;
	    *p1 = '\0';
	    if (*p2 == ':')
		ux.port = atoi(p2+1);
	} else
	    ux.port = oldport;
	
	if (url[x] == ':' && url[x+1] != '/')
	{
	    /* Got a port number */
	    ux.port = atoi(url+x+1);
	}
    }
    if (url[x])
	strcpy(ux.path, url + x);
    return &ux;
}

int 
no_proxy(char *s)
{
    int             sanity = 0;
    char           *t;

    /*
     * If the CAB option no_proxy is not defined then we will
     * always use a proxy 
     */
    if (!browser->proxy->no_proxy[0])
    {
	LOG(("No no_proxy variable defined\n"));
	return 0;
    }
    /*
     * no_proxy is defined. Step through the list and try to match it against
     * the supplied site. If we find a match then we do not proxy requests
     * for this site 
     */
    strcpy(gbuf, browser->proxy->no_proxy);
    strcat(gbuf, ",");
    t = strtok(gbuf, ",;:");
    if (!t)
    {
	LOG(("Proxy list empty\n"));
	return 0;
    }
    LOG(("searching proxy list\n"));
    do
    {
	LOG(("no_proxy check: %s\n", t));
	if (++sanity > 50)
	{
	    LOG(("Sanity test aborted proxy check\n"));
	    return 1;
	}
	if (strlen(t) == 0)
	    continue;
	if (!stricmp(t, s))
	{
	    LOG(("Do not proxy for this site: %s\n", s));
	    return 1;
	}
    } while (t = strtok(NULL, ",;:"));
    LOG(("Access Proxy for this site: %s\n", s));
    return 0;
}

char           *
redirection()
{
    if (!fp)
	return NULL;
    if (!fread(gbuf, 6, 1, fp))
	goto out;
    gbuf[6] = '\0';
    if (!stricmp("<HTML>", gbuf))
    {
	/* check document */
	while (!feof(fp))
	{
	    fgets(gbuf, READ_SIZE, fp);
	    if (!stricmp("<TITLE>Redirection</TITLE>", gbuf))
	    {
		while (!feof(fp))
		{
		    fgets(gbuf, READ_SIZE, fp);
		    if (!strnicmp("<A HREF", gbuf, 7))
		    {
			char *p1, *p2;
			for (p1 = gbuf+7; *p1++ != '"';)
			    ;
			for (p2 = p1; *p2 && *p2 != '"'; ++p2)
			    ;
			if (*p2 != '"')
			    goto out;
			*p2 = '\0';
			fclose(fp);
			return p1;
		    }
		}
	    } else
	    if (!strnicmp("<TITLE>", gbuf, 7))
		goto out;
	}
    }
out: fclose(fp);
    return (NULL);
}

URL            *___CDECL 
parseURL(char *url)
{
    URL            *u;

    u = _parseURL(url);
    if (!u)
	return u;
    u->flags &= ~DID_PROXY;
    if (u->request == MAIL || !proxies[u->request][0] || no_proxy(u->site))
	return u;
    if (u->port != urltypes[u->request].port)
	sprintf(u->host, "%s:%d", u->site, u->port);
    else
	strcpy(u->host, u->site);
    u = _parseURL(proxies[u->request]);
    strcpy(u->path, url);
    u->flags |= DID_PROXY;
    return u;
}

static char prevhost[1024];

/*
**  Open a socket to the specified service.
*/
int 
OpenConnection(char *host, short port)
{
    char          **ap;
    register int    i;
    static struct hostent *hp;
    struct sockaddr_in server;

    if (hp && !stricmp(host, prevhost))
    {
	ap = hp->h_addr_list;
	goto skip;
    }

    /* Get the host's address. */
    if ((hp = gethostbyname(host)) != NULL)
    {
	/* Symbolic host name. */
	ap = hp->h_addr_list;
    } else
    {
	LOG(("Unknown host %s h_errno %d\n", host, h_errno));
	errno = EPATH;
	return -1;
    }
    strcpy(prevhost, host);

skip:
    respond(R_STATUS, STATUS_CONNECTING_HOST, 0);

    /* Set up the socket address. */
    (void) memset((char *) &server, 0, sizeof server);
    server.sin_family = hp->h_addrtype;
    server.sin_port = port;

    /* Loop through the address list, trying to connect. */
    for (; ap && *ap; ap++)
    {
	/* Make a socket and try to connect. */
	if ((i = socket(hp->h_addrtype, SOCK_STREAM, 0)) < 0)
	    break;
	(void) memcpy((char *) &server.sin_addr, (char *) *ap, (int) hp->h_length);
	if (connect(i, (struct sockaddr *) & server, sizeof server) == 0)
	    return i;
	(void) close(i);
    }
    LOG(("Can't connect\n"));
    return -1;
}

long 
readline(int zeroit, int s, char *buf, int limit)
{
    char            *ptr = buf;
    long            b, c = 0;
    static long     bcount;

    if (zeroit)
	bcount = 0;

    while (++c < limit)
    {
	b = Fgetchar(s, 0);
	if (b < 0 || b == 0xff1a)
	{
	    LOG(("Fgetchar got %d\n", b));
	    return b;
	}
	if (b == '\r')
	    continue;
	*ptr++ = b;
	if (b == '\n')
	    break;
    }
    bcount += c-1;
    if (zeroit || ptr-buf == 1)
	respond(R_STATUS, STATUS_RECEIVING_DATA, bcount);
    *ptr = '\0';
    return ptr-buf;
}

static const char  *monthtab[12] = {"Jan", "Feb", "Mar",
				    "Apr", "May", "Jun",
				    "Jul", "Aug", "Sep",
				    "Oct", "Nov", "Dec"};
static const char *days[] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

long 
make_unix_time(char *s)
{
    struct tm       time;
    int             i, ysub = 1900, fmt = 0;
    char            day[128];
    char            month[20];
    char           *n;

    if (s[3] != ' ')
    {
	fmt = 1;
	if (s[3] != ',')
	    ysub = 0;
    }
    for (n = s; *n; ++n)
	if (*n == '-' || *n == ':')
	    *n = ' ';

    time.tm_mon = 0;
    if (fmt)
	sscanf(s, "%s %d %s %d %d %d %d GMT",
	    day, &time.tm_mday, month, &time.tm_year,
	    &time.tm_hour, &time.tm_min, &time.tm_sec);
    else
	sscanf(s, "%s %s  %d %d %d %d %d",
	    day, month, &time.tm_mday,
	    &time.tm_hour, &time.tm_min, &time.tm_sec, &time.tm_year);
    time.tm_year -= ysub;

    for (i = 0; i < 12; i++)
	if (!stricmp(month, monthtab[i]))
	{
	    time.tm_mon = i;
	    break;
	}
    time.tm_isdst = 0;		/* daylight saving is never in effect in GMT */
    return mktime(&time);
}

#if KEEPINFO
typedef struct urlinfo {
	long size;
	long time;
	char *type;
	char *url;
} urlinfo;

static urlinfo infos[KEEPINFO];

static int      last_slot = 0, slots_used = 0;

int
check_info()
{
    int		i, r;

    for (i = 0, r = last_slot; i < slots_used; i++, r--, r &= (KEEPINFO-1))
    {
	LOG(("cache %d = '%s'\n", r, infos[r].url));
	if (!stricmp(url, infos[r].url))
	{
	    *(long *)enc = infos[r].time;
	    *(long *)body = infos[r].size;
	    strcpy(ctype, infos[r].type);
	    LOG(("Found in cache slot %d\n", r));
	    return 1;
	}
    }
    return 0;
}

void
cache_info()
{
    int l1, l2;

    ++last_slot;
    if (slots_used < KEEPINFO)
	++slots_used;
    last_slot &= (KEEPINFO-1);


    infos[last_slot].time = *(long *)enc;
    infos[last_slot].size = hsize;
    if (infos[last_slot].type)
	free(infos[last_slot].type);
    l1 = strlen(ctype) + 1;
    l2 = strlen(url) + 1;
    infos[last_slot].type = malloc(l1+l2);
    if (infos[last_slot].type)
    {
	strcpy(infos[last_slot].type, ctype);
	infos[last_slot].url = infos[last_slot].type + l1;
	strcpy(infos[last_slot].url, url);
    } else
	infos[last_slot].url = NULL;
}
#endif /* KEEPINFO */

long
try_redir(int kind, char *new, URL *u);

static const char *reqs[] = {"HEAD", "GET", "POST", "GET", "", "MAIL"};

long _mailto(URL *u);

long            ___CDECL 
GetUrl(int kind)
{
    URL            *u;
    int             e, hterr = 0;
    char           *ptr;
    long            bcount = 0;
    long            sz = 0;
    int             primitive = 0, got_redirect = 0;
    int		    check_redirect;
    int		    do_gzip = 0;

    if (!url)
	return EBADREQ;

    LOG(("\n%s %s\n", reqs[kind], url));

    respond(R_STATUS, STATUS_DATALENGTH, -1);
    
    if (kind != HEAD)
    {
	strcpy(fname, ctype);
	LOG(("Filename %s\n", fname));
    }

    if (!prev_url || strcmp(url, prev_url))
    {
	u = parseURL(url);
	if (!u)
	    return EBADREQ;
    } else
    {
	u = &ux;
    }
    LOG(("URL Parsed.\n"));
    LOG(("REQ : %d(%s)\n", u->request,
	 u->request >= 0 ? urltypes[u->request].name : "unknown"));
    LOG(("PATH: %s\n", u->path));
    LOG(("SITE: %s\n", u->site));
    LOG(("PORT: %d\n", u->port));

    if (kind == HEAD)
    {
	if (!body)
	    return EBADREQ;
	*(long *)body = -1;
#if KEEPINFO
	if (check_info())
	    return 0;
#endif
    }
    s = OpenConnection(u->site, u->port);
    if (s == -1)
	return errno;

    LOG(("Connection opened\n"));

    respond(R_STATUS, STATUS_SENDING_REQUEST, 0);

    if (kind == MAIL)
	return _mailto(u);

    sp = fdopen(s, "w");

    LOG(("%s %s HTTP/1.0\n"
	"User-Agent: CAB/%s  CAB-for-MiNT Overlay/%s\n"
	"Accept: *\n",
	reqs[kind], u->path, cab_version, version));
    fprintf(sp, "%s %s HTTP/1.0\n"
	"User-Agent: CAB/%s  CAB-for-MiNT Overlay/%s\n"
	"Accept: *\n",
	reqs[kind], u->path, cab_version, version);
    if (gzip)
    {
	LOG(("Accept-Encoding: x-gzip, x-compress, gzip, compress\n"));
	fprintf(sp, "Accept-Encoding: x-gzip, x-compress, gzip, compress\n");
    }
    if (*browser->reloadflag)
    {
	LOG(("Pragma: no-cache\nCache-Control: no-cache\n"));
	fprintf(sp, "Pragma: no-cache\nCache-Control: no-cache\n");
    }
    if (kind == POST)
    {
	LOG(("Content-type: %s\nContent-length: %ld\n\n%s\n",
		enc, strlen(body), body));
	fprintf(sp, "Content-type: %s\nContent-length: %ld\n\n%s\n",
		enc, strlen(body), body);
    } else if (kind == GETNEW)
    {
	struct tm *tm = gmtime((time_t *)enc);
	LOG(("If-Modified-Since: %s, %2d %s %d %02d:%02d:%02d GMT\n",
	    days[tm->tm_wday], tm->tm_mday, monthtab[tm->tm_mon],
	    1900 + tm->tm_year, tm->tm_hour, tm->tm_min, tm->tm_sec));
	fprintf(sp, "If-Modified-Since: %s, %2d %s %d %02d:%02d:%02d GMT\n",
	    days[tm->tm_wday], tm->tm_mday, monthtab[tm->tm_mon],
	    1900 + tm->tm_year, tm->tm_hour, tm->tm_min, tm->tm_sec);
    }
    LOG(("Host: %s\n", (u->flags & DID_PROXY) ? u->host : u->site));
    fprintf(sp, "Host: %s\n", (u->flags & DID_PROXY) ? u->host : u->site);

    fputc('\n', sp);
    e = fflush(sp);
    if (e == EOF)
    {
	e = errno;
	shutdown(s, 2);
	fclose(sp);
	return e;
    }
    LOG(("Sent %s.\n", reqs[kind]));
    respond(R_STATUS, STATUS_WAITING_RESPONSE, 0);
    if ((e = readline(1, s, gbuf, READ_SIZE)) >= 0)
    {
	LOG(("Got %s", gbuf));
	if (strnicmp("HTTP/1.", gbuf, 7))
	{
	    /* Eeek! Server is HTTP/0.9 */
	    primitive = 1;
	} else
	{
	    char           *tmp;
	    tmp = strchr(gbuf, ' ');
	    if (!tmp)
	    {
		LOG(("Malformed response line\n"));
		shutdown(s, 2);
		fclose(sp);
		return EPLFMT;
	    }
	    ++tmp;
	    if (*tmp == '4' || *tmp == '5' || *tmp == '1')
	    {
		hterr = atoi(tmp);
		LOG(("Got a failure code %d.\n", hterr));
	    }
	    if (*tmp == '3')
	    {
		/* Did we get a Not Modified response that we wanted? */
		if (kind == GETNEW && tmp[1] == '0' && tmp[2] == '4')
		{
		    shutdown(s, 2);
		    fclose(sp);
		    return 0;
		}
		/* Some kind of redirection */
		got_redirect = 1;
	    }
	}
	if (primitive && kind == HEAD)
	{
	    shutdown(s, 2);
	    fclose(sp);
	    return EBADRQ;
	}
    } else
    {
	LOG(("Fatal error %d reading first response line\n", e));
	shutdown(s, 2);
	fclose(sp);
	return e;
    }
    if (!primitive)
    {
	while ((e = readline(0, s, gbuf, READ_SIZE)) > 1 && gbuf[0])
	{
	    LOG((": %s", gbuf));
	    gbuf[strlen(gbuf) - 1] = '\0';
	    if (got_redirect && !strnicmp("Location:", gbuf, 9))
	    {
		char *new;
		for (new=gbuf+9; *new == ' ' || *new == '\t'; new++)
		    ;
		shutdown(s, 2);
		fclose(sp);
		return try_redir(kind, new, u);
	    } else
	    if (!strnicmp("content-encoding: ", gbuf, 18))
	    {
		do_gzip = 1;
	    } else
	    if (!strnicmp("content-length: ", gbuf, 16))
	    {
		sscanf(gbuf + 16, "%ld", &sz);
		LOG(("Content length: %ld\n", sz));
	    } else
	    if (kind == HEAD)
	    {
		if (!strnicmp("content-type: ", gbuf, 14))
		{
		    strncpy(ctype, gbuf + 14, 199);
		    ctype[199] = '\0';
		    LOG(("Content type: %s\n", ctype));
		} else
		if (!strnicmp("Last-Modified: ", gbuf, 15))
		{
		    *(long *)enc = make_unix_time(gbuf + 15);
		    LOG(("Last mod: %ld\n", *(long *)enc));
		}
	    }
	}
	if (e < 0)
	{
	    LOG(("Fatal error reading headers, %d\n", e));
	    shutdown(s, 2);
	    fclose(sp);
	    return e;
	}
    }

    if (kind == HEAD)
    {
	if (sz)
	    hsize = sz;
#if KEEPINFO
	cache_info();
#endif
	shutdown(s, 2);
	fclose(sp);
	return 0;
    }


    fp = fopen(fname, "w+b");
    if (!fp)
    {
	e = errno;
	LOG(("Couldn't open file %s, err %d\n", fname, e));
	shutdown(s, 2);
	fclose(sp);
	return e;
    }

    if (do_gzip)
    {
	int fds[2], pid, out;
	Fpipe(fds);
	out = Fdup(1);
	Fforce(1, fileno(fp));
	Fforce(0, fds[0]);
	pid = Pexec(100, gzip, "\002-d", NULL);
	if (pid < 0)
	    do_gzip = 0;
	else
	    Fforce(fileno(fp), fds[1]);
	Fclose(fds[0]);
	Fclose(fds[1]);
	Fforce(1, out);
    }

    if (hterr)
	fprintf(fp, "<html><head><title>Error %d</title></head>\n", hterr);

    if (kind == GET)
	check_redirect = 1;
    else
	check_redirect = 0;

    if (sz)
        respond(R_STATUS,STATUS_DATALENGTH,sz);

    while (1)
    {
	sz = Fread(s, READ_SIZE, gbuf);
	LOG(("Fread %ld\n", sz));
	if (sz == -1 || sz > READ_SIZE)
	{
err:	    e = errno;
	    shutdown(s, 2);
	    fclose(fp);
	    fclose(sp);
	    if (do_gzip)
		Pwait();
	    return e;
	}
	if (sz < 1)
	    break;
	if (check_redirect == 1)
	{
	    if (strnicmp("<html>", gbuf, 6))
		check_redirect = 0;
	    else
	    {
	    	ptr = strchr(gbuf+6, '<');
		if (!ptr || strnicmp(ptr, "<TITLE>Redirection</TITLE>",
		    sizeof("<TITLE>Redirection</TITLE>")-1))
		    check_redirect = 0;
		else
		    check_redirect = 2;
	    }
	    
	}
	sz = fwrite(gbuf, 1, sz, fp);
	if (sz < 1 || sz > READ_SIZE)
	    goto err;
	LOG(("write %ld\n", sz));
	bcount += sz;
	respond(R_STATUS, STATUS_RECEIVING_DATA, bcount);
    }
    shutdown(s, 2);
    fclose(sp);
    if (check_redirect == 2)
    {
	/* check for redirections */
	fseek(fp, 0L, SEEK_SET);
	if (redirection(fp))
	    return try_redir(kind, gbuf, u);
	return 0;
    }
    fclose(fp);
    if (do_gzip)
	Pwait();
    switch (hterr)
    {
	case 0: e = 0; break;
	case 400:
	case 405:
	case 406:
	case 408: e = EBADRQ; break;
	case 401:
	case 402:
	case 403:
	case 407: e = EACCES; break;
	case 404:
	case 410: e = EPATH; break;
	case 409: e = ELOCKED; break;
	case 411: e = EBADARG; break;
	case 412: e = ENOENT; break;
	case 413: e = ERANGE; break;
	case 414: e = ENAMETOOLONG; break;
	case 415: e = EUKMEDIA; break;
	case 500: e = EINTERNAL; break;
	case 501: e = EINVAL; break;
	case 502: e = EBADRQ; break;
	case 503: e = EDRVNR; break;
	case 504: e = ETIMEDOUT; break;
	case 505: e = EINVAL; break;
	default: e = EBADRQ; break;
    }
    LOG(("Return %d\n", e));
    return e;
}

long
try_redir(int kind, char *new, URL *u)
{
    char *ptr;

    ptr = strchr(new, '/');
    /* Do we have a fully qualified URL? */
    if (!ptr || ptr[1] != '/')
    {
	ptr = u->path;
	ptr += sprintf(u->path, "http://%s",
		(u->flags & DID_PROXY) ? u->host : u->site);
	if (*new != '/')
	    *ptr++ = '/';
	strcpy(ptr, new);
	new = alloca(strlen(u->path)+1);
	strcpy(new, u->path);
    } else
    {
	ptr = alloca(strlen(new)+1);
	strcpy(ptr, new);
	new = ptr;
    }
    LOG(("Attempting redirection to %s\n", new));
    if (kind == HEAD || !respond(R_REDIR, (long)new, (long)&ctype))
    {
	if (kind == HEAD && !prev_url)
	{
		prev_url = malloc(strlen(url)+1);
		if (prev_url)
			strcpy(prev_url, url);
	}
	url = new;
	return GetUrl(kind);
    }
    return 0;
}

static char hostname[128];
static char username[256], *user;

#define MBSIZE	1024

long _mailto(URL *u)
{
	char *ptr, *dest, mbuf[MBSIZE];
	time_t now;
	int i, e;

	if (!hostname[0])
		gethostname(hostname, sizeof(hostname));

	if (!user)
		user = getenv("MAILUSER");

	if (!user)
		user = username;

	if (!user[0])
	{
		i = respond(R_PROMPT, 0, (long)&ptr);
		if (i < 1)
			return -1;
		strcpy(user, ptr);
	}
	if (!strchr(user,'@'))
	{
		strcat(user, "@");
		strcat(user, hostname);
	}

	fp  = fopen(fname,"r");
	if (!fp)
		return errno;

	sp = fdopen(s, "w");

	for (ptr = u->path; *ptr==' ';ptr++);
	dest = ptr;

	respond(R_STATUS, STATUS_WAITING_RESPONSE, 0);
	if (readline(1, s, mbuf, MBSIZE) < 0)
	{
	   e = errno;
	   LOG(("Fatal error reading first response line\n"));
err_out:
	   fclose(sp);
	   fclose(fp);
	   return e;
	}
	if (mbuf[0] != '2')
	{
bad_rsp:   LOG(("Unexpected response: %s", mbuf));
	   fprintf(sp, "QUIT\n");
	   e = EBADREQ;
	   goto err_out;
	}

	fprintf(sp, "HELO %s\n", hostname); fflush(sp);
	LOG(("Sent HELO %s\n", hostname));
	respond(R_STATUS, STATUS_SENDING_REQUEST, 0);
	if (readline(1, s, mbuf, MBSIZE) < 0)
	{
	   e = errno;
	   goto err_out;
	}
	if (mbuf[0] != '2')
	{
	   goto bad_rsp;
	}
	fprintf(sp, "MAIL FROM: <%s>\n", user); fflush(sp);
	respond(R_STATUS, STATUS_SENDING_REQUEST, 0);
	if (readline(1, s, mbuf, MBSIZE) < 0)
	{
		e = errno;
		goto err_out;
	}	
	if (mbuf[0] != '2')
		goto bad_rsp;
	fprintf(sp, "RCPT TO: <%s>\n", dest); fflush(sp);
	respond(R_STATUS, STATUS_SENDING_REQUEST, 0);
	if (readline(1, s, mbuf, MBSIZE) < 0)
	{
		e = errno;
		goto err_out;
	}	
	if (mbuf[0] != '2')
		goto bad_rsp;
	fprintf(sp, "DATA\n"); fflush(sp);
	respond(R_STATUS, STATUS_SENDING_REQUEST, 0);
	if (readline(1, s, mbuf, MBSIZE) < 0)
	{
		e = errno;
		goto err_out;
	}	
	if (mbuf[0] != '3')
		goto bad_rsp;
	time(&now);
	fprintf(sp,"Date: %sTo: %s\nFrom: %s\nSubject: %s\n\n",
		ctime(&now), dest, user, enc); fflush(sp);
	while(fgets(gbuf, READ_SIZE, fp))
	{
		if (gbuf[0] == '.' && gbuf[1] == '\0')
		{
			gbuf[1] = '.';
			gbuf[2] = '\0';
		}
		fprintf(sp, "%s", gbuf);
	}
	fprintf(sp, ".\n"); fflush(sp);
	fclose(fp);
	respond(R_STATUS, STATUS_WAITING_RESPONSE, 0);
	if (readline(1, s, mbuf, MBSIZE) < 0)
	{
		e = errno;
		goto err_out;
	}	
	if (mbuf[0] != '2')
		goto bad_rsp;
	fprintf(sp, "QUIT\n");
	fclose(sp);
	return 0;
}

void handler(int sig)
{
	LOG(("\nClk %ld Got signal %d\n\n", time(0L), sig));

	if (sig == SIGTERM)
	{
		if (debug)
		{
			fclose(stdout);
#if DEBUG_PARENT
			fclose(stderr);
#endif
		}
		appl_exit();
		Pterm0();
	}
	if (fp)
	{
		fclose(fp);
		fp = NULL;
	}
	if (sp)
	{
		shutdown(s, 2);
		fclose(sp);
		sp = NULL;
	}
	url = ctype = enc = body = NULL;
	longjmp(myjmp, EINTR);
}

void
myloop() {
	long i;
	int id;

	ifd = Fopen(CABPIPE,0);
	if (ifd < 0)
		return;

	id = appl_init();
	if (_global[1] == -1)
		menu_register(id,"  CAB+MiNTNet");

	ap_id = appl_find("CAB     ");
	signal(SIGINT, handler);
	signal(SIGTERM, handler);

	debug = getenv("CMDEBUG");
	if (debug)
		freopen("cmdebug.log","w",stdout);
	gzip = getenv("CMGZIP");

	if (setjmp(myjmp) && !didreply)
		respond(R_ERROR, 0, 0);
	didreply = 0;
	
	for (;;)
	{
		i = Fgetchar(ifd, 0);
		if (i < 0 || i == 0xff1a)
			break;
		fp = sp = NULL;
		id = i;
		i = GetUrl(id);
		if (prev_url && id != HEAD)
			free(prev_url);
		respond(R_ERROR, i, 0);
	}
	if (debug)
	{
		fclose(stdout);
#if DEBUG_PARENT
		fclose(stderr);
#endif
	}
	appl_exit();
}
