/* 
** init.c for Inet-Module
** Initialisation for HTML.APP browser inet-module
** 
** Copyright (C) 1995-1996, Andrew 'Dancer' Vesperman. All rights reserved.
** Portions Copyright (C) 1995, Stephane Boisson. All Rights reserved.
** Login <boisson@worldnet.net>
** 
** Started on  Sun Aug 27 23:41:30 1995 Stephane Boisson
** Last update Mon Aug 28 00:44:10 1995 Stephane Boisson
** Dancer commenced on 31 Dec 1995
** Last update 4 Jan 1995
** 
** This file can be redistributed under the terms of the GNU General
** Public Licence.
*/

#define	VERSION	"1.64"
#define	VERSION_BCD 0x00016400

#include <unistd.h>
#include "module.h"

#include <osbind.h>
#include <mintbind.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <netdb.h>
#include <fcntl.h>
#include <basepage.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "weblib.h"



/*--- Global variables ---*/
browser_info_t *browser;

extern	BASEPAGE	*_base;
static	jmp_buf	init_end;
static	int	start_mode=0;
extern int h_errno;
extern char last_info_url[];
char	gbuf[READ_SIZE+256];
char	*version;





/*--- Prototypes ---*/
long ___CDECL init_module(url_methods_t *out, browser_info_t *in, char *path);
long ___CDECL get_url_info(char *url, long *timep, long *sizep, char *type);
void ___CDECL get_version(char **authorp, long *versionp, long *datep);
long ___CDECL get_url(char *url, char *filename);
long ___CDECL post(char *url,char *content, char *enctype, char *filename);
void ___CDECL restore_module(void);



/* ----------------------------------------------------------------- ** 
** init_module - Initialize the module (called by browser)           ** 
** ----------------------------------------------------------------- */
long ___CDECL init_module(out, in, path)
url_methods_t *out;	/* struture to fill */
browser_info_t *in;	/* infos about browser */
char *path;		/* module path, '\' terminated */
{
	int	support=SUPPORT_HTTP;
  /*--- Set browser info variable ---*/
  browser = in;

  /*--- Fill URL methods structure ---*/
  out->restore = restore_module;
  out->get_url = get_url;
  out->get_url_info = get_url_info;
  out->get_version = get_version;
  out->post = post;

  /*--- Initialize other stuffs here ---*/
  version=VERSION;
  last_info_url[0]='\0';
  start_mode=-1;
  _base=(BASEPAGE *)in->basepage;
  if(setjmp(init_end)!=1)
	{
	_crtinit();
	}

  /*--- Return support ---*/
	if(gopher_proxy(NULL))
		support|=SUPPORT_GOPHER;
	if(ftp_proxy(NULL))
		support|=SUPPORT_FTP;
  return(SUPPORT_HTTP);
}


/* ----------------------------------------------------------------- ** 
** get_version - Returns infos about module                          ** 
** ----------------------------------------------------------------- */
void ___CDECL get_version(authorp, versionp, datep)
char **authorp;	/* 4x30 chars separated by '|' */
long *versionp;	/* Version number in BCD format (V1.15 -> 0x00011500) */
long *datep;	/* Date in BCD format (0xYYYYMMDD) */
{
   *versionp = VERSION_BCD;
   *datep = 0x19960108L;               
   *authorp = "Andrew 'Dancer' Vesperman|EMAIL: dancer@brisnet.org.au";
}


/* ----------------------------------------------------------------- ** 
** restore_module - De-initialization                                ** 
**                  (freeing memory, closing files, etc...)          ** 
** ----------------------------------------------------------------- */
void ___CDECL restore_module()
{
#ifdef	DEBUG
	fclose(ep);
#endif
}


/* ----------------------------------------------------------------- ** 
** get_url - Fetch URL and write it as a HTML file                   ** 
**           Returns 0 if OK, else `errno'                           **
** ----------------------------------------------------------------- */

long ___CDECL get_url(char *url, char *filename)
{
	return _get_url(url,filename,"GET");
}




/* ----------------------------------------------------------------- ** 
** post    - Post FORM, fetch result and write it as a HTML file     ** 
**           Returns 0 if OK, else `errno'                           **
** ----------------------------------------------------------------- */
#if 0
char *url;     		/* URL to fetch */
char *content;      /* data to post */
char *enctype;      /* format of data */
char *filename;		/* file to write to */
#endif

long ___CDECL post(char *url, char *content, char *enctype, char *filename)
{
  return 0;
}


/* ----------------------------------------------------------------- ** 
** get_url_info - Retreive infos for an URL                          ** 
**                Returns 0 if OK, else `errno'                      **
** ----------------------------------------------------------------- */

long ___CDECL _get_url_info(char *url, long *timep, long *sizep, char *type,int dofetch);

long ___CDECL get_url_info(char *url, long *timep, long *sizep, char *type)
{
	return _get_url_info(url,timep,sizep,type,1);
}

/* ----------------------------------------------------------------- ** 
** main - Doesn't useful, but take care that others functions don't  ** 
**        get `swallowed' by compiler optimizations                  ** 
** ----------------------------------------------------------------- */

int main()
{
  static void *array[] = {
    "Needs HTML.APP to run\r\n",
    (void *)BROWSER_MAGIC1, (void *)BROWSER_MAGIC2,
    (void *)BROWSER_MAGIC3, (void *)BROWSER_MAGIC4BIS, init_module};

  if(start_mode!=0)
	{
	longjmp(init_end,1);
	}
 else
	  write(1, array[0], strlen(array[0]));
  return 1;
}

