| dmasound.s: DMA sound interrupt routine. It is raised at the end
| of each sample frame.
|
| Also a few low-level functions

.globl _new_timera_vector

_new_timera_vector:
	moveml	d0-d1/a0-a1, sp@-
	jsr	_do_timera		| do things...
	moveml	sp@+, d0-d1/a0-a1
	bclr	#5, 0x00FFFA0F
	rte

| Utility functions to modify the interrupt mask. They'll be used
| only if the NO_INLINE macro is defined.

.globl _spl7, _spl

_spl7:
	movew	sr, d0
	oriw	#0x700, sr
	rts

_spl:
	movew	sp@(4), sr
	rts
