/*
 * dmasnd.h -- STe DMA sound registers
 */

#ifndef DMASND_H
#define DMASND_H

#define DMActl	(*(volatile unsigned char *)0x00ff8901)
#define DMAbah	(*(volatile unsigned char *)0x00ff8903)
#define DMAbam	(*(volatile unsigned char *)0x00ff8905)
#define DMAbal	(*(volatile unsigned char *)0x00ff8907)
#define DMAach	(*(volatile unsigned char *)0x00ff8909)
#define DMAacm	(*(volatile unsigned char *)0x00ff890b)
#define DMAacl	(*(volatile unsigned char *)0x00ff890d)
#define DMAeah	(*(volatile unsigned char *)0x00ff890f)
#define DMAeam	(*(volatile unsigned char *)0x00ff8911)
#define DMAeal	(*(volatile unsigned char *)0x00ff8913)
#define DMAsmc	(*(volatile unsigned char *)0x00ff8921)

#define DMASetBase(bufstart) \
	{ \
		DMAbah=(((long)bufstart) & 0x00ff0000) >> 16; \
		DMAbam=(((long)bufstart) & 0x0000ff00) >> 8; \
		DMAbal= ((long)bufstart) & 0x000000ff; \
	}

#define DMASetEnd(bufend) \
	{ \
		DMAeah=(((long)bufend) & 0x00ff0000) >> 16; \
		DMAeam=(((long)bufend) & 0x0000ff00) >> 8; \
		DMAeal= ((long)bufend) & 0x000000ff; \
	}

#endif /* DMASND_H */
