/*
 * audioflush.c: flushes the "/dev/audio" buffer.  Probably not much
 * use on its own... if you want the sound to stop, kill the program
 * and wait a few seconds for the buffer to empty.
 */
 
#include "audiodev.h"

int main()
{
	int fp, ret;
	
	fp = Fopen("u:\\dev\\audio", 0);
	if (fp < 0) {
		Cconws("audioflush: can't open \"" DEVNAME "\"\r\n");
		return fp;
	}
	ret = Fcntl(fp, 0L, TIOCFLUSH);
	if (ret < 0) {
		Cconws("audioflush: can't flush \"" DEVNAME "\"\r\n");
		return ret;
	}
	return 0;  /* Ok */
}
