/* Scheme implementation intended for JACAL.
   Copyright (C) 1993 Aubrey Jaffer.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

The author can be reached at jaffer@ai.mit.edu or
Aubrey Jaffer, 84 Pleasant St., Wakefield MA 01880
*/

#include "scm.h"

#ifdef DLD
#include "dld.h"

static char s_link[] = "foreign:link", s_fcall[] = "foreign:call";
SCM llink(fname)
     SCM fname;
{
  int status;
  ASSERT(NIMP(fname) && STRINGP(fname), fname, ARG1, s_link);
  DEFER_INTS;
  status = dld_link(CHARS(fname));
  ALLOW_INTS;
  if (!status) return BOOL_T;
  dld_perror("DLD");
  return BOOL_F;
}
SCM fcall(symb)
     SCM symb;
{
  void (*func)() = 0;
  ASSERT(NIMP(symb) && STRINGP(symb), symb, ARG1, s_fcall);
  DEFER_INTS;
  if (dld_function_executable_p(CHARS(symb)))
    func = (void (*) ()) dld_get_func(CHARS(symb));
  else dld_perror("DLDP");
  ALLOW_INTS;
  if (!func) {
    dld_perror("DLD");
    return BOOL_F;
  }
  (*func) ();
  return BOOL_T;
}
static iproc subr1s[] = {
	{s_link, llink},
	{s_fcall, fcall},
	{0,0}};
void init_dynl()
{
#ifndef RTL
  if (dld_init (dld_find_executable (CHARS(CAR(progargs))))) {
    dld_perror("DLD:");
    wta(CAR(progargs),"couldn't init","dld");
  }
#endif
  init_iprocs(subr1s, tc7_subr_1);
}
#endif

#ifdef vms
/* This permits dynamic linking. For example, the procedure of 0 arguments
   from a file could be the initialization procedure.
   (dynamic-link-call "MYDISK:[MYDIR].EXE" "foo" "INIT_FOO")
   The first argument specifies the directory where the file specified
   by the second argument resides.  The current directory would be
   "SYS$DISK:[].EXE".
   The second argument cannot contain any punctuation.
   The third argument probably needs to be uppercased to mimic the VMS linker.
   */

#include <descrip.h>
#include <ssdef.h>
#include <rmsdef.h>

struct dsc$descriptor *descriptorize(x,buff)
     struct dsc$descriptor *x;
     SCM buff;
{(*x).dsc$w_length = LENGTH(buff);
 (*x).dsc$a_pointer = CHARS(buff);
 (*x).dsc$b_class = DSC$K_CLASS_S;
 (*x).dsc$b_dtype = DSC$K_DTYPE_T;
 return(x);}

static char s_dynl[] = "vms:dynamic-link-call";
SCM dynl(dir,symbol,fname)
     SCM dir,symbol,fname;
{
  struct dsc$descriptor fnamed,symbold,dird;
  void (*fcn)();
  long retval;
  ASSERT(IMP(dir) || STRINGP(dir),dir,ARG1,s_dynl);
  ASSERT(NIMP(fname) && STRINGP(fname),fname,ARG2,s_dynl);
  ASSERT(NIMP(symbol) && STRINGP(symbol),symbol,ARG3,s_dynl);
  descriptorize(&fnamed,fname);
  descriptorize(&symbold,symbol);
  DEFER_INTS;
  retval = lib$find_image_symbol(&fnamed, &symbold, &fcn,
				 IMP(dir) ? 0 : descriptorize(&dird, dir));
  if (SS$_NORMAL != retval) {
    /* wta(MAKINUM(retval),"vms error",s_dynl); */
    ALLOW_INTS;
    return BOOL_F;
  }
  (*fcn)();
  ALLOW_INTS;
  return BOOL_T;
}

void init_dynl()
{
  make_subr(s_dynl,tc7_subr_3,dynl);
}
#endif
