
#ifndef WORM_H
#  define WORM_H

#include"Queue.H"

#define Q_SIZE 4096

class Worm
{
   Queue WQ;
   int HeadX, HeadY, Len, Alive;
   int ToGrow, Score;
   int MaxWidth, MaxHeight;
   void AddQueue( int x, int y );
   void DelQueue();
   void RedrawHead();
   public:
   Worm() : WQ( Q_SIZE )
      {
         Len = Score = 0;
         ToGrow = 1;
         Alive = 1;
      }
   void SetSize( int w, int h )
      {
         MaxWidth = w - 1;
         MaxHeight = h - 2;
         Reset();
      }
   void Move( int Dir );
   void AddScore( int Pts );
   void Shrink( int Count );
   void Redraw() const;
   int InMe( int X, int Y ) const;
   void Die();
   void Reset()
      {
         WQ.Reset();
         Len = Score = 0;
         ToGrow = 1;
         Alive = 1;
         HeadX = MaxWidth >> 1;
         HeadY = MaxHeight >> 1;
      }
   int IsAlive() const
      { return Alive; }
   int GetScore() const
      { return Score; }
};

#endif

