
#include"Worm.H"
#include"Queue.H"
#include"Video.H"
#include"Field.H"

extern Video CurrVideo;
extern FieldDesc F;

void Worm::Move( int Dir )
{
int X = HeadX;
int Y = HeadY;
Fruit * Fr;
   switch( Dir )
   {
      case '8' : Y--; break;
      case '2' : Y++; break;
      case '4' : X--; break;
      case '6' : X++; break;
      default : return;
   }
   if( X < 1 || X > MaxWidth )
      Die();
   if( Y < 1 || Y > MaxHeight )
      Die();
   if( InMe( X, Y ) )
      Die();
   if( F.QueryLoc( X, Y ) )
   {
      Fr = F.GetFruitAt( X, Y );
      AddScore( Fr->GetScore() );
      if( Fr->GetShrink() )
         Shrink( Fr->GetShrink() + Fr->GetScore() );
      F.EatLoc( X, Y );
   }
   if( Len )
      CurrVideo.PutSymAt( HeadX, HeadY, WORM_SYM );
   if( !ToGrow )
      DelQueue();
   else
   {
      ToGrow--;
      Len++;
   }
   CurrVideo.PutSymAt( X, Y, WORM_HEAD_SYM );
   AddQueue( HeadX = X, HeadY = Y );
}

void Worm::AddScore( int Pts )
{
   ToGrow += Pts;
   Score += Pts;
   CurrVideo.ShowScore( Score );
}

void Worm::Shrink( int Count )
{
   if( Count >= Len )
      Count = Len;
   while( ToGrow )
   {
      ToGrow--;
      Count--;
   }
   while( Count-- > 0 )
   {
      DelQueue();
      Len--;
   }
}

void Worm::Redraw() const
{
QueueIterator QI( WQ );
int x, y;
   for( ; !QI.AtEnd(); QI.Advance() )
   {
      QI.GetCurr( x, y );
      CurrVideo.PutSymAt( x, y, WORM_SYM );
   }
   CurrVideo.ShowScore( Score );
}

void Worm::AddQueue( int x, int y )
{
   WQ.Insert( x, y );
}

void Worm::DelQueue()
{
int x, y;
   if( WQ.Remove( x, y ) )
      return;
   CurrVideo.PutSymAt( x, y, EMPTY_SYM );
}

int Worm::InMe( int X, int Y ) const
{
return WQ.InQueue( X, Y );
}

void Worm::Die()
{
   Alive = 0;
}

