
#include<X11/X.h>
#include<X11/Xlib.h>
#include<X11/keysym.h>
#include<X11/Xutil.h>
#include<stdio.h>
#include<stdlib.h>
#include<signal.h>
#include"Video.H"
#include"Config.H"

#include"Icon.xbm"
#include"IconMask.xbm"

#define CellW 16
#define CellH 16

extern void Redraw(); // From Main.C

static void InitPics();
static void SetupText();

static Pixmap Syms[ MAX_SYM + 1 ];
static Display * Dpy;
static int Scr;
static Window Wnd;
static long Black, White;
static GC Gc;
static GC BigTextGc, SmallTextGc;
static Font BigFnt, SmallFnt;
static Pixmap IconPm, IconMaskPm;

Video::Video()
{
   if( !( Dpy = XOpenDisplay( 0 ) ) )
   {
      char *DpyName = getenv( "DISPLAY" );
      fprintf(
         stderr,
         "Cannot open display \"%s\"\n",
         DpyName ? DpyName : "Unset" );
      raise( SIGTERM );
   }
   Scr = DefaultScreen( Dpy );
   Black = BlackPixel( Dpy, Scr );
   White = WhitePixel( Dpy, Scr );
}

void Video::InitVideo( int W, int H )
{
XEvent Ev;
XWMHints * WM;
XSizeHints * SH;
   w = W + 1; h = H + 1;
   Wnd = XCreateSimpleWindow(
      Dpy,
      DefaultRootWindow( Dpy ),
      0, 0,
      w * CellW, h * CellH,
      1,
      White,
      Black );
   Gc = XCreateGC( Dpy, Wnd, 0L, 0 );
   XSetGraphicsExposures( Dpy, Gc, False );
   SetupText();
   InitPics();
   XSelectInput(
      Dpy,
      Wnd,
      ExposureMask | KeyPressMask );
   IconPm = XCreateBitmapFromData(
      Dpy,
      Wnd,
      ( char * )Icon_bits,
      Icon_width, Icon_height );
   IconMaskPm = XCreateBitmapFromData(
      Dpy,
      Wnd,
      ( char * )IconMask_bits,
      IconMask_width, IconMask_height );
   WM = XAllocWMHints();
   WM->flags = IconPixmapHint | IconMaskHint;
   WM->icon_pixmap = IconPm;
   WM->icon_mask = IconMaskPm;
   XSetWMHints( Dpy, Wnd, WM );
   XFree( WM );
   SH = XAllocSizeHints();
   SH->flags = PMinSize | PMaxSize;
   SH->min_width = SH->max_width = w * CellW;
   SH->min_height = SH->max_height = h * CellH;
   XSetWMNormalHints( Dpy, Wnd, SH );
   XFree( SH );
   XSetIconName( Dpy, Wnd, "XWorm" );
   XStoreName( Dpy, Wnd, "XWorm" );
   XMapRaised( Dpy, Wnd );
   do
      XNextEvent( Dpy, &Ev );
   while( Ev.type != Expose );
}

Video::~Video()
{
   XUnmapWindow( Dpy, Wnd );
   XFreePixmap( Dpy, IconPm );
   XFreePixmap( Dpy, IconMaskPm );
   XUnloadFont( Dpy, BigFnt );
   XUnloadFont( Dpy, SmallFnt );
   XFreeGC( Dpy, BigTextGc );
   XFreeGC( Dpy, SmallTextGc );
   XFreeGC( Dpy, Gc );
   for( int i = 0; i <= MAX_SYM; i++ )
      XFreePixmap( Dpy, Syms[ i ] );
   XDestroyWindow( Dpy, Wnd );
   XCloseDisplay( Dpy );
}

void Video::GetWindowSize( int& W, int& H )
{
   W = X_VIDEO_DEF_WIDTH;
   H = X_VIDEO_DEF_HEIGHT;
}

void Video::PutSymAt( int x, int y, int Sym )
{
   XCopyArea(
      Dpy,
      Syms[ Sym ],
      Wnd,
      Gc,
      0, 0,
      CellW, CellH,
      x * CellW, y * CellH );
   XSync( Dpy, False );
}

int Video::GetChar()
{
XEvent Ev;
   if( !XPending( Dpy ) )
      return 0;
   while( XPending( Dpy ) )
   {
      XNextEvent( Dpy, &Ev );
      if( Ev.type == Expose )
      {
         if( ( ( XExposeEvent * )&Ev )->count == 0 )
         {
            Redraw();
            return 0;
         }
         continue;
      }
      if( Ev.type != KeyPress )
         return 0;
      switch( XLookupKeysym( ( XKeyEvent * )&Ev, 0 ) )
      {
         case XK_Up :
            return W_KEY_UP;
         case XK_Down :
            return W_KEY_DOWN;
         case XK_Left :
            return W_KEY_LEFT;
         case XK_Right :
            return W_KEY_RIGHT;
         case XK_Q : case XK_q :
            return W_KEY_QUIT;
         case XK_P : case XK_p :
            return W_KEY_PAUSE;
         case XK_space :
            return W_KEY_SPACE;
      }
   }
return 0;
}

void Video::DrawBox( int x, int y, int w, int h )
{
int Count, i;
   for( i = x + 1, Count = 1; Count < w; i++, Count++ )
   {
      PutSymAt( i, y, H_BORDER_SYM );
      PutSymAt( i, y + h, H_BORDER_SYM );
   }
   for( i = y + 1, Count = 1; Count < h; i++, Count++ )
   {
      PutSymAt( x, i, V_BORDER_SYM );
      PutSymAt( x + w, i, V_BORDER_SYM );
   }
}

void Video::ShowScore( int Score )
{
char Tmp[ 255 ];
   sprintf( Tmp, "Score = %d", Score );
   PutTextAt( BIG_FONT | ALIGN_LEFT, 2, h - 1, Tmp );
}

void Video::PutTextAt( int info, int x, int y, char * Txt )
{
XFontStruct * FS;
int Width = 0, NCh;
   NCh = strlen( Txt );
   if( info & ALIGN_CTR )
   {
      FS = XQueryFont( Dpy, info & SMALL_FONT ? SmallFnt : BigFnt );
      Width = XTextWidth( FS, Txt, NCh );
      XFreeFontInfo( 0, FS, 1 );
   }
   y++; // To get the text on the same line alignment as Syms...
   XDrawImageString(
      Dpy,
      Wnd,
      info & SMALL_FONT ? SmallTextGc : BigTextGc,
      x * CellW - Width / 2, y * CellH, // Width == 0 if not centered
      Txt,
      NCh);
}

void Video::Clear()
{
   XClearWindow( Dpy, Wnd );
}

// ***********
//   Static
// ***********

#include"Fruit1.xbm"
#include"Fruit2.xbm"
#include"Fruit3.xbm"
#include"Fruit4.xbm"
#include"Worm.xbm"
#include"Head.xbm"
#include"HBorder.xbm"
#include"VBorder.xbm"

void InitPics()
{
   Syms[ FRUIT_SYM1 ] = XCreatePixmapFromBitmapData(
      Dpy,
      Wnd,
      ( char * )Fruit1_bits,
      Fruit1_width, Fruit1_height,
      White, Black,
      DefaultDepth( Dpy, Scr ) );

   Syms[ FRUIT_SYM2 ] = XCreatePixmapFromBitmapData(
      Dpy,
      Wnd,
      ( char * )Fruit3_bits,
      Fruit3_width, Fruit3_height,
      White, Black,
      DefaultDepth( Dpy, Scr ) );

   Syms[ FRUIT_SYM3 ] = XCreatePixmapFromBitmapData(
      Dpy,
      Wnd,
      ( char * )Fruit4_bits,
      Fruit4_width, Fruit4_height,
      White, Black,
      DefaultDepth( Dpy, Scr ) );

   Syms[ FRUIT_SYM4 ] = XCreatePixmapFromBitmapData(
      Dpy,
      Wnd,
      ( char * )Fruit2_bits,
      Fruit2_width, Fruit2_height,
      White, Black,
      DefaultDepth( Dpy, Scr ) );

   Syms[ WORM_SYM ] = XCreatePixmapFromBitmapData(
      Dpy,
      Wnd,
      ( char * )Worm_bits,
      Worm_width, Worm_height,
      White, Black,
      DefaultDepth( Dpy, Scr ) );
   
   Syms[ WORM_HEAD_SYM ] = XCreatePixmapFromBitmapData(
      Dpy,
      Wnd,
      ( char * )Head_bits,
      Head_width, Head_height,
      White, Black,
      DefaultDepth( Dpy, Scr ) );

   Syms[ H_BORDER_SYM ] = XCreatePixmapFromBitmapData(
      Dpy,
      Wnd,
      ( char * )HBorder_bits,
      HBorder_width, HBorder_height,
      White, Black,
      DefaultDepth( Dpy, Scr ) );

   Syms[ V_BORDER_SYM ] = XCreatePixmapFromBitmapData(
      Dpy,
      Wnd,
      ( char * )VBorder_bits,
      VBorder_width, VBorder_height,
      White, Black,
      DefaultDepth( Dpy, Scr ) );

   Syms[ EMPTY_SYM ] = XCreatePixmap(
      Dpy,
      Wnd,
      CellW, CellH,
      DefaultDepth( Dpy, Scr ) );
   XFillRectangle(
      Dpy,
      Syms[ EMPTY_SYM ],
      Gc,
      0, 0,
      CellW, CellH );
}

void SetupText()
{
   BigFnt = XLoadFont( Dpy, "10x20" );
   SmallFnt = XLoadFont( Dpy, "fixed" );
   BigTextGc = XCreateGC( Dpy, Wnd, 0L, 0 );
   SmallTextGc = XCreateGC( Dpy, Wnd, 0L, 0 );
   XSetFont( Dpy, Gc, SmallFnt );
   XSetFont( Dpy, BigTextGc, BigFnt );
   XSetForeground( Dpy, BigTextGc, White );
   XSetForeground( Dpy, SmallTextGc, White );
   XSetBackground( Dpy, BigTextGc, Black );
   XSetBackground( Dpy, SmallTextGc, Black );
}
