
#include<vga.h>
#include<vgakeyboard.h>
#include<string.h>
#include<stdlib.h>
#include<stdio.h>
#include"Video.H"
#include"VgaFont.H"

#define CellW 16
#define CellH 16

struct Image
{
   int w, h;
   char * buf;
   Image( int W, int H )
      {
         w = W;
         h = H;
         buf = new char[ w * h ];
      }
   ~Image()
      { delete [] buf; }
};

extern void Redraw(); // From Main.C

static Image * CreateImage( unsigned char *, int, int );
static void InitImages();
static void WriteVgaString( int x, int y, char * str );
static void WriteVgaStringBig( int x, int y, char * str );
extern "C" void KeyHandler( int scan, int press );

static Image * Syms[ MAX_SYM + 1 ];
static int LastKey;

Video::Video()
{
   vga_init();
   vga_setmode( G640x480x256 );
   InitImages();
   InitFont();
}

Video::~Video()
{
   keyboard_close();
   vga_setmode( TEXT );
}

void Video::GetWindowSize( int& W, int& H )
{
   W = 39;
   H = 29;
}

void Video::InitVideo( int W, int H )
{
   keyboard_init();
   keyboard_seteventhandler( KeyHandler );
   keyboard_translatekeys( TRANSLATE_CURSORKEYS );
   w = W;
   h = H;
}

void Video::PutSymAt( int x, int y, int Sym )
{
Image * sym = Syms[ Sym ];
   for( int i = 0; i < sym->h; i++ )
      vga_drawscansegment(
         ( unsigned char * )sym->buf + i * sym->w,
         x * CellW, y * CellH + i,
         sym->w );
}

int Video::GetChar()
{
   if( !keyboard_update() )
      return 0;
   switch( LastKey )
   {
      case SCANCODE_CURSORUP : case SCANCODE_CURSORBLOCKUP :
         return W_KEY_UP;
      case SCANCODE_CURSORDOWN : case SCANCODE_CURSORBLOCKDOWN :
         return W_KEY_DOWN;
      case SCANCODE_CURSORLEFT : case SCANCODE_CURSORBLOCKLEFT :
         return W_KEY_LEFT;
      case SCANCODE_CURSORRIGHT : case SCANCODE_CURSORBLOCKRIGHT :
         return W_KEY_RIGHT;
      case SCANCODE_Q :
         return W_KEY_QUIT;
      case 0x19 : // SCANCODE_P
         return W_KEY_PAUSE;
      case SCANCODE_SPACE :
         return W_KEY_SPACE;
   }
return 0;
}

void Video::DrawBox( int x, int y, int w, int h )
{
int Count, i;
   for( i = x + 1, Count = 1; Count < w; i++, Count++ )
   {
      PutSymAt( i, y, H_BORDER_SYM );
      PutSymAt( i, y + h, H_BORDER_SYM );
   }
   for( i = y + 1, Count = 1; Count < h; i++, Count++ )
   {
      PutSymAt( x, i, V_BORDER_SYM );
      PutSymAt( x + w, i, V_BORDER_SYM );
   }
}

void Video::ShowScore( int Score )
{
char Buf[ 255 ];
   sprintf( Buf, "Score = %d", Score );
   PutTextAt( ALIGN_LEFT | BIG_FONT, 1, h, Buf );
}

void Video::PutTextAt( int info, int x, int y, char * Txt )
{
int xp;
int FontW;
   ++x;
   xp = x * CellW;
   FontW = info & BIG_FONT ? 16 : 8;
   if( info & ALIGN_CTR )
      xp -= ( FontW * strlen( Txt ) ) / 2;
   if( info & BIG_FONT )
      WriteVgaStringBig( xp, y * CellH, Txt );
   else
      WriteVgaString( xp, y * CellW, Txt );
}

void Video::Clear()
{
   vga_clear();
}

// Had to make it c-style for the vgalib...
void KeyHandler( int scan, int press )
{
   if( !press )
      return;
   LastKey = scan;
}

// ******
// Static
// ******

#include"Fruit1.xbm"
#include"Fruit2.xbm"
#include"Fruit3.xbm"
#include"Fruit4.xbm"
#include"HBorder.xbm"
#include"VBorder.xbm"
#include"Worm.xbm"
#include"Head.xbm"

Image * CreateImage( unsigned char * Bits, int W, int H )
{
Image * New = new Image( W, H );
int Count = ( W * H ) / 8, i = 0, ndx = 0;
   while( Count-- )
   {
      for( int bit = 0x01; bit != 0x100; bit <<= 1 )
         if( Bits[ i ] & bit )
            New->buf[ ndx++ ] = 15;
         else
            New->buf[ ndx++ ] = 0;
      i++;
   }
return New;
}

void InitImages()
{
   Syms[ EMPTY_SYM ] = new Image( CellW, CellH );
   for( int i = 0; i < CellW * CellH; i++ )
      Syms[ EMPTY_SYM ]->buf[ i ] = 0;
   Syms[ FRUIT_SYM1 ] = CreateImage( Fruit1_bits, CellW, CellH );
   Syms[ FRUIT_SYM2 ] = CreateImage( Fruit3_bits, CellW, CellH );
   Syms[ FRUIT_SYM3 ] = CreateImage( Fruit4_bits, CellW, CellH );
   Syms[ FRUIT_SYM4 ] = CreateImage( Fruit2_bits, CellW, CellH );
   Syms[ WORM_SYM ] = CreateImage( Worm_bits, CellW, CellH );
   Syms[ WORM_HEAD_SYM ] = CreateImage( Head_bits, CellW, CellH );
   Syms[ V_BORDER_SYM ] = CreateImage( VBorder_bits, CellW, CellH );
   Syms[ H_BORDER_SYM ] = CreateImage( HBorder_bits, CellW, CellH );
}

void WriteVgaString( int x, int y, char * str )
{
   for( ; *str; x += 8 )
      DrawChar( x, y, *str++ );
}

void WriteVgaStringBig( int x, int y, char * str )
{
   for( ; *str; x += 16 )
      DrawCharBig( x, y, *str++ );
}

