
#include<ncurses/ncurses.h>
#include"Video.H"

extern void Redraw(); // From Main.C

static char Syms[] =
{
   ' ', '%', '+', '#', 'o', '-', '|', 'O', '@'
};

static int SymAttr[] =
{
   A_NORMAL, A_REVERSE, A_REVERSE, A_REVERSE, A_NORMAL, A_BOLD, A_BOLD,
   A_NORMAL, A_REVERSE
};

Video::Video()
{
   initscr();
   nonl();
   noecho();
   cbreak();
   nodelay( stdscr, true );
   keypad( stdscr, true );
}

Video::~Video()
{
   endwin();
}

void Video::GetWindowSize( int& W, int& H )
{
   getmaxyx( stdscr, H, W );
   H--;
   W--;
}

void Video::InitVideo( int W, int H )
{
   w = W;
   h = H;
}

void Video::PutSymAt( int x, int y, int Sym )
{
   attron( SymAttr[ Sym ] );
   mvaddch( y, x, Syms[ Sym ] );
   attroff( SymAttr[ Sym ] );
   refresh();
}

int Video::GetChar()
{
int Ch;
   if( ( Ch = getch() ) == -1 )
      return 0;
   switch( Ch )
   {
      case KEY_UP :
         return W_KEY_UP;
      case KEY_DOWN :
         return W_KEY_DOWN;
      case KEY_LEFT :
         return W_KEY_LEFT;
      case KEY_RIGHT :
         return W_KEY_RIGHT;
      case 'Q' : case 'q' :
         return W_KEY_QUIT;
      case 'P' : case 'p' :
         return W_KEY_PAUSE;
      case ' ' :
         return W_KEY_SPACE;
   }
return 0;
}

void Video::DrawBox( int x, int y, int w, int h )
{
int Count, i;
   for( i = x + 1, Count = 1; Count < w; i++, Count++ )
   {
      PutSymAt( i, y, H_BORDER_SYM );
      PutSymAt( i, y + h, H_BORDER_SYM );
   }
   for( i = y + 1, Count = 1; Count < h; i++, Count++ )
   {
      PutSymAt( x, i, V_BORDER_SYM );
      PutSymAt( x + w, i, V_BORDER_SYM );
   }
}

void Video::ShowScore( int Score )
{
   mvprintw( h, 1, "Score = %d", Score );
}

void Video::PutTextAt( int info, int x, int y, char * Txt )
{
   if( info & ALIGN_CTR )
      x -= strlen( Txt ) / 2;
   if( info & SMALL_FONT )
      attroff( A_BOLD );
   else
      attron( A_BOLD );
   mvprintw( y, x, "%s", Txt );
   refresh();
}

void Video::Clear()
{
   clear();
   refresh();
}
