
#include<vga.h>

static char * Char[ 128 ]; // 7-bit only... -> 128 * 8 * 8 bytes = 8K

static char CharFont[ 26 ][ 64 ] =
{
   { 0,0,0,0,1,0,0,0, //A
     0,0,0,1,0,1,0,0,
     0,0,1,0,0,0,1,0,
     0,1,0,0,0,0,0,1,
     0,1,1,1,1,1,1,1,
     0,1,0,0,0,0,0,1,
     0,1,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0 },
   { 0,1,1,1,1,0,0,0, //B
     0,1,0,0,0,1,0,0,
     0,1,0,0,0,1,0,0,
     0,1,1,1,1,0,0,0,
     0,1,0,0,0,1,0,0,
     0,1,0,0,0,1,0,0,
     0,1,1,1,1,0,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,0,1,1,1,1,0,0, //C
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,
     0,1,0,0,0,0,1,0,
     0,0,1,1,1,1,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,1,1,1,1,0,0, //D
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,1,1,1,1,1,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,1,1,1,1,1,0, //E
     0,1,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,
     0,1,1,1,1,0,0,0,
     0,1,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,
     0,1,1,1,1,1,1,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,1,1,1,1,1,0, //F
     0,1,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,
     0,1,1,1,1,1,0,0,
     0,1,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,0,1,1,1,1,0,0, //G
     0,1,0,0,0,0,1,0,
     0,1,0,1,0,0,0,0,
     0,1,0,1,1,1,0,0,
     0,1,0,1,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,0,1,1,1,1,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,0,0,0,0,1,0, //H
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,1,1,1,1,1,1,0,
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,0,0,0,0,0,0,0 },
   { 0,0,1,1,1,0,0,0, //I
     0,0,0,1,0,0,0,0,
     0,0,0,1,0,0,0,0,
     0,0,0,1,0,0,0,0,
     0,0,0,1,0,0,0,0,
     0,0,0,1,0,0,0,0,
     0,0,1,1,1,0,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,0,0,0,1,1,1,0, //J
     0,0,0,0,0,1,0,0,
     0,0,0,0,0,1,0,0,
     0,0,0,0,0,1,0,0,
     0,0,0,0,0,1,0,0,
     0,1,0,0,0,1,0,0,
     0,0,1,1,1,0,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,0,0,0,1,0,0, //K
     0,1,0,0,1,0,0,0,
     0,1,0,1,0,0,0,0,
     0,1,1,0,0,0,0,0,
     0,1,0,1,0,0,0,0,
     0,1,0,0,1,0,0,0,
     0,1,0,0,0,1,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,0,0,0,0,0,0, //L
     0,1,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,
     0,1,1,1,1,1,1,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,1,0,0,0,1,1, //M
     0,1,0,1,0,1,0,1,
     0,1,0,0,1,0,0,1,
     0,1,0,0,0,0,0,1,
     0,1,0,0,0,0,0,1,
     0,1,0,0,0,0,0,1,
     0,1,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0 },
   { 0,1,0,0,0,0,0,1, //N
     0,1,1,0,0,0,0,1,
     0,1,0,1,0,0,0,1,
     0,1,0,0,1,0,0,1,
     0,1,0,0,0,1,0,1,
     0,1,0,0,0,0,1,1,
     0,1,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0 },
   { 0,0,1,1,1,1,0,0, //O
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,0,1,1,1,1,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,1,1,1,0,0,0, //P
     0,1,0,0,0,1,0,0,
     0,1,0,0,0,1,0,0,
     0,1,1,1,1,0,0,0,
     0,1,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,0,1,1,1,1,0,0, //Q
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,1,1,0,
     0,0,1,1,1,1,1,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,1,1,1,0,0,0, //R
     0,1,0,0,0,1,0,0,
     0,1,0,0,0,1,0,0,
     0,1,1,1,1,0,0,0,
     0,1,0,1,0,0,0,0,
     0,1,0,0,1,0,0,0,
     0,1,0,0,0,1,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,0,1,1,1,1,1,0, //S
     0,1,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,
     0,0,1,1,1,1,0,0,
     0,0,0,0,0,0,1,0,
     0,0,0,0,0,0,1,0,
     0,1,1,1,1,1,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,1,1,1,1,1,1, //T
     0,0,0,0,1,0,0,0,
     0,0,0,0,1,0,0,0,
     0,0,0,0,1,0,0,0,
     0,0,0,0,1,0,0,0,
     0,0,0,0,1,0,0,0,
     0,0,0,0,1,0,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,0,0,0,0,1,0, //U
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,0,1,1,1,1,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,0,0,0,0,0,1, //V
     0,1,0,0,0,0,0,1,
     0,1,0,0,0,0,0,1,
     0,1,0,0,0,0,0,1,
     0,0,1,0,0,0,1,0,
     0,0,0,1,0,1,0,0,
     0,0,0,0,1,0,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,0,0,0,0,0,1, //W
     0,1,0,0,0,0,0,1,
     0,1,0,0,0,0,0,1,
     0,1,0,0,1,0,0,1,
     0,1,0,0,1,0,0,1,
     0,0,1,0,1,0,1,0,
     0,0,0,1,0,1,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,0,0,0,1,0,0, //X
     0,1,0,0,0,1,0,0,
     0,0,1,0,1,0,0,0,
     0,0,0,1,0,0,0,0,
     0,0,1,0,1,0,0,0,
     0,1,0,0,0,1,0,0,
     0,1,0,0,0,1,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,0,0,0,1,0,0, //Y
     0,1,0,0,0,1,0,0,
     0,0,1,0,1,0,0,0,
     0,0,0,1,0,0,0,0,
     0,0,0,1,0,0,0,0,
     0,0,0,1,0,0,0,0,
     0,0,0,1,0,0,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,1,1,1,1,0,0, //Z
     0,0,0,0,0,1,0,0,
     0,0,0,0,1,0,0,0,
     0,0,0,1,0,0,0,0,
     0,0,1,0,0,0,0,0,
     0,1,0,0,0,0,0,0,
     0,1,1,1,1,1,1,0,
     0,0,0,0,0,0,0,0 }
};

static char NumberFont[ 10 ][ 64 ] =
{
   { 0,0,1,1,1,1,0,0, //0
     0,1,0,0,0,0,1,0,
     0,1,0,0,1,0,1,0,
     0,1,0,1,1,0,1,0,
     0,1,0,1,0,0,1,0,
     0,1,0,0,0,0,1,0,
     0,0,1,1,1,1,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,0,0,0,1,0,0,0, //1
     0,0,0,1,1,0,0,0,
     0,0,0,0,1,0,0,0,
     0,0,0,0,1,0,0,0,
     0,0,0,0,1,0,0,0,
     0,0,0,0,1,0,0,0,
     0,0,0,1,1,1,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,0,1,1,1,0,0,0, //2
     0,1,0,0,0,1,0,0,
     0,0,0,0,0,1,0,0,
     0,0,0,0,1,0,0,0,
     0,0,0,1,0,0,0,0,
     0,0,1,0,0,0,0,0,
     0,1,1,1,1,1,1,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,1,1,1,1,0,0, //3
     0,0,0,0,0,1,0,0,
     0,0,0,0,1,0,0,0,
     0,0,1,1,1,0,0,0,
     0,0,0,0,0,1,0,0,
     0,0,0,0,0,1,0,0,
     0,1,1,1,1,0,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,0,1,0,0,1,0,0, //4
     0,0,1,0,0,1,0,0,
     0,0,1,0,0,1,0,0,
     0,0,1,1,1,1,0,0,
     0,0,0,0,0,1,0,0,
     0,0,0,0,0,1,0,0,
     0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,1,1,1,1,1,0,0, //5
     0,1,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,
     0,1,1,1,1,1,0,0,
     0,0,0,0,0,0,1,0,
     0,0,0,0,0,0,1,0,
     0,1,1,1,1,1,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,0,0,0,1,0,0,0, //6
     0,0,0,1,0,0,0,0,
     0,0,1,0,0,0,0,0,
     0,1,0,1,1,0,0,0,
     0,1,1,0,0,1,0,0,
     0,1,0,0,0,1,0,0,
     0,0,1,1,1,0,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,0,1,1,1,1,0,0, //7
     0,0,0,0,0,1,0,0,
     0,0,0,0,0,1,0,0,
     0,0,0,0,1,0,0,0,
     0,0,0,1,0,0,0,0,
     0,0,0,1,0,0,0,0,
     0,0,0,1,0,0,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,0,1,1,1,0,0,0, //8
     0,1,0,0,0,1,0,0,
     0,1,0,0,0,1,0,0,
     0,0,1,1,1,0,0,0,
     0,1,0,0,0,1,0,0,
     0,1,0,0,0,1,0,0,
     0,0,1,1,1,0,0,0,
     0,0,0,0,0,0,0,0 },
   { 0,0,0,1,1,1,0,0, //9
     0,0,1,0,0,0,1,0,
     0,0,1,0,0,1,1,0,
     0,0,0,1,1,0,1,0,
     0,0,0,0,0,1,0,0,
     0,0,0,0,1,0,0,0,
     0,0,0,1,0,0,0,0,
     0,0,0,0,0,0,0,0 }
};

static char Dot[] =
{
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,
   0,0,0,1,1,0,0,0,
   0,0,0,1,1,0,0,0
};

static char Comma[] =
{
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,
   0,0,0,1,1,0,0,0,
   0,0,0,1,1,0,0,0,
   0,0,0,0,1,0,0,0
};

static char Apostrophe[] =
{
   0,0,0,1,1,0,0,0,
   0,0,0,1,1,0,0,0,
   0,0,0,0,1,0,0,0,
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0
};

static char Equals[] =
{
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,
   0,1,1,1,1,1,1,0,
   0,0,0,0,0,0,0,0,
   0,1,1,1,1,1,1,0,
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0
};

static char Colon[] =
{
   0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,
   0,0,1,1,0,0,0,0,
   0,0,1,1,0,0,0,0,
   0,0,0,0,0,0,0,0,
   0,0,1,1,0,0,0,0,
   0,0,1,1,0,0,0,0,
   0,0,0,0,0,0,0,0
};

static char EmptyChar[ 64 ] = { 0, };

void InitFont()
{
int i, j;
   for( i = 0; i < 128; i++ )
      Char[ i ] = EmptyChar;
   for( i = 'A', j = 'a'; i <= 'Z'; i++, j++ )
   {
      Char[ i ] = CharFont[ i - 'A' ];
      Char[ j ] = CharFont[ i - 'A' ];
   }
   for( i = '0'; i <= '9'; i++ )
      Char[ i ] = NumberFont[ i - '0' ];
   Char[ '.' ] = Dot;
   Char[ ',' ] = Comma;
   Char[ '\'' ] = Apostrophe;
   Char[ '=' ] = Equals;
   Char[ ':' ] = Colon;
}

void CloseFont()
{
   // Reserved for possible dynamic allocation...
}

void DrawChar( int x, int y, int Ch )
{
int i, j, a, b;
char * tmp = Char[ Ch ];
   b = y;
   for( j = 0; j < 8; j++, b++ )
   {
      a = x;
      for( i = 0; i < 8; i++ )
      {
         if( *tmp++ )
            vga_setcolor( 15 );
         else
            vga_setcolor( 0 );      
         vga_drawpixel( a, b );
         a++;
      }
   }
}

void DrawCharBig( int x, int y, int Ch )
{
int i, j, a, b;
char * tmp = Char[ Ch ];
   b = y;
   for( j = 0; j < 8; j++, b += 2 )
   {
      a = x;
      for( i = 0; i < 8; i++ )
      {
         if( *tmp++ )
            vga_setcolor( 15 );
         else
            vga_setcolor( 0 );      
         vga_drawpixel( a, b );
         vga_drawpixel( a + 1, b );
         vga_drawpixel( a, b + 1 );
         vga_drawpixel( a + 1, b + 1 );
         a += 2;
      }
   }
}
