
#ifndef QUEUE_H
#  define QUEUE_H

#include<stdio.h>

class QueueIterator;

class Queue
{
friend QueueIterator;
   short * X, * Y;
   int Head, Len, Max;
   public:
   Queue( int Size )
   {
      X = new short[ Size ];
      Y = new short[ Size ];
      Head = Len = 0;
      Max = Size;
   }
   ~Queue()
      { delete [] X; delete [] Y; }
   void Insert( int x, int y )
   {
   int pos;
      if( Len >= Max - 1 )
         return;
      pos = Head + Len;
      if( pos >= Max )
         pos -= Max;
      X[ pos ] = x;
      Y[ pos ] = y;
      Len++;
   }
   int Remove( int& x, int& y )
   {
      if( !Len )
         return 1;
      x = X[ Head ];
      y = Y[ Head ];
      Len--;
      Head++;
      if( Head >= Max )
         Head = 0;
   return 0;
   }
   int InQueue( int x, int y ) const
   {
   int i, l;
      for( i = Head, l = Len; l; i++, l-- )
      {
         if( X[ i ] == x && Y[ i ] == y )
            return 1;
         if( i == Max )
            i = 0;
      }
   return 0;
   }
   void Reset()
   {
      Head = Len = 0;
   }
};

class QueueIterator
{
   int ndx;
   int Head, Len, Max;
   const Queue * Q;
   public:
   QueueIterator( const Queue& to )
      {
         Q = &to;
         ndx = Head = Q->Head;
         Len = Q->Len;
         Max = Q->Max;
      }
   void GetCurr( int& x, int& y ) const
      {
         x = Q->X[ ndx ];
         y = Q->Y[ ndx ];
      }
   void Advance()
      {
         ndx++;
         if( ndx >= Max )
            ndx = 0;
      }
   int AtEnd() const
      {
      int tmp;
         tmp = Head + Len;
         if( tmp >= Max )
            tmp -= Max;
         return ndx == tmp;
      }
};

#endif

