
#include<unistd.h>
#include<stdio.h>
#include"Worm.H"
#include"Field.H"
#include"Video.H"
#include"Config.H"

// Problems getting this from unistd...
extern "C" void usleep( unsigned long );

enum RedrawState { REDRAW_BANNER, REDRAW_GAME, REDRAW_PAUSED };

static int Banner();
static void DrawBanner();
static void Pause();
void Redraw(); // The redraw callback. Must be visible to the video code.

static int XDim, YDim;
static RedrawState ToDraw;
static int HighScore = 0;

Video CurrVideo;
Worm W;
FieldDesc F;

int main()
{
int Ch, Dir = '6';
   CurrVideo.GetWindowSize( XDim, YDim );
   CurrVideo.InitVideo( XDim, YDim );
   F.SetSize( XDim, YDim );
   W.SetSize( XDim, YDim );
   for( ;; )
   {
      ToDraw = REDRAW_BANNER;
      if( Banner() )
         break;
      ToDraw = REDRAW_GAME;
      CurrVideo.DrawBox( 0, 0, XDim, YDim - 1 );
      CurrVideo.ShowScore( 0 );
      F.GenerFruits();
      F.Redraw();
      W.Reset();
      for( ; W.IsAlive(); )
      {
         Ch = CurrVideo.GetChar();
         switch( Ch )
         {
            case W_KEY_LEFT : Dir = '4'; break;
            case W_KEY_RIGHT : Dir = '6'; break;
            case W_KEY_UP : Dir = '8'; break;
            case W_KEY_DOWN : Dir = '2'; break;
            case W_KEY_QUIT : W.Die(); break;
            case W_KEY_PAUSE : Pause(); break;
         }
         W.Move( Dir );
         if( Dir == '8' || Dir == '2' )
            usleep( VERT_SLEEP );
         else
            usleep( HORIZ_SLEEP );
      }
      if( W.GetScore() > HighScore )
         HighScore = W.GetScore();
   }
return 0;
}

// ********
//  Static
// ********

static char * Msg1 = "X Caterpillar";
static char * Msg2 = "Cherry 3 pts";
static char * Msg3 = "Apple 2 pts, cut by 3 cells";
static char * Msg4 = "Pear 5 pts, cut by 5 cells";
static char * Msg5 = "Nut 3 pts, cut by 20 cells";
static char * Msg6 = "Saku Airila 1996, 1997";
static char * Msg7 = "Hit 'Q' to quit, Space to play...";

int Banner()
{
   DrawBanner();
   for( ;; )
      switch( CurrVideo.GetChar() )
      {
         case W_KEY_QUIT :
            return 1;
         case W_KEY_SPACE :
            CurrVideo.Clear();
            return 0;
         default :
            usleep( 50000 );
            break;
      }
return 0;
}

void Redraw()
{
   if( ToDraw == REDRAW_BANNER )
   {
      DrawBanner();
   }
   else if( ToDraw == REDRAW_GAME )
   {
      CurrVideo.DrawBox( 0, 0, XDim, YDim - 1 );
      F.Redraw();
      W.Redraw();
   }
   else // REDRAW_PAUSED
   {
      ToDraw = REDRAW_GAME;
      Redraw();
      ToDraw = REDRAW_PAUSED;
      CurrVideo.PutTextAt(
         BIG_FONT | ALIGN_CTR,
         XDim /2, YDim / 2,
         "GAME PAUSED ... Space to continue" );
   }
}

void DrawBanner()
{
int i;
char Tmp[ 256 ];
   while( CurrVideo.GetChar() )
      ;
   CurrVideo.Clear();
   CurrVideo.DrawBox( 1, 1, XDim - 2, YDim - 2 );
   CurrVideo.PutTextAt( BIG_FONT | ALIGN_CTR, XDim / 2, 5, Msg1 );
   CurrVideo.PutTextAt( BIG_FONT | ALIGN_CTR, XDim / 2, 8, Msg2 );
   CurrVideo.PutTextAt( BIG_FONT | ALIGN_CTR, XDim / 2, 10, Msg3 );
   CurrVideo.PutTextAt( BIG_FONT | ALIGN_CTR, XDim / 2, 12, Msg4 );
   CurrVideo.PutTextAt( BIG_FONT | ALIGN_CTR, XDim / 2, 14, Msg5 );
   CurrVideo.PutTextAt( SMALL_FONT | ALIGN_CTR, XDim / 2, 19, Msg6 );
   CurrVideo.PutTextAt( SMALL_FONT | ALIGN_CTR, XDim / 2, 16, Msg7 );
   sprintf( Tmp, "Best score for now : %d", HighScore );
   CurrVideo.PutTextAt( SMALL_FONT | ALIGN_CTR, XDim / 2, YDim, Tmp );
   for( i = 3; i < 5; i++ )
   {
      CurrVideo.PutSymAt( i, 8, FRUIT_SYM1 );
      CurrVideo.PutSymAt( XDim - i, 8, FRUIT_SYM1 );
   }
   for( i = 3; i < 5; i++ )
   {
      CurrVideo.PutSymAt( i, 10, FRUIT_SYM2 );
      CurrVideo.PutSymAt( XDim - i, 10, FRUIT_SYM2 );
   }
   for( i = 3; i < 5; i++ )
   {
      CurrVideo.PutSymAt( i, 12, FRUIT_SYM3 );
      CurrVideo.PutSymAt( XDim - i, 12, FRUIT_SYM3 );
   }
   for( i = 3; i < 5; i++ )
   {
      CurrVideo.PutSymAt( i, 14, FRUIT_SYM4 );
      CurrVideo.PutSymAt( XDim - i, 14, FRUIT_SYM4 );
   }
}

void Pause()
{
   ToDraw = REDRAW_PAUSED;
   Redraw();
   while( CurrVideo.GetChar() != W_KEY_SPACE )
      usleep( 50000 );
   CurrVideo.Clear();
   ToDraw = REDRAW_GAME;
   Redraw();
}
