
#ifndef FIELD_H
#  define FIELD_H

#include"Video.H"

#define NUM_FRUITS 12

extern Video CurrVideo;

class Fruit
{
   int Type;
   int ScoreVal, ShrinkVal;
   int x, y;
   int Sym;
   public:
      Fruit( int type, int score, int shrink, int sym )
         {
            Type = type;
            ScoreVal = score;
            ShrinkVal = shrink;
            Sym = sym;
         }
      Fruit()
         {}
      void SetXY( int X, int Y )
         { x = X; y = Y; }
      void Locate( int& X, int& Y ) const
         { X = x; Y = y; }
      int Eat() const
         { return ScoreVal; }
      int GetType() const
         { return Type; }
      int GetScore() const
         { return ScoreVal; }
      int GetShrink() const
         { return ShrinkVal; }
      void operator=( const Fruit& other )
         {
            Type = other.Type;
            ScoreVal = other.ScoreVal;
            ShrinkVal = other.ShrinkVal;
            Sym = other.Sym;
         }
      void Show() const
         { CurrVideo.PutSymAt( x, y, Sym ); }
};

class FieldDesc
{
   int W, H, FruitCnt;
   Fruit Fruits[ NUM_FRUITS ];
   public:
   FieldDesc()
      {
         FruitCnt = 0;
      }
   void SetSize( int w, int h )
      {
         W = w - 2;
         H = h - 2;
      }
   int Width() const
      { return W; }
   int Height() const
      { return H; }
   void GenerFruits();
   int QueryLoc( int x, int y );
   Fruit * GetFruitAt( int x, int y );
   void EatLoc( int x, int y );
   void Redraw() const;
};

#endif

