
#include<stdlib.h>
#include"Field.H"
#include"Video.H"
#include"Worm.H"

#define BONUS1_PROB 10
#define BONUS2_PROB 5
#define BONUS3_PROB 2

#define POS_TRIES 50

const Fruit NormalFruit( 1, 3, 0, FRUIT_SYM1 );
const Fruit BonusFruit1( 2, 2, 3, FRUIT_SYM2 );
const Fruit BonusFruit2( 3, 5, 5, FRUIT_SYM3 );
const Fruit BonusFruit3( 4, 3, 20, FRUIT_SYM4 );

extern Video CurrVideo;
extern Worm W;

void FieldDesc::GenerFruits()
{
int x, y;
   for( int i = 0; i < NUM_FRUITS; i++ )
   {
      Fruits[ i ] = NormalFruit;
      do
      {
         x = ( rand() % W ) + 1;
         y = ( rand() % H ) + 1;
      } while( QueryLoc( x, y ) );
      Fruits[ i ].SetXY( x, y );
      Fruits[ i ].Show();
   }
}

Fruit * FieldDesc::GetFruitAt( int x, int y )
{
int X, Y;
   for( int i = 0; i < NUM_FRUITS; i++ )
   {
      Fruits[ i ].Locate( X, Y );
      if( X == x && Y == y )
         return &Fruits[ i ];
   }
return NULL;
}

int FieldDesc::QueryLoc( int x, int y )
{
Fruit * Fr = GetFruitAt( x, y );
return Fr ? Fr->GetType() : 0;
}

void FieldDesc::EatLoc( int x, int y )
{
int X, Y;
Fruit * Fr;
int Count = 0;
   if( !( Fr = GetFruitAt( x, y ) ) )
      return;
   if( ( rand() % 100 ) < BONUS1_PROB )
      *Fr = BonusFruit1;
   else if( ( rand() % 100 ) < BONUS2_PROB )
      *Fr = BonusFruit2;
   else if( ( rand() % 100 ) < BONUS3_PROB )
      *Fr = BonusFruit3;
   else
      *Fr = NormalFruit;
   do
   {
      X = ( rand() % W ) + 1;
      Y = ( rand() % H ) + 1;
      Count++;
   } while( ( ::W.InMe( X, Y ) || QueryLoc( X, Y ) ) && Count < POS_TRIES );
   Fr->SetXY( X, Y );
   Fr->Show();
}

void FieldDesc::Redraw() const
{
   for( int i = 0; i < NUM_FRUITS; i++ )
      Fruits[ i ].Show();
}

