/*------------------------------------------
  ttime
  by Francesco Munaretto
  Version 1.0 
  (c) March 1996
  Prints some statistics about work-sessions 
------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

int main(int argc, char *argv[])
{
   FILE *min_f;
   FILE *ore_f;
   int ore_i, min_i;
   int tot_ore, tot_min, ore, sessioni;
   double minuti;
   int ore_0=0, ore_1=0, ore_2=0, ore_3=0, ore_4=0, ore_5=0, ore_6=0;
   char ore_s[3];
   char min_s[3];
   char verify;
   char cmd_ore[30];
   char cmd_min[30];
  
   if ((argc != 2) || ((argv[1][0] == '-') 
      && (argv[1][1] != 'v')) || ((argv[1][0] == '-') && (strlen(argv[1]) > 2))) {
      printf("usage: ttime login\n");
      printf("  or:  ttime -v\n");
      printf("Prints some statistics about work-sessions.\n");
      exit(0);
   }
   if ((strcmp(argv[1], "-v") == 0) && (argc == 2)) {
      printf("\nttime v1.0\n");
      printf("by Francesco Munaretto\n");
      printf("(c) March 1996\n\n");
      exit(0);
   }
   strcpy(cmd_ore, "last ");
   strcat(cmd_ore, argv[1]);
   strcat(cmd_ore, " | cut -b 68-69 > ore");
   system(cmd_ore);
   strcpy(cmd_min, "last ");
   strcat(cmd_min, argv[1]);
   strcat(cmd_min, " | cut -b 71-72 > minuti");
   system(cmd_min);
   min_f = fopen("minuti", "r");
   ore_f = fopen("ore", "r");
   verify = fgetc(ore_f);
   if (verify == '\n') {
      printf("user %s does not exist!\n", argv[1]);
      fclose(min_f);
      fclose(ore_f);
      remove("ore");
      remove("minuti");
      exit(0);
   }
   tot_ore = 0;
   tot_min = 0;
   while ((! feof(min_f)) && (! feof(ore_f))) {
      fgets(min_s, 3, min_f);
      fgets(ore_s, 3, ore_f);
      min_i = atoi(min_s);
      ore_i = atoi(ore_s);
      if (ore_i == 0)
         ore_0++;
      if (ore_i == 1)
         ore_1++;
      if (ore_i == 2) 
         ore_2++;
      if (ore_i == 3)
         ore_3++;
      if (ore_i == 4)
         ore_4++;
      if (ore_i == 5)
         ore_5++;
      if (ore_i == 6)
         ore_6++;
      tot_ore = tot_ore + ore_i;
      tot_min = tot_min + min_i;
   }
   fclose(min_f);
   fclose(ore_f);
   sessioni = ore_0 + ore_1 + ore_2 + ore_3 + ore_4 + ore_5 + ore_6;
   ore = tot_ore;
   tot_ore = tot_ore + (int)(tot_min /60);
   minuti = fmod(tot_min, 60);
   printf("Hours     #Sessions     Total\n");
   printf("0|--1        %3d        sessions: %3d\n", ore_0, sessioni);
   printf("1|--2        %3d\n", ore_1);
   printf("2|--3        %3d        hours:   %4d\n", ore_2, ore);
   printf("3|--4        %3d\n", ore_3);
   printf("4|--5        %3d        minuts:  %4d\n", ore_4, tot_min);
   printf("5|--6        %3d\n", ore_5);
   printf("6|--?        %3d        the duration of the whole %s's sessions: %dh:%dm\n", ore_6, argv[1], tot_ore,(int)minuti);
   remove("ore");
   remove("minuti");
   return 0;
}
