/*
 * $Header: /u1/src/rfmail/RCS/zs.c,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: zs.c,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.2  1991/06/05  09:13:58  pgd
 * Various Bugfixes:
 *
 * Patches suggested by Jari Nopanen (jn):
 * Removed the ugly close error
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 */

/* File: zs.c */

/*
 * Zmodem file send code.
 *
 * Version for rfmail made by Per Lindqvist, pgd@compuram.bbt.se
 *
 * This version in based on the program rz.c by Chuck Forsberg,
 * and on the zmodem code from Binkleyterm by Robert C. Hartman
 * and Vincent E. Perillo
 */

#include "fnet.h"

#ifdef FCNTL
#include <fcntl.h>
#endif

#ifndef HAVE_BCOPY
#include <memory.h>
#endif

#include <sys/stat.h>

#include "zmodem.h"
#include "crc.h"
#include "fcall.h"

#ifdef XENIX
DECLARE(int, fstat, (int, struct stat *));
#endif

/*
 * Private data
 */
static FILE *Infile;		/* Handle of file being sent */
static long Strtpos;		/* Starting byte position of */
				/* download */
static long LastZRpos;		/* Last error location */
static long ZRPosCount;		/* ZRPOS repeat count */
static long Txpos;		/* Transmitted file position */
int Txfcs32;			/* True means send binary 32-bit frames */
static int Tframlen;		/* Override for tx frame length */
static int Rxbuflen;		/* Receiver's max buffer */
				/* length */
static int Rxflags;		/* Receiver's flags */
static int blklen, maxblklen;
static int filessent = 0;


extern char Rxhdr[4];		/* Received header */
extern char Txhdr[4];		/* Transmitted header */
extern int Rxtimeout;		/* seconds to wait for something */
extern char filename[];		/* Name of file beeing transferred */
extern int Crc32t;
extern int zsize;
extern int baudrate;
extern int line;
extern char secbuf[];
extern boolean Usevhdrs;
extern int remote_capabilities;

/*
 * Attention string to interrupt sender.
 * We are using the rdchk() call to check for any incoming character
 * but if you need some character to turn around the channel, you
 * should define Myattn to that character.
 */
static char Myattn[] = {0};

#if 0
/*
 * Attention string to be executed by receiver to interrupt streaming data
 *  when an error is detected.  A pause (0336) may be needed before the
 *  ^C (03) or after it.
 */
char Myattn[] = { 03, 0336, 0 };
#endif

static char *crcframes[] =
	{"ZCRCE", "ZCRCG", "ZCRCQ", "ZRCRW"};

/* zs.c */
LDECLARE(int, getzrxinit, ( void ));
LDECLARE(int, zsendfile, ( int , int , int , int  ));
LDECLARE(int, zsendfdata, ( void ));
LDECLARE(int, getinsync, ( int  ));
LDECLARE(void, saybibi, ( void ));
LDECLARE(int, sendzsinit, (void ));
LDECLARE(void, zsdata, (char *, int, int));

/*
 * Send a file with zmodem
 * Return value:
 *	OK - File transferred
 *	FAILED - file cannot be sent
 *	ERROR - Some fatal error communicating with remote
 *	REJECTED - File rejected by host
 */
int
sendzmodem(fname, alias, conv, manag, trans)
	char *fname, *alias;
	int conv, manag, trans;
{
	register char *p;
	struct stat f;
	int i;
	int rc;

	debug(3, "zmodem - sendzmodem file %s", fname ? fname : "NONE");

	zsize = 0;
	Infile = NULL;

	/*
	 * First-time zmodem initialization
	 */
	if (filessent == 0) {
		Rxtimeout = 20;
		if (getzrxinit() == ERROR)
			return ERROR;
	}
	filessent++;

	if (fname == NULL)
		return OK;

	Rxtimeout = (int) (61440L / (long) baudrate);
	if (Rxtimeout < 10)
		Rxtimeout = 10;

	/*
	 * Prepare the file for transmission.  Just ignore file open errors
	 * because there may be other files that can be sent.
	 */
	if (alias == NULL)
		alias = basename(fname);
	else
		log("Remote name for file %s is %s", fname, alias);
	strcpy(filename, fname);
	Infile = fopen(filename, "r");
	if (Infile == NULL) {
		log("$Open error on %s", filename);
		return FAILED;
	}

	/*
	 * Send the file
	 */
	rc = FAILED;

	/*
	 * Display outbound filename, size, and ETA for sysop
	 */
	fstat(fileno(Infile), &f);

	i = (int) (f.st_size * 10 / baudrate + 27) / 54;
	log("Zmodem-Send %s, %ldb, %d min.", filename, f.st_size, i);


	/*
	 * Store filename without path, filesize, time last modified,
	 * and file mode in header packet
	 */
	bzero(secbuf, WAZOOMAX);
	strcat(secbuf, alias);
	p = secbuf + strlen(secbuf) + 1;
	sprintf(p, "%lu %lo %o", f.st_size, f.st_mtime, f.st_mode);

	/* force 256 byte block if name won't fit in 128 byte block */
	if (secbuf[125])
		blklen = 256;

	/*
	 * Transmit the filename block and begin the download
	 */
	throughput(0, 0L);

	/*
	 * Check the results
	 */
	switch (zsendfile(1+strlen(p)+(p-secbuf), conv, manag, trans)) {
	case ERROR:
		/*
		 * Something tragic happened
		 */
		break;

	case OK:
		/*
		 * File was sent
		 */
		if (Infile && fclose(Infile) == -1)
			log("$Close error on %s", filename);
		Infile = NULL;

		log("Sent-Zmodem%s file %s", Crc32t ? "/32" : "", filename);
		rc = OK;
		break;

	case ZSKIP:
		log("zmodem - Remote refused %s", filename);
		rc = REJECTED;
		break;

	default:
		/*
		 * Ignore the problem, get next file, trust other
		 * error handling mechanisms to deal with problems
		 */
		break;
	}                                          

	if (Infile)
		fclose(Infile);
	return rc;
}

void
endzsend()
{
	debug(3, "zmodem send finish (endzsend called), filessent = %d", filessent);
	if (filessent == 0)
		sendzmodem(NULL, NULL, 0, 0, 0);
	saybibi();
	filessent = 0;
}


/*
 * Get the receiver's init parameters
 */
static int 
getzrxinit()
{
	int n;
	long rxpos;

	debug(1, "Get other sides zmodem init parameters (getzrxinit)");
	for (n = 10; --n >= 0;) {
		switch (zgethdr(Rxhdr, &rxpos)) {
		case ZCHALLENGE: 	/* Echo receiver's challange number */
			stohdr(rxpos);
			zshhdr(ZACK, Txhdr);
			continue;

		case ZCOMMAND:		/* They didn't see our ZRQINIT */
			stohdr(0L);
			zshhdr(ZRQINIT, Txhdr);
			continue;

		case ZRINIT:
			Rxflags = 0377 & Rxhdr[ZF0];
			Usevhdrs = (boolean)!!(Rxhdr[ZF1] & CANVHDR);
			Rxbuflen = ((Rxhdr[ZP1] & 0377) << 8)
				  | (Rxhdr[ZP0] & 0377);
			Txfcs32 = Rxflags & CANFC32;
			debug(3, "Rxbuflen=%d Tframlen=%d Rxflags=%x", Rxbuflen, Tframlen, Rxflags);
			return sendzsinit();

		case ZCAN:
		case TIMEOUT:
			return ERROR;

		case ZRQINIT:
			if (Rxhdr[ZF0] == ZCOMMAND)
				continue;

		default:
			zshhdr(ZNAK, Txhdr);
			continue;
		}                                       
	}
	return ERROR;
}

/*
 * Send ZFILE frame and begin sending ZDATA frame
 */
static int 
zsendfile(blen, conv, manag, trans)
	int blen, conv, manag, trans;
{
	register int c;
	long rxpos;

	debug(3, "zmodem zsendfile");
	for (;;) {
		Txhdr[ZF0] = conv;	/* Default file conversion mode */
		Txhdr[ZF1] = manag;	/* Default file management mode */
		Txhdr[ZF2] = trans;	/* Default file transport mode */
		Txhdr[ZF3] = 0;
		zsbhdr(ZFILE, Txhdr);
		zsdata(secbuf, blen, ZCRCW); /* ZACK expected, end of frame */
again:
		switch (c = zgethdr(Rxhdr, &rxpos)) {
		case ZRINIT:
			while ((c = readline(5*1000)) > 0)
				if (c == ZPAD)
					goto again;
			continue;

		default:
			continue;

		case ZCAN:
		case TIMEOUT:
		case ZFIN:
		case ZABORT:
			return ERROR;

		case ZSKIP:
			/*
			 * Other system wants to skip this file
			 */
			return c;

		case ZRPOS:
			/*
			 * Resend from this position...
			 */
			fseek(Infile, rxpos, 0);
			if (rxpos != 0L) {
				log("Resuming from offset %ld", rxpos);
				flushline(); 	/* Get rid of queued data */
				xon_flush();	/* End XON/XOFF restraint */
				sendline(XON);	/* Send XON to remote */
			}
			LastZRpos = Strtpos = Txpos = rxpos;
			ZRPosCount = 10;
			flush();
			return zsendfdata();
		}                                       
	}                                          
}

/*
 * Send the data in the file
 */
static int 
zsendfdata()
{
	register int c, e;
	int newcnt, goodblks, goodneeded = 1;

	debug(3, "zmodem zsendfdata");
	maxblklen = (baudrate < 300) ? 128 : baudrate / 300 * 256;
	if (maxblklen > WAZOOMAX)
		maxblklen = WAZOOMAX;
	if ((remote_capabilities & ZED_ZAPPER) == 0)
		maxblklen = 1024;
	if (Rxbuflen && maxblklen > Rxbuflen)
		maxblklen = Rxbuflen;
	blklen = maxblklen;
	debug(3, "Rxbuflen=%d blklen=%d", Rxbuflen, blklen);
SomeMore:
	if (readcheck()) {
waitack:
		switch (c = getinsync(1)) {
		case ZSKIP:
			/*
			 * Skip this file
			 */
			return c;

		case ZACK:
			break;

		case ZRPOS:
			/*
			 * Resume at this position
			 */
			blklen = (blklen >> 2 > 64) ? blklen >> 2 : 64;
			debug(3, "blklen = %d", blklen);
			goodblks = 0;
			goodneeded = (goodneeded << 1 > 16) ? 16 : goodneeded << 1;
			break;

		case ZRINIT:
			/*
			 * Receive init
			 */
			throughput (1, Txpos - Strtpos);
			return OK;

		case TIMEOUT:
			/*
			 * Timed out on message from other side
			 */
			break;

		default:
			log("zmodem transfer cancelled");
			if (fclose(Infile) == -1)
				log("$Close error on file %s", filename);
			Infile = NULL;
			return ERROR;
		}                                       

		/*
		 * Noise probably got us here. Odds of surviving are not good.
		 * But we have to get unstuck in any event. 
		 */
		uncorktransmitter();		/* Get our side free if need
						 * be */
		sendline(XON);			/* Send an XON to release
						 * other side */

		while (readcheck()) {
			switch (readline(0)) {
			case CAN:
			case ZPAD:
				goto waitack;
			}                                    
		}                                       
	}                                          

	newcnt = Rxbuflen;
	stohdr(Txpos);
	zsbhdr(ZDATA, Txhdr);

	do {
		if ((c = fread(secbuf, 1, blklen, Infile)) != zsize)
			debug(2, "Read %ld bytes from pos %ld",
			      (long)(zsize = c), Txpos);

		if (c < blklen)
			e = ZCRCE;	/* frame ends, hdr pkt follows */
		else if (Rxbuflen && (newcnt -= c) <= 0)
			e = ZCRCW; 	/* ZACK expected, end of frame  */
		else
			e = ZCRCG;	/* frame continues nonstop */

		zsdata(secbuf, c, e);
		Txpos += c;
		if (blklen < maxblklen && ++goodblks > goodneeded) {
			blklen = (blklen << 1 < maxblklen) ? blklen << 1 : maxblklen;
			debug(3, "blklen = %d", blklen);
			goodblks = 0;
		}

		if (e == ZCRCW)
			goto waitack;

		while (readcheck()) {
			switch (readline(0)) {
			case CAN:
			case ZPAD:
				/*
				 * Interruption detected;
				 * stop sending and process complaint
				 */
				debug(1, "zmodem Trouble?");
				flushline();
				zsdata(secbuf, 0, ZCRCE); /* frame end */
						/* hdr pkt follows  */
				goto waitack;
			}                                    
		}                                       

	} while (e == ZCRCG);

	for (;;) {
		stohdr(Txpos);
		zsbhdr(ZEOF, Txhdr);

		switch (getinsync (7)) {
		case ZACK:
			continue;

		case ZRPOS:
			/*
			 * Resume at this position...
			 */
			goto SomeMore;

		case ZRINIT:
			/*
			 * Receive init
			 */
			throughput (1, Txpos - Strtpos);
			return OK;

		case ZSKIP:
			/*
			 * Request to skip the current file
			 */
			log("zmodem SKIP command received");
			if (fclose(Infile) == -1)
				log("$Close error on %s", filename);
			Infile = NULL;
			return c;

		default:
			log("zmodem transfer cancelled");
			if (fclose(Infile) == -1)
				log("$Close error on %s", filename);
			Infile = NULL;
			return ERROR;
		}                                       
	}                                          
}

/*
 * Respond to receiver's complaint, get back in sync with receiver
 */
static int 
getinsync(num_errs)
	int num_errs;
{
	register int c;
	long rxpos;

	debug(3, "zmodem getinsync");
	for (;;) {
		c = zgethdr(Rxhdr, &rxpos);
		flush();
		switch (c) {
		case TIMEOUT:
			log("zmodem timeout");
			if ((num_errs--) >= 0)
				break;

		case ZCAN:
		case ZABORT:
		case ZFIN:
			log("zmodem err");
			return ERROR;

		case ZRPOS:
			if (rxpos == LastZRpos)	{ /* Same as last time? */
				if (!(--ZRPosCount)) /* Yup, 10 times yet? */
					return ERROR; /* Too many, get out */
			} else
				ZRPosCount = 10; /* Reset repeat count */
			LastZRpos = rxpos;	/* Keep track of this */

			rewind(Infile);		/* In case file EOF seen */
			fseek(Infile, rxpos, 0);
			Txpos = rxpos;
			debug(1, "Resending from %ld", (long)Txpos);
			return c;

		case ZSKIP:
			log("zmodem SKIP command received");

		case ZRINIT:
			if (fclose(Infile) == -1)
				log("$Close error on %s", filename);
			Infile = NULL;
			return c;

		case ZACK:
			return c;

		default:
			zsbhdr(ZNAK, Txhdr);
			continue;
		}                                       
	}                                          
}



/*
 * Say "bibi" to the receiver, try to do it cleanly
 */
static void 
saybibi()
{
	debug(3, "zmodem say 'bibi'");
	for (;;) {
		stohdr(0L);
		zsbhdr(ZFIN, Txhdr);
		switch (zgethdr(Rxhdr, NULL)) {
		case ZFIN:
			sendline('O');
			sendline('O');
			drainline(1);
			/* fallthrough... */
		case ZCAN:
		case TIMEOUT:
			return;
		}                                       
	}                                          
}


/* 
 * Send send-init information
 * but only if needed
 */
static int
sendzsinit()
{
        register c;
        register errors;

	if (Myattn[0] == 0)
		return OK;
        errors = 0;
        for (;;) {
                stohdr(0L);
                zsbhdr(ZSINIT, Txhdr);
                zsdata(Myattn, 1+strlen(Myattn), ZCRCW);
                c = zgethdr(Rxhdr, NULL);
                switch (c) {
                case ZCAN:
                        return ERROR;
                case ZACK:
                        return OK;
                default:
                        if (++errors > 9)
                                return ERROR;
                        continue;
                }
        }
}


/*
 * Send binary array buf of length length, with ending ZDLE sequence frameend
 */
static void
zsdata(buf, length, frameend)
	register char *buf;
	int length;
	int frameend;
{
	debug(3, "zsdata: length=%d end=%s", length, crcframes[frameend-ZCRCE]);
	if (Crc32t) {
		Ulong crc = 0xffffffffU;

		for (; --length >= 0; ) {
			register int c = *buf++ & 0377;
			zsendline(c);
			crc = updcrc32(c, crc);
		}
		xsendline(ZDLE);
		xsendline(frameend);
		crc = updcrc32(frameend, crc);
		crc = ~crc;
		for (length = 4; --length >= 0;) {
			zsendline(crc);
			crc >>= 8;
		}
	} else {
		register Ushort crc = 0;
		for (; --length >= 0; ) {
			register int c = *buf++;
			zsendline(c);
			crc = updcrc(c, crc);
		}
		xsendline(ZDLE);
		xsendline(frameend);
		crc = updcrc(frameend, crc);
		zsendline(crc >> 8);
		zsendline(crc);
	}
	if (frameend == ZCRCW) {
		xsendline(XON);
		drainline(1);
	} else
		drainline(0);
}

/* END OF FILE: zs.c */
