/*
 * $Header: /u1/src/rfmail/RCS/zr.c,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: zr.c,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.2  1991/06/05  09:13:58  pgd
 * Various Bugfixes:
 *
 * Fixed problem with receiving 8k blocks
 *
 * Revision 0.4.1.1  1991/05/21  11:13:48  pgd
 * *** empty log message ***
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 */

/* File: zr.c */

/*
 * Zmodem file receiver code.
 *
 * Version for rfmail made by Per Lindqvist, pgd@compuram.bbt.se
 *
 * This version in based on the program sz.c by Chuck Forsberg,
 * and on the zmodem code from Binkleyterm by Robert C. Hartman
 * and Vincent E. Perillo
 */

#include "fnet.h"

#include <sys/stat.h>

#ifdef HAVE_UTIME_H
#include <utime.h>
#else
struct	 utimbuf {
	time_t	actime;		/* access time */
	time_t	modtime;	/* modification	time */
};
#endif

#include "zmodem.h"
#include "nodelist.h"
#include "configs.h"
#include "crc.h"
#include "fcall.h"

#ifdef XENIX
DECLARE(int, stat, (char *, struct stat *));
DECLARE(int, utime, (char *, struct utimbuf *));
#endif

#define UNIXFILE 0x8000 /* happens to the the S_IFREG file mask bit for stat */

/*
 * Private declarations
 */
static long filetime;		/* Unix style mod time for incoming file */
static int filemode;		/* Unix style mode for incoming file */
static char realname[64];

static FILE *outfp;		/* Handle of file being received */
static int Tryzhdrtype;		/* Hdr type to send for Last rx close */
static int thisbinary;		/* Current file is binary mode */
static boolean EOFseen;		/* indicates cpm eof (^Z) was received */
static long Filestart;		/* File offset we started this xfer from */
extern long filelength();	/* returns length of file ref'd in stream */
extern char secbuf[];
static int lzmanag;		/* Local file management request */
static int zconv;		/* ZMODEM file conversion request */
static int zmanag;		/* ZMODEM file managment request */
static int ztrans;		/* ZMODEM file transport request */
extern int zsize;
extern int Rxtimeout;
extern char filename[PATH_LEN];	/* Real file name (path) */
static char tmpname[PATH_LEN];	/* Name/path of temporary file */
extern Node remote_node;	/* Node communicating with */
extern char Rxhdr[4];
extern char Txhdr[4];
extern long Txpos;		/* Transmitted file position */
extern char Attn[ZATTNLEN+1];
extern int Crc32r;
int overwrite = 0;
extern int baudrate;		/* baudrate for line */
static int Rxcount;
static int numNAKs;		/* Number of NAK's sent */
extern int Rxframeind;
extern boolean Usevhdrs;	/* Use variable length headers */

/* zr.c */
LDECLARE(int, tryrz, ( void ));
LDECLARE(int, zreceivebatch, ( void ));
LDECLARE(int, rzfile, ( char * ));
LDECLARE(int, procheader, ( char * ));
LDECLARE(int, putsec, ( char * , int  ));
LDECLARE(void, ackbibi, ( void ));
LDECLARE(char *, sys2, ( char * ));
LDECLARE(void, exec2, ( char * ));
LDECLARE(int, zrdata, (char *, int, int *));
LDECLARE(void, show_loc, (Ulong , Uint));


/*
 * Receive a batch of files.
 * returns TRUE (1) for good xfer, FALSE (0) for bad
 */
int
getzmodem()
{
	int i;

	filetime = 0; filemode = 0;

	debug(3, "zmodem 'getzmodem'");
/*	_BRK_DISABLE(); */

	outfp = NULL;
	zsize = 0;
	Rxtimeout = 10;
	Tryzhdrtype = ZRINIT;
	Attn[0] = 0;		/* Set default attention string */

	if (((i = tryrz()) == ZCOMPL) ||
	    ((i == ZFILE) && ((zreceivebatch()) == OK)))
		return 1;

	flushline();
	xon_flush();			/* Make sure xmitter is unstuck */
	for (i = 0; i < 10; i++) 	/* Send 10 CANs */
		xsendline(CAN);
	drainline(1);
	if (outfp)
		fclose(outfp);
	return 0;
}


/*
 * Initialize for Zmodem receive attempt, try to activate Zmodem sender
 * Handles ZSINIT, ZFREECNT, and ZCOMMAND frames
 *
 * Return codes:
 *    ZFILE .... Zmodem filename received
 *    ZCOMPL ... transaction finished
 *    ERROR .... any other condition
 */
static int 
tryrz()
{
	register int n;
	int errors = 0;
	char *sptr;
	int cmdzack1flg;

	debug(3, "zmodem 'tryrz'");
	for (n = 15; --n >= 0;) {
		/*
		 * Set buffer length (0=unlimited, don't wait).
		 * Also set capability flags
		 */
#ifdef SEGMENTS
		stohdr(SEGMENTS*1024L);
#else
		stohdr(0L);
#endif
		Txhdr[ZF0] = CANFC32 | CANFDX | CANOVIO;
/*		Txhdr[ZF0] |= CANRLE; */
/*		Txhdr[ZF1] = CANVHDR; */
		zshhdr(Tryzhdrtype, Txhdr);
		if (Tryzhdrtype == ZSKIP)
			Tryzhdrtype = ZRINIT;

again:
		switch (zgethdr(Rxhdr, NULL)) {
		case ZRQINIT:
			if (Rxhdr[ZF3] & 0x80)
				Usevhdrs = TRUE;
			continue;
		case ZFILE:
			zconv = Rxhdr[ZF0];
			zmanag = Rxhdr[ZF1];
			ztrans = Rxhdr[ZF2];
			if (Rxhdr[ZF3] & ZCANVHDR)
				Usevhdrs = TRUE;
			Tryzhdrtype = ZRINIT;
			if (zrdata(secbuf, WAZOOMAX, &Rxcount) == GOTCRCW)
				return ZFILE;
			zshhdr(ZNAK, Txhdr);
			if (--n < 0) {
				sptr = "ZFILE";
				goto err;
			}
			goto again;

		case ZSINIT:
			/*
			 * Optional sender init packet, 
			 * set new attention string
			 */
/*			Zctlesc = TESCCTL & Rxhdr[ZF0]; */
			if (zrdata(Attn, ZATTNLEN, &Rxcount) == GOTCRCW) {
				stohdr(1L);
				zshhdr(ZACK, Txhdr);
				Attn[Rxcount] = 0;
			} else {
				zshhdr(ZNAK, Txhdr);
				Attn[0] = 0; /* reset attention string */
			}
			if (--n < 0) {
				sptr = "ZSINIT";
				goto err;
			}
			goto again;

		case ZFREECNT:
			stohdr(0L); 	/* No free count on unix */
			zshhdr(ZACK, Txhdr);
			goto again;

		case ZCOMMAND:			/* Command req from remote */
			cmdzack1flg = Rxhdr[ZF0];
			if (zrdata(secbuf, WAZOOMAX, &Rxcount) == GOTCRCW) {
				log("Remote cmd: %s", secbuf);
				if (cmdzack1flg & ZCACK1)
					stohdr(0L);
				else
					stohdr((long)sys2(secbuf));
				do {
					zshhdr(ZCOMPL, Txhdr);
				} while (++errors < 20 && zgethdr(Rxhdr, NULL) != ZFIN);
				ackbibi();
				if (cmdzack1flg & ZCACK1)
					exec2(secbuf);
				return ZCOMPL;
			}
			zshhdr(ZNAK, Txhdr);
			if (--n < 0) {
				sptr = "CMD";
				goto err;
			}
			goto again;

		case ZCOMPL:
			if (--n < 0) {
				sptr = "COMPL";
				goto err;
			}
			goto again;

		case ZFIN:
			ackbibi();
			return ZCOMPL;

		case ZCAN:
			sptr = "transfer cancelled";
			goto err;
		}                                       
	}

	sptr = "timeout";

err:
	log("Zmodem InitRecv error %s", sptr);
	return ERROR;
}

/*
 * Receive a batch of files using ZMODEM protocol
 */
static int
zreceivebatch()
{
	register int c;
	char namebuf[PATH_LEN];

	debug(3, "zmodem 'zreceivebatch'");
	for (;;) {
		switch (c = rzfile(secbuf)) {
		case ZEOF:
			/*
			 * File successfully finished.
			 * Rename the temporary file
			 * to its real name.
			 */
			strcpy(namebuf, filename);
			if (access(filename, 0) != 0)
				unique_name(namebuf);
			if (myrename(tmpname, namebuf) == -1) {
				log("$Cannot move file %s to %s",
				    tmpname, filename);
				savebad(tmpname);
			}
			/* fallthrough */

		case ZSKIP:
			switch (tryrz()) {
			case ZCOMPL:
				return OK;
			default:
				return ERROR;
			case ZFILE:
				break;
			}                                 
			break;

		default:
			fclose(outfp);
			outfp = NULL;
			return c;
		}                                       
	}                                          
}

/*
 * Receive one file
 */
static int
rzfile(fnbuf)
	char *fnbuf;
{
	register int c;
	int n, bc;
	long rxbytes, rxpos;
	char *sptr;
	struct utimbuf utimes;

	debug(3, "zmodem 'rzfile'");
	EOFseen = FALSE;
	numNAKs = 0;
	c = procheader(fnbuf);
	if (c == ERROR || c == ZSKIP)
		return (Tryzhdrtype = ZSKIP);

	n = 10;
	rxbytes = Filestart;

	for (;;) {
		/*
		 * Send 'position' message
		 */
		stohdr(rxbytes);
		zshhdr(ZRPOS, Txhdr);
nxthdr:
		/*
		 * Get header from transmitter side
		 */
		switch (c = zgethdr(Rxhdr, &rxpos)) {
		case ZDATA:
			/*
			 * Data Packet
			 */
			if (rxpos != rxbytes) {
				if (--n < 0) {
					sptr = "too many errors";
					goto err;
				}
				log("zmodem receive bad pos: %ld/%ld", rxbytes, rxpos);
				zmputs(Attn);
				continue;
			}
MoreData:
			switch (c = zrdata(secbuf, WAZOOMAX, &Rxcount)) {
			case ZCAN:
				sptr = "transfer cancelled";
				goto err;

			case ERROR:
				/*
				 * CRC error
				 */
				if (--n < 0) {
					sptr = "too many errors";
					goto err;
				}
				show_loc(rxbytes, n);
				zmputs(Attn);
				continue;

			case TIMEOUT:
				if (--n < 0) {
					sptr = "timeout";
					goto err;
				}
				show_loc(rxbytes, n);
				continue;

			case GOTCRCW:
				/*
				 * End of frame, ZACK expected
				 */
				n = 10;
				if ((bc = putsec(secbuf, Rxcount)) == ERROR)
					return ERROR;
				stohdr(rxbytes += bc);
				zshhdr(ZACK, Txhdr);
				goto nxthdr;

			case GOTCRCQ:
				/*
				 * frame continues, Zack expected
				 */
				n = 10;
				if ((bc = putsec(secbuf, Rxcount)) == ERROR)
					return ERROR;
				stohdr(rxbytes += bc);
				zshhdr(ZACK, Txhdr);
				goto MoreData;

			case GOTCRCG:
				/*
				 * Frame continues non-stop
				 */
				n = 10;
				if ((bc = putsec(secbuf, Rxcount)) == ERROR)
					return ERROR;
				rxbytes += bc;
				goto MoreData;

			case GOTCRCE:
				/*
				 * frame ends, header to follow
				 */
				n = 10;
				if ((bc = putsec(secbuf, Rxcount)) == ERROR)
					return ERROR;
				rxbytes += bc;
				goto nxthdr;
			}                                 

		case ZNAK:
		case TIMEOUT:
			/*
			 * Packet was probably garbled
			 */
			if (--n < 0) {
				sptr = "Garbled packet";
				goto err;
			}
			show_loc(rxbytes, n);
			continue;

		case ZFILE:
			/*
			 * Sender didn't see our ZRPOS yet
			 */
			zrdata(secbuf, WAZOOMAX, &Rxcount);
			continue;

		case ZEOF:
			/*
			 * End of the file
			 * Ignore EOF if it's at wrong place; force
			 * a timeout because the eof might have
			 * gone out before we sent our ZRPOS
			 */
			if (rxpos != rxbytes)
				goto nxthdr;

			throughput(2, rxbytes - Filestart);

			if (fclose(outfp) == -1)
				log("$close failed on %s", tmpname);
			outfp = NULL;

			log("Received-Zmodem%s file %s", Crc32r ? "/32" : "", realname);

			if (filetime) {
				utimes.actime = filetime;
				utimes.modtime = filetime;
				if (utime(tmpname, &utimes) == -1)
					log("$zmodem cannot change times of file %s", tmpname);
			}
/*
 * We don't set file mode.
 * Maybe we should for files we don't know about?
 *
			if (filemode)
				if (chmod(tmpname, (0777 & filemode)) == -1)
					log("$zmodem: cannot set file mode of %s to %o", tmpname, filemode & 0777);
 */
			outfp = NULL;
			return c;

		case ERROR:
			/*
			 * Too much garbage in header search error
			 */
			if (--n < 0) {
				sptr = "HdrJunk";
				goto err;
			}
			show_loc(rxbytes, n);
			zmputs(Attn);
			continue;

		case ZSKIP:
			return c;

		default:
			sptr = "???";
			flush();
			goto err;
		}                                       
	}                                          

err:
	log("zmodem error (rzfile) - %s", sptr);
	return ERROR;
}

/*
 * Process incoming file information header
 */
static int 
procheader(fname)
	char *fname;
{
	register char *p;
	struct stat f;
	Ulong filesize;
	char *fileinfo;
	char *openmode, *basename();
	int Resume_WaZOO;
	char theirname[32];

	debug(3, "zmodem 'procheader' %s", fname);
	/*
	 * Setup the transfer mode
	 */
	openmode = "w";
	thisbinary = RXBINARY || !RXASCII;
	Resume_WaZOO = 0;
	Filestart = 0L;
	if (lzmanag)
		zmanag = lzmanag;

	/*
	 * Process ZMODEM remote file managment requests
	 */
	if (!RXBINARY && zconv == ZCNL)		/* Remote ASCII override */
		thisbinary = 0;
	if (zconv == ZCBIN)			/* Remote Binary override */
		thisbinary = 1;

	/*
	 * Extract and verify filesize, if given.
	 */
	filesize = 0L;
	filemode = 0;
	filetime = 0L;

	strcpy(theirname, fname);
	fileinfo = fname + 1 + strlen(fname);
	if (*fileinfo) {	/* File coming from unix or DOS system */
		sscanf(fileinfo, "%ld %lo %o", &filesize, &filetime, &filemode);
		if (filemode & UNIXFILE)
			thisbinary++;
		for (p = theirname; *p; ++p)
			if (*p == '\\')
				*p = '/';
	} else {			/* File coming from CP/M system */
		for (p = theirname; *p; ++p)	/* change / to _ */
			if (*p == '/')
				*p = '_';
		if (*--p == '.') 		/* zap trailing period */
			*p = 0;
	}

	/*
	 * Get and/or fix filename and path for uploaded file
	 */
	uploadpath(filename, theirname);

	/*
	 * Check if this is a failed WaZOO transfer which should be resumed
	 * Open either the old or a new file, as appropriate
	 */
	sprintf(tmpname, "%s/%s",
		nodepath(config.tmpdir, remote_node), basename(filename));
	if (stat(tmpname, &f) != -1) {
		Resume_WaZOO = 1;
		openmode = "a";
		Filestart = f.st_size;
	} else {
		/*
		 * If the file already exists:
		 * 1) And the new file has the same time and size, return ZSKIP
		 * 2) And OVERWRITE is turned on, delete the old copy
		 * 3) Else create a unique file name in which to store new data
		 */
		if (stat(filename,&f)!=-1) {	/* If file already exists... */
			/*
			 * Check transfer management options
			 */
			switch (zmanag) {
			case ZMNEW: /* Transfer if source newer or longer */
				if (filetime <= f.st_mtime && filesize <= f.st_size)
					goto skip;
			case ZMAPND: /* Append contents to existing file */
				openmode = "a";
				break;
			case ZMCLOB: /* Replace existing file */
				overwrite = 1;
				break;
			case ZMDIFF: /* Transfer if dates of lenghts different */
				if ((filetime == 0 || filetime == f.st_mtime)
				    && filesize == f.st_size)
					goto skip;
			case ZMPROT: /* Protect destination file */
			skip:
				return ZSKIP;
			}
			if (filesize == f.st_size && filetime == f.st_mtime) {
				log("Already have %s", filename);
				return ZSKIP;
			}
			if (!overwrite || is_arcmail(filename)) {
				unique_name(filename);
			} else
				unlink(filename);
		}
		if (strcmp(basename(filename), fname) != 0)
			log("Dupe renamed: %s", basename(filename));
	}
	outfp = myfopen(tmpname, openmode);
	if (outfp == NULL) {
		log("$Open error on %s", tmpname);
		return ERROR;
	}
	if (Resume_WaZOO)
		log("Resuming zmodem transfer from offset %ld", Filestart);

	if (is_mailpkt(theirname))
		p = "MailPkt ";
	else if (is_arcmail(theirname))
		p = "ARCmail ";
	else
		p = "NetFile ";

	log("zmodem %s %s; %s%ldb, %d min.",
	    p, spoolname(filename),
	    thisbinary ? "" : "ASCII ",
	    filesize,
	    (int) (filesize * 10 / baudrate + 27) / 54);

	throughput(0, 0L);

	return OK;
}

/*
 * Putsec writes the n characters of buf to receive file fout.
 * If not in binary mode, carriage returns, and all characters
 * starting with CPMEOF are discarded.
 */
static int 
putsec(buf, nbytes)
	char *buf;
	int nbytes;
{
	register char *p;
	register int count;

	debug(3, "zmodem 'putsec' %d bytes", nbytes);
	count = nbytes;
	if (count != zsize)
		debug(1, "zmodem new block length: %ld",
		      (long)(zsize = count));
	if (thisbinary) {
		if (fwrite(buf, count, 1, outfp) != 1)
			goto oops;
	} else {
		if (EOFseen)
			return OK;
		for (p = buf; --count >= 0; ++p) {
			if (*p == '\r')
				continue;
			if (*p == CPMEOF) {
				EOFseen = TRUE;
				return OK;
			}
			if (putc(*p, outfp) == EOF)
				goto oops;
		}
	}

	debug(2, "zmodem %ld bytes written", (long)nbytes);
	return nbytes;

oops:
	log("$Write error on %s", tmpname);
	return ERROR;
}

/*
 * Ack a ZFIN packet, let byegones be byegones
 */
static void 
ackbibi()
{
	register int n;

	debug(3, "zmodem 'ackbibi'");
	stohdr(0L);
	for (n = 4; --n;) {
		zshhdr(ZFIN, Txhdr);
		switch (readline(10*1000)) {
		case 'O':
			readline(0); 	/* Discard 2nd 'O' */

		case TIMEOUT:
			debug(3, "zmodem ackbibi complete");
			return;
		}
	}
}

/*
 * Strip leading ! if present, do shell escape
 */
static char *
sys2(s)
	char *s;
{
	if (*s == '!')
		++s;
	/*
	 * Here we should check for a valid command,
	 * and execute it.
	 * But currently we do nothing.
	 */
	log("zmodem cmd request: %s", s);
	/* return system(s) */
	return "";
}

/*
 * Strip leading ! if present, do exec.
 */
static void
exec2(s)
	char *s;
{
        if (*s == '!')
                ++s;
	log("zmodem chain request: %s", s);
	/*
	 *         execl("/bin/sh", "sh", "-c", s);
	 */
}


/*
 * Receive array buf of max length with ending ZDLE sequence
 * and CRC.  Returns the ending character or error code.
 */
static int 
zrdata(buf, length, recount)
	register char *buf;
	register int length;
	int *recount;
{
	register int c;
	register Ushort crc = 0;
	int d;
	int bin32 = Rxframeind == ZBIN32;
	Ulong crc32 = 0xffffffffU;
	int cc = 0;

	debug(3, "zmodem 'zrdata' %d", length);
	buf[0] = buf[1] = 0;
		
	for (;;) {
		if ((c = zdlread()) & ~0377) {
CRCfoo:
			switch (c) {
			case GOTCRCE:
			case GOTCRCG:
			case GOTCRCQ:
			case GOTCRCW:
				/*
				 * C R C s
				 */
				if (bin32) {
					d = c;
					c &= 0377;
					crc32 = updcrc32(c, crc32);
					if ((c = zdlread()) & ~0377)
						goto CRCfoo;
					crc32 = updcrc32(c, crc32);
					if ((c = zdlread()) & ~0377)
						goto CRCfoo;
					crc32 = updcrc32(c, crc32);
					if ((c = zdlread()) & ~0377)
						goto CRCfoo;
					crc32 = updcrc32(c, crc32);
					if ((c = zdlread()) & ~0377)
						goto CRCfoo;
					crc32 = updcrc32(c, crc32);
					if (crc32 != 0xDEBB20E3U) {
						log("zmodem CRC-32 error");
						return ERROR;
					}
				} else {
					d = c;
					crc = updcrc(c, crc);
					if ((c = zdlread()) & ~0377)
						goto CRCfoo;
					crc = updcrc(c, crc);
					if ((c = zdlread()) & ~0377)
						goto CRCfoo;
					crc = updcrc(c, crc);
					if (crc & 0xFFFF) {
						log("zmodem CRC error");
						return ERROR;
					}
				}
				*recount = cc;
				debug(3, "zrdata: cnt=%d ret=%x", cc, d);
				return d;
				
			case GOTCAN:
				/*
				 * Cancel
				 */
				log("zmodem transfer cancelled");
				return ZCAN;
				
			case TIMEOUT:
				/*
				 * Timeout
				 */
				log("zmodem timeout");
				return c;

			default:
				/*
				 * Something bizarre
				 */
				log("zmodem Debris");
				flush();
				return c;
			}                                    
		}
		if (++cc > length)
			break;
		*buf++ = c;
		if (bin32)
			crc32 = updcrc32(c, crc32);
		else
			crc = updcrc(c, crc);
	}
	log("zmodem Long packet");
	return ERROR;
}

static void
show_loc(l, w)
	Ulong l;
	Uint w;
{
	debug(2, "zmodem transfer Ofs=%ld Retries=%d", l, w);
}

/* End of file: zr.c */

