/*
 * $Header: /u1/src/rfmail/RCS/zmodem.h,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: zmodem.h,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.3  1991/06/15  09:33:39  pgd
 * *** empty log message ***
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 */

/* File: zmodem.h */

/*
 *   Z M O D E M . H     Manifest constants for ZMODEM
 *    application to application file transfer protocol
 *    04-17-89  Chuck Forsberg Omen Technology Inc
 *
 * Version for rfmail made by Per Lindqvist pgd@compuram.bbt.se
 */

#define ZPAD	'*'		/* Padding character begins frames */
#define ZDLE	030		/* CTRL-X Zmodem escape - `a la BISYNC DLE */
#define ZDLEE	(ZDLE^0100)	/* Escaped ZDLE as transmitted */
#define ZBIN	'A'		/* Binary frame indicator */
#define ZHEX	'B'		/* Hex frame indicator */
#define ZBIN32	'C'		/* 32-bit crc indicator */
#define	ZBINR32	'D'		/* RLE packed Binary frame with 32 bit FCS */
#define ZVBIN	'a'		/* Binary frame indicator (CRC-16) */
#define ZVHEX	'b'		/* HEX frame indicator */
#define ZVBIN32	'c'		/* Binary frame with 32 bit FCS */
#define ZVBINR32 'd'		/* RLE packed Binary frame with 32 bit FCS */
#define ZRESC	0176		/* RLE flag/escape character */
#define ZMAXHLEN 16	      /* Max header information length  NEVER CHANGE */
#define ZMAXSPLEN 1024		/* Max subpacket length  NEVER CHANGE */


/*
 * Frame types (see array "frametypes" in zm.c)
 */
#define ZRQINIT		0	/* Request receive init */
#define ZRINIT          1	/* Receive init */
#define ZSINIT          2	/* send init sequence (optional) */
#define ZACK            3	/* ACK to above */
#define ZFILE           4	/* File name from sender */
#define ZSKIP           5	/* To sender: skip this file */
#define ZNAK            6	/* Last packet was garbled */
#define ZABORT          7	/* Abort batch transfers */
#define ZFIN            8	/* Finish session */
#define ZRPOS           9	/* Resume data trans at this position */
#define ZDATA           10	/* Data packet(s) follow */
#define ZEOF            11	/* End of file */
#define ZFERR           12	/* Fatal Read or Write error Detected */
#define ZCRC            13	/* Request for file CRC and response */
#define ZCHALLENGE      14	/* Receiver's Challange */
#define ZCOMPL          15	/* Request is complete */
#define ZCAN            16	/* Other end canned session with CAN*5 */
#define ZFREECNT        17	/* Request for free bytes on filesystem */
#define ZCOMMAND        18	/* Command from sending program */
#define ZSTDERR         19	/* Output to standard error, data follows */

/*
 * ZDLE sequences
 */
#define ZCRCE	'h'	/* CRC next, frame ends, header packet follows */
#define ZCRCG	'i'	/* CRC next, frame continues nonstop */
#define ZCRCQ	'j'	/* CRC next, frame continues, ZACK expected */
#define ZCRCW	'k'	/* CRC next, ZACK expected, end of frame */
#define ZRUB0	'l'	/* Translate to rubout 0177 */
#define ZRUB1	'm'	/* Translate to rubout 0377 */

/*
 * zdlread return values (internal)
 * -1 is general error, -2 is timeout
 */
#define GOTOR	0400
#define GOTCRCE	(ZCRCE|GOTOR)	/* ZDLE-ZCRCE received */
#define GOTCRCG	(ZCRCG|GOTOR)	/* ZDLE-ZCRCG received */
#define GOTCRCQ	(ZCRCQ|GOTOR)	/* ZDLE-ZCRCQ received */
#define GOTCRCW	(ZCRCW|GOTOR)	/* ZDLE-ZCRCW received */
#define GOTCAN	(GOTOR|030)	/* CAN*5 seen */

/*
 * Byte positions within header array
 */
#define ZF0	3		/* First flags byte */
#define ZF1	2
#define ZF2	1
#define ZF3	0

#define ZP0	0		/* Low order 8 bits of position */
#define ZP1	1
#define ZP2	2
#define ZP3	3

/*
 * Bit Masks for ZRINIT flags byte ZF0
 */
#define CANFDX		01	/* Rx can send and receive true FDX */
#define CANOVIO         02	/* Rx can receive data during disk I/O */
#define CANBRK          04	/* Rx can send a break signal */
#define CANCRY          010	/* Receiver can decrypt */
#define CANLZW          020	/* Receiver can uncompress */
#define CANFC32         040	/* Receiver can do 32-bit CRC */
#define	ESCCTL		0100	/* Receiver expects ctl chars to be escaped */
#define	ESC8		0200	/* Receiver expects 8th bit to be escaped */

/* Bit Masks for ZRINIT flags byte ZF0 */
#define	CANVHDR		01	/* Variable headers OK */

/*
 * Parameters for ZSINIT frame
 */
#define ZATTNLEN 32	/* Max length of attention string */
#define	ALTCOFF	ZF1	/* Offset to alternate canit string, 0 if not used */

/* Bit Masks for ZSINIT flags byte ZF0 */
#define	TESCCTL	0100	/* Transmitter expects ctl chars to be escaped */
#define	TESC8	0200	/* Transmitter expects 8th bit to be escaped */

/*
 * Parameters for ZFILE frame
 * Conversion options one of these in ZF0
 */
#define ZCBIN	1	/* Binary transfer - inhibit conversion */
#define ZCNL	2	/* Convert NL to local end of line convention */
#define ZCRESUM	3	/* Resume interrupted file transfer */

/*
 * Management options, one of these in ZF1
 */
#define ZMNEWL          1	/* Transfer if source newer or longer */
#define ZMCRC           2	/* Transfer if different file CRC of length */
#define ZMAPND          3	/* Append contents to existing file (if any) */
#define ZMCLOB          4	/* Replace existing file */
#define ZMNEW	        5	/* Transfer if source newer */
#define ZMDIFF          6	/* Transfer if dates of lengths different */
#define ZMPROT          7	/* Protect destination file */
#define	ZMMASK		037 	/* Mask for choices above */
#define	ZMSKNOLOC	0200	/* Skip file if not present at rx */

/*
 * Transport options, one of these in ZF2
 */
#define ZTLZW           1	/* Lempel-Ziv compression */
#define ZTRLE           3	/* Run-Length encoding */
#define	ZXSPARS		64	/* Encoding for sparse file operations */
#define	ZCANVHDR	01	/* Variable headers OK */

/*
 * Parameters for ZCOMMAND frame ZF0 (otherwise 0)
 */
#define ZCACK1          1	/* Acknowledge, then do command */

/*
 * Miscellaneous definitions
 */
#define XON             ('Q'&037)
#define XOFF            ('S'&037)
#define CPMEOF          ('Z'&037)

#define RXBINARY        FALSE
#define RXASCII         FALSE
#define LZCONV          0
#define LZMANAG         0
#define LZTRANS         0
#define KSIZE           1024
#define WAZOOMAX        8192
#define SECSPERDAY      (24L*60L*60L)

/*
 * YOOHOO<tm> CAPABILITY VALUES
 */
#define Y_DIETIFNA 0x0001  /* Can do fast "FTS-0001" */
#define FTB_USER   0x0002  /* Full-Tilt Boogie (Reserved by Opus-CBCS) */
#define ZED_ZIPPER 0x0004  /* Does ZModem, 1K blocks */
#define ZED_ZAPPER 0x0008  /* Can do ZModem variant */
#define DOES_IANUS 0x0010  /* Can do Janus */
#define DO_DOMAIN  0x4000  /* Packet contains domain */
#define WZ_FREQ    0x8000  /* WZ file req. ok */

/* zm.c */
DECLARE(void, zshhdr, ( int  , char * ));
DECLARE(int, zgethdr, ( char *, long * ));
DECLARE(int, zdlread, ( void ));
DECLARE(void, stohdr, ( long  ));
DECLARE(void, zmputs, ( char * ));
DECLARE(void, uncorktransmitter, ( void ));
DECLARE(void, zsendline, (int));
DECLARE(void, throughput, (int, Ulong));
DECLARE(void, zsbhdr, (int, char *));

/* zs.c */
DECLARE(int, sendzmodem, ( char * , char *, int, int, int ));
DECLARE(void, endzsend, (void));

/* zr.c */
DECLARE(int, getzmodem, ());

/* END OF FILE: zmodem.h */
