/*
 * $Header: /u1/src/rfmail/RCS/yoohoo.c,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: yoohoo.c,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.3  1991/06/15  09:33:39  pgd
 * *** empty log message ***
 *
 * Made the routine not assume anything about byte order. (So it will also
 * work with motorola-backwards-byte order)
 *
 * Revision 0.4.1.1  1991/05/21  11:13:48  pgd
 * *** empty log message ***
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 *
 */

/*
 * YooHoo and WaZoo protocols
 *
 * This version made for rfmail, by Per Lindqvist pgd@compuram.bbt.se
 *
 */

#include "fnet.h"

#ifndef HAVE_BCOPY
#include <memory.h>
#endif

#ifdef FCNTL
#include <fcntl.h>
#endif

#include <sys/stat.h>

#include "fcall.h"
#include "nodelist.h"
#include "configs.h"
#include "packet.h"
#include "crc.h"
#include "zmodem.h"

/*
 * Yoohoo definitions
 */
struct   YOOHOO_Hello {
    Ushort	signal;		/* always 'o'     (0x6f)                   */
    Ushort	hello_version;	/* currently 1    (0x01)                   */
    Ushort	product;	/* product code                            */
    Ushort	product_maj;	/* major revision of the product           */
    Ushort	product_min;	/* minor revision of the product           */
    char	my_name[60];	/* Other end's name, will include domain   */
    char	sysop[20];	/* sysop's name                            */
    Ushort	my_zone;	/* 0== not supported                       */
    Ushort	my_net;		/* out primary net number                  */
    Ushort	my_node;	/* our primary node number                 */
    Ushort	my_point;	/* 0== not supported                       */
    char	my_password[8];	/* This is not necessarily null-terminated */
    char	reserved2[8];	/* reserved by Opus                        */
    Ushort	capabilities;	/* capabilities word                       */
    char	reserved3[12];	/* for non-Opus systems with "approval"    */
};				/*          total size 128 bytes           */

extern boolean wazoo;
extern Node remote_node;
extern struct nodelist remote_nodeentry;
int remote_capabilities;
extern Uint event_options;
extern char *outpacket;
extern char packetname[];
int our_capabilities = Y_DIETIFNA | ZED_ZAPPER;
int sentfilerequests;
extern fidonet_options_t fidonet_options;
extern boolean calling;
extern boolean carrier;

LDECLARE(boolean, send_hello_packet, (void));
LDECLARE(boolean, receive_hello_packet, (void));
LDECLARE(void, pack_hello, (struct YOOHOO_Hello *, Uchar *));
LDECLARE(void, unpack_hello, (struct YOOHOO_Hello *, Uchar *));



/*
 * Yoohoo sender code
 *
 * Returns -1 if error.
 *          1 if WaZoo protocol
 *	    0 for not WaZoo, (FTS-0001)
 */
int
yoohoo_sender()
{
	enum {SS0, SS1, SS2, SS3, SS4, YS1, YS2, YS3} state;
	long t, t3, t30, t60, nak_timer;
	int c, nak_count;
	static char *statename[] = {
		"SS0(SyncInit)", "SS1(SendSync)", "SS2(WaitResp)",
		"SS3(NAKTmr)", "SS4(NAKCount)",
		"YS1(SndHello)", "YS2(WaitResp)", "YS3(GetHello)"};

	state = SS0;
	t3 = nak_timer = 0;
		
	for (;;) {
		debug(3, "YOOHOO state %s", statename[(int)state]);
		switch (state) {
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | SS0 | SyncInit |                         | Prepare 3 sec Sync timer|     |
 * |     |          |                         | Prepare .5 sec NAK tmr  |     |
 * |     |          |                         | Init NAK Count          |     |
 * |     |          |                         | Start 60 sec master tmr | SS1 |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case SS0:	/* SyncInit */
			t60 = time(NULL) + 60;
			state = SS1;
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | SS1 | SendSync | 1. Over 60 seconds      |                         |     |
 * |     |          |    or carrier lost      | no response             | exit|
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 2. 3 sec elapsed        | Clear Inbound buffer    |     |
 * |     |          |    or timer not started | Send YOOHOO, then TSYNC |     |
 * |     |          |                         | Start 3 sec Sync timer  | SS2 |
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 3. not elapsed          |                         | SS2 |
 * |-----+----------+-------------------------+-------------------------+-----|
 * | SS2 | WaitResp | 1. Nothing received     | require a response      | SS1 |
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 2. ENQ received         | WaZOO Protocol selected | exit|
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 3. 'C' received         | probable FTS-0001       | SS3 |
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 4. NAK received         | probable FTS-0001       | SS3 |
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 5. Debris (might include| Reset NAK timer         |     |
 * |     |          |    (YOOHOO|TSYNC) & 127)| if started              | SS1 |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case SS1:	/* SendSync */
			while (state == SS1) {
				t = time(NULL);
				if (!carrier || t >= t60)
					return -1;
				else if (t3 == 0 || t >= t3) {
					eatnoice();
					sendline(YOOHOO);
					sendline(TSYNCH);
					t = time(NULL);
					t3 = t + 3;
				}
				/* State SS2 */
/*debug(10, "SendSync: readline(3*1000): "); */
				c = readline(3*1000);
/*debug(10, "==> %d\n", c);*/
				if (c == ENQ)
					state = YS1;
				else if (c == 'C' || c == NAK)
					state = SS3;
				else if (c != TIMEOUT) {
					if (nak_timer)
						nak_timer = 0L;
				}
			}
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | SS3 | NAKTmr   | 1. Timer not expired    | Zero NAK count          |     |
 * |     |          |    or timer not started | Start .5 sec NAK timer  | SS1 |
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 2. Timer expired        | Bump NAK count          | SS4 |
 * |-----+----------+-------------------------+-------------------------+-----|
 * | SS4 | NAKCount | 1. Count >= 2?          | assume FTS-0001         | exit|
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 2. Count < 2            | Keep looking            | SS1 |
 * `-----+----------+-------------------------+-------------------------+-----'
 */
		case SS3:	/* NAKTmr */
			t = time(NULL);
			if (nak_timer == 0 || nak_timer >= t) {
				nak_count = 0;
				nak_timer = t + 1;
				state = SS1;
			} else {
				/* State SS4 */
				if (nak_count++ >= 2)
					return 0;
				else
					state = SS1;
			}
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | YS1 | SndHello | Successful              | Looks like WaZOO        | YS2 |
 * |     | (state   +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |  SH1)    | Not successful          | Repeat whole thing      | exit|
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case YS1:	/* SndHello */
			if (send_hello_packet())
				state = YS2;
			else
				state = SS0;
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | YS2 | WaitResp | 30 sec timer expires    | repeat whole thing      | exit|
 * |     |          | or lost carrier         |                         |     |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | Received YOOHOO         | Another WaZOO, go       | YS3 |
 * |     |          |                         | process receive         |     |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | Received debris         | Repeat whole thing      | YS2 |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case YS2:	/* WaitResp */
			t = time(NULL);
			t30 = t + 30;
			while (state == YS2) {
/*debug(10, "WaitResp: readline(%d) ", (t30-t)*1000);*/
				c = readline((t30 - t)*1000);
/*debug(10, " ==> %d\n", c); */
				if (c == YOOHOO)
					state = YS3;
				else {
					t = time(NULL);
					if (t >= t30 || !carrier) {
						debug(3, "YS2 state timeout");
						return -1;
					}
				}
			}
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | YS3 | GetHello | Information             | Report Success          | exit|
 * |     | (state   | Successfully            |                         |     |
 * |     |  RH1)    | Exchanged               |                         |     |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | Failure                 | Repeat whole thing      | exit|
 * `-----+----------+-------------------------+-------------------------+-----'
 */
		case YS3:	/* GetHello */
			if (receive_hello_packet())
				return 1;
			else
				state = SS0;
			break;
		}
	}
	return -1;
}

/*
 * Returns 1 if ZedZap
 *         0 if FTS-001
 *        -1 if to abort
 */
int
yoohoo_receiver()
{
	long t, t5, t20, t10;
	int c, retry_count;
	enum {RS0, RS1, RS2, RS3, RS4, RS5, RS6, YR1, YR2, YR3, YR4} state;
	static char *statename[] = {
		"RS0(SyncInit)", "RS1(IdleWait)", "RS2(SendBanner)",
		"RS3(RecvInit)", "RS4(SendSync)", "RS5(WaitSync)",
		"RS6(TsyncTmr)",
		"YR1(GetHello)", "YR2(WaitResp)", "YR3(PollPeer)",
		"YR4(SndHello)"};

	state = RS0;
	for (;;) {
		debug(3, "YOOHOO receiver state %s", statename[(int)state]);
		switch (state) {
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RS0 | SyncInit |                         | Start 5 second idle tmr | RS1 |
 * |-----+----------+-------------------------+-------------------------+-----| */
		case RS0:	/* SyncInit */
			t5 = time(NULL) + 5;
			state = RS1;
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RS1 | IdleWait | 1. 5 sec tmr expired    | Take the initiative     | RS2 |
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 2. Carrier lost         | Session aborted         | exit|
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 3. Peek = YOOHOO        | Looks like a live WaZOO | RS3 |
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 4. Peek = TSYNC         | Live FTS-0001, we think | RS3 |
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 5. Peek = CR, LF, space | He looks alive          | RS2 |
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 6. Other character      | Eat it                  | RS1 |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case RS1:
			while (state == RS1) {
				c = readline(5*1000);
				if (c < 0) {
					if (!carrier)
						return -1;
					else
						state = RS2;
				} else if (c == YOOHOO || c == TSYNCH) {
					state = RS3;
					putback(c);
				} else if (c == ' ' || c == LF || c == ' ') {
					state = RS2;
					putback(c);
				}
			}
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RS2 |SendBanner| 1. Error returned       | Session aborted         | exit|
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 2. Banner sent OK       |                         | RS3 |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case RS2:	/* SendBanner */
			/* Send banner */
			state = RS3;
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RS3 |RecvInit  |                         | Start 20 sec timer      | RS4 |
 * |     |          |                         | Init 10 sec timer       |     |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case RS3:	/* RecvInit */
			t = time(NULL);
			t20 = t + 20;
			t10 = 0;
			state = RS4;
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RS4 |SendSync  | 1. Error returned       | Session aborted         | exit|
 * |     |(xmit sync+-------------------------+-------------------------+-----|
 * |     |string)   | 2. String sent OK       | Watch for sender sync   | RS5 |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case RS4:	/* SendSync */
/*			if (!xmit_sync_string())
				return -1;
			else */
				state = RS5;
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RS5 | WaitSync | 1. Carrier lost         | Session aborted         | exit|
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 2. YOOHOO received      | WaZOO session selected  | exit|
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 3. TSYNC received       | probable FTS-0001       | RS6 |
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 4. CR received          | Still sync'ing          | RS4 |
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 5. Other character rcvd | Get next input character| RS5 |
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 6. 10 sec timer elapsed | FTS-0001 selected       | exit|
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 7. 20 sec timer elapsed | Not a mail session      | exit|
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case RS5:	/* WaitSync */
			while (state == RS5) {
				t = time(NULL);
				if (t10 && t >= t10)
					return 0;
				c = readline((int)(t10 - t)*1000);
				if (c == YOOHOO)
					state = YR1;
				else if (c == TSYNCH)
					state = RS6;
				else if (c == CR)
					state = RS4;
				else if (c < 0) {
					if (!carrier)
						return -1;
					else if (t20 && (t = time(NULL)) <= t20)
						return -1;
					else
						return 0;
				}
			}
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RS6 | TsyncTmr | 1. Timer not running    | Start 10 second timer   | RS5 |
 * |     |          |                         | Reset 20 sec timer      |     |
 * |     |          +-------------------------+-------------------------+-----|
 * |     |          | 2. Timer running        | Two TSYNCS = FTS-0001   | exit|
 * `-----+----------+-------------------------+-------------------------+-----'
 */
		case RS6:
			if (t10 == 0) {
				t = time(NULL);
				t10 = t + 10;
				t20 = 0;
				state = RS5;
			} else
				return 0;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | YR1 | GetHello | Information             | Start 20 sec timer      | YR2 |
 * |     | (state   | Successfully            | Initialize retry count  |     |
 * |     |  RH1)    | Exchanged               | Send YooHoo             |     |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | Failure                 | Repeat whole thing      | exit|
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case YR1:	/* GetHello */
			if (receive_hello_packet()) {
				t = time(NULL);
				t20 = t + 20;
				retry_count = 0;
				sendline(YOOHOO);
				state = YR2;
			} else
				state = RS0;
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | YR2 | WaitResp | 20 sec timeout          | try again               | YR3 |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | Lost carrier            | Failure                 | exit|
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | Received ENQ            | Go send hello           | YR4 |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | Received debris         | Keep looking            | YR2 |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case YR2:
			while (state == YR2) {
				t = time(NULL);
				if (t >= t20)
					state = YR3;
				else {
					c = readline((int)(t20 - t)*1000);
					if (c == ENQ)
						state = YR4;
					else if (c < 0) {
						if (!carrier)
							return -1;
					}
				}
			}
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | YR3 | PollPeer | More than 3 retries     | Give it up              | exit|
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | Less than 3 retries     | Bump retry count        | YR2 |
 * |     |          |                         | Clear input buffer      |     |
 * |     |          |                         | Send YOOHOO             |     |
 * |     |          |                         | Restart 20 sec timer    |     |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case YR3:
			if (retry_count > 3)
				return -1;
			else {
				retry_count++;
				eatnoice();
				sendline(YOOHOO);
				t20 = time(NULL) + 20;
				state = YR2;
			}
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | YR4 | SndHello | Successful              | All done, report success| exit|
 * |     | (state   +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |  SH1)    | Not successful          | Repeat whole thing      | exit|
 * `-----+----------+-------------------------+-------------------------+-----'
 */
		case YR4:
			if (send_hello_packet())
				return 1;
			else
				state = RS0;
			
		}
	}
}


static boolean
send_hello_packet()
{
	int	i, c;
	struct YOOHOO_Hello hello;
	long t, t40;
	Ushort crc;
	Uchar buffer[128];
	int retry_count;
	
	debug(2, "send_hello_packet");

	if (fidonet_options.file_requests)
		our_capabilities |= WZ_FREQ;
	/*
	 * Build our hello packet
	 */
	bzero((char *)&hello, sizeof(hello));
	hello.signal = 'o';
	hello.hello_version = 1;
	hello.product = PRODUCTCODE;
	hello.product_maj = version_major;
	hello.product_min = version_minor;
	strncpy(hello.my_name, config.system_name, sizeof(hello.my_name)-1);
	hello.my_name[sizeof(hello.my_name)-1] = 0;
	strncpy(hello.sysop, config.sysop_name, sizeof(hello.sysop));
	hello.sysop[sizeof(hello.sysop)-1] = 0;
	hello.my_zone = config.mynode.zone;
	hello.my_net = config.mynode.net;
	hello.my_node = config.mynode.node;
	hello.my_point = config.mynode.point;
	hello.capabilities = our_capabilities;

	/*
	 * Put packet data into buffer, with the correct byte order.
	 */
	pack_hello(&hello, buffer);

	/*
	 * Calculate crc
	 */
	crc = 0;
	for (i = 0; i < 128; i++)
		crc = updcrc(buffer[i], crc);
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | SH1 | InitSend |                         | Disable XON/XOFF        | SH2 |
 * |     |          |                         | Set retry count to 0    |     |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
	debug(3, "State SH1 (InitSend)");
	xon_disable();
	retry_count = 0;

resend:
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | SH2 | SendHedr |                         | Send Hex 1f, then       | SH3 |
 * |     |          |                         | Send HELLO struct       |     |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
	debug(3, "State SH2 (SendHedr)");
	sendline(0x1f);
	senddata(buffer, 128);

/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | SH3 | SendCRC  |                         | Clear Input Buffer      | SH4 |
 * |     |          |                         | Send two-byte CRC of pkt|     |
 * |     |          |                         | MSB followed by LSB     |     |
 * |     |          |                         | Start 40 second timer   |     |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
	debug(3, "State SH3 (SendCRC)");
	eatnoice();
	sendline(crc >> 8);
	sendline(crc);
	t40 = time(NULL) + 40;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | SH4 | GetResp  | 40 second timer expires | Failed to send packet   | exit|
 * |     |          | or carrier lost         |                         |     |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | ACK received            | Successful transmission | exit|
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | '?' received            | Error, try retransmit   | SH2 |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | ENQ received            | Out of sync?            | SH2 |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | other character recvd   | Debris, keep watching   | SH4 |
 * `-----+----------+-------------------------+-------------------------+-----'
 */

	debug(3, "State SH4 (GetResp)");
	for (;;) {
		t = time(NULL);
		if (t >= t40)
			break;
/* debug(10, "readline(%d) ", (t40 - t) * 1000); */
		c = readline((t40 - t) * 1000);
/* debug(10, " ==> %d\n", c); */
		if (c < 0)
			break;
		else if (c == ACK) {
			debug(3, "Send Hello Packet got ACK");
			return TRUE;
		} else if (c == '?') {
			debug(3, "Resend of Hello Packet requested");
			goto resend;
		} else if (c == ENQ) {
			debug(3, "Out of sync?");
			goto resend;
		}
	}
	debug(3, "Timed out waiting for reply to hello packet");
	return FALSE;
}

/*
 * Return 1 for success, 0 for failure
 */
static boolean
receive_hello_packet()
{
	int c, cnt;
	Ushort crc;
	int retry_counter;
	struct YOOHOO_Hello hello;
	long t, t10, t120, t30;
	Uchar buffer[128 + 2];
	enum {RH1, RH2, RH3, RH4, RH5, RH6, RH7, RH8, RH9, RH10, DONE} state;
	static char *statename[] = {
		"RH1(SendENQ)", "RH2(WaitHedr)", "RH3(TossJunk)",
		"RH4(ReSynch)", "RH5(HdrSetup)", "RH6(GetHChar)",
		"RH7(StoHChar)", "RH8(CheckCRC)", "RH9(CountERR)",
		"RH10(HelloOK)", "DONE"};

	debug(2, "receive_hello_packet");
	bzero((char *)buffer, sizeof(buffer));

	state = RH1;
	t10 = t120 = t30 = 0;
	retry_counter = 0;

	while (state != DONE) {
		debug(3, "Receive Hello Packet %s", statename[(int)state]);
		switch (state) {
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RH1 | SendENQ  |                         | Start 2 minute timer    | RH2 |
 * |     |          |                         | Send an ENQ character   |     |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case RH1:	/* SendENQ */
			t120 = time(NULL) + 120;
			sendline(ENQ);
			state = RH2;
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RH2 | WaitHedr | 2 minute timer expires  | Report failure          | exit|
 * |     |          | or carrier lost         |                         |     |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | Received Hex 1f         | Got header, get packet  | RH5 |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | Received other char     | Debris, throw away      | RH3 |
 * |     |          |                         | Start 10 sec timer      |     |
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RH3 | TossJunk | 10 sec timer expires    | Too much noise          | RH4 |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | Received Hex 1f         | Got header, get packet  | RH5 |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | Input buffer empty      | Try to resynch          | RH4 |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | Carrier lost            | Report failure          | exit|
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case RH2:
			t = time(NULL);
			if (t >= t120)
				return FALSE;
			state = RH3;
			while (state == RH3) {
/* debug(10, "RH2: readline(10*1000) "); */
				c = readline(10*1000);
/*debug(10, " ==> %d\n", c); */
				if (c == 0x1f)
					state = RH5;
				else if (c < 0) {
					if (!carrier)
						return -1;
					else
						state = RH4;
				}
			}
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RH4 | ReSynch  |                         | Clear input buffer      | RH2 |
 * |     |          |                         | Send ENQ                |     |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case RH4:
			eatnoice();
			sendline(ENQ);
			state = RH2;
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RH5 | HdrSetup |                         | Initialize CRC          |     |
 * |     |          |                         | Set 30 second timer     | RH6 |
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RH6 | GetHChar | 30 sec timer expires or |                         |     |
 * |     |          | carrier lost            | Report failure          | exit|
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | Character received      | Process character       | RH7 |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | 10 seconds with no char | Error, try resync       | RH9 |
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RH7 | StoHChar | Buffer and CRC filled   | Compare CRC             | RH8 |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | More characters needed  | Reset 30 sec timer      | RH6 |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case RH5:
			t30 = time(NULL) + 30;
			crc = 0;
			cnt = 0;
			state = RH6;
			while (state == RH6) {
				if ((c = readline(10*1000)) < 0) {
					if (!carrier || t30 <= (t = time(NULL))) {
						debug(1, "Timeout while receiving hello block");
						return FALSE;
					} else {
						state = RH9;
						break;
					}
				} else {
					buffer[cnt++] = c;
					t30 = 0;
					if (cnt <= 128)
						crc = updcrc(c, crc);
					else if (cnt == 128 + 2) {
						state = RH8;
						break;
					}
				}
			}
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RH8 | CheckCRC | CRC matches             | Finish Receive          | RH10|
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | CRC doesn't match       | Handle error            | RH9 |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case RH8:
			if (buffer[128] == (crc >> 8)
			    && buffer[129] == (crc & 0xff))
				state = RH10;
			else
				state = RH9;
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RH9 | CountERR | Less than 10 errors     | Send '?' (0x3f)         | RH2 |
 * |     |          +- - - - - - - - - - - - -+- - - - - - - - - - - - -+- - -|
 * |     |          | 10 errors               | Hang up, report failure | exit|
 * |-----+----------+-------------------------+-------------------------+-----|
 */
		case RH9:
			if (retry_counter++ < 10) {
				debug(1, "Crc error on hello header");
				sendline('?');
				state = RH2;
			} else
				return FALSE;
			break;
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | RH10| HelloOK  |                         | Clear inbound buffer    | exit|
 * |     |          |                         | Send ACK                |     |
 * `-----+----------+-------------------------+-------------------------+-----'
 */
		case RH10:
			debug(2, "Successfully received WaZOO Hello packet, sending ACK");
			sendline(ACK);
			state = DONE;
		}
	}

	/*
	 * Process the hello packet gotten.
	 */
	unpack_hello(&hello, buffer);
	hello.my_name[sizeof(hello.my_name)-1] = '\0';
	hello.sysop[sizeof(hello.sysop)-1] = '\0';
	remote_nodeentry.node.zone = remote_node.zone = hello.my_zone;
	remote_nodeentry.node.net = remote_node.net = hello.my_net;
	remote_nodeentry.node.node = remote_node.node = hello.my_node;
	remote_nodeentry.node.point = remote_node.point = hello.my_point;
	strncpy(remote_nodeentry.name, hello.my_name, sizeof(remote_nodeentry.name));
	strncpy(remote_nodeentry.sysop, hello.sysop, sizeof(remote_nodeentry.sysop));
	remote_capabilities = hello.capabilities | Y_DIETIFNA;
	log("%s system is %s %s",
	    calling ? "Called" : "Calling",
	    remote_nodeentry.name, ascnode(remote_node));
	if (hello.product == 5)
		log("Remote Uses Opus Version %d.%02d",
		    hello.product_maj,
		    (hello.product_min == 48) ? 0 : hello.product_min);
	else
		log("Remote uses %s Version %d.%02d",
		    productname(hello.product),
		    hello.product_maj, hello.product_min);
	log("Remote capabilities = %04x (%s%s%s%s%s%s%s )",
	      remote_capabilities,
	      (remote_capabilities&Y_DIETIFNA)?" DietIFNA":"",
	      (remote_capabilities&FTB_USER)?" FTB":"",
	      (remote_capabilities&ZED_ZIPPER)?" ZedZip":"",
	      (remote_capabilities&ZED_ZAPPER)?" ZedZap":"",
	      (remote_capabilities&DOES_IANUS)?" Ianus":"",
	      (remote_capabilities&DO_DOMAIN)?" Domain":"",
	      (remote_capabilities&WZ_FREQ)?" WzFreq":"");
	remove_reqs();
	
	return TRUE;
}


static boolean
wazoo_sendbundles()
{
	boolean ok;

	ok = TRUE;
	if (outpacket = outgoing_mailpacket(remote_node)) {
		log("Sending mail packet %s with zmodem", outpacket);
		switch (sendzmodem(outpacket, packetname, 0, 0, 0)) {
		case OK:
			savepacket(outpacket);
			break;
		case REJECTED:
			ok = FALSE;
			log("Mail packet rejected by remote");
			savebad(outpacket);
			break;
		case ERROR:
		case FAILED:
			ok = FALSE;
			log("Mail Packet not sent");
			break;
		}
	} else
		log("No outgoing mail packet");
	return ok;
}

/*
 * This is the main code for the YooHoo/ZedZap protocol, 
 * when we are calling another node.
 */
boolean
zzsender()
{
	boolean ok, reqs;

	xon_enable();
	log("ZedZap send bundles");
	if (!(ok = wazoo_sendbundles()))
		goto fin;
	log("ZedZap send files");
	if (!(ok = sendfiles(TRUE)))
		goto fin;
	if (fidonet_options.file_requests)
		reqs = sendreq(TRUE);
	else
		reqs = FALSE;
	endzsend();
	if (reqs)
		log("ZedZap receive bundles, files and file requests");
	else
		log("Zedzap receive bundles and files.");
	if (!(ok = recfiles(TRUE)))
		goto fin;
	if (our_capabilities & WZ_FREQ) {
		log("ZedZap process file requests");
		if (filerequests(TRUE))
			endzsend();
	}
	ok = TRUE;
 fin:
	xon_disable();
	log("End of WaZoo ZedZap session");
	return ok;
}


/*
 * This is the main code for the YooHoo/ZedZap protocol, 
 * when we are called by another node.
 */
boolean
zzreceiver()
{
	boolean ok;

	xon_enable();
	log("ZedZap Receive bundles, files, file requests");
	if (!(ok = recfiles(TRUE)))
		goto fin;
	log("ZedZap Send bundles");
	if (!(ok = wazoo_sendbundles()))
		goto fin;
	log("ZedZap Send files");
	if (!(ok = sendfiles(TRUE)))
		goto fin;
	if (remote_capabilities & WZ_FREQ)
		filerequests(TRUE);
	endzsend();
	if (sentfilerequests > 0 && remote_capabilities & WZ_FREQ) {
		log("ZedZap Receive response to our file requests");
		if (!(ok = recfiles(TRUE)))
			goto fin;
	}
	log("End of WaZoo ZedZap session");
	ok = TRUE;
 fin:
	xon_disable();
	return ok;
}

/*
 * Pack hello packet into buffer, in a transportable way
 */
#define	PUTINT(I)	*cp++ = (I) & 0xff; *cp++ = ((Uint)(I) >> 8)

static void
pack_hello(hello, buffer)
	register struct YOOHOO_Hello *hello;
	Uchar *buffer;
{
	register Uchar *cp = buffer;
	register int i;

	PUTINT(hello->signal);
	PUTINT(hello->hello_version);
	PUTINT(hello->product);
	PUTINT(hello->product_maj);
	PUTINT(hello->product_min);
	for (i = 0; i < sizeof(hello->my_name); i++)
		*cp++ = hello->my_name[i];
	for (i = 0; i < sizeof(hello->sysop); i++)
		*cp++ = hello->sysop[i];
	PUTINT(hello->my_zone);
	PUTINT(hello->my_net);
	PUTINT(hello->my_node);
	PUTINT(hello->my_point);
	for (i = 0; i < sizeof(hello->my_password); i++)
		*cp++ = hello->my_password[i];
	for (i = 0; i < sizeof(hello->reserved2); i++)
		*cp++ = hello->reserved2[i];
	PUTINT(hello->capabilities);
	for (i = 0; i < sizeof(hello->reserved3); i++)
		*cp++ = hello->reserved3[i];
	while (cp < buffer+128)
		*cp++ = 0;
}

#define	GETINT		(cp[0] & 0377) | (cp[1]<<8); cp += 2;

static void
unpack_hello(hello, buffer)
	register struct YOOHOO_Hello *hello;
	Uchar *buffer;
{
	register Uchar *cp = buffer;
	register int i;

	hello->signal = GETINT;
	hello->hello_version = GETINT;
	hello->product = GETINT;
	hello->product_maj = GETINT;
	hello->product_min = GETINT;
	for (i = 0; i < sizeof(hello->my_name); i++)
		hello->my_name[i] = *cp++;
	for (i = 0; i < sizeof(hello->sysop); i++)
		hello->sysop[i] = *cp++;
	hello->my_zone = GETINT;
	hello->my_net = GETINT;
	hello->my_node = GETINT;
	hello->my_point = GETINT;
	for (i = 0; i < sizeof(hello->my_password); i++)
		hello->my_password[i] = *cp++;
	for (i = 0; i < sizeof(hello->reserved2); i++)
		hello->reserved2[i] = *cp++;
	hello->capabilities = GETINT;
	for (i = 0; i < sizeof(hello->reserved3); i++)
		hello->reserved3[i] = *cp++;
}

