/*
 * $Header: /u1/src/rfmail/RCS/xtsend.c,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: xtsend.c,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.3  1991/06/15  09:33:39  pgd
 * *** empty log message ***
 *
 * Revision 0.4.1.2  1991/06/05  09:13:58  pgd
 * Various Bugfixes:
 *
 * Patches suggested by Jari Nopanen:
 *
 * Revision 0.4.1.1  1991/05/21  11:13:48  pgd
 * *** empty log message ***
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 */


/* Send file(s) unsing Xmodem/TeLink/MODEM7 Batch protocols.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

/* LINTLIBRARY */

#include "fnet.h"

#ifdef FCNTL
#include <fcntl.h>
#endif

#include <sys/stat.h>

#include "fcall.h"
#include "crc.h"
#include "xmodem.h"
     
#ifdef XENIX
DECLARE(int, stat, (char *, struct stat *));
#endif

extern char binaryfirstblock[128]; /* Note slightly different use here! */
extern char binarytelinkblock[128];
extern char packetname[];

#define BytesSend       (block * BlockSize)

/* General states for finite state machines. These are used to break
   loops mostly. */

#define Error           (-1)    /* error state */
#define Done            (-2)    /* state to break loops */

/* XMODEM/TeLink send states. */

#define WaitTeLnk       (0)
#define WaitStart       (1)
#define SendBlock       (2)
#define WaitACK         (3)
#define WaitEnd         (4)

/* Debugging */
static char *xtsendstates[] = {
	"WaitTeLnk", "WaitStart", "SendBlock", "WaitACK", "WaitEnd"};

/* BATCH File sender states. */

#define MoreFiles       (0)
#define CheckFNm        (1)
#define CheckFile       (2)
#define EndSend         (3)

/* States for MODEM7 filename sender. */

#define WaitNak         (0)
#define WaitChAck       (1)
#define WaitCksm        (2)

static boolean send_sealink = TRUE;

/* Return filename for MS-DOS. Because MS-DOS has many restrictions in
   filenames (that silly dot in between), we must use something equivalent
   while sending TeLink. This is currently not used? */

char *
conver_to_msdos_name(filename)
     char *filename;
{
  static char msdos_name[16];
  register int pos;
  register char *cp;
  
  /* strip off pathname */
  cp = basename(filename);
  
  /* ignore leading dot */
  if (*cp == '.')
    cp++;
  
  /* create first 8 characters of ms-dos name */
  for (pos = 0; *cp && *cp != '.' && pos < 8; pos++, cp++)
    msdos_name[pos] = *cp;
  
  /* add dot for ms-dos */
  msdos_name[pos] = '.';
  if (*cp == '.')
	  cp++;
  
  /* add 3 character type */
  for (pos++; *cp && *cp != '.' && pos < 12; pos++, cp++)
    msdos_name[pos] = *cp;
  
  /* null terminate ms-dos name */
  msdos_name[pos] = 0;
  
  /* JN: convert to uppercase */
  for (cp = msdos_name; *cp; cp++)
	  *cp = toupper(*cp);

  debug(2, "File %s changed to %s in MS-DOS", filename, msdos_name);
  return msdos_name;
}

/* Create special TeLink block. This block will be send as block 0 before
   all other data will be sent. Return false if it couldn't be created,
   otherwise true. */

static boolean
make_first_block(filename, aliasname, buffer, sealinkblock, length)
     char *filename, *aliasname, *buffer;
     int sealinkblock; /* True, make sealink block, not telink block. */
	off_t length;		/* JN */
{
  static struct stat stbuf;
  register int cnt;
  register char *cp;

/*  JN ??? if (!sealinkblock) /* Need to stat. Be sloppy, fix it later. */
    {
      /* get status of file */
      if (filename == NULL || stat(filename, &stbuf) == -1)
	{
	  if (filename)
		  log("$Cannot stat %s", filename);
	  stbuf.st_size = length; 	/* JN, originally 0 */
	  stbuf.st_ctime = time(NULL);
	}
    }
  
  /* save file length */
  for (cnt = 0; cnt < 4; cnt++)
    buffer[cnt] = (stbuf.st_size >> (cnt * 8)) & 0377;
  
  /* creation time and date will be all zeroes */
  if (sealinkblock)
    {
      buffer[cnt++] = stbuf.st_ctime & 0377;
      buffer[cnt++] = (stbuf.st_ctime >> 8) & 0377;
      buffer[cnt++] = (stbuf.st_ctime >> 16) & 0377;
      buffer[cnt++] = (stbuf.st_ctime >> 24) & 0377;
    }
  else
    {
      for (cnt = 4; cnt < 8; cnt++)
	buffer[cnt] = 0;
    }
  

  /* save the file name */
  if (filename == NULL)
	  aliasname = packetname;
/*
  else {
  filename = basename(filename);
  if (strlen(filename) >= 16)
    filename[15] = '\0';
  }			Is this really necessary? */
  
  for (cnt = 8, cp = aliasname; *cp; cp++, cnt++)
    buffer[cnt] = *cp;
  
  /* if name was shorter than 16 chars, fill rest of it with blanks */
  if (sealinkblock)
    {
      while (cnt < 25)
	buffer[cnt++] = '\0';
    }
  else
    {
      while (cnt < 24)
	buffer[cnt++] = ' ';
      
      /* Sealink last byte of filename, telink header_version */
      buffer[cnt] = '\0';
    }
  
  /* name of sending program...  */
  for (cnt = 25; cnt < 41; cnt++)
    buffer[cnt] = 0;
  
  sprintf(&buffer[25], "rfmail %s", version); /* Max 15 characters */

  if (sealinkblock)
    buffer[39] = '\0';

  if (sealinkblock)
    {
      cnt = 40;
      /* SLO, SEAlink overdrive */
      buffer[cnt++] = 0; /* 1 yes, 0 no */
      /* RESYNC */
      buffer[cnt++] = 0;
      /* MACFLOW */
      buffer[cnt++] = 0;
    }
  else
    {
      cnt = 41;
      
      /* crc mode */
      buffer[41] = 0;
    }
  /* rest of buffer will be full of zeroes */
  for (cnt = 42; cnt < 128; cnt++)
    buffer[cnt] = 0;
  return True;
}

/* Send block to line. Note that intial SOH or SYN is not sent by
   this routine. */

static void
xtsendblk(sxbuf, blocknum, crcmode)
     char *sxbuf;
     int blocknum;
     boolean crcmode;
{
  register Ushort crc;
  register int checksum, cnt;
  
  debug(1, "Send block %d", blocknum);
  
  /* send block number */
  sendline(blocknum & 0377);
  sendline(~(blocknum & 0377));
  
  /* send the block itself */
  debug(1, "Send %d bytes", BlockSize);
  senddata(sxbuf, BlockSize);
  
  /* count crc and checksum */
  for (crc = 0, checksum = 0, cnt = 0; cnt < BlockSize; cnt++) {
      crc = updcrc(sxbuf[cnt], crc);
      checksum += sxbuf[cnt];
    }
  
  if (crcmode)
    {
      /* send crc */
      /* crc = updcrc(0, updcrc(0, crc)); /* What is this for? */
      debug(1, "Send crc %d", crc);
      sendline((int) (crc >> 8));
      sendline((int) crc);
    }
  else
    {
      /* send checksum */
      debug(1, "send checksum %d", checksum & 0377);
      sendline(checksum & 0377);
    }
}

/* Check out if we can see sealink block numbers there? */

typedef enum
{ EXPECT_BLOCK_OK, EXPECT_BLOCK_FAIL, EXPECT_BLOCK_NO_NUMBERS }
expect_block_t;

static expect_block_t
expect_block(block)
     int block;
{
  int c;
  static int timedout_count = 0;
  static int okcount = 0;

  /* See if there is a block number and its complement in input. If not seen
     for two consecutive blocks, turn send_sealink off. */

  if ((c = readline(1*1000)) < 0)
    goto timeout;

  if (c == (block & 0377) || (block == -1 && (c == 0 || c == 1)))
    {
      if ((c = readline(1*1000)) != TIMEOUT)
	{
	  if (c == (~block & 0377) || (block == -1 && (c == 255 || c == 254)))
	    {
	      timedout_count = 0;
	      okcount++;
	      return EXPECT_BLOCK_OK;
	    }
	  else
	    goto trash;
	}
      else
	goto timeout;
    }
  /* else goto trash; */
  
 trash:
  return EXPECT_BLOCK_FAIL; /* Fail, block number received but incorrect. */
  
 timeout:
  if (timedout_count++ > 2)
    {
      log("No block numbers, no sealink");
      return EXPECT_BLOCK_NO_NUMBERS;
    }
  else
    {
      debug(10, "Timeout in expect block number");
      return EXPECT_BLOCK_OK; /* Assume it is ok. */
    }
}

#define BLOCK_0_OR_1 -1

static int
expectnack(timeout, block, crcmode)
	int timeout, block;
	boolean crcmode;
{
  register int c;

  if ((c = readline(timeout*1000)) == NAK || c == 'C' || c == ACK)
    {
      if (send_sealink)
	{
	  switch (expect_block(block))
	    {
	     case EXPECT_BLOCK_NO_NUMBERS:
	      send_sealink = FALSE;
	      return c;
	      
	     case EXPECT_BLOCK_FAIL:
	      /* If an ACK comes with an invalid block number, make it a nak
		 instead. */ 
	      if (c == ACK)
		{
		  c = (crcmode ? 'C' : NAK);
		  debug(1, "Incorrect block number, turning ACK to %s.",
			(c == 'C') ? "'C'" : "NAK");
		}
	      return c;
	      
	     case EXPECT_BLOCK_OK:
	      return c;
	    }
	}
    }
    return c;
}

/* Read file block into sxbuf ready to send. */

static char sxbuf[BlockSize];
static int last_block_read = -1; /* Last block read; avoid rereading it */

static boolean
read_block(buffer, block, size, fp)
     char *buffer;
     int block;	/* Block number to send, seek if necessary. */
     int size;	/* Block size, normally BlockSize. */
     FILE *fp;	/* File to read from. */
{
  static boolean returnvalue = FALSE;
  register int cnt, c;

  /* If trying to reread the same block for some reason, don't bother
     to seek & read it again. */
  if (last_block_read != -1)
    {
      if (last_block_read == block)
	return returnvalue;
    }

  if (block < 1)
    {
      log("Block (%d) should not be less than 1 !");
      block = 1;
      /* Continue, even though this is dangerous. */
    }
  
  if (ftell(fp) != (block - 1) * (long) size) /* block starts at 1 ! */
    {
      if (fseek(fp, (block - 1) * (long) size, SEEK_SET) == -1)
	{
	  log("$Seek fp to (block %d - 1) * size %d = %ld failed",
	      block, size, (block - 1) * (long) size);
	  /* Continue, even though this is dangerous. */
	}
    }

  last_block_read = block;
  
  for (cnt = 0; cnt < size; cnt++)
    {
      if ((c = getc(fp)) == EOF)
	{
	  for (cnt++; cnt < BlockSize; cnt++)
	    buffer[cnt] = CTRLZ; /* Fill up rest of the block. */

	  /* Tell we have the last block */
	  return returnvalue = TRUE;
	}
      else
	buffer[cnt] = c;
    } /* For */
  
  return returnvalue = FALSE; /* Not last block */
}

/* Send file using XMODEM/TeLink protocol. Return True if everything went
   fine, otherwise false. */

boolean
xtsend(filename, aliasname, transfermode)
	char *filename, *aliasname;
	transfermode_t transfermode;
{
  int state = WaitTeLnk;
  struct stat st;
  time_t s_time, starttime, transfertime;
  int tries, c, garpagecount, blocktype = -1;
  FILE *fp;
  boolean lastblock = False;
  int block = 1, ackblock = 1;
  boolean crcmode = True;
  Uint windowblocks = 0;

  send_sealink = TRUE;
  last_block_read = -1; /* Must reset this for every file! */
			  
  if (aliasname == NULL)
	  aliasname = basename(filename);
  if (filename == NULL || (fp = fopen(filename, "r")) == NULL) {
    if (filename == NULL || errno == ENOENT)
      log("No packet to send, Sending empty packet");
    else
      log("$Can not open %s, sending empty file",
	  filename ? filename : "???");
    bzero(sxbuf, sizeof sxbuf);
    st.st_size = build_header(sxbuf);
/*  *filename = 0;  JN ??? */
    filename = aliasname = NULL;
  } else {
	  if (aliasname)
		  log("Sending %s as %s", filename, aliasname);
	  else
		  log("Sending %s", filename);
    (void) stat(filename, &st);
  }
  
  starttime = time(NULL);

  if (send_sealink)
    {
      windowblocks = (long) xmodem_options.windows_at_2400 * xmodem_options.speed / 2400;
      
      if (windowblocks * BlockSize > xmodem_options.max_send_ahead)
	windowblocks = xmodem_options.max_send_ahead / BlockSize;
    }
  else
    windowblocks = 0;

  while (state >= WaitTeLnk && state <= WaitEnd) {
    debug(3, "xtsend state: %s", xtsendstates[state]);
    switch (state)
      {
      case WaitTeLnk: /* Really WaitTeLnk_or_SEAlink_or_failure, sigh. */

	/* First make all special blocks we need. */
	
        if (!make_first_block(filename, aliasname, binarytelinkblock, FALSE) ||
	    !make_first_block(filename, aliasname, binaryfirstblock, TRUE))
          {
            log("Unable to send file %s", filename);
            state = Error;
	    break;
          }

	block = 1;
	ackblock = 1;
	if (fp != NULL)
		lastblock = read_block(sxbuf, block, BlockSize, fp);
	else
		lastblock = TRUE;
	
	SetStart();
	blocktype = -1; /* Block type counter. SEAlink, Telink, Xmodem ... */
	
	for (tries = 0; state == WaitTeLnk;)
	  {
	    if ((c = expectnack(40, BLOCK_0_OR_1, crcmode)) == NAK || c == 'C')
	      {
		/* FTS-0001, SEAlink and all the other protocols
		   make things difficult; SEAlink first block is different
		   from Telink-based FTS-0001, and many systems don't
		   tolerate neither blocks, some will even panic. */
		
		/* Solution; we try three kind of startup blocks, in
		   the following order
		   
		   SEAlink
		   Telink 
		   Xmodem
		   
		   until one of these catches up.

		   If no sealink is specified, do not do SEAlink phase at all.
		   If no telink is specified, do not do telink phase either.
		   */
		
		if (tries++ > 12)
		  {
		    log("Too many tries on first block");
		    /* First block not accepted, try go xmodem */
		    block = 1;
		    ackblock = 1; /* 1 not acked yet. */
		    state = WaitStart;
		    break;
		  }
		
		/* If other stuff, not ack/nak received, just ignore */
		if (xmodem_options.forcecrc)
		  crcmode = True; /* Standard: c == 'C'; */
		else
		  crcmode = (boolean)(c == 'C');
		
		debug(1, "Got %s", (c == 'C') ? "C" : "NAK");
		blocktype++;

		/* If sealink mode or telink block has been disabled, skip
		   those states. If both are disabled, we are simply sending
		   first block only. */
		if (!xmodem_options.sealink && blocktype % 3 == 0) blocktype++;
		if (!xmodem_options.dotelink && blocktype % 3 == 1) blocktype++;
		
		switch (blocktype % 3)
		  {
		   case 0: /* SEAlink first block. CRC & all. */
		    debug(1, "Sending SEAlink block");
		    sendline(SOH);
		    xtsendblk(binaryfirstblock, 0, True);
		    break;
		    
		   case 1: /* Telink first block. */
		    debug(1, "Sending Telink block");
		    sendline(SYN);
		    /* telink block always has checksum and 0 block
		       number */
		    xtsendblk(binarytelinkblock, 0, False);
		    break;
		    
		   case 2: /* File first block. */
		    debug(1, "Sending first data block");
		    sendline(SOH);
		    xtsendblk(sxbuf, block, crcmode);
		    break;
		  }
	      }
	    else if (c == ACK)
	      {
		block = 1;
		ackblock = 1;
		switch (blocktype % 3)
		  {
		   case 0:
		    debug(1, "Got ACK, SEAlink block sent ok");
		    break;

		   case 1:
		    debug(1, "Got ACK, Telink block sent ok");
		    break;

		   case 2:
		    debug(1, "Got ACK, first data block sent ok");
		    block = 2; /* Sent first one already */
		    ackblock = 2;
		    break;
		  }
		state = SendBlock /* Was WaitStart? */;
	      }
	    else if (Timeout(40))
	      {
		log("Timeout on protocol startup");
		block = 1; /* First block not accepted, go try xmodem */
		ackblock = 1;
		state = WaitStart; /* Exit according to standard? */
		tries++;
	      }
	    else
	      {
		/* We wanted either ack or nak. If we are doing fidonet
		   mail, try to send another TSYNCH just in case other end
		   didn't get the first one. */
		if (transfermode == MAILTRANSFER)
		  sendline(TSYNCH);
	      }
	  } 
        break;
	
      case WaitStart:
        SetStart();
        for (tries = 0; state == WaitStart;)
	  {
	    if (Timeout(60))
	      {
		log("Timeout on xmodem start");
		state = Error;
	      }
	    else if (tries > 20)
	      {
		log("Too many retries in xmodem startup");
		state = Error;
	      }
	    else if ((c = expectnack(10, BLOCK_0_OR_1, crcmode)) == NAK
		     || c == 'C')
	      {
		debug(1, "Got %s, sendblock start", (c == 'C') ? "C" : "NAK");
		if (xmodem_options.forcecrc)
		  crcmode = True; /* Standard: c == 'C'; */
		else
		  crcmode = (boolean)(c == 'C');
		
		state = SendBlock;
	      }
	    else if (c < 0)
	      tries++;
	    /* Else Nonstandard: Expect some weird protocol handshake */
	  }
        break;
      case SendBlock:
	while (state == SendBlock) {
		if (lastblock || fp == NULL) {
			if (block == 1) {
				sendline(SOH);
				xtsendblk(sxbuf, block, crcmode);
				state = WaitACK;
			} else {
				sendline(EOT);
				state = WaitEnd;
			}
		} else {
			lastblock = read_block(sxbuf, block, BlockSize, fp);
			sendline(SOH);
			xtsendblk(sxbuf, block, crcmode);
/*			block++;		JN: Not a very good idea */
			state = WaitACK;
		}
	  }
        break;
      case WaitACK:
        SetStart();
	garpagecount = 0;
        for (tries = 0; state == WaitACK; )
	  {
	    if (tries >= 10)
	      {
		log("Too many tries on xmodem send");
		state = Error;
	      }
	    else if (Timeout(60))
	      {
		log("Xmodem send timeout");
		state = Error;
	      }
	    else
	      {
		c = expectnack(send_sealink ? 0 : 10, block, crcmode);
		if (c == NAK || c == 'C')
		  {
		    /* Could try to send only those which failed. Now this is
		       completely sender-driven, thus transmission error will
		       cause resending from the failed point. */
		    block = ackblock;
		    
		    /* This may not actually be true, but it will be reset in
		       SendBlock. */ 
		    lastblock = FALSE;
		    
		    state = SendBlock;
		    debug(1, "Got %s, resend block %d",
			  (c == 'C') ? "'C'" : "NAK", block);
		    if (c == 'C' && block > 1)
		      {
			debug(1,
			      "Other end sends as 'C' instead of NAK? -> %s",
			      "crcmode");
			crcmode = TRUE; /* Try going into crc mode? */
		      }
		    
		    tries++;
		  }
		else if (c == ACK)
		  {
		    debug(1, "Got ACK for %d, send next block", ackblock);
		    ackblock++;
		    block++;	/* JN: I hope this is the right place to
				   increase block count */
		    
		    debug(2, "%ld bytes sent (%d %%)", BytesSend,
			  BytesSend * 100L / st.st_size);
		    state = SendBlock;
		    if ( (lastblock && ackblock == block) || !fp)
		      {
			sendline(EOT);
			state = WaitEnd;
		      }
		  }
		else if (c != TIMEOUT)
		  {
		    if (garpagecount++ > 1024) /* Shouldn't be more than 1K? */
		      {
			log("Too much trash on line");
			state = Error;
		      }
		    /* Loop again without increasing tries. */
		  }
		else
		  {
		    /* Timed out, no ack is waiting for us. If we have run too
		       far, sleep and keep waiting for acks, otherwise go back
		       to sendblock. */
		    if (ackblock < block - windowblocks || lastblock)
			    mssleep(100); /* 1/10th of a second. */
		    else
		      state = SendBlock;
	          }
	      }
	  }
	break;
	
      case WaitEnd:
        for (tries = 0; state == WaitEnd; tries++)
	  {
	    if (tries > 10)
	      {
		log("Too many retries on xmodem end");
		state = Error;
	      }
	    else if (Timeout(60))
	      {
		log("Timeout on xmodem/telink end");
		state = Error;
		break;
	      }
	    else if ((c = readline(60*1000)) == NAK)
	      {
		sendline(EOT);
		debug(2, "Send EOT");
	      }
	    else if (c == ACK)
	      {
		transfertime = time(NULL) - starttime;
		log("Send %ld bytes, %ld seconds, %ld characters per second",
		    st.st_size,
		    transfertime,
		    transfertime ? st.st_size / transfertime : 0L);
		
		total_bytes += st.st_size;
	      
		log("Xmodem/TeLink send successful");
		state = Done;
	      }
	    /* Else line noise or sealink trash? Ten tries should be ok */
	  }
        break;
      }
  }
  
  return state == Error ? False : True;
}

/* Send MODEM7 filename. */

static boolean
sendmdmfn(filename)
     char *filename;
{
  int state = WaitNak;
  time_t s_time;
  int tries = 0;
  int c, checksum, cnt;
  

  char fname[12];

  memset(fname, ' ', sizeof fname);
  for (c=0; c < 8 && *filename != '.' && *filename ; c++, filename++)
    fname[c] = *filename; 

  if (*filename == '.')
    filename++;

  for (c=8; c < 11 && *filename != '.' && *filename; c++, filename++)
    fname[c] = *filename;

  fname[11] = '\0';
  filename = fname;

  SetStart();
  while (state >= WaitNak && state <= WaitCksm)
    switch (state)
      {
      case WaitNak:
        while (state == WaitNak)
          if ((c = readline(60*1000)) == NAK)
            {
              debug(2, "Got NAK for filename %s", filename);
              sendline(ACK);
              sendline(*filename);
              cnt = 1;
              state = WaitChAck;
            }
          else if (Timeout(60))
            {
              debug(1, "Timeout on filename");
              state = Error;
            }
          else if (tries >= 20)
            {
              debug(1, "Too many retries on filename");
              state = Error;
            }
        break;
      case WaitChAck:
        if (readline(2*1000) == ACK)
          {
            if (filename[cnt])
              sendline(filename[cnt++]);
            else
              {
                sendline(SUB);
                state = WaitCksm;
              }
          }
        else
          {
            sendline('u');
            tries++;
            state = WaitNak;
          }
        break;
      case WaitCksm:
        if ((c = readline(2*1000)) < 0) /* Standard says 1 second */
          {
            sendline('u');
            tries++;
            state = WaitNak;
          }
        else
          {
            for (cnt = 0, checksum = SUB; filename[cnt]; cnt++)
              checksum += filename[cnt];
            if (c != (checksum & 0377))
              {
                debug(1, "Checksum error in filename");
                sendline('u');
                state = WaitNak;
                tries++;
              }
            else
              {
                sendline(ACK);
                debug(2, "Filename sent ok");
                state = Done;
              }
          }
        break;
      }
  
  return (boolean)(state != Error);
}

/*
 * Batch file sender. If filename is NULL, no more files to send.
 * Returns:
 *	OK - File transferred
 *	ERROR - Something went wrong
 */

int
batchsend(filename, alias)
     char *filename, *alias;
{
  int state = MoreFiles;
  int c;
  time_t s_time;
  boolean ok;
  
  if (alias == NULL && filename)
	  alias = basename(filename);
  while (state >= MoreFiles && state <= EndSend)
    switch (state)
      {
      case MoreFiles:
        if (filename)
          {
            debug(2, "Sending filename for %s (%s)", filename, alias);
            ok = sendmdmfn(alias);
            state = CheckFNm;
          }
        else
          state = EndSend;
        break;
      case CheckFNm:
        if (ok)
          {
            debug(1, "Sending file %s", filename);
            ok = xtsend(filename, alias, FILETRANSFER);
            state = CheckFile;
          }
        else
          state = Error;
        break;
      case CheckFile:
        if (ok)
          {
            debug(1, "File sent ok");
            state = Done;
          }
        else
          {
            log("TeLink file send failed");
            state = Error;
          }
        break;
      case EndSend:
        SetStart();
        while (!Timeout(10))
          if ((c = readline(10*1000)) == NAK || c == 'C')
            {
              sendline(EOT);
              log("Batch file send ok");
              state = Done;
              break;
            }
        if (state != Done)
          {
            log("Batch file send failed, no NAK");
            sendline(EOT);
            state = Error;
          }
        break;
      }
  
  return state != Error ? OK : ERROR;
}
