/*
 * $Header: /u1/src/rfmail/RCS/xmodem.h,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: xmodem.h,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 */

typedef enum { FILETRANSFER = 0, MAILTRANSFER = 1 } transfermode_t;

typedef struct {
  boolean sealink;
  boolean forcecrc;
  boolean quicknak;
  boolean transfer_ack_numbered;
  boolean dotelink;
  Uint windows_at_2400;
  Uint max_send_ahead;
  Uint checksum_fallback;
  Uint speed;
  boolean mailtransmit;
} xmodem_options_t;


typedef struct {
  long fileLength;	/*  0  4 */
  char CreationTime[2];	/*  4  2 */
  char CreationDate[2];	/*  6  2 */
  char filename[16];	/*  8 17 */
  char header_version;  /*  9  1 Sealink: Last byte of filename, must be 0 */
  char sendingProg[15];	/* 25 15 Name of transmitting program */
  /* char overdrive;	/* 40  1 Sealink: overdrive flag. */
  /* char crcMode;	/* 41  1 ?? Zeroed against standard (bug). */
  char fill[88];
} Telinkblock;

extern xmodem_options_t xmodem_options;
extern Telinkblock telinkblock;

DECLARE(void, check_out_telinkblock, (void));
DECLARE(boolean, xtrec, (char *, transfermode_t));
DECLARE(boolean, batchrec, ());

DECLARE(char *, conver_to_msdos_name, (char *));
DECLARE(boolean, xtsend, (char *, char *, transfermode_t));
DECLARE(int, batchsend, (char *, char *));
