/*
 * $Header: /u1/src/rfmail/RCS/shuffle.c,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: shuffle.c,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 */

#include "fnet.h"
#include "shuffle.h"

static char *sbuf[MAX_SHUFFLE_BUFFERS];
static int count = 0;
char *sbuffer;

char *
shufflebuffers()
{
#ifdef SMALLER_OBJECT_STAYS
  /* Pack previous buffer to save some memory. This only works if your realloc
     never moves objects when you make them smaller. Smart systems may move
     things, so data is moved. Better scheme for this should be implemented, I
     guess I have to go to double pointers here. */
  
  if (sbuf[count])
    sbuf[count] = myrealloc(sbuf[count], (Uint) strlen(sbuf[count]) + 2);
#endif
  
  /* Increment buffer counter */
  
  loop_increment(count, MAX_SHUFFLE_BUFFERS);

  /* During first run, buffers may be unallocated */
  
  if (!sbuf[count])
    {
      mallocname("shuffle");
      sbuf[count] = (char *)mymalloc(MAX_SHUFFLE_BUFFERSIZE);
    }
#ifdef SMALLER_OBJECT_STAYS
  else
    {
      /* If we resize stuff to save memory, need to resize it large again. */ 
      sbuf[count] = myrealloc(sbuf[count], MAX_SHUFFLE_BUFFERSIZE);
    }
#endif
  
  /* Returning global pointer may be a good idea sometimes */
  
  sbuffer = sbuf[count];
  return sbuffer;
}
  
