/*
 * $Header: /u1/src/rfmail/RCS/rfstatus.c,v 0.5 1992/05/18 04:27:24 pgd Exp pgd $
 *
 * $Log: rfstatus.c,v $
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 */

#include "fnet.h"

#include <sys/stat.h>

#include <errno.h>

#include "nodelist.h"
#include "configs.h"
#include "packet.h"

#ifdef XENIX
DECLARE(int, stat, (char *, struct stat *));
#endif

#define POSSIBLE_UNPACKED_MESSAGES 1
#define POSSIBLE_PACKETS 2
#define POSSIBLE_RFC822_MESSAGES 4
#define FILES 5

/* Types for found files. */
  
#define TYPE_UNKNOWN 0
#define TYPE_PACKET 1

/* Levels of messages: Report everything or just things that look abnormal. */

#define MERROR 1
#define MUNUSUAL 2
#define MNORMAL 3

  
LDECLARE(boolean, display_pkt_hdr, (Packet *));
LDECLARE(boolean, display_msg_hdr, (Message *));
LDECLARE(boolean, is_omailpkt, (char *));
LDECLARE(boolean, is_oreq, (char *));



static boolean
display_pkt_hdr(pkt)
	struct packet *pkt;
{
	if (pkt->orig.zone < 0) {
		debug(5, "Orig zone %d\n", pkt->orig.zone);
		return FALSE; /* Not a packet */
	}
	if (pkt->orig.net < 0) {
		debug(5, "Orig net %d\n", pkt->orig.net);
		return FALSE; /* Not a packet */
	}
	if (pkt->orig.node < 0) {
		debug(5, "Orig node %d\n", pkt->orig.node);
		return FALSE; /* Not a packet */
	}
	if (pkt->dest.zone < 0) {
		debug(5, "Dest zone %d\n", pkt->dest.zone);
		return FALSE; /* Not a packet */
	}
	if (pkt->dest.zone < 0) {
		debug(5, "Dest zone %d\n", pkt->dest.zone);
		return FALSE; /* Not a packet */
	}
	if (pkt->dest.zone < 0) {
		debug(5, "Dest zone %d\n", pkt->dest.zone);
		return FALSE; /* Not a packet */
	}

	if (pkt->hour < 0 || pkt->hour > 24) {
		debug(5, "Hour (%d) invalid", pkt->hour);
		return FALSE;
	}
	if (pkt->minute < 0 || pkt->minute > 59) {
		debug(5, "Minute (%d) invalid", pkt->minute);
		return FALSE;
	}
	if (pkt->second < 0 || pkt->second > 59) {
		debug(5, "Second (%d) invalid", pkt->minute);
		return FALSE;
	}

	if (pkt->day < 1 || pkt->day > 31) {
		debug(5, "Day (%d) invalid", pkt->day);
		return FALSE;
	}
	if (pkt->month < 0 || pkt->month > 12) {
		debug(5, "Month (%d) invalid", pkt->month);
		return FALSE;
	}
	/* This program will stop working year 32767. Sloppy coding. */
	if (pkt->year < 0 || pkt->year > 32767) {
		debug(5, "Year (%d) invalid", pkt->year);
		return FALSE;
	}
  
	printf("\tOrigin %s, Target %s\n",
	       ascnode(pkt->orig), ascnode(pkt->dest));
	printf("\tDate %02d:%02d:%02d day %d month %d year %d\n",
	       pkt->hour, pkt->minute, pkt->second,
	       pkt->day, pkt->month + 1, pkt->year);
	printf("\tHeader version %d, product code %d\n",
	       pkt->ver, pkt->prodcode);
	if (*pkt->passwd)
		printf("\tPassword %s\n", pkt->passwd);
	return TRUE;
}

static boolean
display_msg_hdr(msg)
	Message *msg;
{
	if (msg->orig.zone < 0) {
		debug(5, "Orig zone %d\n", msg->orig.zone);
		return FALSE; /* Not a message */
	}
	if (msg->orig.net < 0) {
		debug(5, "Orig net %d\n", msg->orig.net);
		return FALSE; /* Not a message */
	}
	if (msg->orig.node < 0) {
		debug(5, "Orig node %d\n", msg->orig.node);
		return FALSE; /* Not a message */
	}
	if (msg->dest.zone < 0) {
		debug(5, "Dest zone %d\n", msg->dest.zone);
		return FALSE; /* Not a message */
	}
	if (msg->dest.zone < 0) {
		debug(5, "Dest zone %d\n", msg->dest.zone);
		return FALSE; /* Not a message */
	}
	if (msg->dest.zone < 0) {
		debug(5, "Dest zone %d\n", msg->dest.zone);
		return FALSE; /* Not a message */
	}
  
	printf("Origin %s, Target %s\n",
	       ascnode(msg->orig), ascnode(msg->dest));
	printf("\tDate: %s", msg->ascdate);
	if (msg->replyaddr)
		printf(", Replyaddr: %s\n", msg->replyaddr);
	else
		putchar('\n');
	printf("\tFrom: %s, To: %s, Subj: %s\n",
	       msg->from, msg->to, msg->subject);
	return TRUE;
}

int
check_packet(packet)
     FILE *packet;
{
  /* Read messages to count them and to check packet consistency */
#ifdef READY
  while (getmessage(packet));
#endif
  return TRUE;			/* What is supposed to be here? */
}

void
checkfiles(directory, mode)
     char *directory;
     int mode;
{
	FILE *packet, *msgfp;
	char *fname, *bn;
	Packet pkt;
	Message msg;

	printf("\nDirectory %s\n\n", directory);
  
	if (chdir(directory) != 0 || !myopendir(NULL, TRUE))
		return;
	while (fname = myreaddir(NULL)) {
		printf("File %s:\t", fname);
				
		if (is_req(fname) || is_oreq(fname)) {
			printf("File request file\n");
			continue;
		}
		if (is_arcmail(fname)) {
			printf("Arcmail archive\n");
			continue;
		}
		if ((is_mailpkt(fname) || is_omailpkt(fname)) && (mode & POSSIBLE_PACKETS)) {
			if ((packet = fopen(fname, "r")) == NULL) {
				printf("Open error: %s\n", syserr(errno));
				continue;
			}
			if (!read_packet_header(packet, &pkt)) {
				printf("Error reading packet header\n");
				goto next;
			}
			if (!display_pkt_hdr(&pkt)) {
				printf("Not a mail packet\n");
				goto next;
			}
			if (!check_packet(packet)) {
				printf("Check error\n");
				goto next;
			}
		next:
			fclose(packet);
			continue;
		}
		bn = basename(fname);
		if (bn[0] == 'M' && bn[1] == '.') {
			if ((msgfp = fopen(fname, "r")) == NULL) {
				printf("Open error: %s", syserr(errno));
				continue;
			}
			if (!read_msg_hdr(&msg, msgfp)) {
				fclose(msgfp);
				printf("Illegal message header format\n");
				continue;
			}
			if (!display_msg_hdr(&msg)) {
				printf("Illegal message foramat\n");
				freemsg(&msg);
				goto next;
			}
			freemsg(&msg);
			fclose(msgfp);
			continue;
		}
		if (access(fname, 4) == -1)
			printf("File unreadable\n");
		else
			printf("File type unknown\n");
	}
	myclosedir();
}

void
printusage(fp)
	FILE *fp;
{
	fprintf(fp, "rfstatus: Display fidonet status\n");
	configprintusage(fp);
	fflush(fp);
}
     
int
main(argc, argv)
     int argc;
     char *argv[];
{
	int c;
	static char *options = "";

	get_configuration(&argc, argv, options);
  
	while ((c = getopt(argc, argv, options)) != EOF) {
		switch (c) {
		default:
			printusage(errorfp);
			exit(EX_USAGE);
		}
	}

  /* Display fidonet status: Look at all packets in spool area, in order
     outgoing, incoming, bad. Check out all packets in directories and try to
     find out what are they. */

  /* Spooldir can contain unpacked messages. */
  checkfiles(config.msgdir, POSSIBLE_UNPACKED_MESSAGES);
  
  /* Incoming and outgoing directory should only contain packets. */
  checkfiles(config.outdir, POSSIBLE_PACKETS);
  checkfiles(config.indir, POSSIBLE_PACKETS);

  /* Bad directory can contain both bad packets and bad rfc822 format messages
     bounced by inews. */
  checkfiles(config.badfiles, POSSIBLE_PACKETS | POSSIBLE_RFC822_MESSAGES);

  /* In files can be just about anything? */
  checkfiles(config.infiles, FILES);
  
  exit(EX_OK);
  return EX_OK;
}


/*
 * Check if file is an outgoing file request file
 */
static boolean
is_oreq(fname)
	char *fname;
{
	register char *p;

	p = strrchr(fname, '.');
	if (p && strchr("rhcd", tolower(p[1]))
	      && tolower(p[2]) == 'e'
	      && tolower(p[3]) == 'q'
	      && p[4] == 0)
		return TRUE;
	return FALSE;
}

/*
 * Check if file is an outgoing mail packet.
 */
static boolean
is_omailpkt(fname)
	char *fname;
{
	register char *p;

	p = strrchr(fname, '.');
	if (p && strchr("ohcd", tolower(p[1]))
	      && tolower(p[2]) == 'u'
	      && tolower(p[3]) == 't'
	      && p[4] == 0)
		return TRUE;
	return FALSE;
}



