/*
 * $Header: /u1/src/rfmail/RCS/rfconfig.c,v 0.5 1992/05/18 04:27:24 pgd Exp pgd $
 *
 * $Log: rfconfig.c,v $
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 */

#include "fnet.h"
#include "nodelist.h"
#include "configs.h"
  
#define its(s) (!strcmp(string, s))

int
main(argc, argv)
     int argc;
     char *argv[];
{
  int c, exitcode = EX_OK;
  FILE *configfp;
  char buffer[BUFSIZ], *p, *p1, *string;
  static char *options = "";

  get_configuration(&argc, argv, options);
  
  while ((c = getopt(argc, argv, options)) != EOF) {
	  switch (c) {

	  default:
		  perror("usage: [-v] config-string\n");
		  exit(EX_USAGE);
	  }
  }

  if (optind != argc - 1) {
    perror("usage: [-v] config-string\n");
    exit(EX_USAGE);
  }

  string = argv[optind];
  
  if (its("configfile"))
    (void) fputs(CONFIGFILE, stdout);
  else if (its("logdir"))
    (void) fputs(config.logdir, stdout);
  else if (its("outdir"))
    (void) fputs(config.outdir, stdout);
  else if (its("indir"))
    (void) fputs(config.indir, stdout);
  else if (its("crdebug"))
    (void) printf("%d", config.crdebug);
  else if (configfp = fopen(CONFIGFILE, "r"))
    {
      while (fgets(buffer, BUFSIZ, configfp))
	{
	  p = strtok(buffer, SEPARATORS);
	  
	  /* Empty lines skipped silently */
	  
	  if (!p) continue;
	  
	  /* Skip comment lines */
	  
	  if (*p == '#') continue;
	  
	  if (strequ(p, argv[optind]))
	    {
	      /* Get rest of line, this may cause trouble if something
		 is to be ignored. That kind of situation should be
		 handled separately, see upwards, if (its("..")). */
	      
	      p = strtok(NULL, "");
	      if (p) {
		  if (p1 = strchr(p, '\n')) *p1 = 0;
		  fputs(p, stdout);
		  fflush(stdout);
		}
	      
	      exit(EX_OK);
	    }
	}
      
      (void) fclose(configfp);
      
      exitcode = EX_NOINPUT; /* Could not find such string */
    }
  else
    {
      log("$Cannot open config file %s", CONFIGFILE);
      exit(EX_NOINPUT);
    }

  (void) fflush(stdout);
  exit(exitcode);
  return exitcode;
}


void
printusage(fp)
	FILE *fp;
{
	fprintf(fp, "rfconfig [options]\n");
	fprintf(fp, "Where options are any of:\n");
	configprintusage(fp);
}


