/*
 * $Header: /u/src/com/RCS/rfc822.y,v 2.6.5.1 1991/08/04 13:54:38 pgd Exp pgd $
 *
 * $Log: rfc822.y,v $
 *
 */

/*
 * An rfc822 parser. Returns TRUE if a legal address, FALSE otherwise
 */

%{
static char	*linep;
static int	 iseol;
#define	YYPURE
#ifdef __STDC__
static int yyparse();
#else
#define	yyparse	yyparse_rfc822
#endif

static int yylex();
static void yyerror(char *);

%}

%token	EOL ATOM LIT_DOMAIN QUOTED_STRING

%start	addr_list

%%

addr_list:	addr_lel
       |	addr_list addr_lel
       ;

addr_lel:	address EOL 
	|	address ',' 
	|	error
	;

address:	mailbox
	|	group
	;

group	: phrase ':' mbox_list ';'
	;

mbox_list:	mailbox 
	|	mbox_list ',' mailbox
	;

mailbox:	addr_spec
	|	route_addr
	|	phrase route_addr
	;

phrase	:	word
	|	phrase word
	;

route_addr:	'<' addr_spec '>'
       |	'<' route addr_spec '>'

route	:	route_list ':'
	;

route_list:	'@' domain
	|	route_list ',' '@' domain
	;

addr_spec:	local_part '@' domain
	|	local_part
	;


local_part:	word
	|	local_part '.' word
	|	local_part '%' word
	;

domain	:	sub_domain
	|	domain '.' sub_domain
	;

sub_domain:	domain_ref
	|	LIT_DOMAIN
	;

domain_ref:	ATOM
	;

word	:	ATOM
	|	QUOTED_STRING
	;

%%

#include <stdio.h>
#include <ctype.h>

#define ERROR	-2

int errflag;

static void
yyerror(s)
	char	*s;
{
	errflag = 1;
}

rfc822(line)
	char	*line;
{
	register char *cp;

	/*
	 * A rfc822 address has to include either a '@' or a '!'
	 * to be valid for our purposes.
	 */
	if (strchr(line, '@') == NULL && strchr(line, '!') == NULL)
		return 0;
	errflag = 0;
	linep = line;
	(void)yyparse();
	return errflag ? 0 : 1;
}


static int
yylex()
{
	register char	*p;
	register int	 paren_count;

	while (isascii(*linep) && (isspace(*linep) || (*linep == '('))) {
		if (*linep == '(') {
			for (paren_count = 1, p = linep + 1; paren_count; p++) {
				if (*p == '\0')
					return(EOF);
				if (*p == '(')
					paren_count++;
				else if (*p == ')')
					paren_count--;
			}
			linep = p;
		} else
			linep++;
	}

	if (!isascii(*linep)) {
		return(ERROR);
	}
	
	switch (*linep) {
	case '\0':
		if (iseol) {
			iseol = 0;
			return(EOF);
		}
		iseol = 1;
		return(EOL);
	case ',':
	case ':':
	case ';':
	case '.':
	case '@':
	case '%':
	case '<':
	case '>':
		return(*linep++);
	case '[':			/* LIT_DOMAIN */
		for (p = linep; *++p && *p != ']'; )
			;
		if (*p == '\0') {
			return(EOF);
		}
		linep = ++p;
		return(LIT_DOMAIN);

	case '"':       /* QUOTED_STRING */
		for (p = linep; *++p && *p != '"'; )
			;
		if (*p == '\0') {
			return(EOF);
		}
		linep = ++p;
		return(QUOTED_STRING);
	}
	for (p = linep; ; p++)
		switch (*p) {
		case 'a':
		case 'A':
			if ((p[1] == 't' || p[1] == 'T') && isspace(p[2])) {
				linep = p + 2;
				return('@');
			}
			break;
		case ',':
		case ':':
		case ';':
		case '.':
		case '@':
		case '%':
		case '<':
		case '>':
		case '(':
		case ')':
		case '[':
		case '"':
		case '\0':
			goto out;
		default:
			if (isspace(*p))
				goto out;
		}
out:
    	linep = p;
    	return(ATOM);
}

#if 0
/* main() */
{
	char line[80];

	while (!feof(stdin)) {
		printf(">>>");
		gets(line);
		printf("Parser returns: %d\n", rfc822(line));
	}
}
#endif
