/*
 * $Header: /u1/src/rfmail/RCS/packet.h,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: packet.h,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 *
 */

/*
 * Author:
 *
 * Per Lindqvist (pgd@compuram.bbt.se) 
 */

struct line
{
	struct line *prev, *next;
	boolean softeol;
	char *txt;
};

/*
 * Structure for packet header.
 *
 * Note: this structure is not the same as sent
 * it is used for internal processing of packets.
 */

typedef struct packet {
	Node orig;		/* Originating node */
	Node dest;		/* Destination node */
	Uchar orig_domain[9];	/* originating domain */
	Uchar dest_domain[9];	/* destinatin domain */
	Ushort year;		/* packing year (e.g. 1986) */
	Ushort month;		/* 0-11 for Jan - Dec */
	Ushort day;		/* 1-31 */
	Ushort hour;		/* 0-23 */
	Ushort minute;		/* 0-59 */
	Ushort second;		/* 0-59 */
	Ushort rate;		/* maximum baud rate */
	Ushort	ver;
	Ushort prodcode;	/* product code */
	Uchar prodmaj;		/* product major revision */
	Uchar prodmin;		/* product minor revision */
	Uchar serialno;		/* serial number */
	Uchar passwd[9];
	Ushort capword;		/* Capabilities word */
	Ulong proddata;		/*  */
	Ushort pktterm;		/* packet terminator */
	Pkttype pkttype;	/* type of packet sent/received */
} Packet;

/*
 * Internal structure for message in memory.
 */
typedef struct message {
	Node orig;		/* Node from which message originated */
	Node dest;		/* destination node for message */
	Ushort attr;		/* message attributes */
	Ushort cost;		/* cost */
	char ascdate[20];	/* Fidonet date */
	time_t date;		/* Date in unix format */
	char to[36];		/* FTSC "to" field of message */
	char from[36];		/* FTSC "From" field of message */
	char subject[72];	/* Message subject */
	struct line *headers;	/* Header (fidonet kludge) lines */
	struct line *body;	/* Body lines */
	struct line *rfchdr;	/* Internet rfc822 version of headers */
	char *replyaddr;	/* Internet reply address */
	/*
	 * Various pieces of the fidonet message header
	 */
	Node *seenby;		/* "SEEN-BY" list */
	short seenbys;		/* number of entries in the seenby list */
	short maxseenbys;	/* Number of entries allocated for in the */
				/* seenby array */
	char *path;		/* "PATH:" header (footer) line */
	char *area;		/* "AREA" header line */
	char *msgid;		/* "MSGID:" line */
	char *reply;		/* "REPLY:" line */
	char *toto;		/* "TO:" kludge */
	Newsgroup *ngp;		/* Pointer to newsgroup structure */
	char *internet;		/* The _genuine_ from address */
	char *ufgroup;		/* ... and original newsgroup */
	char *ufgid;		/* ... and Message-Id */
} Message;



/* Attributes tranferred via mail. + not cleared when packetizing, s seadog */

#define ATTR_PRIVATE    (0000001) /* +  private msg */
#define ATTR_CRASH      (0000002) /* +s SEAdog only */
#define ATTR_RECD       (0000004) /*    Received */
#define ATTR_SENT	(0000010) /*    Sent */
#define ATTR_FILE	(0000020) /* +  files attached */
#define ATTR_INTRANSIT 	(0000040) /*    In transit */
#define ATTR_ORPHAN	(0000100) /*    Orphan */
#define ATTR_KILLSENT	(0000200) /*    Kill when sent */
#define ATTR_LOCAL	(0000400) /*    Local message, not sent out */
#define ATTR_HOLD	(0001000) /*  s Hold for Pickup */
#define ATTR_UNUSED 	(0002000) /* +  unused */
#define ATTR_FILEREQ	(0004000) /*  s File request */
#define ATTR_RRR 	(0010000) /* +s Returnreceiptrequest */
#define ATTR_IRR 	(0020000) /* +s Isreturnreceipt */
#define ATTR_AUDREQ 	(0040000) /* +s Audit Request */
#define ATTR_UPDREQ	(0100000) /*  s File update request */

/* Mask of bits to keep when packetizing */
#define	ATTR_MASK	(ATTR_PRIVATE|ATTR_CRASH|ATTR_FILE|ATTR_UNUSED|ATTR_RRR|ATTR_IRR|ATTR_AUDREQ)

/* Product code for rfmail */

#define PRODUCTCODE (0x5e)

/* Capability word, Packet and message types. */

#define HDRVER (02)
#define MSGTYPE (02)
#define CAP_WORD (01)

DECLARE(boolean, read_type2_message, (FILE *, Message *, Packet *));
DECLARE(boolean, read_type2_header, (FILE *, Message *));
DECLARE(boolean, read_packet_header, (FILE *, Packet *));
DECLARE(struct line *, addline, (struct line *, char *, int));
DECLARE(void, freemsg, (Message *));
DECLARE(boolean, valid_netnode, (char *, Node));
DECLARE(void, newbodyline, (Message *, char *, int, boolean));
DECLARE(void, newrfchdrline, (Message *, char *, int));
DECLARE(boolean, write_msg, (Message *, Node, Node));
DECLARE(struct line *, delline, (struct line *, struct line **));
DECLARE(boolean, read_msg, (Message *, FILE *));
DECLARE(boolean, write_type2_message, (Message *, FILE *));
DECLARE(void, create_packet_header, (Packet *, Node));
DECLARE(boolean, write_packet_header, (Packet *, FILE *));
DECLARE(boolean, read_msg_hdr, (Message *, FILE *));
DECLARE(boolean, write_type2_hdr, (Message *, FILE *));
DECLARE(void, newheaderline, (struct message *, char *, int));
DECLARE(char *, ascii_attribute, (int));
DECLARE(int, binary_attribute, (char *));
DECLARE(void, add_seenby, (struct message *, Node));
