/*
 * $Header: /u1/src/rfmail/RCS/nodelist.h,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: nodelist.h,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.5  1991/09/07  10:37:46  pgd
 * not finished revision check-in
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 *
 */

/* Structures and definitions for nodelist.

   @(#)Copyright (c) 1987 by Teemu Torma
 
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

#define	NODELIST_ID	1


/* Compare two node entried to see if they are same node (ignoring
   possible other information */
#define samenode(n1, n2) ((n1).zone == (n2).zone && (n1).net == (n2).net && \
			  (n1).node == (n2).node && (n1).point == (n2).point)

/*
 * Structure for node. (It is broken out of "struct nodelist", because
 * it is manipulated in so many places which does not need the
 * other information.
 */
typedef struct {
	Ushort zone;		/* Zone of node (not really supported yet) */
	Ushort net;		/* net/region of node */
	Ushort node;		/* number of node */
	Ushort point;		/* Point of node */
} Node;

#define	NOZONE	((Ushort)0xffff)
#define	NONET	((Ushort)0xffff)
#define	NONODE	((Ushort)0xffff)
#define	NOPOINT	((Ushort)0xffff)

/* General defines to make program more readable and easier to write... */

#define NODE_WILDCARD ((Ushort)0xfffe)


/* Compare two nodes for equality */
#define	NODEEQU(N1, N2)	((N1).zone==(N2).zone && (N1).net==(N2).net && (N1).node==(N2).node && (N1).point==(N2).point)


/* 
 * Structure for nodelist entry. 
 * Routines to get one node from nodelist
 * will return this structure. 
 */

#ifdef XENIX
#pragma pack(1)
#endif
struct nodelist {
	Uchar type;		/* type of entry (see below) + type flags */
	Node node;		/* Node number */
	Ushort region;		/* region (not necessarily used/set) */
	Ushort speed;		/* speeds */
	Ushort flags;		/* Nodelist flags */
	Ulong modemcap;	/* Node modem capabilities */
	Uchar mailhour;	/* Node mailhours */
	char name[40];		/* name of bbs */
	char city[40];		/* city */
	char sysop[40];		/* name of sysop */
	char phone[40];		/* phone-number */
	char password[40];	/* Node password */
};

typedef struct _indexnode {
	Node node;
	long offset;
} node_index_t;

typedef struct _indexname {
	long offset;		/* Refers to nodelist index entry */
	char name[40];		/* System name */
} name_index_t;

#ifdef XENIX
#pragma pack()
#endif

/* 
 * Nodelist Entry types.
 */
#define REGION	1		/* Entry is region-host */
#define HOST	2		/* Entry is net-host */
#define HUB 	3		/* Entry is local-host */
#define	KENNEL	7		/* Entry is kennel */
#define	NODE	8		/* Entry is a normal node */
#define ZONE	9		/* Entry is Zone */
#define POINT	10		/* point node */
#define	NLENTRYMASK	017

/*
 * Nodelist entry flags
 */
#define	BOSS	020		/* Node is Boss node points */
#define	DOWN	040		/* Node is down */
#define	HOLD	0100		/* no mail to this node */
#define PRIVATE 0200		/* Node is private */

/*
 * Nodelist flags
 */
#define	CM	0000001		/* Node accepts mail 24 hours a day */
#define	MO	0000002		/* Node does not accept human callers */
#define	LO	0000004		/* Node accepts calls Only from */
				/* listed fidonet addresses */
#define	MN	0000010		/* No compression supported */
#define	XA	0000020		/* Bark freq/updreq, WaZoo freq/updreq */
#define	XB	0000040		/* Bark freq/updreq, WaZoo freq */
#define	XC	0000100		/* Bark freq, WaZoo freq/updreq */
#define	XP	0000200		/* Bark freq/updreq */
#define	XR	0000400		/* Bark freq */
#define	XW	0001000		/* WaZoo freq */
#define	XX	0002000		/* WaZoo freq/updreq */

#define	GUUCP	0004000		/* Node is an uucp gateway */
#define	NEC	0010000		/* Network echomail coordinator */
#define	REC	0020000		/* Regional echomal coordinator */

/*
 * Mail hour flags
 */
#define	MH01	0000001		/* Zone 5 mail hour (01:00 - 02:00 UTC) */
#define	MH02	0000002		/* Zone 2 mail hour (02:30 - 03:30 UTC) */
#define	MH08	0000004		/* Zone 4 mail hour (08:00 - 09:00 UTC) */
#define	MH09	0000010		/* Zone 1 mail hour (09:00 - 10:00 UTC) */
#define	MH18	0000020		/* Zone 3 mail hour (18:00 - 19:00 UTC) */
#define	MH20	0000040		/* Zone 6 mail hour (20:00 - 21:00 UTC) */

/*
 * Nodelist modem capabilities flags
 */
#define	BELL300	000000001   /* Bell            300 bps full duplex */
#define	V21	000000002   /* CCITT V.21      300 bps full duplex */
#define	BELL212	000000004   /* Bell 212	      1200 bps full duplex */
#define	V22	000000010   /* CCITT V.22     1200 bps full duplex */
#define	V22b	000000020   /* CCITT V.22bis  2400 bps full duplex */
#define	V23	000000040   /* CCITT V.23 */
#define	V29	000000100   /* CCITT V.29     9600 bps half duplex */
#define	V32	000000200   /* CCITT V.32     9600 bps full duplex */
#define	V32b	000000400   /* CCITT V.32bis 14400 bps full duplex */
#define	V33	000001000   /* CCITT V.33 */
#define	V34	000002000   /* CCITT V.34 */
#define	V42	000004000   /* LAP-M error correction w/fallback to MNP 1-4 */
#define	V42b	000010000   /* LAP-M error correction w/fallback to MNP 1-5 */
#define	MNP	000020000   /* Microcom Networking Protocol error correction */
#define	H96	000040000   /* Hayes V9600 */
#define	HST	000100000   /* USR Courier HST */
#define	MAX	000200000   /* Microcom AX/96xx series */
#define	PEP	000400000   /* Telebit Packet Ensemble Protocol */
#define	CSP	001000000   /* Compucom Speedmodem */
#define	ISDNA	002000000
#define	ISDNB	004000000
#define	ISDNC	010000000


/* Declarations for routines. */

DECLARE(Node *, search_node, (Node, struct nodelist *));
DECLARE(Node *, search_name, (char *, struct nodelist *));
DECLARE(int, cmpnode, (Node *, Node *));
DECLARE(char *, ascnode, (Node));
DECLARE(char *, netnode, (Node));
DECLARE(char *, ascnode_nopoint, (Node));
DECLARE(char *, internode, (Node));
/* DECLARE(char *, ascnodei, (node_index_t)); */
DECLARE(char *, parse_address, (char *, char *, Node *));
DECLARE(int, parsefnetaddress, (char *, Node *));
DECLARE(boolean, parseinternode, (char *, Node *));
DECLARE(char *, nodepath, (char *, Node ));
DECLARE(void, sprintipacketname, (char *, Node));
DECLARE(void, get_nodelist, (void));
DECLARE(long, read_file, (char **, char *));
DECLARE(char *, parsenode, (char *, Node*, char *, Node*));
DECLARE(boolean, check_parsenode, (char *, Node*));
DECLARE(boolean, check_atoi, (char *, int *));
DECLARE(boolean, node_match, (Node, Node));
DECLARE(boolean, route_node, (Node, routing_type *, Node *));
DECLARE(struct dest_info, get_destinfo, (Node));
DECLARE(void, dial_translation, (char *, char *));
DECLARE(boolean, set_node_lock, (Node));
DECLARE(void, clear_node_lock, (Node));
DECLARE(void, set_call_status, (Node, boolean));
DECLARE(void, clear_call_status, (Node));
DECLARE(Node *, node_to_call, (VOID));
DECLARE(char *, outgoing_mailpacket, (Node));
DECLARE(boolean, is_our_node, (Node));


extern Node originnode;
extern node_index_t *nodeindex;
#ifdef NEED_NAME_INDEX
extern name_index_t *nameindex;
#endif
extern int nodes;

