/*
 * $Header: /u1/src/rfmail/RCS/nodelist.c,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: nodelist.c,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.5  1991/09/07  10:37:46  pgd
 * not finished revision check-in
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 *
 */

/* Routines to get and translate information in nodelist.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

/*
 * Authors:
 *
 * Teemu Torma who wrote the original code (?)
 *
 * Heikki Suonsivu (hsu@hutcs.hut.fi) who made a lot of enhancements
 * 
 * Per Lindqvist (pgd@compuram.bbt.se) who continued to enhance rfmail.
 */

/*
  Sat Oct  8 17:36:11 1988
  Rewrote nodelist index handling and reading. Now index is kept
  in memory, and has zones also.
  */
     
/* LINTLIBRARY */

#include "fnet.h"

#ifdef HAVE_VALUES_H
#include <values.h>
#endif

#include <sys/stat.h>

#include "nodelist.h"
#include "configs.h"
#include "shuffle.h"

#ifdef XENIX
DECLARE(int, stat, (char *, struct stat *));
#endif

/* extern long atol(); */
Node originnode;
node_index_t *nodeindex = NULL;
static Ulong nodeindexsize;	/* Size of nodelist in bytes */
int nodes;			/* Number of nodes in nodelist */
name_index_t **nameindex, *nameindex_base;
int names;			/* Number of names in name index */
static Ulong nameindexsize;	/* Size of name index in bytes */
int compile_zone, compile_region, compile_net, compile_node;

static FILE *nlfp;		/* Nodelist file-pointer */


void
name_to_fidonet_format(name)
     char *name;
{
	boolean wasspace = TRUE;

	for (; *name; name++) {
		if (*name == '_') *name = ' ';
		if (isspace(*name))
			wasspace = TRUE;
		else if (wasspace) {
			*name = toupper(*name);
			wasspace = FALSE;
		} else
			*name = tolower(*name);
	}
}

/*
 * Compare two nodes
 */
int
cmpnode(node1, node2)
	register Node *node1, *node2;
{
	if (node1->zone < node2->zone) return -1;
	if (node1->zone > node2->zone) return 1;
	if (node1->net < node2->net) return -1;
	if (node1->net > node2->net) return 1;
	if (node1->node < node2->node) return -1;
	if (node1->node > node2->node) return 1;
	if (node1->point < node2->point) return -1;
	if (node1->point > node2->point) return 1;
	return 0; /* Same node */
}

/* Compare nodelist index entry (for qsort) */
static int
cmpnodeindex(node1, node2)
	node_index_t *node1, *node2;
{
	return cmpnode(&node1->node, &node2->node);
}


static int
cmpnameindex(name1, name2)
	name_index_t **name1, **name2;
{
	return stricmp((*name1)->name, (*name2)->name);
}

/* Read file in to a buffer allocating buffer for it */

long 
read_file(buffer, name)
     char **buffer, *name;
{
	FILE *fp;
	long size = 0;
  
	if (fp = fopen(name, "r")) {
		myfseek(fp, 0L, SEEK_END);
		size = ftell(fp);

		/* Apparently we are on 16-bit? */
		if (size > MAXINT) {
			log("Brain damaged CPU architecture reading file?");
			size = 0;
			goto out;
		}
    
		rewind(fp);
		
		if (*buffer)
			*buffer = (char *)myrealloc( *buffer, (Uint) size);
		else
			*buffer = (char *)mymalloc( (Uint) size);
    
		debug(1, "Reading %d bytes from %s", size, name);
		if (fread( *buffer, 1, (int) size, fp) != size)
			size = 0;
		fclose(fp);
	}
#ifndef BSD
 out:
#endif
	return size;
}

int
write_file(buffer, name, size)
	char *buffer, *name;
	int size;
{
	FILE *fp;
	register int rvalue = 0;
  
	if (fp = myfopen(name, "w+")) {
		debug(1, "Writing %d bytes to %s", size, name);
		if (fwrite(buffer, 1, size, fp) != size)
			rvalue = -1;
		if (fclose(fp) == -1)
			rvalue = -1;
	}
	return rvalue;
}

/*
 * Search nodelist for a node.
 * Return NULL, if node not found.
 */
Node *
search_node(node, nlptr)
	Node node;
	struct nodelist *nlptr;
{
	struct nodelist entry;
	long offset;
	node_index_t *nodeip, nodei;

	if (node.zone == 0)
		node.zone = config.mynode.zone;
	nodei.node = node;

	nodeip = (node_index_t *)
			bsearch( (char *) &nodei, (char *) nodeindex,
				(Uint) nodes, sizeof(node_index_t),
				cmpnodeindex);
	
	debug(2, "Searching %s from %d nodes -- %s",
	      ascnode(nodei.node), nodes,
	      nodeip ? "Node found" : "Node unknown");

	if (nodeip == NULL)
		return NULL;
	if (nlptr == NULL)
		return &nodeip->node;

	/*
	 * Get all data for node
	 */
	offset = nodeip->offset;
	myfseek(nlfp, offset, 0);

	if (!read_char(nlfp, &entry.type)      			 ||
	    !read_int16(nlfp, &entry.node.zone)  		 ||
	    !read_int16(nlfp, &entry.node.net)   		 ||
	    !read_int16(nlfp, &entry.node.node)  		 ||
	    !read_int16(nlfp, &entry.node.point) 		 ||
	    !read_int16(nlfp, &entry.region)			 ||
	    !read_int16(nlfp, &entry.speed)      		 ||
	    !read_int16(nlfp, &entry.flags)     		 ||
	    !read_long(nlfp, &entry.modemcap)   		 ||
	    !read_char(nlfp, &entry.mailhour)		         ||
	    !read_string(nlfp, entry.name, sizeof(entry.name))   ||
	    !read_string(nlfp, entry.city, sizeof(entry.city))   ||
	    !read_string(nlfp, entry.sysop, sizeof(entry.sysop)) ||
	    !read_string(nlfp, entry.phone, sizeof(entry.phone)) ||
	    !read_string(nlfp, entry.password, sizeof(entry.password))) {
		buglog("$Read error on nodelist, pos=%ld, node=%s",
		       offset, ascnode(node));
		return NULL;
	}
	*nlptr = entry;
	return &nodeip->node;
}

#ifdef ALIASTABLE_NEEDED

static char **aliastable = NULL;
static allocated = 0;
static aliases = 0;

int
expand_aliastable()
{
	if (!aliastable) {
		aliastable = (char **) mymalloc(sizeof(char *) * 20);
		if (aliastable)
			allocated = 20;
	}
	if (aliases == allocated) { /* Need more pointers */
		allocated += 20;
		aliastable = (char **) myrealloc( (char *) aliastable,
						  sizeof(char *) * allocated);
		if (!aliastable) {
			log("Cannot realloc %d bytes",
			    sizeof(char *) * allocated);
			return -1;
		}
	}
	return 0;
}
	
#endif


/*
 * Read the nodelist
 */
void
get_nodelist()
{
	Ulong nlversion, nodeindexpos, nameindexpos;
	register char *cp;
	register int j;
	int i;
	Ulong lnodes, lnames;
	
	nlfp = fopen(config.nodelist_name, "r");
	if (nlfp == NULL)
		fatal(EX_OSFILE, "$Unable to open nodelist file: %s",
		    config.nodelist_name);
	if (!read_long(nlfp, &nlversion)     ||
	    !read_long(nlfp, &lnodes)        ||
	    !read_long(nlfp, &nodeindexpos)  ||
	    !read_long(nlfp, &nodeindexsize) ||
	    !read_long(nlfp, &lnames)        ||
	    !read_long(nlfp, &nameindexpos)  ||
	    !read_long(nlfp, &nameindexsize))
		fatal(EX_OSFILE, "$Read error on nodeindex, file: %s",
		      config.nodelist_name);
	names = lnames;
	nodes = lnodes;
	if (nodeindexsize > MAXINT)
		fatal(EX_OSERR, "Nodeindex too big to load into memory");
	if (nlversion != NODELIST_ID)
		fatal(EX_OSFILE, "Nodelist file version mismatch. Version=%d, should be=%d",
		    nlversion, NODELIST_ID);

	/*
	 * Read node index into memory
	 */
	myfseek(nlfp, nodeindexpos, SEEK_SET);
	nodeindex = (node_index_t *)mymalloc(nodeindexsize);
	if (fread((char *)nodeindex, 1, nodeindexsize, nlfp) != nodeindexsize)
		fatal(EX_OSFILE, "$Read error on nodeindex, file: %s",
		      config.nodelist_name);


	/*
	 * Read name index into memory
	 */
	myfseek(nlfp, nameindexpos, SEEK_SET);
	nameindex_base = (name_index_t *)mymalloc(nameindexsize);
	if (fread((char *)nameindex_base, 1, nameindexsize, nlfp) != nameindexsize)
		fatal(EX_OSFILE, "$Read error on nameindex, file: %s",
		      config.nodelist_name);
	nameindex = (name_index_t **)mymalloc(names*sizeof(name_index_t *));
	cp = (char *)nameindex_base;
	for (i = 0; i < names; i++) {
		nameindex[i] = (name_index_t *)cp;
		cp += sizeof(nameindex_base->offset);
		for (j = 0; j < sizeof(nameindex_base->name); j++)
			if (*cp++ == 0)
				break;
	}
}



#if 0
	if (nodeip == NULL) {
		unknown = TRUE;
      
		nodeip = (node_index_t *)
				bfind( (char *) &nodei, (char *) nodeindex,
				      (Uint) nodes, sizeof(node_index_t),
				      cmpnodeindex);

		if (nodeip < nodeindex) {
			log("Internal error: Nodeip (%ld) < nodeindex (%ld)",
			    (long) nodeip, (long) nodeindex);
			return NULL;
		}
	  
		/* Go up in nodelist until node higher in fidonet hierarchy is found. */
      
		for (;;) {
			if (nodeip->node.node == 0)
				break;
			if (nodeip > nodeindex)
				nodeip--;
			if (nodeip == nodeindex) {
				log("Could not find upper node for %s",
				    ascnode(nodei.node));
				return NULL;
			}
		}
	}
	
#endif

/*
 * Search fidonet nodelist for an address
 * Return NULL, if node not found.
 */
Node *
search_name(name, nlptr)
	char *name;
	struct nodelist *nlptr;
{
	static struct nodelist entry;
	long offset;
	name_index_t **nameip, namei, *nip;

	strncopy(namei.name, name, sizeof(namei.name)-1);
	nip = &namei;
	nameip = (name_index_t **)
			bsearch( (char *)&nip, (char *)nameindex,
				(Uint) names, sizeof(name_index_t*),
				cmpnameindex);
	if (nameip == NULL)
		return NULL;

	/*
	 * Get all data for node
	 */
	offset = (*nameip)->offset;
	myfseek(nlfp, offset, 0);

	if (!read_char(nlfp, &entry.type)      			 ||
	    !read_int16(nlfp, &entry.node.zone)  		 ||
	    !read_int16(nlfp, &entry.node.net)   		 ||
	    !read_int16(nlfp, &entry.node.node)  		 ||
	    !read_int16(nlfp, &entry.node.point) 		 ||
	    !read_int16(nlfp, &entry.region)			 ||
	    !read_int16(nlfp, &entry.speed)      		 ||
	    !read_int16(nlfp, &entry.flags)     		 ||
	    !read_long(nlfp, &entry.modemcap)   		 ||
	    !read_char(nlfp, &entry.mailhour)		         ||
	    !read_string(nlfp, entry.name, sizeof(entry.name))   ||
	    !read_string(nlfp, entry.city, sizeof(entry.city))   ||
	    !read_string(nlfp, entry.sysop, sizeof(entry.sysop)) ||
	    !read_string(nlfp, entry.phone, sizeof(entry.phone)) ||
	    !read_string(nlfp, entry.password, sizeof(entry.password))) {
		buglog("$Read error on nodelist, pos=%ld, name=%s",
		       offset, name);
		return NULL;
	}

	debug(2, "Found name %s at node %s", name, ascnode(entry.node));

	if (nlptr)
		*nlptr = entry;
	return &entry.node;
}

void
dial_translation(dest, source)
	char *dest, *source;
{
	int i, pos;
  
	for (i = pos = 0; i < config.dials; pos += 2, i++) {
		if (!*config.dialtable[pos] ||
		    !strncmp(config.dialtable[pos], source,
			     strlen(config.dialtable[pos]))) {

			/* Matched, take prefix, */
			strcpy(dest, config.dialtable[pos + 1]);

			/* Then add phone number */
			strcat(dest, source + strlen(config.dialtable[pos]));
			return;
		}
	}
}

