/*
 * $Header: /u1/src/rfmail/RCS/ndiff.c,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: ndiff.c,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 */

/* ndiff.c

   Makes a new nodelist from a nodediff

   For Unix System V. Not tested on BSD, but there is a define for BSD.

   Compile it with "make ndiff"

   900812  Bo Kullmar, bk@kullmar.se, bk at 2:201/235.0

   hsu: edited a bit to make it pass non-ansi compilers and lint.

   pgd: Enhanced it to figure out filenames and calculate crcs.
*/

#include "fnet.h"

#define MAX_LINE 255

LDECLARE(int, getline, (char *, int, FILE *, Ushort *));
LDECLARE(void, putline, (char *, FILE *, Ushort *));
LDECLARE(void, parse_firstline, (char *, int *, Ushort *, char *));



FILE *ndiff, *onode, *nnode;
char ndiffname[128];
char onodename[128];
char nnodename[128];
char tmpnodename[128];
char nlpath[128];
int oiline;
int noline;

/*
 *  macro for updcrc
 */

#define updcrc(c,crc) (crctab[((crc >> 8) & 255) ^ ((c) & 255)] ^ (crc << 8))

/* crctab calculated by Mark G. Mendel, Network Systems Corporation */
Ushort crctab[256] = {
    0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50a5, 0x60c6, 0x70e7,
    0x8108, 0x9129, 0xa14a, 0xb16b, 0xc18c, 0xd1ad, 0xe1ce, 0xf1ef,
    0x1231, 0x0210, 0x3273, 0x2252, 0x52b5, 0x4294, 0x72f7, 0x62d6,
    0x9339, 0x8318, 0xb37b, 0xa35a, 0xd3bd, 0xc39c, 0xf3ff, 0xe3de,
    0x2462, 0x3443, 0x0420, 0x1401, 0x64e6, 0x74c7, 0x44a4, 0x5485,
    0xa56a, 0xb54b, 0x8528, 0x9509, 0xe5ee, 0xf5cf, 0xc5ac, 0xd58d,
    0x3653, 0x2672, 0x1611, 0x0630, 0x76d7, 0x66f6, 0x5695, 0x46b4,
    0xb75b, 0xa77a, 0x9719, 0x8738, 0xf7df, 0xe7fe, 0xd79d, 0xc7bc,
    0x48c4, 0x58e5, 0x6886, 0x78a7, 0x0840, 0x1861, 0x2802, 0x3823,
    0xc9cc, 0xd9ed, 0xe98e, 0xf9af, 0x8948, 0x9969, 0xa90a, 0xb92b,
    0x5af5, 0x4ad4, 0x7ab7, 0x6a96, 0x1a71, 0x0a50, 0x3a33, 0x2a12,
    0xdbfd, 0xcbdc, 0xfbbf, 0xeb9e, 0x9b79, 0x8b58, 0xbb3b, 0xab1a,
    0x6ca6, 0x7c87, 0x4ce4, 0x5cc5, 0x2c22, 0x3c03, 0x0c60, 0x1c41,
    0xedae, 0xfd8f, 0xcdec, 0xddcd, 0xad2a, 0xbd0b, 0x8d68, 0x9d49,
    0x7e97, 0x6eb6, 0x5ed5, 0x4ef4, 0x3e13, 0x2e32, 0x1e51, 0x0e70,
    0xff9f, 0xefbe, 0xdfdd, 0xcffc, 0xbf1b, 0xaf3a, 0x9f59, 0x8f78,
    0x9188, 0x81a9, 0xb1ca, 0xa1eb, 0xd10c, 0xc12d, 0xf14e, 0xe16f,
    0x1080, 0x00a1, 0x30c2, 0x20e3, 0x5004, 0x4025, 0x7046, 0x6067,
    0x83b9, 0x9398, 0xa3fb, 0xb3da, 0xc33d, 0xd31c, 0xe37f, 0xf35e,
    0x02b1, 0x1290, 0x22f3, 0x32d2, 0x4235, 0x5214, 0x6277, 0x7256,
    0xb5ea, 0xa5cb, 0x95a8, 0x8589, 0xf56e, 0xe54f, 0xd52c, 0xc50d,
    0x34e2, 0x24c3, 0x14a0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
    0xa7db, 0xb7fa, 0x8799, 0x97b8, 0xe75f, 0xf77e, 0xc71d, 0xd73c,
    0x26d3, 0x36f2, 0x0691, 0x16b0, 0x6657, 0x7676, 0x4615, 0x5634,
    0xd94c, 0xc96d, 0xf90e, 0xe92f, 0x99c8, 0x89e9, 0xb98a, 0xa9ab,
    0x5844, 0x4865, 0x7806, 0x6827, 0x18c0, 0x08e1, 0x3882, 0x28a3,
    0xcb7d, 0xdb5c, 0xeb3f, 0xfb1e, 0x8bf9, 0x9bd8, 0xabbb, 0xbb9a,
    0x4a75, 0x5a54, 0x6a37, 0x7a16, 0x0af1, 0x1ad0, 0x2ab3, 0x3a92,
    0xfd2e, 0xed0f, 0xdd6c, 0xcd4d, 0xbdaa, 0xad8b, 0x9de8, 0x8dc9,
    0x7c26, 0x6c07, 0x5c64, 0x4c45, 0x3ca2, 0x2c83, 0x1ce0, 0x0cc1,
    0xef1f, 0xff3e, 0xcf5d, 0xdf7c, 0xaf9b, 0xbfba, 0x8fd9, 0x9ff8,
    0x6e17, 0x7e36, 0x4e55, 0x5e74, 0x2e93, 0x3eb2, 0x0ed1, 0x1ef0
};

int
main(argc, argv)
	int argc;
	char *argv[];
{
	char messages[MAX_LINE];
	char ndiff_first_line[MAX_LINE];
	char buffer[MAX_LINE];
	int odayno, ndayno;
	Ushort ocrc, ncrc, crc, orcrc;
	register char *cp;
	int havenname;
	int e;

	int no_lines, no, number = 0; 	/* = 0 added by hsu? */
	int n;  
	
	if (argc < 3) {
		fprintf(stderr,
			"Usage: ndiff <noddiff> <nodelist path>\n");
		fprintf(stderr,
			"Or:    ndiff <noddiff> <old nodelist> <new nodelist>\n");
		exit(1);
	}

	/*
	 * First open up nodediff file, and read the first line of it
	 */
	strcpy(ndiffname, argv[1]);

	if ((ndiff = fopen(ndiffname, "r")) == NULL ) {
		sprintf(messages, "Can't open %s", ndiffname);
		perror(messages);
		exit(1);
	}
	n = getline(ndiff_first_line, MAX_LINE, ndiff, NULL);
	if (n <= 0) {
		fprintf(stderr, "Error on %s\n", ndiffname);
		exit(1);
	}

	/*
	 * Now, depending on the invocation style, we either
	 * generate the old- and new- nodelist filenames,
	 * or take them from the command line.
	 */
	if (argc == 4) {
		strcpy(onodename, argv[2]);
		strcpy(nnodename, argv[3]);
		havenname = 1;
	} else {
		parse_firstline(ndiff_first_line, &odayno, &ocrc, ndiffname);
		strcpy(nlpath, argv[2]);
		strcpy(onodename, nlpath);
		cp = onodename + strlen(onodename);
		sprintf(cp, ".%03d", odayno);
		strcpy(nnodename, nlpath);
		havenname = 0;
	}

	if ((onode = fopen(onodename, "r")) == NULL ) {
		sprintf(messages,"Can't open %s", onodename);
		perror(messages);
		exit(1);
	}
	
	/*
	 * Create a temporary name for the output file.
	 */
	strcpy(tmpnodename, nnodename);
	cp = strrchr(tmpnodename, '/');
	if (cp)
		cp++;
	else
		cp = tmpnodename;
	strcpy(cp, "ndifftmpXXXXXX");
	mktemp(tmpnodename);

	if ((nnode = fopen(tmpnodename, "w")) == NULL ) {
		sprintf(messages,"Can't open %s for output", tmpnodename);
		perror(messages);
		exit (1);
	} else
		chmod(nnodename, 0644);
  
	crc = 0;
	orcrc = 0;
	oiline = 0;
	noline = 0;

	/*
	 * Process the nodediff.
	 */
	while ((e = getline(buffer, MAX_LINE, ndiff, NULL)) != 0) {
		if (e == -1) {
			fprintf(stderr, "Error on %s\n", ndiffname);
			unlink(tmpnodename);
			exit(1);
		}
		if (buffer[0] == 'A') {	/* Add lines from the diff */
			no_lines = atoi(&buffer[1]);
			for (no = 1; no <= no_lines; no++) {
				e = getline(buffer, MAX_LINE, ndiff, NULL);
				if (e <= 0) {
					fprintf(stderr, "Error on %s\n",
						ndiffname);
					unlink(tmpnodename);
					exit(1);
				}
				if (noline == 0) {
					parse_firstline(buffer, &ndayno, &ncrc,
							onodename);
					putline(buffer, nnode, NULL);
				} else
					putline(buffer, nnode, &crc);
				noline++;
			}
		} else if (buffer[0] == 'C') { /* Copy lines from the old nodelist */
			no_lines = atoi(&buffer[1]);
			for (no = 1; no <= no_lines; no++) {
				if (getline(buffer, MAX_LINE, onode, oiline++ ? &orcrc : NULL) <= 0) {
					fprintf(stderr, "Error on %s\n",
						onodename);
					unlink(tmpnodename);
					exit(1);
				}
				if (noline == 0) {
					parse_firstline(buffer, &ndayno, &ncrc,
							onodename);
					putline(buffer, nnode, NULL);
				} else
					putline(buffer, nnode, &crc);
				noline++;
			}
		} else if (buffer[0] == 'D') { /* Delete lines from the old nodelist */
			no_lines = atoi(&buffer[1]);
			for (no = 1; no <= no_lines; no++) {
				if (getline(buffer, MAX_LINE, onode, oiline++ ? &orcrc : NULL) <= 0) {
					fprintf(stderr, "Error on %s\n",
						onodename);
					unlink(tmpnodename);
					exit(1);
				}
				number++;
				if (number == 1) {
					/*
					 * This is the first-line of
					 * the new nodediff file.
					 * Process it.
					 */
					if (strcmp(ndiff_first_line, buffer) != 0) {
						fprintf(stderr,"Wrong nodelist diff file\n");
						exit (1);
					}
				}
			}
		}
	}
	
	/*
	 * File is processed. Check crc, and if allright,
	 * rename the temporary file to the new nodelist name.
	 * and report success.
	 */
	fclose(onode);
	fclose(nnode);
	fclose(ndiff);
	if (ocrc != orcrc) {
		fprintf(stderr, "Crc error on old nodelist file\n");
		fprintf(stderr, "Good crc = %d, bad crc = %d\n", ocrc, orcrc);
		unlink(tmpnodename);
		exit(1);
	}
	if (crc != ncrc) {
		fprintf(stderr, "Crc error on new nodelist file\n");
		fprintf(stderr, "Good crc = %d, bad crc = %d\n", ncrc, crc);
		unlink(tmpnodename);
		exit(1);
	}
	cp = nnodename + strlen(nnodename);
	sprintf(cp, ".%03d", ndayno);
	unlink(nnodename);
	if (link(tmpnodename, nnodename) == -1) {
		perror("Link failed");
		unlink(tmpnodename);
		exit(1);
	} 
	if (unlink(tmpnodename) == -1) {
		perror(tmpnodename);
		exit(1);
	}

	printf("Nodelist %s successfully created.\n", nnodename);
				    
	exit(0);
	return 0;
}

/* 
 * Read a line, strip end-line character, return length
 */
static int
getline(line, max, fd, crcp)
	char *line;
	int max;
	FILE *fd;
	Ushort *crcp;
{
	register char *cp = line;
	char *ce = line + max;
	register int c;

	if (ferror(fd))
		return -1;
	while ((c = getc(fd)) != -1) {
		if (c == 032)		/* DOS EOF character */
			break;
		if (crcp) {
			if (c != '\r') {
				if (c == '\n')
					*crcp = updcrc('\r', *crcp);
				*crcp = updcrc(c, *crcp);
			}
		}
		if (c == '\n')
			break;
		if (cp == ce)
			return -1;
		if (c != '\r')
			*cp++ = c;
	}
	*cp = 0;
	return cp - line;
}


static void
parse_firstline(first_line, dayno, crc, fname)
	char *first_line;
	int *dayno;
	Ushort *crc;
	char *fname;
{
	register char *cp, *cp1;

	cp1 = strrchr(first_line, ':');
	if (cp1 == NULL)
		goto bad;
	cp = cp1 + 1;
	while (isspace(*cp))
		cp++;
	if (!isdigit(*cp))
		goto bad;
	*crc = atoi(cp);

	cp = cp1 - 1;
	while (cp > first_line && isspace(*cp))
		cp--;
	while (cp > first_line && isdigit(*cp))
		cp--;
	if (!isspace(cp[0]) || !isdigit(cp[1]))
		goto bad;
	*dayno = atoi(cp+1);
	if (*dayno == 0 || *dayno > 366)
		goto bad;
	return;

 bad:
	fprintf(stderr, "Processing error on file %s:\n", fname);
	fprintf(stderr, "Illegal format on first line:\n%s\n", first_line);
	exit(1);
}

static void
putline(line, fp, crcp)
	char *line;
	FILE *fp;
	Ushort *crcp;
{
	register Ushort crc;
	register int c;

	if (crcp)
		crc = *crcp;
	while (c = *line++) {
		putc(c, fp);
		crc = updcrc(c, crc);
	}
	putc('\n', fp);
	crc = updcrc('\r', crc);
	crc = updcrc('\n', crc);
	if (crcp)
		*crcp = crc;
}
