/*
 * gethostname.c: Emulation of the gethostname() function call
 *
 *
 * $Header: /u1/src/rfmail/RCS/gethostnam.c,v 0.5 1992/05/18 04:27:24 pgd Exp pgd $
 *
 * $Log: gethostnam.c,v $
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.5  1991/09/07  10:37:46  pgd
 * not finished revision check-in
 *
 * gethostname() was broken for PHOSTNAME conditional compilation.
 *
 * Revision 0.4  1991/05/08  04:36:28  pgd
 * Initial Beta-release
 *
 *
 */


/* Get host name. This emulates routine with same name in BSD-Unix.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */
 

/*
 * Authors:
 *
 * Teemu Torma who wrote the original code (?)
 *
 * Heikki Suonsivu (hsu@hutcs.hut.fi) who made a lot of enhancements
 * 
 * Per Lindqvist (pgd@compuram.bbt.se) who continued to enhance rfmail.
 */

#ifndef GETHOSTNAME

#include "fnet.h"

#ifdef DOUNAME

#include <sys/utsname.h>

DECLARE(int, uname, (struct utsname *));

/* Get name of this uucp-node. Name is stored in buffer. Len in maximum
   length of buffer. Return -1 if can not do uname(2), otherwise 0. */

int
gethostname(buffer, len)
	char *buffer;
	int len;
{
	struct utsname name;
  
	if (uname(&name) == -1)
		return -1;
	strncpy(buffer, name.nodename, len);
	buffer[len - 1] = 0;
	return 0;
}

#else

#ifdef PHOSTNAME
/*
 * Get host name through a shell command
 */
int
gethostname(buffer, len)
	char *buffer;
	int len;
{
	char buf[1024];		/* Should be big enough */
	FILE *fp;

	fp = popen(PHOSTNAME,"r");
	
	if (fp == NULL) {
		buglog("Can't find hostname with the %s command\n", PHOSTNAME);
		fatal(0, "Can't find hostname");
	}
	fgets(buf,sizeof buf,fp);
	buf[strlen(buf)-1] = '\0';	/* wipe out newline */
	strncpy(buffer, buf, len);
	pclose(fp);
}
#else

#ifdef USE_WHOAMI
#include <whoami.h>

/*
 * Get hostname through the WHOAMI symbol
 */
int
gethostname(buffer, len)
	char *buffer;
	int len;
{
	strncpy(buffer, sysname, len);
}

#endif /* USE_WHOAMI */
#endif /* DOUNAME */
#endif /* PHOSTNAME */
#endif /* GETHOSTNAME */
