%token ID MONTH DAY MERIDIAN NUMBER UNIT MUNIT SUNIT ZONE DAYZONE AGO
%{
	/* 	Originally from: Steven M. Bellovin (unc!smb)	*/ 
	/*	Dept. of Computer Science			*/
	/*	University of North Carolina at Chapel Hill	*/
	/*	@(#)getdate.y	2.17	11/30/87			*/

/*
 * $Header: /u1/src/rfmail/RCS/getdate.y,v 0.5 1992/05/18 04:24:33 pgd Exp pgd $
 *
 * $Log: getdate.y,v $
 * Revision 0.5  1992/05/18  04:24:33  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.5  1991/09/07  10:37:46  pgd
 * not finished revision check-in
 *
 * Added a lot of time-zones. Corrected some.
 *
 * Revision 0.4.1.2  1991/05/21  18:34:15  pgd
 * Problems with some unix compilers not accepting unary +
 *
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 */

#include "fnet.h"

#define daysec (24L*60L*60L)
static int timeflag, zoneflag, dateflag, dayflag, relflag;
static time_t relsec, relmonth;
static int hh, mm, ss, merid;
#ifdef BSD
static int daylight;
#else
extern int daylight;
#endif
static int dayord, dayreq;
static int month, day, year;
static int ourzone;

#define AM 1
#define PM 2
#define DAYLIGHT 1
#define STANDARD 2
#define MAYBE    3

static int lookup();
static void yyerror();
static int yylex();
/* #define	YYPURE */
%}

%%
timedate: 		/* empty */
	| timedate item;

item:	tspec =
		{timeflag++;}
	| zone =
		{zoneflag++;}
	| dtspec =
		{dateflag++;}
	| dyspec =
		{dayflag++;}
	| rspec =
		{relflag++;}
	| nspec;

nspec:	NUMBER '.' NUMBER '.' NUMBER = {
			if (dateflag && !timeflag) {
				hh = $1; mm = $3; ss = $5;
				timeflag++;
			} else if (!dateflag) {
				year = $1; month = $3; day = $5;
				dateflag++;
			} else
			       YYERROR;
		}

	| NUMBER =
		{if (timeflag && dateflag && !relflag) year = $1;
		else {timeflag++;hh = $1/100;mm = $1%100;ss = 0;merid = 24;}};

tspec:	NUMBER MERIDIAN =
		{hh = $1; mm = 0; ss = 0; merid = $2;}
	| NUMBER ':' NUMBER =
		{hh = $1; mm = $3; merid = 24;}
	| NUMBER ':' NUMBER MERIDIAN =
		{hh = $1; mm = $3; merid = $4;}
	| NUMBER ':' NUMBER '+' NUMBER =
		{hh = $1; mm = $3; merid = 24;
		daylight = STANDARD; ourzone = -($4%100 + 60*($4/100));}
	| NUMBER ':' NUMBER '-' NUMBER =
		{hh = $1; mm = $3; merid = 24;
		daylight = STANDARD; ourzone = ($4%100 + 60*($4/100));}
	| NUMBER ':' NUMBER ':' NUMBER =
		{hh = $1; mm = $3; ss = $5; merid = 24;}
/* Yet another speculated variation on the time format. */
	| NUMBER ':' NUMBER '/' NUMBER =
		{hh = $1; mm = $3; ss = $5; merid = 24;}
	| NUMBER ':' NUMBER ':' NUMBER MERIDIAN =
		{hh = $1; mm = $3; ss = $5; merid = $6;}
	| NUMBER ':' NUMBER ':' NUMBER '+' NUMBER =
		{hh = $1; mm = $3; ss = $5; merid = 24;
		daylight = STANDARD; ourzone = -($6%100 + 60*($6/100));};
	| NUMBER ':' NUMBER ':' NUMBER '-' NUMBER =
		{hh = $1; mm = $3; ss = $5; merid = 24;
		daylight = STANDARD; ourzone = ($6%100 + 60*($6/100));};

zone:	ZONE =
		{ourzone = $1; daylight = STANDARD;}
	| DAYZONE =
		{ourzone = $1; daylight = DAYLIGHT;};

dyspec:	DAY =
		{dayord = 1; dayreq = $1;}
	| DAY ',' =
		{dayord = 1; dayreq = $1;}
	| NUMBER DAY =
		{dayord = $1; dayreq = $2;};

dtspec:	NUMBER '/' NUMBER =
		{month = $1; day = $3;}
	| NUMBER '/' NUMBER '/' NUMBER =
		{month = $1; day = $3; year = $5;}
	| MONTH NUMBER =
		{month = $1; day = $2;}
	| MONTH NUMBER ',' NUMBER =
		{month = $1; day = $2; year = $4;}
	| NUMBER MONTH =
		{month = $2; day = $1;}
	| NUMBER MONTH NUMBER =
		{month = $2; day = $1; year = $3;};


rspec:	NUMBER UNIT =
		{relsec +=  60L * $1 * $2;}
	| NUMBER MUNIT =
		{relmonth += $1 * $2;}
	| NUMBER SUNIT =
		{relsec += $1;}
	| UNIT =
		{relsec +=  60L * $1;}
	| MUNIT =
		{relmonth += $1;}
	| SUNIT =
		{relsec++;}
	| rspec AGO =
		{relsec = -relsec; relmonth = -relmonth;};
%%

static int mdays[12] =
	{31, 0, 31,  30, 31, 30,  31, 31, 30,  31, 30, 31};
#define epoch 1970

extern struct tm *localtime();

time_t
dateconv(mo, dy, yr, h, m, s, mer, zone, dyflag)
	int mo, dy, yr, h, m, s, mer, zone, dyflag;
{
	time_t tod, jdate;
	register int i;
	time_t timeconv();

	if (yr < 0) yr = -yr;
	if (yr < 100) yr += 1900;
	mdays[1] = 28 + (yr%4 == 0 && (yr%100 != 0 || yr%400 == 0));
	if (yr < epoch || yr > 1999 || mo < 1 || mo > 12 ||
		dy < 1 || dy > mdays[--mo]) return (-1);
	jdate = dy-1;
        for (i=0; i<mo; i++) jdate += mdays[i];
	for (i = epoch; i < yr; i++) jdate += 365 + (i%4 == 0);
	jdate *= daysec;
	jdate += zone * 60L;
	if ((tod = timeconv(h, m, s, mer)) < 0) return (-1);
	jdate += tod;
	if (dyflag==DAYLIGHT || (dyflag==MAYBE&&localtime(&jdate)->tm_isdst))
		jdate += -1*60*60;
	return (jdate);
}

time_t
dayconv(ord, dy, now)
	int ord, dy; time_t now;
{
	register struct tm *loctime;
	time_t tod;
	time_t daylcorr();

	tod = now;
	loctime = localtime(&tod);
	tod += daysec * ((dy - loctime->tm_wday + 7) % 7);
	tod += 7*daysec*(ord<=0?ord:ord-1);
	return daylcorr(tod, now);
}

time_t
timeconv(hour, min, sec, mer)
	int hour, min, sec, mer;
{
	if (min < 0 || min > 59 || sec < 0 || sec > 59) return (-1);
	switch (mer) {
		case AM: if (hour < 1 || hour > 12) return(-1);
			 return (60L * ((hour%12)*60L + min)+sec);
		case PM: if (hour < 1 || hour > 12) return(-1);
			 return (60L * ((hour%12 +12)*60L + min)+sec);
		case 24: if (hour < 0 || hour > 23) return (-1);
			 return (60L * (hour*60L + min)+sec);
		default: return (-1);
	}
}

time_t
monthadd(sdate, relmon)
	time_t sdate, relmon;
{
	struct tm *ltime;
	time_t dateconv();
	time_t daylcorr();
	int mon, yr;

	if (relmon == 0) return 0;
	ltime = localtime(&sdate);
	mon = 12*ltime->tm_year + ltime->tm_mon + relmon;
	yr = mon/12;
	mon = mon%12 + 1;
	return daylcorr(dateconv(mon, ltime->tm_mday, yr, ltime->tm_hour,
		ltime->tm_min, ltime->tm_sec, 24, ourzone, MAYBE), sdate);
}

time_t
daylcorr(future, now)
time_t future, now;
{
	int fdayl, nowdayl;

	nowdayl = (localtime(&now)->tm_hour+1) % 24;
	fdayl = (localtime(&future)->tm_hour+1) % 24;
	return (future-now) + 60L*60L*(nowdayl-fdayl);
}

static char *lptr;

static int
yylex()
{
	extern int yylval;
	register char c;
	register char *p;
	char idbuf[20];
	int pcnt;

	for (;;) {
		while (isspace(*lptr))
			lptr++;

#if 1
		if (isdigit(c = *lptr)) {
#else
		if (isdigit(c = *lptr) || c == '-' || c == '+') {
			if (c== '-' || c == '+') {
				if (c=='-') sign = -1;
				else sign = 1;
				if (!isdigit(*++lptr)) {
					/* yylval = sign; return (NUMBER); */
					return yylex();	/* skip the '-' sign */
				}
			} else sign = 1;
#endif
			yylval = 0;
			while (isdigit(c = *lptr++))
				yylval = 10*yylval + c - '0';
/*			yylval *= sign; */
			lptr--;
			return (NUMBER);

		} else if (isalpha(c)) {
			p = idbuf;
			while (isalpha(c = *lptr++) || c=='.')
				if (p < &idbuf[sizeof(idbuf)-1]) *p++ = c;
			*p = '\0';
			lptr--;
			return (lookup(idbuf));
		}

		else if (c == '(') {
			pcnt = 0;
			do {
				c = *lptr++;
				if (c == '\0') return(c);
				else if (c == '(') pcnt++;
				else if (c == ')') pcnt--;
			} while (pcnt > 0);
		}

		else return (*lptr++);
	}
}

struct table {
	char *name;
	int type, value;
};

struct table mdtab[] = {
	{"january", 	MONTH, 1},
	{"february", 	MONTH, 2},
	{"march", 	MONTH, 3},
	{"april", 	MONTH, 4},
	{"may", 	MONTH, 5},
	{"june", 	MONTH, 6},
	{"july", 	MONTH, 7},
	{"august", 	MONTH, 8},
	{"september", 	MONTH, 9},
	{"sept", 	MONTH, 9},
	{"october", 	MONTH, 10},
	{"november", 	MONTH, 11},
	{"december", 	MONTH, 12},

	{"sunday", 	DAY, 0},
	{"monday", 	DAY, 1},
	{"tuesday", 	DAY, 2},
	{"tues", 	DAY, 2},
	{"wednesday", 	DAY, 3},
	{"wednes", 	DAY, 3},
	{"thursday", 	DAY, 4},
	{"thur", 	DAY, 4},
	{"thurs", 	DAY, 4},
	{"friday", 	DAY, 5},
	{"saturday", 	DAY, 6},

#ifdef SWEDISH
/*
 * Swedish names, where they differ, used by some mailers
 */
	{"januari", 	MONTH, 1},
	{"februari", 	MONTH, 2},
	{"mars", 	MONTH, 3},
	{"april", 	MONTH, 4},
	{"maj", 	MONTH, 5},
	{"juni", 	MONTH, 6},
	{"juli",	MONTH, 7},
	{"augusti",	MONTH, 8},
	{"september",	MONTH, 9},
	{"oktober",	MONTH, 10},
	{"november",	MONTH, 11},
#endif

	{0, 0, 0}};

#define HRS *60
#define HALFHR 30
struct table mztab[] = {
	{"a.m.", MERIDIAN, AM},
	{"am", MERIDIAN, AM},
	{"p.m.", MERIDIAN, PM},
	{"pm", MERIDIAN, PM},

    {"gmt",	ZONE,	 0 HRS},	/* Greenwich Mean time */
    {"g.m.t.",	ZONE,	 0 HRS},
    {"ut",	ZONE,	 0 HRS},	/* Universal time (Coordinated) */
    {"utc",	ZONE,	 0 HRS},
    {"bst",	DAYZONE, 0 HRS},	/* British Summer time */
    {"b.s.t.",	DAYZONE, 0 HRS},
    {"wet",	ZONE,	 0 HRS },	/* Western European time */
    {"w.e.t.",	ZONE,	 0 HRS },
    {"west",	DAYZONE,-1 HRS},	/* Western European Summer time */
    {"w.e.s.t.",DAYZONE,-1 HRS},
    {"cet",	ZONE,	-1 HRS},	/* Central European time */
    {"met",	ZONE,	-1 HRS},	/* Middle European time */
    {"m.e.t.",	ZONE,	-1 HRS},
    {"mewt",	ZONE,	-1 HRS},	/* Middle European Winter time */
    {"m.e.w.t.",ZONE,	-1 HRS},
    {"mest",	DAYZONE,-1 HRS},	/* Middle European Summer time */
    {"m.e.s.t.",DAYZONE,-1 HRS},
    {"swt",	ZONE,	-1 HRS},	/* Swedish Winter time */
    {"sst",	DAYZONE,-1 HRS},	/* Swedish Summer time */
    {"fwt",	ZONE,	-1 HRS},	/* French Winter time */
    {"fst",	DAYZONE,-1 HRS},	/* French Summer time */
    {"eet",	ZONE,	-2 HRS},	/* European Eastern, USSR Zone 1 */
    {"e.e.t.",	ZONE,	-2 HRS},
    {"eest",	DAYZONE,-2 HRS},	/* European Eastern Summer time */
    {"e.e.s.t.",DAYZONE,-2 HRS},
    {"at",	ZONE,	-2 HRS},	/* Azores time */
    {"bt",	ZONE,	-3 HRS},	/* Baghdad, USSR Zone 2 */
    {"it",	ZONE,	-3 HRS-HALFHR}, /* Iranian time */
    {"zp4",	ZONE,	-4 HRS},	/* USSR Zone 3 */
    {"zp5",	ZONE,	-5 HRS},	/* USSR Zone 4 */
    {"ist",	ZONE,	-5 HRS-HALFHR},	/* Indian Standard time */
    {"zp6",	ZONE,	-6 HRS},	/* USSR Zone 5 */
    {"wast",	ZONE,	-7 HRS},	/* West Australian Standard time */
    {"wadt",	DAYZONE,-7 HRS},	/* West Australian Daylight time */
    {"jt",	ZONE,	-7 HRS-HALFHR},	/* Java time (3pm in Cronusland!) */
    {"cct",	ZONE,	-8 HRS},	/* China Coast, USSR Zone 7 */
    {"awst",	ZONE,	-8 HRS},	/* Australian Western Time */
    {"a.w.s.t.",ZONE,	-8 HRS},	/* (no daylight time there, I'm told */
    {"jst",	ZONE,	-9 HRS},	/* Japan Standard, USSR Zone 8 */
    {"j.s.t.",	ZONE,	-9 HRS},	/* Japan Standard */
    {"cast",	ZONE,	-9 HRS-HALFHR}, /* Central Australian Standard time */
    {"cadt",	ZONE,	-9 HRS-HALFHR},	/* Central Australian Daylight time */
    {"acst",	ZONE,	-9 HRS-HALFHR}, /* Australian Central Time */
    {"a.c.s.t.",ZONE,	-9 HRS-HALFHR},
    {"acsst", 	DAYZONE,-9 HRS-HALFHR}, /* Australian Central Summer time */
    {"a.c.s.s.t.",DAYZONE,-9 HRS-HALFHR},
    {"east",	ZONE,	-10 HRS},	/* Eastern Australian Standard time */
    {"eadt",	DAYZONE,-10 HRS},	/* Eastern Australian Daylight time */
    {"aest",	ZONE,	-10 HRS},	/* Australian Eastern Standard time */
    {"a.e.s.t.",ZONE,	-10 HRS},
    {"aesst",	DAYZONE,-10 HRS},	/* Australian Eastern Summer time */
    {"a.e.s.s.t.",DAYZONE,-10 HRS},
    {"gst",	ZONE,	-10 HRS},	/* Guam Standard, USSR Zone 9 */
    {"nzt",	ZONE,	-12 HRS},	/* New Zeeland time */
    {"nzst",	ZONE,	-12 HRS},	/* New Zeeland Standard time */
    {"nzdt",	DAYZONE,-12 HRS},	/* New Zeeland Daylight time */
    {"idle",	ZONE,	-12 HRS},	/* International Date Line East */

    {"wat",	ZONE,	1 HRS},		/* West African time */
    {"sat",	ZONE,	2 HRS},		/* South African Time */
    {"s.a.t.",	ZONE,	2 HRS},
    {"sast",	ZONE,	2 HRS},		/* South African Standard time */
    {"s.a.s.t.",ZONE,	2 HRS},
    {"nft",	ZONE,	3 HRS+HALFHR},	/* Newfoundland time */
    {"nst",	ZONE,	3 HRS+HALFHR},	/* Newfoundland Standard time */
    {"n.s.t.",	ZONE,	3 HRS+HALFHR},
    {"ndt",	DAYZONE,3 HRS+HALFHR},	/* Newfoundland Daylight time */
    {"ast",	ZONE,	4 HRS},		/* Atlantic Standard time */
    {"a.s.t.",	ZONE,	4 HRS},
    {"adt",	DAYZONE,4 HRS},		/* Atlantic Daylight time */
    {"a.d.t.",	DAYZONE,4 HRS},
    {"est",	ZONE,	5 HRS},		/* Eastern Standard time */
    {"e.s.t.",	ZONE,	5 HRS},
    {"edt",	DAYZONE,5 HRS},		/* Eastern Daylight time */
    {"e.d.t.",	DAYZONE,5 HRS},
    {"cst",	ZONE,	6 HRS},		/* Central Standard time */
    {"c.s.t.",	ZONE,	6 HRS},
    {"cdt",	DAYZONE,6 HRS},		/* Central Daylight time */
    {"c.d.t.",	DAYZONE,6 HRS},
    {"mst",	ZONE,	7 HRS},		/* Mountain Standard time */
    {"m.s.t.",	ZONE,	7 HRS},
    {"mdt",	DAYZONE,7 HRS},		/* Mountain Daylight time */
    {"m.d.t.", 	DAYZONE,7 HRS},
    {"pst", 	ZONE,	8 HRS},		/* Pacific Standard time */
    {"p.s.t.", 	ZONE,	8 HRS},
    {"pdt", 	DAYZONE,8 HRS},		/* Pacific Daylight time */
    {"p.d.t.", 	DAYZONE,8 HRS},
    {"yst", 	ZONE,	9 HRS},		/* Yukon Standard time */
    {"y.s.t.", 	ZONE,	9 HRS},
    {"ydt", 	DAYZONE,9 HRS},		/* Yukon Daylight time */
    {"y.d.t.", 	DAYZONE,9 HRS},
    {"hst", 	ZONE,	10 HRS},	/* Hawaii Standard time */
    {"h.s.t.", 	ZONE,	10 HRS},
    {"hdt", 	DAYZONE,10 HRS},	/* Hawaii Daylight time */
    {"h.d.t.", 	DAYZONE,10 HRS},
    {"cat",	ZONE,	10 HRS},	/* Central Alaska time */
    {"ahst", 	ZONE,	10 HRS},	/* Alaska-Hawaii Standard time */
    {"nt", 	ZONE,	11 HRS},	/* Nome time */
    {"idlw", 	ZONE,	12 HRS},	/* International Date Line West */

    {0, 0, 0}};

struct table unittb[] = {
	{"year", MUNIT, 12},
	{"month", MUNIT, 1},
	{"fortnight", UNIT, 14*24*60},
	{"week", UNIT, 7*24*60},
	{"day", UNIT, 1*24*60},
	{"hour", UNIT, 60},
	{"minute", UNIT, 1},
	{"min", UNIT, 1},
	{"second", SUNIT, 1},
	{"sec", SUNIT, 1},
	{0, 0, 0}};

struct table othertb[] = {
	{"tomorrow", UNIT, 1*24*60},
	{"yesterday", UNIT, -1*24*60},
	{"today", UNIT, 0},
	{"now", UNIT, 0},
	{"last", NUMBER, -1},
	{"this", UNIT, 0},
	{"next", NUMBER, 2},
	{"first", NUMBER, 1},
	/* {"second", NUMBER, 2}, */
	{"third", NUMBER, 3},
	{"fourth", NUMBER, 4},
	{"fifth", NUMBER, 5},
	{"sixth", NUMBER, 6},
	{"seventh", NUMBER, 7},
	{"eight", NUMBER, 8},
	{"ninth", NUMBER, 9},
	{"tenth", NUMBER, 10},
	{"eleventh", NUMBER, 11},
	{"twelfth", NUMBER, 12},
	{"ago", AGO, 1},
	{0, 0, 0}};

struct table milzone[] = {
	{"a", ZONE, 1 HRS},
	{"b", ZONE, 2 HRS},
	{"c", ZONE, 3 HRS},
	{"d", ZONE, 4 HRS},
	{"e", ZONE, 5 HRS},
	{"f", ZONE, 6 HRS},
	{"g", ZONE, 7 HRS},
	{"h", ZONE, 8 HRS},
	{"i", ZONE, 9 HRS},
	{"k", ZONE, 10 HRS},
	{"l", ZONE, 11 HRS},
	{"m", ZONE, 12 HRS},
	{"n", ZONE, -1 HRS},
	{"o", ZONE, -2 HRS},
	{"p", ZONE, -3 HRS},
	{"q", ZONE, -4 HRS},
	{"r", ZONE, -5 HRS},
	{"s", ZONE, -6 HRS},
	{"t", ZONE, -7 HRS},
	{"u", ZONE, -8 HRS},
	{"v", ZONE, -9 HRS},
	{"w", ZONE, -10 HRS},
	{"x", ZONE, -11 HRS},
	{"y", ZONE, -12 HRS},
	{"z", ZONE, 0 HRS},
	{0, 0, 0}};

static int
lookup(id)
	char *id;
{
#define gotit (yylval=i->value,  i->type)

	char idvar[128];
	register char *j, *k;
	register struct table *i;
	int abbrev;

	(void) strcpy(idvar, id);
	j = idvar;
	k = id - 1;
	while (*++k)
		*j++ = isupper(*k) ? tolower(*k) : *k;
	*j = '\0';

	if (strlen(idvar) == 3)
		abbrev = 1;
	else
		if (strlen(idvar) == 4 && idvar[3] == '.') {
			abbrev = 1;
			idvar[3] = '\0';
		}
	else
		abbrev = 0;

	for (i = mdtab; i->name; i++) {
		k = idvar;
		for (j = i->name; *j++ == *k++;) {
			if (abbrev && j == i->name+3)
				return gotit;
			if (j[-1] == 0)
				return gotit;
		}
	}

	for (i = mztab; i->name; i++)
		if (strcmp(i->name, idvar) == 0)
			return gotit;

	for (i=mztab; i->name; i++)
		if (strcmp(i->name, idvar) == 0)
			return gotit;

	for (i=unittb; i->name; i++)
		if (strcmp(i->name, idvar) == 0)
			return gotit;

	if (idvar[strlen(idvar)-1] == 's')
		idvar[strlen(idvar)-1] = '\0';

	for (i=unittb; i->name; i++)
		if (strcmp(i->name, idvar) == 0)
			return gotit;

	for (i = othertb; i->name; i++)
		if (strcmp(i->name, idvar) == 0)
			return gotit;

	if (strlen(idvar) == 1 && isalpha(*idvar)) {
		for (i = milzone; i->name; i++)
			if (strcmp(i->name, idvar) == 0)
				return gotit;
	}

	return ID;
}

time_t
parsedate(p, now)
	char *p;
	struct timeb *now;
{
#define mcheck(f)	if (f>1) err++
	time_t monthadd();
	int err;
	struct tm *lt;
	struct timeb ftz;

	time_t sdate, tod;

	lptr = p;
	if (now == ((struct timeb *) NULL)) {
		now = &ftz;
		ftime(&ftz);
	}
	lt = localtime(&now->time);
	year = lt->tm_year;
	month = lt->tm_mon+1;
	day = lt->tm_mday;
	relsec = 0; relmonth = 0;
	timeflag=zoneflag=dateflag=dayflag=relflag=0;
	ourzone = now->timezone;
	daylight = MAYBE;
	hh = mm = ss = 0;
	merid = 24;

	if (err = yyparse()) return (-1);

	mcheck(timeflag);
	mcheck(zoneflag);
	mcheck(dateflag);
	mcheck(dayflag);

	if (err) return (-1);
	if (dateflag || timeflag || dayflag) {
		sdate = dateconv(month,day,year,hh,mm,ss,merid,ourzone,daylight);
		if (sdate < 0) return -1;
	}
	else {
		sdate = now->time;
		if (relflag == 0)
			sdate -= (lt->tm_sec + lt->tm_min*60 +
				lt->tm_hour*(60L*60L));
	}

	sdate += relsec;
	sdate += monthadd(sdate, relmonth);

	if (dayflag && !dateflag) {
		tod = dayconv(dayord, dayreq, sdate);
		sdate += tod;
	}

	/*
	** Have to do *something* with a legitimate -1 so it's distinguishable
	** from the error return value.  (Alternately could set errno on error.)
	*/
	return (sdate == -1) ? 0 : sdate;
}

static void
yyerror(s) char *s;
{}
