
/*  A Bison parser, made from getdate.y  */

#define YYBISON 1  /* Identify Bison output.  */

#define	ID	258
#define	MONTH	259
#define	DAY	260
#define	MERIDIAN	261
#define	NUMBER	262
#define	UNIT	263
#define	MUNIT	264
#define	SUNIT	265
#define	ZONE	266
#define	DAYZONE	267
#define	AGO	268

#line 2 "getdate.y"

	/* 	Originally from: Steven M. Bellovin (unc!smb)	*/ 
	/*	Dept. of Computer Science			*/
	/*	University of North Carolina at Chapel Hill	*/
	/*	@(#)getdate.y	2.17	11/30/87			*/

/*
 * $Header: /u1/src/rfmail/RCS/getdate.y,v 0.5 1992/05/18 04:24:33 pgd Exp pgd $
 *
 * $Log: getdate.y,v $
 * Revision 0.5  1992/05/18  04:24:33  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.5  1991/09/07  10:37:46  pgd
 * not finished revision check-in
 *
 * Added a lot of time-zones. Corrected some.
 *
 * Revision 0.4.1.2  1991/05/21  18:34:15  pgd
 * Problems with some unix compilers not accepting unary +
 *
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 */

#include "fnet.h"

#define daysec (24L*60L*60L)
static int timeflag, zoneflag, dateflag, dayflag, relflag;
static time_t relsec, relmonth;
static int hh, mm, ss, merid;
#ifdef BSD
static int daylight;
#else
extern int daylight;
#endif
static int dayord, dayreq;
static int month, day, year;
static int ourzone;

#define AM 1
#define PM 2
#define DAYLIGHT 1
#define STANDARD 2
#define MAYBE    3

static int lookup();
static void yyerror();
static int yylex();
/* #define	YYPURE */

#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#ifndef YYSTYPE
#define YYSTYPE int
#endif
#include <stdio.h>

#ifndef __STDC__
#define const
#endif



#define	YYFINAL		54
#define	YYFLAG		-32768
#define	YYNTBASE	20

#define YYTRANSLATE(x) ((unsigned)(x) <= 268 ? yytranslate[x] : 28)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    16,    19,    17,    14,    18,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    15,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     4,     6,     8,    10,    12,    14,    16,    22,
    24,    27,    31,    36,    42,    48,    54,    60,    67,    75,
    83,    85,    87,    89,    92,    95,    99,   105,   108,   113,
   116,   120,   123,   126,   129,   131,   133,   135
};

#endif

static const short yyrhs[] = {    -1,
    20,    21,     0,    23,     0,    24,     0,    26,     0,    25,
     0,    27,     0,    22,     0,     7,    14,     7,    14,     7,
     0,     7,     0,     7,     6,     0,     7,    15,     7,     0,
     7,    15,     7,     6,     0,     7,    15,     7,    16,     7,
     0,     7,    15,     7,    17,     7,     0,     7,    15,     7,
    15,     7,     0,     7,    15,     7,    18,     7,     0,     7,
    15,     7,    15,     7,     6,     0,     7,    15,     7,    15,
     7,    16,     7,     0,     7,    15,     7,    15,     7,    17,
     7,     0,    11,     0,    12,     0,     5,     0,     5,    19,
     0,     7,     5,     0,     7,    18,     7,     0,     7,    18,
     7,    18,     7,     0,     4,     7,     0,     4,     7,    19,
     7,     0,     7,     4,     0,     7,     4,     7,     0,     7,
     8,     0,     7,     9,     0,     7,    10,     0,     8,     0,
     9,     0,    10,     0,    27,    13,     0
};

#if YYDEBUG != 0
static const short yyrline[] = { 0,
    60,    61,    63,    65,    67,    69,    71,    73,    75,    86,
    90,    92,    94,    96,    99,   102,   105,   107,   109,   112,
   116,   118,   121,   123,   125,   128,   130,   132,   134,   136,
   138,   142,   144,   146,   148,   150,   152,   154
};

static const char * const yytname[] = {   "$","error","$illegal.","ID","MONTH",
"DAY","MERIDIAN","NUMBER","UNIT","MUNIT","SUNIT","ZONE","DAYZONE","AGO","'.'",
"':'","'+'","'-'","'/'","','","timedate","item","nspec","tspec","zone","dyspec",
"dtspec","rspec",""
};
#endif

static const short yyr1[] = {     0,
    20,    20,    21,    21,    21,    21,    21,    21,    22,    22,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    24,    24,    25,    25,    25,    26,    26,    26,    26,    26,
    26,    27,    27,    27,    27,    27,    27,    27
};

static const short yyr2[] = {     0,
     0,     2,     1,     1,     1,     1,     1,     1,     5,     1,
     2,     3,     4,     5,     5,     5,     5,     6,     7,     7,
     1,     1,     1,     2,     2,     3,     5,     2,     4,     2,
     3,     2,     2,     2,     1,     1,     1,     2
};

static const short yydefact[] = {     1,
     0,     0,    23,    10,    35,    36,    37,    21,    22,     2,
     8,     3,     4,     6,     5,     7,    28,    24,    30,    25,
    11,    32,    33,    34,     0,     0,     0,    38,     0,    31,
     0,    12,    26,    29,     0,    13,     0,     0,     0,     0,
     0,     9,    16,    14,    15,    17,    27,    18,     0,     0,
    19,    20,     0,     0
};

static const short yydefgoto[] = {     1,
    10,    11,    12,    13,    14,    15,    16
};

static const short yypact[] = {-32768,
     8,     0,   -16,    -4,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,     9,   -10,-32768,    16,-32768,
-32768,-32768,-32768,-32768,    19,    20,    21,-32768,    22,-32768,
    11,    15,    23,-32768,    29,-32768,    30,    31,    32,    33,
    35,-32768,    18,-32768,-32768,-32768,-32768,-32768,    36,    37,
-32768,-32768,    45,-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768
};


#define	YYLAST		45


static const short yytable[] = {    19,
    20,    21,    18,    22,    23,    24,    17,    53,    29,    25,
    26,     2,     3,    27,     4,     5,     6,     7,     8,     9,
    36,    28,    30,    48,    35,    31,    32,    33,    34,    37,
    38,    39,    40,    49,    50,    42,    43,    44,    45,    46,
    41,    47,    51,    52,    54
};

static const short yycheck[] = {     4,
     5,     6,    19,     8,     9,    10,     7,     0,    19,    14,
    15,     4,     5,    18,     7,     8,     9,    10,    11,    12,
     6,    13,     7,     6,    14,     7,     7,     7,     7,    15,
    16,    17,    18,    16,    17,     7,     7,     7,     7,     7,
    18,     7,     7,     7,     0
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#define YYLEX		yylex(&yylval, &yylloc)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_bcopy(FROM,TO,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (char *from, char *to, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 169 "/usr/lib/bison.simple"
int
yyparse()
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
#ifdef YYLSP_NEEDED
		 &yyls1, size * sizeof (*yylsp),
#endif
		 &yystacksize);

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symboles being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 3:
#line 64 "getdate.y"
{timeflag++;;
    break;}
case 4:
#line 66 "getdate.y"
{zoneflag++;;
    break;}
case 5:
#line 68 "getdate.y"
{dateflag++;;
    break;}
case 6:
#line 70 "getdate.y"
{dayflag++;;
    break;}
case 7:
#line 72 "getdate.y"
{relflag++;;
    break;}
case 9:
#line 75 "getdate.y"
{
			if (dateflag && !timeflag) {
				hh = yyvsp[-4]; mm = yyvsp[-2]; ss = yyvsp[0];
				timeflag++;
			} else if (!dateflag) {
				year = yyvsp[-4]; month = yyvsp[-2]; day = yyvsp[0];
				dateflag++;
			} else
			       YYERROR;
		;
    break;}
case 10:
#line 87 "getdate.y"
{if (timeflag && dateflag && !relflag) year = yyvsp[0];
		else {timeflag++;hh = yyvsp[0]/100;mm = yyvsp[0]%100;ss = 0;merid = 24;};
    break;}
case 11:
#line 91 "getdate.y"
{hh = yyvsp[-1]; mm = 0; ss = 0; merid = yyvsp[0];;
    break;}
case 12:
#line 93 "getdate.y"
{hh = yyvsp[-2]; mm = yyvsp[0]; merid = 24;;
    break;}
case 13:
#line 95 "getdate.y"
{hh = yyvsp[-3]; mm = yyvsp[-1]; merid = yyvsp[0];;
    break;}
case 14:
#line 97 "getdate.y"
{hh = yyvsp[-4]; mm = yyvsp[-2]; merid = 24;
		daylight = STANDARD; ourzone = -(yyvsp[-1]%100 + 60*(yyvsp[-1]/100));;
    break;}
case 15:
#line 100 "getdate.y"
{hh = yyvsp[-4]; mm = yyvsp[-2]; merid = 24;
		daylight = STANDARD; ourzone = (yyvsp[-1]%100 + 60*(yyvsp[-1]/100));;
    break;}
case 16:
#line 103 "getdate.y"
{hh = yyvsp[-4]; mm = yyvsp[-2]; ss = yyvsp[0]; merid = 24;;
    break;}
case 17:
#line 106 "getdate.y"
{hh = yyvsp[-4]; mm = yyvsp[-2]; ss = yyvsp[0]; merid = 24;;
    break;}
case 18:
#line 108 "getdate.y"
{hh = yyvsp[-5]; mm = yyvsp[-3]; ss = yyvsp[-1]; merid = yyvsp[0];;
    break;}
case 19:
#line 110 "getdate.y"
{hh = yyvsp[-6]; mm = yyvsp[-4]; ss = yyvsp[-2]; merid = 24;
		daylight = STANDARD; ourzone = -(yyvsp[-1]%100 + 60*(yyvsp[-1]/100));;
    break;}
case 20:
#line 113 "getdate.y"
{hh = yyvsp[-6]; mm = yyvsp[-4]; ss = yyvsp[-2]; merid = 24;
		daylight = STANDARD; ourzone = (yyvsp[-1]%100 + 60*(yyvsp[-1]/100));;
    break;}
case 21:
#line 117 "getdate.y"
{ourzone = yyvsp[0]; daylight = STANDARD;;
    break;}
case 22:
#line 119 "getdate.y"
{ourzone = yyvsp[0]; daylight = DAYLIGHT;;
    break;}
case 23:
#line 122 "getdate.y"
{dayord = 1; dayreq = yyvsp[0];;
    break;}
case 24:
#line 124 "getdate.y"
{dayord = 1; dayreq = yyvsp[-1];;
    break;}
case 25:
#line 126 "getdate.y"
{dayord = yyvsp[-1]; dayreq = yyvsp[0];;
    break;}
case 26:
#line 129 "getdate.y"
{month = yyvsp[-2]; day = yyvsp[0];;
    break;}
case 27:
#line 131 "getdate.y"
{month = yyvsp[-4]; day = yyvsp[-2]; year = yyvsp[0];;
    break;}
case 28:
#line 133 "getdate.y"
{month = yyvsp[-1]; day = yyvsp[0];;
    break;}
case 29:
#line 135 "getdate.y"
{month = yyvsp[-3]; day = yyvsp[-2]; year = yyvsp[0];;
    break;}
case 30:
#line 137 "getdate.y"
{month = yyvsp[0]; day = yyvsp[-1];;
    break;}
case 31:
#line 139 "getdate.y"
{month = yyvsp[-1]; day = yyvsp[-2]; year = yyvsp[0];;
    break;}
case 32:
#line 143 "getdate.y"
{relsec +=  60L * yyvsp[-1] * yyvsp[0];;
    break;}
case 33:
#line 145 "getdate.y"
{relmonth += yyvsp[-1] * yyvsp[0];;
    break;}
case 34:
#line 147 "getdate.y"
{relsec += yyvsp[-1];;
    break;}
case 35:
#line 149 "getdate.y"
{relsec +=  60L * yyvsp[0];;
    break;}
case 36:
#line 151 "getdate.y"
{relmonth += yyvsp[0];;
    break;}
case 37:
#line 153 "getdate.y"
{relsec++;;
    break;}
case 38:
#line 155 "getdate.y"
{relsec = -relsec; relmonth = -relmonth;;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 440 "/usr/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 156 "getdate.y"


static int mdays[12] =
	{31, 0, 31,  30, 31, 30,  31, 31, 30,  31, 30, 31};
#define epoch 1970

extern struct tm *localtime();

time_t
dateconv(mo, dy, yr, h, m, s, mer, zone, dyflag)
	int mo, dy, yr, h, m, s, mer, zone, dyflag;
{
	time_t tod, jdate;
	register int i;
	time_t timeconv();

	if (yr < 0) yr = -yr;
	if (yr < 100) yr += 1900;
	mdays[1] = 28 + (yr%4 == 0 && (yr%100 != 0 || yr%400 == 0));
	if (yr < epoch || yr > 1999 || mo < 1 || mo > 12 ||
		dy < 1 || dy > mdays[--mo]) return (-1);
	jdate = dy-1;
        for (i=0; i<mo; i++) jdate += mdays[i];
	for (i = epoch; i < yr; i++) jdate += 365 + (i%4 == 0);
	jdate *= daysec;
	jdate += zone * 60L;
	if ((tod = timeconv(h, m, s, mer)) < 0) return (-1);
	jdate += tod;
	if (dyflag==DAYLIGHT || (dyflag==MAYBE&&localtime(&jdate)->tm_isdst))
		jdate += -1*60*60;
	return (jdate);
}

time_t
dayconv(ord, dy, now)
	int ord, dy; time_t now;
{
	register struct tm *loctime;
	time_t tod;
	time_t daylcorr();

	tod = now;
	loctime = localtime(&tod);
	tod += daysec * ((dy - loctime->tm_wday + 7) % 7);
	tod += 7*daysec*(ord<=0?ord:ord-1);
	return daylcorr(tod, now);
}

time_t
timeconv(hour, min, sec, mer)
	int hour, min, sec, mer;
{
	if (min < 0 || min > 59 || sec < 0 || sec > 59) return (-1);
	switch (mer) {
		case AM: if (hour < 1 || hour > 12) return(-1);
			 return (60L * ((hour%12)*60L + min)+sec);
		case PM: if (hour < 1 || hour > 12) return(-1);
			 return (60L * ((hour%12 +12)*60L + min)+sec);
		case 24: if (hour < 0 || hour > 23) return (-1);
			 return (60L * (hour*60L + min)+sec);
		default: return (-1);
	}
}

time_t
monthadd(sdate, relmon)
	time_t sdate, relmon;
{
	struct tm *ltime;
	time_t dateconv();
	time_t daylcorr();
	int mon, yr;

	if (relmon == 0) return 0;
	ltime = localtime(&sdate);
	mon = 12*ltime->tm_year + ltime->tm_mon + relmon;
	yr = mon/12;
	mon = mon%12 + 1;
	return daylcorr(dateconv(mon, ltime->tm_mday, yr, ltime->tm_hour,
		ltime->tm_min, ltime->tm_sec, 24, ourzone, MAYBE), sdate);
}

time_t
daylcorr(future, now)
time_t future, now;
{
	int fdayl, nowdayl;

	nowdayl = (localtime(&now)->tm_hour+1) % 24;
	fdayl = (localtime(&future)->tm_hour+1) % 24;
	return (future-now) + 60L*60L*(nowdayl-fdayl);
}

static char *lptr;

static int
yylex()
{
	extern int yylval;
	register char c;
	register char *p;
	char idbuf[20];
	int pcnt;

	for (;;) {
		while (isspace(*lptr))
			lptr++;

#if 1
		if (isdigit(c = *lptr)) {
#else
		if (isdigit(c = *lptr) || c == '-' || c == '+') {
			if (c== '-' || c == '+') {
				if (c=='-') sign = -1;
				else sign = 1;
				if (!isdigit(*++lptr)) {
					/* yylval = sign; return (NUMBER); */
					return yylex();	/* skip the '-' sign */
				}
			} else sign = 1;
#endif
			yylval = 0;
			while (isdigit(c = *lptr++))
				yylval = 10*yylval + c - '0';
/*			yylval *= sign; */
			lptr--;
			return (NUMBER);

		} else if (isalpha(c)) {
			p = idbuf;
			while (isalpha(c = *lptr++) || c=='.')
				if (p < &idbuf[sizeof(idbuf)-1]) *p++ = c;
			*p = '\0';
			lptr--;
			return (lookup(idbuf));
		}

		else if (c == '(') {
			pcnt = 0;
			do {
				c = *lptr++;
				if (c == '\0') return(c);
				else if (c == '(') pcnt++;
				else if (c == ')') pcnt--;
			} while (pcnt > 0);
		}

		else return (*lptr++);
	}
}

struct table {
	char *name;
	int type, value;
};

struct table mdtab[] = {
	{"january", 	MONTH, 1},
	{"february", 	MONTH, 2},
	{"march", 	MONTH, 3},
	{"april", 	MONTH, 4},
	{"may", 	MONTH, 5},
	{"june", 	MONTH, 6},
	{"july", 	MONTH, 7},
	{"august", 	MONTH, 8},
	{"september", 	MONTH, 9},
	{"sept", 	MONTH, 9},
	{"october", 	MONTH, 10},
	{"november", 	MONTH, 11},
	{"december", 	MONTH, 12},

	{"sunday", 	DAY, 0},
	{"monday", 	DAY, 1},
	{"tuesday", 	DAY, 2},
	{"tues", 	DAY, 2},
	{"wednesday", 	DAY, 3},
	{"wednes", 	DAY, 3},
	{"thursday", 	DAY, 4},
	{"thur", 	DAY, 4},
	{"thurs", 	DAY, 4},
	{"friday", 	DAY, 5},
	{"saturday", 	DAY, 6},

#ifdef SWEDISH
/*
 * Swedish names, where they differ, used by some mailers
 */
	{"januari", 	MONTH, 1},
	{"februari", 	MONTH, 2},
	{"mars", 	MONTH, 3},
	{"april", 	MONTH, 4},
	{"maj", 	MONTH, 5},
	{"juni", 	MONTH, 6},
	{"juli",	MONTH, 7},
	{"augusti",	MONTH, 8},
	{"september",	MONTH, 9},
	{"oktober",	MONTH, 10},
	{"november",	MONTH, 11},
#endif

	{0, 0, 0}};

#define HRS *60
#define HALFHR 30
struct table mztab[] = {
	{"a.m.", MERIDIAN, AM},
	{"am", MERIDIAN, AM},
	{"p.m.", MERIDIAN, PM},
	{"pm", MERIDIAN, PM},

    {"gmt",	ZONE,	 0 HRS},	/* Greenwich Mean time */
    {"g.m.t.",	ZONE,	 0 HRS},
    {"ut",	ZONE,	 0 HRS},	/* Universal time (Coordinated) */
    {"utc",	ZONE,	 0 HRS},
    {"bst",	DAYZONE, 0 HRS},	/* British Summer time */
    {"b.s.t.",	DAYZONE, 0 HRS},
    {"wet",	ZONE,	 0 HRS },	/* Western European time */
    {"w.e.t.",	ZONE,	 0 HRS },
    {"west",	DAYZONE,-1 HRS},	/* Western European Summer time */
    {"w.e.s.t.",DAYZONE,-1 HRS},
    {"cet",	ZONE,	-1 HRS},	/* Central European time */
    {"met",	ZONE,	-1 HRS},	/* Middle European time */
    {"m.e.t.",	ZONE,	-1 HRS},
    {"mewt",	ZONE,	-1 HRS},	/* Middle European Winter time */
    {"m.e.w.t.",ZONE,	-1 HRS},
    {"mest",	DAYZONE,-1 HRS},	/* Middle European Summer time */
    {"m.e.s.t.",DAYZONE,-1 HRS},
    {"swt",	ZONE,	-1 HRS},	/* Swedish Winter time */
    {"sst",	DAYZONE,-1 HRS},	/* Swedish Summer time */
    {"fwt",	ZONE,	-1 HRS},	/* French Winter time */
    {"fst",	DAYZONE,-1 HRS},	/* French Summer time */
    {"eet",	ZONE,	-2 HRS},	/* European Eastern, USSR Zone 1 */
    {"e.e.t.",	ZONE,	-2 HRS},
    {"eest",	DAYZONE,-2 HRS},	/* European Eastern Summer time */
    {"e.e.s.t.",DAYZONE,-2 HRS},
    {"at",	ZONE,	-2 HRS},	/* Azores time */
    {"bt",	ZONE,	-3 HRS},	/* Baghdad, USSR Zone 2 */
    {"it",	ZONE,	-3 HRS-HALFHR}, /* Iranian time */
    {"zp4",	ZONE,	-4 HRS},	/* USSR Zone 3 */
    {"zp5",	ZONE,	-5 HRS},	/* USSR Zone 4 */
    {"ist",	ZONE,	-5 HRS-HALFHR},	/* Indian Standard time */
    {"zp6",	ZONE,	-6 HRS},	/* USSR Zone 5 */
    {"wast",	ZONE,	-7 HRS},	/* West Australian Standard time */
    {"wadt",	DAYZONE,-7 HRS},	/* West Australian Daylight time */
    {"jt",	ZONE,	-7 HRS-HALFHR},	/* Java time (3pm in Cronusland!) */
    {"cct",	ZONE,	-8 HRS},	/* China Coast, USSR Zone 7 */
    {"awst",	ZONE,	-8 HRS},	/* Australian Western Time */
    {"a.w.s.t.",ZONE,	-8 HRS},	/* (no daylight time there, I'm told */
    {"jst",	ZONE,	-9 HRS},	/* Japan Standard, USSR Zone 8 */
    {"j.s.t.",	ZONE,	-9 HRS},	/* Japan Standard */
    {"cast",	ZONE,	-9 HRS-HALFHR}, /* Central Australian Standard time */
    {"cadt",	ZONE,	-9 HRS-HALFHR},	/* Central Australian Daylight time */
    {"acst",	ZONE,	-9 HRS-HALFHR}, /* Australian Central Time */
    {"a.c.s.t.",ZONE,	-9 HRS-HALFHR},
    {"acsst", 	DAYZONE,-9 HRS-HALFHR}, /* Australian Central Summer time */
    {"a.c.s.s.t.",DAYZONE,-9 HRS-HALFHR},
    {"east",	ZONE,	-10 HRS},	/* Eastern Australian Standard time */
    {"eadt",	DAYZONE,-10 HRS},	/* Eastern Australian Daylight time */
    {"aest",	ZONE,	-10 HRS},	/* Australian Eastern Standard time */
    {"a.e.s.t.",ZONE,	-10 HRS},
    {"aesst",	DAYZONE,-10 HRS},	/* Australian Eastern Summer time */
    {"a.e.s.s.t.",DAYZONE,-10 HRS},
    {"gst",	ZONE,	-10 HRS},	/* Guam Standard, USSR Zone 9 */
    {"nzt",	ZONE,	-12 HRS},	/* New Zeeland time */
    {"nzst",	ZONE,	-12 HRS},	/* New Zeeland Standard time */
    {"nzdt",	DAYZONE,-12 HRS},	/* New Zeeland Daylight time */
    {"idle",	ZONE,	-12 HRS},	/* International Date Line East */

    {"wat",	ZONE,	1 HRS},		/* West African time */
    {"sat",	ZONE,	2 HRS},		/* South African Time */
    {"s.a.t.",	ZONE,	2 HRS},
    {"sast",	ZONE,	2 HRS},		/* South African Standard time */
    {"s.a.s.t.",ZONE,	2 HRS},
    {"nft",	ZONE,	3 HRS+HALFHR},	/* Newfoundland time */
    {"nst",	ZONE,	3 HRS+HALFHR},	/* Newfoundland Standard time */
    {"n.s.t.",	ZONE,	3 HRS+HALFHR},
    {"ndt",	DAYZONE,3 HRS+HALFHR},	/* Newfoundland Daylight time */
    {"ast",	ZONE,	4 HRS},		/* Atlantic Standard time */
    {"a.s.t.",	ZONE,	4 HRS},
    {"adt",	DAYZONE,4 HRS},		/* Atlantic Daylight time */
    {"a.d.t.",	DAYZONE,4 HRS},
    {"est",	ZONE,	5 HRS},		/* Eastern Standard time */
    {"e.s.t.",	ZONE,	5 HRS},
    {"edt",	DAYZONE,5 HRS},		/* Eastern Daylight time */
    {"e.d.t.",	DAYZONE,5 HRS},
    {"cst",	ZONE,	6 HRS},		/* Central Standard time */
    {"c.s.t.",	ZONE,	6 HRS},
    {"cdt",	DAYZONE,6 HRS},		/* Central Daylight time */
    {"c.d.t.",	DAYZONE,6 HRS},
    {"mst",	ZONE,	7 HRS},		/* Mountain Standard time */
    {"m.s.t.",	ZONE,	7 HRS},
    {"mdt",	DAYZONE,7 HRS},		/* Mountain Daylight time */
    {"m.d.t.", 	DAYZONE,7 HRS},
    {"pst", 	ZONE,	8 HRS},		/* Pacific Standard time */
    {"p.s.t.", 	ZONE,	8 HRS},
    {"pdt", 	DAYZONE,8 HRS},		/* Pacific Daylight time */
    {"p.d.t.", 	DAYZONE,8 HRS},
    {"yst", 	ZONE,	9 HRS},		/* Yukon Standard time */
    {"y.s.t.", 	ZONE,	9 HRS},
    {"ydt", 	DAYZONE,9 HRS},		/* Yukon Daylight time */
    {"y.d.t.", 	DAYZONE,9 HRS},
    {"hst", 	ZONE,	10 HRS},	/* Hawaii Standard time */
    {"h.s.t.", 	ZONE,	10 HRS},
    {"hdt", 	DAYZONE,10 HRS},	/* Hawaii Daylight time */
    {"h.d.t.", 	DAYZONE,10 HRS},
    {"cat",	ZONE,	10 HRS},	/* Central Alaska time */
    {"ahst", 	ZONE,	10 HRS},	/* Alaska-Hawaii Standard time */
    {"nt", 	ZONE,	11 HRS},	/* Nome time */
    {"idlw", 	ZONE,	12 HRS},	/* International Date Line West */

    {0, 0, 0}};

struct table unittb[] = {
	{"year", MUNIT, 12},
	{"month", MUNIT, 1},
	{"fortnight", UNIT, 14*24*60},
	{"week", UNIT, 7*24*60},
	{"day", UNIT, 1*24*60},
	{"hour", UNIT, 60},
	{"minute", UNIT, 1},
	{"min", UNIT, 1},
	{"second", SUNIT, 1},
	{"sec", SUNIT, 1},
	{0, 0, 0}};

struct table othertb[] = {
	{"tomorrow", UNIT, 1*24*60},
	{"yesterday", UNIT, -1*24*60},
	{"today", UNIT, 0},
	{"now", UNIT, 0},
	{"last", NUMBER, -1},
	{"this", UNIT, 0},
	{"next", NUMBER, 2},
	{"first", NUMBER, 1},
	/* {"second", NUMBER, 2}, */
	{"third", NUMBER, 3},
	{"fourth", NUMBER, 4},
	{"fifth", NUMBER, 5},
	{"sixth", NUMBER, 6},
	{"seventh", NUMBER, 7},
	{"eight", NUMBER, 8},
	{"ninth", NUMBER, 9},
	{"tenth", NUMBER, 10},
	{"eleventh", NUMBER, 11},
	{"twelfth", NUMBER, 12},
	{"ago", AGO, 1},
	{0, 0, 0}};

struct table milzone[] = {
	{"a", ZONE, 1 HRS},
	{"b", ZONE, 2 HRS},
	{"c", ZONE, 3 HRS},
	{"d", ZONE, 4 HRS},
	{"e", ZONE, 5 HRS},
	{"f", ZONE, 6 HRS},
	{"g", ZONE, 7 HRS},
	{"h", ZONE, 8 HRS},
	{"i", ZONE, 9 HRS},
	{"k", ZONE, 10 HRS},
	{"l", ZONE, 11 HRS},
	{"m", ZONE, 12 HRS},
	{"n", ZONE, -1 HRS},
	{"o", ZONE, -2 HRS},
	{"p", ZONE, -3 HRS},
	{"q", ZONE, -4 HRS},
	{"r", ZONE, -5 HRS},
	{"s", ZONE, -6 HRS},
	{"t", ZONE, -7 HRS},
	{"u", ZONE, -8 HRS},
	{"v", ZONE, -9 HRS},
	{"w", ZONE, -10 HRS},
	{"x", ZONE, -11 HRS},
	{"y", ZONE, -12 HRS},
	{"z", ZONE, 0 HRS},
	{0, 0, 0}};

static int
lookup(id)
	char *id;
{
#define gotit (yylval=i->value,  i->type)

	char idvar[128];
	register char *j, *k;
	register struct table *i;
	int abbrev;

	(void) strcpy(idvar, id);
	j = idvar;
	k = id - 1;
	while (*++k)
		*j++ = isupper(*k) ? tolower(*k) : *k;
	*j = '\0';

	if (strlen(idvar) == 3)
		abbrev = 1;
	else
		if (strlen(idvar) == 4 && idvar[3] == '.') {
			abbrev = 1;
			idvar[3] = '\0';
		}
	else
		abbrev = 0;

	for (i = mdtab; i->name; i++) {
		k = idvar;
		for (j = i->name; *j++ == *k++;) {
			if (abbrev && j == i->name+3)
				return gotit;
			if (j[-1] == 0)
				return gotit;
		}
	}

	for (i = mztab; i->name; i++)
		if (strcmp(i->name, idvar) == 0)
			return gotit;

	for (i=mztab; i->name; i++)
		if (strcmp(i->name, idvar) == 0)
			return gotit;

	for (i=unittb; i->name; i++)
		if (strcmp(i->name, idvar) == 0)
			return gotit;

	if (idvar[strlen(idvar)-1] == 's')
		idvar[strlen(idvar)-1] = '\0';

	for (i=unittb; i->name; i++)
		if (strcmp(i->name, idvar) == 0)
			return gotit;

	for (i = othertb; i->name; i++)
		if (strcmp(i->name, idvar) == 0)
			return gotit;

	if (strlen(idvar) == 1 && isalpha(*idvar)) {
		for (i = milzone; i->name; i++)
			if (strcmp(i->name, idvar) == 0)
				return gotit;
	}

	return ID;
}

time_t
parsedate(p, now)
	char *p;
	struct timeb *now;
{
#define mcheck(f)	if (f>1) err++
	time_t monthadd();
	int err;
	struct tm *lt;
	struct timeb ftz;

	time_t sdate, tod;

	lptr = p;
	if (now == ((struct timeb *) NULL)) {
		now = &ftz;
		ftime(&ftz);
	}
	lt = localtime(&now->time);
	year = lt->tm_year;
	month = lt->tm_mon+1;
	day = lt->tm_mday;
	relsec = 0; relmonth = 0;
	timeflag=zoneflag=dateflag=dayflag=relflag=0;
	ourzone = now->timezone;
	daylight = MAYBE;
	hh = mm = ss = 0;
	merid = 24;

	if (err = yyparse()) return (-1);

	mcheck(timeflag);
	mcheck(zoneflag);
	mcheck(dateflag);
	mcheck(dayflag);

	if (err) return (-1);
	if (dateflag || timeflag || dayflag) {
		sdate = dateconv(month,day,year,hh,mm,ss,merid,ourzone,daylight);
		if (sdate < 0) return -1;
	}
	else {
		sdate = now->time;
		if (relflag == 0)
			sdate -= (lt->tm_sec + lt->tm_min*60 +
				lt->tm_hour*(60L*60L));
	}

	sdate += relsec;
	sdate += monthadd(sdate, relmonth);

	if (dayflag && !dateflag) {
		tod = dayconv(dayord, dayreq, sdate);
		sdate += tod;
	}

	/*
	** Have to do *something* with a legitimate -1 so it's distinguishable
	** from the error return value.  (Alternately could set errno on error.)
	*/
	return (sdate == -1) ? 0 : sdate;
}

static void
yyerror(s) char *s;
{}
